/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android;

import android.graphics.Rect;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import androidx.compose.ui.text.android.PaintExtensionsKt;
import androidx.compose.ui.text.android.TextLayout;
import androidx.compose.ui.text.android.style.LineHeightStyleSpan;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0002H\u0000\u001a\u0018\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0007H\u0002\u001a\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u0018\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0007H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"EmptyPair", "Lkotlin/Pair;", "", "getTextDirectionHeuristic", "Landroid/text/TextDirectionHeuristic;", "textDirectionHeuristic", "getLineHeightPaddings", "Landroidx/compose/ui/text/android/TextLayout;", "getLineHeightSpans", "", "Landroidx/compose/ui/text/android/style/LineHeightStyleSpan;", "(Landroidx/compose/ui/text/android/TextLayout;)[Landroidx/compose/ui/text/android/style/LineHeightStyleSpan;", "getVerticalPaddings", "ui-text_release"})
public final class TextLayoutKt {
    @NotNull
    private static final Pair<Integer, Integer> EmptyPair = new Pair((Object)0, (Object)0);

    @NotNull
    public static final TextDirectionHeuristic getTextDirectionHeuristic(int textDirectionHeuristic) {
        TextDirectionHeuristic textDirectionHeuristic2;
        switch (textDirectionHeuristic) {
            case 0: {
                TextDirectionHeuristic textDirectionHeuristic3 = TextDirectionHeuristics.LTR;
                textDirectionHeuristic2 = textDirectionHeuristic3;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic3, (String)"LTR");
                break;
            }
            case 5: {
                TextDirectionHeuristic textDirectionHeuristic4 = TextDirectionHeuristics.LOCALE;
                textDirectionHeuristic2 = textDirectionHeuristic4;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic4, (String)"LOCALE");
                break;
            }
            case 1: {
                TextDirectionHeuristic textDirectionHeuristic5 = TextDirectionHeuristics.RTL;
                textDirectionHeuristic2 = textDirectionHeuristic5;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic5, (String)"RTL");
                break;
            }
            case 3: {
                TextDirectionHeuristic textDirectionHeuristic6 = TextDirectionHeuristics.FIRSTSTRONG_RTL;
                textDirectionHeuristic2 = textDirectionHeuristic6;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic6, (String)"FIRSTSTRONG_RTL");
                break;
            }
            case 4: {
                TextDirectionHeuristic textDirectionHeuristic7 = TextDirectionHeuristics.ANYRTL_LTR;
                textDirectionHeuristic2 = textDirectionHeuristic7;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic7, (String)"ANYRTL_LTR");
                break;
            }
            case 2: {
                TextDirectionHeuristic textDirectionHeuristic8 = TextDirectionHeuristics.FIRSTSTRONG_LTR;
                textDirectionHeuristic2 = textDirectionHeuristic8;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic8, (String)"FIRSTSTRONG_LTR");
                break;
            }
            default: {
                TextDirectionHeuristic textDirectionHeuristic9 = TextDirectionHeuristics.FIRSTSTRONG_LTR;
                textDirectionHeuristic2 = textDirectionHeuristic9;
                Intrinsics.checkNotNullExpressionValue((Object)textDirectionHeuristic9, (String)"FIRSTSTRONG_LTR");
            }
        }
        return textDirectionHeuristic2;
    }

    private static final Pair<Integer, Integer> getVerticalPaddings(TextLayout $this$getVerticalPaddings) {
        Rect rect;
        int topPadding;
        if ($this$getVerticalPaddings.getIncludePadding() || $this$getVerticalPaddings.isFallbackLinespacingApplied$ui_text_release()) {
            return new Pair((Object)0, (Object)0);
        }
        TextPaint paint = $this$getVerticalPaddings.getLayout().getPaint();
        CharSequence text = $this$getVerticalPaddings.getLayout().getText();
        Intrinsics.checkNotNullExpressionValue((Object)paint, (String)"paint");
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        Rect firstLineTextBounds = PaintExtensionsKt.getCharSequenceBounds(paint, text, $this$getVerticalPaddings.getLayout().getLineStart(0), $this$getVerticalPaddings.getLayout().getLineEnd(0));
        int ascent = $this$getVerticalPaddings.getLayout().getLineAscent(0);
        int n = topPadding = firstLineTextBounds.top < ascent ? ascent - firstLineTextBounds.top : $this$getVerticalPaddings.getLayout().getTopPadding();
        if ($this$getVerticalPaddings.getLineCount() == 1) {
            rect = firstLineTextBounds;
        } else {
            int line = $this$getVerticalPaddings.getLayout().getLineCount() - 1;
            rect = PaintExtensionsKt.getCharSequenceBounds(paint, text, $this$getVerticalPaddings.getLayout().getLineStart(line), $this$getVerticalPaddings.getLayout().getLineEnd(line));
        }
        Rect lastLineTextBounds = rect;
        int descent = $this$getVerticalPaddings.getLayout().getLineDescent($this$getVerticalPaddings.getLayout().getLineCount() - 1);
        int bottomPadding = lastLineTextBounds.bottom > descent ? lastLineTextBounds.bottom - descent : $this$getVerticalPaddings.getLayout().getBottomPadding();
        return topPadding == 0 && bottomPadding == 0 ? EmptyPair : new Pair((Object)topPadding, (Object)bottomPadding);
    }

    private static final Pair<Integer, Integer> getLineHeightPaddings(TextLayout $this$getLineHeightPaddings) {
        int firstAscentDiff = 0;
        int lastDescentDiff = 0;
        for (LineHeightStyleSpan span : TextLayoutKt.getLineHeightSpans($this$getLineHeightPaddings)) {
            if (span.getFirstAscentDiff() < 0) {
                firstAscentDiff = Math.max(firstAscentDiff, Math.abs(span.getFirstAscentDiff()));
            }
            if (span.getLastDescentDiff() >= 0) continue;
            lastDescentDiff = Math.max(firstAscentDiff, Math.abs(span.getLastDescentDiff()));
        }
        return firstAscentDiff == 0 && lastDescentDiff == 0 ? EmptyPair : new Pair((Object)firstAscentDiff, (Object)lastDescentDiff);
    }

    private static final LineHeightStyleSpan[] getLineHeightSpans(TextLayout $this$getLineHeightSpans) {
        if (!($this$getLineHeightSpans.getText() instanceof Spanned)) {
            boolean $i$f$emptyArray = false;
            return (LineHeightStyleSpan[])((Object[])new LineHeightStyleSpan[0]);
        }
        LineHeightStyleSpan[] lineHeightStyleSpans = (LineHeightStyleSpan[])((Spanned)$this$getLineHeightSpans.getText()).getSpans(0, $this$getLineHeightSpans.getText().length(), LineHeightStyleSpan.class);
        Intrinsics.checkNotNullExpressionValue((Object)lineHeightStyleSpans, (String)"lineHeightStyleSpans");
        if (lineHeightStyleSpans.length == 0) {
            boolean $i$f$emptyArray = false;
            return (LineHeightStyleSpan[])((Object[])new LineHeightStyleSpan[0]);
        }
        return lineHeightStyleSpans;
    }

    public static final /* synthetic */ Pair access$getVerticalPaddings(TextLayout $receiver) {
        return TextLayoutKt.getVerticalPaddings($receiver);
    }

    public static final /* synthetic */ Pair access$getLineHeightPaddings(TextLayout $receiver) {
        return TextLayoutKt.getLineHeightPaddings($receiver);
    }
}

