/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.tooling.animation.clock;

import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationKt;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.TargetBasedAnimation;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.tooling.ComposeAnimatedProperty;
import androidx.compose.animation.tooling.TransitionInfo;
import androidx.compose.ui.tooling.animation.AnimateXAsStateComposeAnimation;
import androidx.compose.ui.tooling.animation.clock.ComposeAnimationClock;
import androidx.compose.ui.tooling.animation.clock.UtilsKt;
import androidx.compose.ui.tooling.animation.states.TargetState;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u0004B\u0019\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011H\u0002J\b\u0010\u001f\u001a\u00020\fH\u0016J\b\u0010 \u001a\u00020\fH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001c2\u0006\u0010#\u001a\u00020\fH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\fH\u0016J\u001a\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010)H\u0016R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0000@BX\u0082\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\"\u0004\b\u0013\u0010\u0014R0\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006+"}, d2={"Landroidx/compose/ui/tooling/animation/clock/AnimateXAsStateClock;", "T", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/ui/tooling/animation/clock/ComposeAnimationClock;", "Landroidx/compose/ui/tooling/animation/AnimateXAsStateComposeAnimation;", "Landroidx/compose/ui/tooling/animation/states/TargetState;", "animation", "(Landroidx/compose/ui/tooling/animation/AnimateXAsStateComposeAnimation;)V", "getAnimation", "()Landroidx/compose/ui/tooling/animation/AnimateXAsStateComposeAnimation;", "value", "", "clockTimeNanos", "setClockTimeNanos", "(J)V", "currAnimation", "Landroidx/compose/animation/core/TargetBasedAnimation;", "currentValue", "setCurrentValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "state", "getState", "()Landroidx/compose/ui/tooling/animation/states/TargetState;", "setState", "(Landroidx/compose/ui/tooling/animation/states/TargetState;)V", "getAnimatedProperties", "", "Landroidx/compose/animation/tooling/ComposeAnimatedProperty;", "getCurrentAnimation", "getMaxDuration", "getMaxDurationPerIteration", "getTransitions", "Landroidx/compose/animation/tooling/TransitionInfo;", "stepMillis", "setClockTime", "", "animationTimeNanos", "setStateParameters", "par1", "", "par2", "ui-tooling_release"})
public final class AnimateXAsStateClock<T, V extends AnimationVector>
implements ComposeAnimationClock<AnimateXAsStateComposeAnimation<T, V>, TargetState<T>> {
    @NotNull
    private final AnimateXAsStateComposeAnimation<T, V> animation;
    @NotNull
    private TargetState<T> state;
    private T currentValue;
    @NotNull
    private TargetBasedAnimation<T, V> currAnimation;
    private long clockTimeNanos;

    public AnimateXAsStateClock(@NotNull AnimateXAsStateComposeAnimation<T, V> animation) {
        this.animation = animation;
        this.state = new TargetState<Object>(this.getAnimation().getAnimationObject().getValue(), this.getAnimation().getAnimationObject().getValue());
        this.currentValue = this.getAnimation().getToolingState().getValue();
        this.currAnimation = this.getCurrentAnimation();
    }

    @Override
    @NotNull
    public AnimateXAsStateComposeAnimation<T, V> getAnimation() {
        return this.animation;
    }

    @Override
    @NotNull
    public TargetState<T> getState() {
        return this.state;
    }

    @Override
    public void setState(@NotNull TargetState<T> value) {
        this.state = value;
        this.currAnimation = this.getCurrentAnimation();
        this.setClockTime(0L);
    }

    private final void setCurrentValue(T value) {
        this.currentValue = value;
        this.getAnimation().getToolingState().setValue(value);
    }

    @Override
    public void setStateParameters(@NotNull Object par1, @Nullable Object par2) {
        block0: {
            TargetState<T> targetState = UtilsKt.parseParametersToValue(this.currentValue, par1, par2);
            if (targetState == null) break block0;
            TargetState<T> it = targetState;
            boolean bl = false;
            this.setState(it);
        }
    }

    @Override
    @NotNull
    public List<ComposeAnimatedProperty> getAnimatedProperties() {
        String string = this.getAnimation().getLabel();
        T t = this.currentValue;
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Any");
        return CollectionsKt.listOf((Object)new ComposeAnimatedProperty(string, t));
    }

    @Override
    public long getMaxDurationPerIteration() {
        return UtilsKt.nanosToMillis(this.currAnimation.getDurationNanos());
    }

    @Override
    public long getMaxDuration() {
        return UtilsKt.nanosToMillis(this.currAnimation.getDurationNanos());
    }

    @Override
    @NotNull
    public List<TransitionInfo> getTransitions(long stepMillis) {
        return CollectionsKt.listOf((Object)UtilsKt.createTransitionInfo((Animation)this.currAnimation, this.getAnimation().getLabel(), this.getAnimation().getAnimationSpec(), stepMillis));
    }

    private final void setClockTimeNanos(long value) {
        this.clockTimeNanos = value;
        this.setCurrentValue(this.currAnimation.getValueFromNanos(value));
    }

    @Override
    public void setClockTime(long animationTimeNanos) {
        this.setClockTimeNanos(animationTimeNanos);
    }

    private final TargetBasedAnimation<T, V> getCurrentAnimation() {
        AnimationSpec animationSpec = this.getAnimation().getAnimationSpec();
        Object t = ((TargetState)this.getState()).getInitial();
        Object t2 = ((TargetState)this.getState()).getTarget();
        TwoWayConverter twoWayConverter = this.getAnimation().getAnimationObject().getTypeConverter();
        Object object = this.getAnimation().getAnimationObject().getVelocity();
        return AnimationKt.TargetBasedAnimation(animationSpec, (TwoWayConverter)twoWayConverter, t, t2, (Object)object);
    }
}

