/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.tooling.animation.clock;

import androidx.compose.animation.core.Transition;
import androidx.compose.animation.tooling.ComposeAnimatedProperty;
import androidx.compose.animation.tooling.TransitionInfo;
import androidx.compose.ui.tooling.animation.TransitionBasedAnimation;
import androidx.compose.ui.tooling.animation.clock.ComposeAnimationClock;
import androidx.compose.ui.tooling.animation.clock.UtilsKt;
import androidx.compose.ui.tooling.animation.states.TargetState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0002B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u001a\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR0\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Landroidx/compose/ui/tooling/animation/clock/TransitionClock;", "T", "Landroidx/compose/ui/tooling/animation/clock/ComposeAnimationClock;", "Landroidx/compose/ui/tooling/animation/TransitionBasedAnimation;", "Landroidx/compose/ui/tooling/animation/states/TargetState;", "animation", "(Landroidx/compose/ui/tooling/animation/TransitionBasedAnimation;)V", "getAnimation", "()Landroidx/compose/ui/tooling/animation/TransitionBasedAnimation;", "value", "state", "getState", "()Landroidx/compose/ui/tooling/animation/states/TargetState;", "setState", "(Landroidx/compose/ui/tooling/animation/states/TargetState;)V", "getAnimatedProperties", "", "Landroidx/compose/animation/tooling/ComposeAnimatedProperty;", "getMaxDuration", "", "getMaxDurationPerIteration", "getTransitions", "Landroidx/compose/animation/tooling/TransitionInfo;", "stepMillis", "setClockTime", "", "animationTimeNanos", "setStateParameters", "par1", "", "par2", "ui-tooling_release"})
@SourceDebugExtension(value={"SMAP\nTransitionClock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransitionClock.kt\nandroidx/compose/ui/tooling/animation/clock/TransitionClock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1603#2,9:89\n1855#2:98\n1856#2:100\n1612#2:101\n766#2:102\n857#2,2:103\n1549#2:105\n1620#2,3:106\n766#2:109\n857#2,2:110\n1#3:99\n*S KotlinDebug\n*F\n+ 1 TransitionClock.kt\nandroidx/compose/ui/tooling/animation/clock/TransitionClock\n*L\n60#1:89,9\n60#1:98\n60#1:100\n60#1:101\n64#1:102\n64#1:103,2\n77#1:105\n77#1:106,3\n79#1:109\n79#1:110,2\n60#1:99\n*E\n"})
public final class TransitionClock<T>
implements ComposeAnimationClock<TransitionBasedAnimation<T>, TargetState<T>> {
    @NotNull
    private final TransitionBasedAnimation<T> animation;
    @NotNull
    private TargetState<T> state;

    public TransitionClock(@NotNull TransitionBasedAnimation<T> animation) {
        this.animation = animation;
        this.state = new TargetState<Object>(this.getAnimation().getAnimationObject().getCurrentState(), this.getAnimation().getAnimationObject().getTargetState());
    }

    @Override
    @NotNull
    public TransitionBasedAnimation<T> getAnimation() {
        return this.animation;
    }

    @Override
    @NotNull
    public TargetState<T> getState() {
        return this.state;
    }

    @Override
    public void setState(@NotNull TargetState<T> value) {
        this.state = value;
        this.setClockTime(0L);
    }

    @Override
    public void setStateParameters(@NotNull Object par1, @Nullable Object par2) {
        block0: {
            TargetState targetState = UtilsKt.parseParametersToValue(((TargetState)this.getState()).getInitial(), par1, par2);
            if (targetState == null) break block0;
            TargetState it = targetState;
            boolean bl = false;
            this.setState(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ComposeAnimatedProperty> getAnimatedProperties() {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = UtilsKt.allAnimations(this.getAnimation().getAnimationObject());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ComposeAnimatedProperty it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Transition.TransitionAnimationState it = (Transition.TransitionAnimationState)element$iv$iv;
            boolean bl2 = false;
            Object value = it.getValue();
            if ((value == null ? null : new ComposeAnimatedProperty(it.getLabel(), value)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ComposeAnimatedProperty it = (ComposeAnimatedProperty)element$iv$iv;
            boolean bl = false;
            if (!(!UtilsKt.getIGNORE_TRANSITIONS().contains(it.getLabel()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public long getMaxDurationPerIteration() {
        return UtilsKt.nanosToMillis(this.getAnimation().getAnimationObject().getTotalDurationNanos());
    }

    @Override
    public long getMaxDuration() {
        return UtilsKt.nanosToMillis(this.getAnimation().getAnimationObject().getTotalDurationNanos());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TransitionInfo> getTransitions(long stepMillis) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        TransitionInfo it;
        void $this$mapTo$iv$iv;
        Transition transition = this.getAnimation().getAnimationObject();
        Iterable $this$map$iv = UtilsKt.allAnimations(transition);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Transition.TransitionAnimationState transitionAnimationState = (Transition.TransitionAnimationState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilsKt.createTransitionInfo(it, stepMillis));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TransitionInfo)element$iv$iv;
            boolean bl = false;
            if (!(!UtilsKt.getIGNORE_TRANSITIONS().contains(it.getLabel()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void setClockTime(long animationTimeNanos) {
        this.getAnimation().getAnimationObject().seek(((TargetState)this.getState()).getInitial(), ((TargetState)this.getState()).getTarget(), animationTimeNanos);
    }
}

