/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.tooling.animation.clock;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.InfiniteRepeatableSpec;
import androidx.compose.animation.core.InfiniteTransition;
import androidx.compose.animation.core.RepeatMode;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.animation.tooling.ComposeAnimatedProperty;
import androidx.compose.animation.tooling.TransitionInfo;
import androidx.compose.ui.tooling.animation.InfiniteTransitionComposeAnimation;
import androidx.compose.ui.tooling.animation.clock.ComposeAnimationClock;
import androidx.compose.ui.tooling.animation.clock.UtilsKt;
import androidx.compose.ui.tooling.animation.states.TargetState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00122\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u001a\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004H\u0016J,\u0010\u001f\u001a\u00020\b\"\u0004\b\u0000\u0010 \"\b\b\u0001\u0010!*\u00020\"*\u0012\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u0002H!0#R\u00020$H\u0002R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Landroidx/compose/ui/tooling/animation/clock/InfiniteTransitionClock;", "Landroidx/compose/ui/tooling/animation/clock/ComposeAnimationClock;", "Landroidx/compose/ui/tooling/animation/InfiniteTransitionComposeAnimation;", "Landroidx/compose/ui/tooling/animation/states/TargetState;", "", "animation", "maxDuration", "Lkotlin/Function0;", "", "(Landroidx/compose/ui/tooling/animation/InfiniteTransitionComposeAnimation;Lkotlin/jvm/functions/Function0;)V", "getAnimation", "()Landroidx/compose/ui/tooling/animation/InfiniteTransitionComposeAnimation;", "state", "getState", "()Landroidx/compose/ui/tooling/animation/states/TargetState;", "setState", "(Landroidx/compose/ui/tooling/animation/states/TargetState;)V", "getAnimatedProperties", "", "Landroidx/compose/animation/tooling/ComposeAnimatedProperty;", "getMaxDuration", "getMaxDurationPerIteration", "getTransitions", "Landroidx/compose/animation/tooling/TransitionInfo;", "stepMillis", "setClockTime", "", "animationTimeNanos", "setStateParameters", "par1", "par2", "getIterationDuration", "T", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/InfiniteTransition$TransitionAnimationState;", "Landroidx/compose/animation/core/InfiniteTransition;", "ui-tooling_release"})
@SourceDebugExtension(value={"SMAP\nInfiniteTransitionClock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InfiniteTransitionClock.kt\nandroidx/compose/ui/tooling/animation/clock/InfiniteTransitionClock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1603#2,9:87\n1855#2:96\n1856#2:98\n1612#2:99\n766#2:100\n857#2,2:101\n1549#2:103\n1620#2,3:104\n766#2:107\n857#2,2:108\n1#3:97\n*S KotlinDebug\n*F\n+ 1 InfiniteTransitionClock.kt\nandroidx/compose/ui/tooling/animation/clock/InfiniteTransitionClock\n*L\n47#1:87,9\n47#1:96\n47#1:98\n47#1:99\n51#1:100\n51#1:101,2\n68#1:103\n68#1:104,3\n70#1:107\n70#1:108,2\n47#1:97\n*E\n"})
public final class InfiniteTransitionClock
implements ComposeAnimationClock<InfiniteTransitionComposeAnimation, TargetState<Object>> {
    @NotNull
    private final InfiniteTransitionComposeAnimation animation;
    @NotNull
    private final Function0<Long> maxDuration;
    @NotNull
    private TargetState<Object> state;

    public InfiniteTransitionClock(@NotNull InfiniteTransitionComposeAnimation animation, @NotNull Function0<Long> maxDuration) {
        this.animation = animation;
        this.maxDuration = maxDuration;
        this.state = new TargetState<Integer>(0, 0);
    }

    public /* synthetic */ InfiniteTransitionClock(InfiniteTransitionComposeAnimation infiniteTransitionComposeAnimation, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(infiniteTransitionComposeAnimation, (Function0<Long>)function0);
    }

    @Override
    @NotNull
    public InfiniteTransitionComposeAnimation getAnimation() {
        return this.animation;
    }

    @Override
    @NotNull
    public TargetState<Object> getState() {
        return this.state;
    }

    @Override
    public void setState(@NotNull TargetState<Object> targetState) {
        this.state = targetState;
    }

    @Override
    public void setStateParameters(@NotNull Object par1, @Nullable Object par2) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ComposeAnimatedProperty> getAnimatedProperties() {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getAnimation().getAnimationObject().getAnimations();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ComposeAnimatedProperty it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            InfiniteTransition.TransitionAnimationState it = (InfiniteTransition.TransitionAnimationState)element$iv$iv;
            boolean bl2 = false;
            Object value = it.getValue();
            if ((value == null ? null : new ComposeAnimatedProperty(it.getLabel(), value)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ComposeAnimatedProperty it = (ComposeAnimatedProperty)element$iv$iv;
            boolean bl = false;
            if (!(!UtilsKt.getIGNORE_TRANSITIONS().contains(it.getLabel()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public long getMaxDurationPerIteration() {
        Comparable comparable;
        Iterator iterator = ((Iterable)this.getAnimation().getAnimationObject().getAnimations()).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            InfiniteTransition.TransitionAnimationState it = (InfiniteTransition.TransitionAnimationState)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Long.valueOf(this.getIterationDuration(it));
            while (iterator.hasNext()) {
                InfiniteTransition.TransitionAnimationState it2 = (InfiniteTransition.TransitionAnimationState)iterator.next();
                $i$a$-maxOfOrNull-InfiniteTransitionClock$getMaxDurationPerIteration$1 = false;
                Comparable comparable3 = Long.valueOf(this.getIterationDuration(it2));
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Long l = (Long)comparable;
        return UtilsKt.nanosToMillis(l != null ? l : 0L);
    }

    @Override
    public long getMaxDuration() {
        return Math.max(this.getMaxDurationPerIteration(), ((Number)this.maxDuration.invoke()).longValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TransitionInfo> getTransitions(long stepMillis) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        TransitionInfo it;
        void $this$mapTo$iv$iv;
        InfiniteTransition transition = this.getAnimation().getAnimationObject();
        Iterable $this$map$iv = transition.getAnimations();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            InfiniteTransition.TransitionAnimationState transitionAnimationState = (InfiniteTransition.TransitionAnimationState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilsKt.createTransitionInfo(it, stepMillis, this.getMaxDuration()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TransitionInfo)element$iv$iv;
            boolean bl = false;
            if (!(!UtilsKt.getIGNORE_TRANSITIONS().contains(it.getLabel()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Override
    public void setClockTime(long animationTimeNanos) {
        this.getAnimation().setTimeNanos(animationTimeNanos);
    }

    private final <T, V extends AnimationVector> long getIterationDuration(InfiniteTransition.TransitionAnimationState<T, V> $this$getIterationDuration) {
        AnimationSpec animationSpec = $this$getIterationDuration.getAnimationSpec();
        Intrinsics.checkNotNull((Object)animationSpec, (String)"null cannot be cast to non-null type androidx.compose.animation.core.InfiniteRepeatableSpec<T of androidx.compose.ui.tooling.animation.clock.InfiniteTransitionClock.getIterationDuration>");
        InfiniteRepeatableSpec repeatableSpec = (InfiniteRepeatableSpec)animationSpec;
        int repeats = repeatableSpec.getRepeatMode() == RepeatMode.Reverse ? 2 : 1;
        VectorizedDurationBasedAnimationSpec animation = repeatableSpec.getAnimation().vectorize($this$getIterationDuration.getTypeConverter());
        return UtilsKt.millisToNanos((long)animation.getDelayMillis() + (long)(animation.getDurationMillis() * repeats));
    }
}

