/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.tooling.animation;

import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.compose.animation.core.Transition;
import androidx.compose.animation.tooling.ComposeAnimatedProperty;
import androidx.compose.animation.tooling.ComposeAnimation;
import androidx.compose.animation.tooling.ComposeAnimationType;
import androidx.compose.ui.tooling.animation.ComposeAnimationParserKt;
import androidx.compose.ui.tooling.animation.TransitionComposeAnimation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\b\u0010\u0018\u00002\u00020\u0001:\u00010B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001b\u001a\u00020\u0004J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\"H\u0002J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0015J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0015J\u000e\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\"J\u0014\u0010*\u001a\u00020\u00042\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00010\u0014J\u001e\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u00020\u0001R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011RD\u0010\u0012\u001a*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0014\u0012\u0004\u0012\u00020\u0015`\u00168\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Landroidx/compose/ui/tooling/animation/PreviewAnimationClock;", "", "setAnimationsTimeCallback", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "DEBUG", "", "TAG", "", "trackedTransitions", "Ljava/util/HashSet;", "Landroidx/compose/ui/tooling/animation/TransitionComposeAnimation;", "Lkotlin/collections/HashSet;", "getTrackedTransitions$ui_tooling_release$annotations", "()V", "getTrackedTransitions$ui_tooling_release", "()Ljava/util/HashSet;", "transitionStates", "Ljava/util/HashMap;", "Landroidx/compose/animation/core/Transition;", "Landroidx/compose/ui/tooling/animation/PreviewAnimationClock$TransitionState;", "Lkotlin/collections/HashMap;", "getTransitionStates$ui_tooling_release$annotations", "getTransitionStates$ui_tooling_release", "()Ljava/util/HashMap;", "transitionStatesLock", "dispose", "getAnimatedProperties", "", "Landroidx/compose/animation/tooling/ComposeAnimatedProperty;", "animation", "Landroidx/compose/animation/tooling/ComposeAnimation;", "getMaxDuration", "", "getMaxDurationPerIteration", "nanosToMillis", "timeNs", "notifySubscribe", "notifyUnsubscribe", "setClockTime", "animationTimeMs", "trackTransition", "transition", "updateFromAndToStates", "composeAnimation", "fromState", "toState", "TransitionState", "ui-tooling_release"})
public class PreviewAnimationClock {
    @NotNull
    private final Function0<Unit> setAnimationsTimeCallback;
    @NotNull
    private final String TAG;
    private final boolean DEBUG;
    @NotNull
    private final HashSet<TransitionComposeAnimation> trackedTransitions;
    @NotNull
    private final HashMap<Transition<Object>, TransitionState> transitionStates;
    @NotNull
    private final Object transitionStatesLock;

    public PreviewAnimationClock(@NotNull Function0<Unit> setAnimationsTimeCallback) {
        Intrinsics.checkNotNullParameter(setAnimationsTimeCallback, (String)"setAnimationsTimeCallback");
        this.setAnimationsTimeCallback = setAnimationsTimeCallback;
        this.TAG = "PreviewAnimationClock";
        boolean bl = false;
        this.trackedTransitions = new HashSet();
        bl = false;
        this.transitionStates = new HashMap();
        this.transitionStatesLock = new Object();
    }

    public /* synthetic */ PreviewAnimationClock(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        this((Function0<Unit>)function0);
    }

    @NotNull
    public final HashSet<TransitionComposeAnimation> getTrackedTransitions$ui_tooling_release() {
        return this.trackedTransitions;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTrackedTransitions$ui_tooling_release$annotations() {
    }

    @NotNull
    public final HashMap<Transition<Object>, TransitionState> getTransitionStates$ui_tooling_release() {
        return this.transitionStates;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTransitionStates$ui_tooling_release$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void trackTransition(@NotNull Transition<Object> transition) {
        Intrinsics.checkNotNullParameter(transition, (String)"transition");
        Object object = this.transitionStatesLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.getTransitionStates$ui_tooling_release().containsKey(transition)) {
                if (this.DEBUG) {
                    Log.d((String)this.TAG, (String)("Transition " + transition + " is already being tracked"));
                }
                return;
            }
            Map map = this.getTransitionStates$ui_tooling_release();
            TransitionState transitionState = new TransitionState(transition.getCurrentState(), transition.getTargetState());
            boolean bl4 = false;
            map.put(transition, transitionState);
            Unit unit = Unit.INSTANCE;
        }
        if (this.DEBUG) {
            Log.d((String)this.TAG, (String)("Transition " + transition + " is now tracked"));
        }
        TransitionComposeAnimation composeAnimation = ComposeAnimationParserKt.parse(transition);
        this.trackedTransitions.add(composeAnimation);
        this.notifySubscribe(composeAnimation);
    }

    @VisibleForTesting
    protected void notifySubscribe(@NotNull ComposeAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
    }

    @VisibleForTesting
    protected void notifyUnsubscribe(@NotNull ComposeAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateFromAndToStates(@NotNull ComposeAnimation composeAnimation, @NotNull Object fromState, @NotNull Object toState) {
        Intrinsics.checkNotNullParameter((Object)composeAnimation, (String)"composeAnimation");
        Intrinsics.checkNotNullParameter((Object)fromState, (String)"fromState");
        Intrinsics.checkNotNullParameter((Object)toState, (String)"toState");
        if (composeAnimation.getType() != ComposeAnimationType.TRANSITION_ANIMATION) {
            return;
        }
        if (CollectionsKt.contains((Iterable)this.trackedTransitions, (Object)composeAnimation)) {
            TransitionComposeAnimation transitionComposeAnimation = (TransitionComposeAnimation)composeAnimation;
            Object object = this.transitionStatesLock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                Map map = this.getTransitionStates$ui_tooling_release();
                Transition<Object> transition = transitionComposeAnimation.getAnimationObject();
                TransitionState transitionState = new TransitionState(fromState, toState);
                boolean bl4 = false;
                map.put(transition, transitionState);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final long getMaxDuration() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.trackedTransitions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void composeAnimation;
            TransitionComposeAnimation transitionComposeAnimation = (TransitionComposeAnimation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = this.nanosToMillis(composeAnimation.getAnimationObject().getTotalDurationNanos());
            collection.add(l);
        }
        Long l = (Long)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        return l == null ? -1L : l;
    }

    /*
     * WARNING - void declaration
     */
    public final long getMaxDurationPerIteration() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.trackedTransitions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void composeAnimation;
            TransitionComposeAnimation transitionComposeAnimation = (TransitionComposeAnimation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = this.nanosToMillis(composeAnimation.getAnimationObject().getTotalDurationNanos());
            collection.add(l);
        }
        Long l = (Long)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        return l == null ? -1L : l;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ComposeAnimatedProperty> getAnimatedProperties(@NotNull ComposeAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        if (animation.getType() != ComposeAnimationType.TRANSITION_ANIMATION) {
            return CollectionsKt.emptyList();
        }
        if (CollectionsKt.contains((Iterable)this.trackedTransitions, (Object)animation)) {
            void $this$mapNotNullTo$iv$iv;
            Transition<Object> transition = ((TransitionComposeAnimation)animation).getAnimationObject();
            Iterable $this$mapNotNull$iv = transition.getAnimations();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ComposeAnimatedProperty composeAnimatedProperty;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Transition.TransitionAnimationState it = (Transition.TransitionAnimationState)element$iv$iv;
                boolean bl2 = false;
                Object object = it.getValue();
                if (object == null) {
                    ComposeAnimatedProperty composeAnimatedProperty2 = null;
                    it.getLabel();
                    composeAnimatedProperty = composeAnimatedProperty2;
                } else {
                    String string;
                    Object object2 = object;
                    composeAnimatedProperty = new ComposeAnimatedProperty(string, object2);
                }
                if (composeAnimatedProperty == null) continue;
                ComposeAnimatedProperty composeAnimatedProperty3 = composeAnimatedProperty;
                boolean bl3 = false;
                boolean bl4 = false;
                ComposeAnimatedProperty it$iv$iv = composeAnimatedProperty3;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    public final void setClockTime(long animationTimeMs) {
        long timeNs = TimeUnit.MILLISECONDS.toNanos(animationTimeMs);
        Iterable $this$forEach$iv = this.trackedTransitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TransitionState transitionState;
            TransitionComposeAnimation composeAnimation = (TransitionComposeAnimation)element$iv;
            boolean bl = false;
            Transition<Object> transition = composeAnimation.getAnimationObject();
            boolean bl2 = false;
            boolean bl3 = false;
            Transition<Object> it = transition;
            boolean bl4 = false;
            TransitionState transitionState2 = this.getTransitionStates$ui_tooling_release().get(it);
            if (transitionState2 == null) continue;
            TransitionState states = transitionState = transitionState2;
            it.seek(states.getCurrent(), states.getTarget(), timeNs);
        }
        this.setAnimationsTimeCallback.invoke();
    }

    public final void dispose() {
        Iterable $this$forEach$iv = this.trackedTransitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TransitionComposeAnimation it = (TransitionComposeAnimation)element$iv;
            boolean bl = false;
            this.notifyUnsubscribe(it);
        }
        this.trackedTransitions.clear();
        this.transitionStates.clear();
    }

    private final long nanosToMillis(long timeNs) {
        return (timeNs + (long)999999) / (long)1000000;
    }

    public PreviewAnimationClock() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\u0012"}, d2={"Landroidx/compose/ui/tooling/animation/PreviewAnimationClock$TransitionState;", "", "current", "target", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getCurrent", "()Ljava/lang/Object;", "getTarget", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ui-tooling_release"})
    @VisibleForTesting
    public static final class TransitionState {
        @NotNull
        private final Object current;
        @NotNull
        private final Object target;

        public TransitionState(@NotNull Object current, @NotNull Object target) {
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.current = current;
            this.target = target;
        }

        @NotNull
        public final Object getCurrent() {
            return this.current;
        }

        @NotNull
        public final Object getTarget() {
            return this.target;
        }

        @NotNull
        public final Object component1() {
            return this.current;
        }

        @NotNull
        public final Object component2() {
            return this.target;
        }

        @NotNull
        public final TransitionState copy(@NotNull Object current, @NotNull Object target) {
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new TransitionState(current, target);
        }

        public static /* synthetic */ TransitionState copy$default(TransitionState transitionState, Object object, Object object2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = transitionState.current;
            }
            if ((n & 2) != 0) {
                object2 = transitionState.target;
            }
            return transitionState.copy(object, object2);
        }

        @NotNull
        public String toString() {
            return "TransitionState(current=" + this.current + ", target=" + this.target + ')';
        }

        public int hashCode() {
            int result = this.current.hashCode();
            result = result * 31 + this.target.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TransitionState)) {
                return false;
            }
            TransitionState transitionState = (TransitionState)other;
            if (!Intrinsics.areEqual((Object)this.current, (Object)transitionState.current)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.target, (Object)transitionState.target);
        }
    }
}

