/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.compose;

import androidx.compose.ui.layout.LayoutIdKt;
import androidx.compose.ui.layout.Measurable;
import androidx.constraintlayout.compose.State;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.HelperWidget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a(\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\u001a$\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u000e0\u000e*\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\b*\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u000e\u0010\u0018\u001a\u00020\b*\u0004\u0018\u00010\u0016H\u0002\u001aB\u0010\u0019\u001a\u00020\u0003*\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u001f2\u0006\u0010 \u001a\u00020!H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"CONSTRAINTS_JSON_VERSION", "", "addReferencesIds", "", "helperWidget", "Landroidx/constraintlayout/core/widgets/HelperWidget;", "helperReferences", "", "", "root", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "rootId", "createDesignInfoJson", "content", "Lorg/json/JSONObject;", "parseConstraintsToJson", "state", "Landroidx/constraintlayout/compose/State;", "startX", "startY", "boundsToJson", "kotlin.jvm.PlatformType", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "getHelperId", "getRefId", "putViewIdToBoundsAndConstraints", "viewId", "boxJson", "isHelper", "", "isRoot", "", "constraintsInfoArray", "Lorg/json/JSONArray;", "compose_release"})
public final class ToolingUtilsKt {
    private static final int CONSTRAINTS_JSON_VERSION = 1;

    @NotNull
    public static final String parseConstraintsToJson(@NotNull ConstraintWidgetContainer root, @NotNull State state2, int startX, int startY) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        String rootId = new Object().toString();
        JSONObject idToConstraintsJson = new JSONObject();
        ArrayList arrayList = root.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"root.children");
        Iterable $this$forEach$iv = arrayList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String widgetId;
            String string;
            ConstraintWidget constraintWidget = (ConstraintWidget)element$iv;
            boolean bl = false;
            JSONArray constraintsInfoArray = new JSONArray();
            boolean bl2 = false;
            List helperReferences = new ArrayList();
            boolean isParent = Intrinsics.areEqual((Object)root, (Object)constraintWidget);
            boolean isHelper = constraintWidget instanceof HelperWidget;
            if (isParent) {
                string = rootId;
            } else if (isHelper) {
                Intrinsics.checkNotNullExpressionValue((Object)constraintWidget, (String)"constraintWidget");
                string = ToolingUtilsKt.getHelperId(constraintWidget, state2);
            } else {
                string = widgetId = ToolingUtilsKt.getRefId(constraintWidget);
            }
            if (isHelper) {
                if (constraintWidget == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.core.widgets.HelperWidget");
                }
                ToolingUtilsKt.addReferencesIds((HelperWidget)constraintWidget, helperReferences, root, rootId);
            }
            ArrayList arrayList2 = constraintWidget.getAnchors();
            Intrinsics.checkNotNullExpressionValue((Object)arrayList2, (String)"constraintWidget.anchors");
            Iterable $this$forEach$iv2 = arrayList2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String string2;
                ConstraintAnchor anchor = (ConstraintAnchor)element$iv2;
                boolean bl3 = false;
                if (!anchor.isConnected()) continue;
                ConstraintWidget targetWidget = anchor.getTarget().getOwner();
                boolean targetIsParent = Intrinsics.areEqual((Object)root, (Object)targetWidget);
                boolean targetIsHelper = targetWidget instanceof HelperWidget;
                if (targetIsParent) {
                    string2 = rootId;
                } else if (targetIsHelper) {
                    Intrinsics.checkNotNullExpressionValue((Object)targetWidget, (String)"targetWidget");
                    string2 = ToolingUtilsKt.getHelperId(targetWidget, state2);
                } else {
                    string2 = ToolingUtilsKt.getRefId(targetWidget);
                }
                String targetId = string2;
                JSONObject jSONObject = new JSONObject().put("originAnchor", (Object)anchor.getType());
                ConstraintAnchor constraintAnchor = anchor.getTarget();
                Intrinsics.checkNotNull((Object)constraintAnchor);
                constraintsInfoArray.put((Object)jSONObject.put("targetAnchor", (Object)constraintAnchor.getType()).put("target", (Object)targetId).put("margin", anchor.getMargin()));
            }
            Intrinsics.checkNotNullExpressionValue((Object)constraintWidget, (String)"constraintWidget");
            arrayList2 = ToolingUtilsKt.boundsToJson(constraintWidget, startX, startY);
            Intrinsics.checkNotNullExpressionValue((Object)arrayList2, (String)"constraintWidget.boundsToJson(startX, startY)");
            ToolingUtilsKt.putViewIdToBoundsAndConstraints(idToConstraintsJson, widgetId, (JSONObject)arrayList2, constraintWidget instanceof HelperWidget, false, helperReferences, constraintsInfoArray);
        }
        arrayList = ToolingUtilsKt.boundsToJson((ConstraintWidget)root, startX, startY);
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"root.boundsToJson(startX, startY)");
        ToolingUtilsKt.putViewIdToBoundsAndConstraints(idToConstraintsJson, rootId, (JSONObject)arrayList, false, true, CollectionsKt.emptyList(), new JSONArray());
        return ToolingUtilsKt.createDesignInfoJson(idToConstraintsJson);
    }

    private static final void addReferencesIds(HelperWidget helperWidget, List<String> helperReferences, ConstraintWidgetContainer root, String rootId) {
        ConstraintWidget[] constraintWidgetArray = helperWidget.mWidgets;
        Intrinsics.checkNotNullExpressionValue((Object)constraintWidgetArray, (String)"helperWidget.mWidgets");
        Object[] $this$forEach$iv = constraintWidgetArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConstraintWidget referencedWidget = (ConstraintWidget)element$iv;
            boolean bl = false;
            String referenceId = Intrinsics.areEqual((Object)referencedWidget, (Object)root) ? rootId : ToolingUtilsKt.getRefId(referencedWidget);
            helperReferences.add(referenceId);
        }
    }

    private static final String getHelperId(ConstraintWidget $this$getHelperId, State state2) {
        return String.valueOf(state2.getKeyId$compose_release((HelperWidget)$this$getHelperId));
    }

    private static final String getRefId(ConstraintWidget $this$getRefId) {
        ConstraintWidget constraintWidget = $this$getRefId;
        Object object = constraintWidget == null ? null : constraintWidget.getCompanionWidget();
        Measurable measurable = object instanceof Measurable ? (Measurable)object : null;
        return String.valueOf(measurable == null ? null : LayoutIdKt.getLayoutId((Measurable)measurable));
    }

    private static final String createDesignInfoJson(JSONObject content) {
        String string = new JSONObject().put("type", (Object)"CONSTRAINTS").put("version", 1).put("content", (Object)content).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONObject()\n    .put(\"type\", \"CONSTRAINTS\")\n    .put(\"version\", CONSTRAINTS_JSON_VERSION)\n    .put(\"content\", content).toString()");
        return string;
    }

    private static final JSONObject boundsToJson(ConstraintWidget $this$boundsToJson, int startX, int startY) {
        return new JSONObject().put("left", $this$boundsToJson.getLeft() + startX).put("top", $this$boundsToJson.getTop() + startY).put("right", $this$boundsToJson.getRight() + startX).put("bottom", $this$boundsToJson.getBottom() + startY);
    }

    private static final void putViewIdToBoundsAndConstraints(JSONObject $this$putViewIdToBoundsAndConstraints, String viewId, JSONObject boxJson, boolean isHelper, boolean isRoot, List<String> helperReferences, JSONArray constraintsInfoArray) {
        JSONObject viewWithBoundsAndConstraints = new JSONObject();
        viewWithBoundsAndConstraints.put("viewId", (Object)viewId);
        viewWithBoundsAndConstraints.put("box", (Object)boxJson);
        viewWithBoundsAndConstraints.put("isHelper", isHelper);
        viewWithBoundsAndConstraints.put("isRoot", isRoot);
        JSONArray helperReferencesArray = new JSONArray();
        Iterable $this$forEach$iv = helperReferences;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object p0 = element$iv = iterator.next();
            helperReferencesArray.put(p0);
        }
        viewWithBoundsAndConstraints.put("helperReferences", (Object)helperReferencesArray);
        viewWithBoundsAndConstraints.put("constraints", (Object)constraintsInfoArray);
        $this$putViewIdToBoundsAndConstraints.put(viewId, (Object)viewWithBoundsAndConstraints);
    }
}

