/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.compose;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import androidx.constraintlayout.core.motion.Motion;
import androidx.constraintlayout.core.motion.MotionPaths;
import java.util.HashMap;

class MotionRenderDebug {
    public static final int DEBUG_SHOW_NONE = 0;
    public static final int DEBUG_SHOW_PROGRESS = 1;
    public static final int DEBUG_SHOW_PATH = 2;
    static final int MAX_KEY_FRAMES = 50;
    private static final int DEBUG_PATH_TICKS_PER_MS = 16;
    float[] mPoints;
    int[] mPathMode;
    float[] mKeyFramePoints;
    Path mPath;
    Paint mPaint;
    Paint mPaintKeyframes;
    Paint mPaintGraph;
    Paint mTextPaint;
    Paint mFillPaint;
    private float[] mRectangle;
    final int RED_COLOR = -21965;
    final int KEYFRAME_COLOR = -2067046;
    final int GRAPH_COLOR = -13391360;
    final int SHADOW_COLOR = 0x77000000;
    final int DIAMOND_SIZE = 10;
    DashPathEffect mDashPathEffect;
    int mKeyFrameCount;
    Rect mBounds = new Rect();
    boolean mPresentationMode = false;
    int mShadowTranslate = 1;

    public MotionRenderDebug(float textSize) {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(-21965);
        this.mPaint.setStrokeWidth(2.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaintKeyframes = new Paint();
        this.mPaintKeyframes.setAntiAlias(true);
        this.mPaintKeyframes.setColor(-2067046);
        this.mPaintKeyframes.setStrokeWidth(2.0f);
        this.mPaintKeyframes.setStyle(Paint.Style.STROKE);
        this.mPaintGraph = new Paint();
        this.mPaintGraph.setAntiAlias(true);
        this.mPaintGraph.setColor(-13391360);
        this.mPaintGraph.setStrokeWidth(2.0f);
        this.mPaintGraph.setStyle(Paint.Style.STROKE);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setColor(-13391360);
        this.mTextPaint.setTextSize(textSize);
        this.mRectangle = new float[8];
        this.mFillPaint = new Paint();
        this.mFillPaint.setAntiAlias(true);
        this.mDashPathEffect = new DashPathEffect(new float[]{4.0f, 8.0f}, 0.0f);
        this.mPaintGraph.setPathEffect((PathEffect)this.mDashPathEffect);
        this.mKeyFramePoints = new float[100];
        this.mPathMode = new int[50];
        if (this.mPresentationMode) {
            this.mPaint.setStrokeWidth(8.0f);
            this.mFillPaint.setStrokeWidth(8.0f);
            this.mPaintKeyframes.setStrokeWidth(8.0f);
            this.mShadowTranslate = 4;
        }
    }

    public void draw(Canvas canvas, HashMap<String, Motion> frameArrayList, int duration, int debugPath, int layoutWidth, int layoutHeight) {
        if (frameArrayList == null || frameArrayList.size() == 0) {
            return;
        }
        canvas.save();
        for (Motion motionController : frameArrayList.values()) {
            this.draw(canvas, motionController, duration, debugPath, layoutWidth, layoutHeight);
        }
        canvas.restore();
    }

    public void draw(Canvas canvas, Motion motionController, int duration, int debugPath, int layoutWidth, int layoutHeight) {
        int mode = motionController.getDrawPath();
        if (debugPath > 0 && mode == 0) {
            mode = 1;
        }
        if (mode == 0) {
            return;
        }
        this.mKeyFrameCount = motionController.buildKeyFrames(this.mKeyFramePoints, this.mPathMode, null);
        if (mode >= 1) {
            int frames = duration / 16;
            if (this.mPoints == null || this.mPoints.length != frames * 2) {
                this.mPoints = new float[frames * 2];
                this.mPath = new Path();
            }
            canvas.translate((float)this.mShadowTranslate, (float)this.mShadowTranslate);
            this.mPaint.setColor(0x77000000);
            this.mFillPaint.setColor(0x77000000);
            this.mPaintKeyframes.setColor(0x77000000);
            this.mPaintGraph.setColor(0x77000000);
            motionController.buildPath(this.mPoints, frames);
            this.drawAll(canvas, mode, this.mKeyFrameCount, motionController, layoutWidth, layoutHeight);
            this.mPaint.setColor(-21965);
            this.mPaintKeyframes.setColor(-2067046);
            this.mFillPaint.setColor(-2067046);
            this.mPaintGraph.setColor(-13391360);
            canvas.translate((float)(-this.mShadowTranslate), (float)(-this.mShadowTranslate));
            this.drawAll(canvas, mode, this.mKeyFrameCount, motionController, layoutWidth, layoutHeight);
            if (mode == 5) {
                this.drawRectangle(canvas, motionController);
            }
        }
    }

    public void drawAll(Canvas canvas, int mode, int keyFrames, Motion motionController, int layoutWidth, int layoutHeight) {
        if (mode == 4) {
            this.drawPathAsConfigured(canvas);
        }
        if (mode == 2) {
            this.drawPathRelative(canvas);
        }
        if (mode == 3) {
            this.drawPathCartesian(canvas);
        }
        this.drawBasicPath(canvas);
        this.drawTicks(canvas, mode, keyFrames, motionController, layoutWidth, layoutHeight);
    }

    private void drawBasicPath(Canvas canvas) {
        canvas.drawLines(this.mPoints, this.mPaint);
    }

    private void drawTicks(Canvas canvas, int mode, int keyFrames, Motion motionController, int layoutWidth, int layoutHeight) {
        int viewWidth = 0;
        int viewHeight = 0;
        if (motionController.getView() != null) {
            viewWidth = motionController.getView().getWidth();
            viewHeight = motionController.getView().getHeight();
        }
        for (int i = 1; i < keyFrames - 1; ++i) {
            if (mode == 4 && this.mPathMode[i - 1] == 0) continue;
            float x = this.mKeyFramePoints[i * 2];
            float y = this.mKeyFramePoints[i * 2 + 1];
            this.mPath.reset();
            this.mPath.moveTo(x, y + 10.0f);
            this.mPath.lineTo(x + 10.0f, y);
            this.mPath.lineTo(x, y - 10.0f);
            this.mPath.lineTo(x - 10.0f, y);
            this.mPath.close();
            MotionPaths framePoint = motionController.getKeyFrame(i - 1);
            float dx = 0.0f;
            float dy = 0.0f;
            if (mode == 4) {
                if (this.mPathMode[i - 1] == 1) {
                    this.drawPathRelativeTicks(canvas, x - dx, y - dy);
                } else if (this.mPathMode[i - 1] == 0) {
                    this.drawPathCartesianTicks(canvas, x - dx, y - dy);
                } else if (this.mPathMode[i - 1] == 2) {
                    this.drawPathScreenTicks(canvas, x - dx, y - dy, viewWidth, viewHeight, layoutWidth, layoutHeight);
                }
                canvas.drawPath(this.mPath, this.mFillPaint);
            }
            if (mode == 2) {
                this.drawPathRelativeTicks(canvas, x - dx, y - dy);
            }
            if (mode == 3) {
                this.drawPathCartesianTicks(canvas, x - dx, y - dy);
            }
            if (mode == 6) {
                this.drawPathScreenTicks(canvas, x - dx, y - dy, viewWidth, viewHeight, layoutWidth, layoutHeight);
            }
            if (dx != 0.0f || dy != 0.0f) {
                this.drawTranslation(canvas, x - dx, y - dy, x, y);
                continue;
            }
            canvas.drawPath(this.mPath, this.mFillPaint);
        }
        if (this.mPoints.length > 1) {
            canvas.drawCircle(this.mPoints[0], this.mPoints[1], 8.0f, this.mPaintKeyframes);
            canvas.drawCircle(this.mPoints[this.mPoints.length - 2], this.mPoints[this.mPoints.length - 1], 8.0f, this.mPaintKeyframes);
        }
    }

    private void drawTranslation(Canvas canvas, float x1, float y1, float x2, float y2) {
        canvas.drawRect(x1, y1, x2, y2, this.mPaintGraph);
        canvas.drawLine(x1, y1, x2, y2, this.mPaintGraph);
    }

    private void drawPathRelative(Canvas canvas) {
        canvas.drawLine(this.mPoints[0], this.mPoints[1], this.mPoints[this.mPoints.length - 2], this.mPoints[this.mPoints.length - 1], this.mPaintGraph);
    }

    private void drawPathAsConfigured(Canvas canvas) {
        boolean path = false;
        boolean cart = false;
        for (int i = 0; i < this.mKeyFrameCount; ++i) {
            if (this.mPathMode[i] == 1) {
                path = true;
            }
            if (this.mPathMode[i] != 0) continue;
            cart = true;
        }
        if (path) {
            this.drawPathRelative(canvas);
        }
        if (cart) {
            this.drawPathCartesian(canvas);
        }
    }

    private void drawPathRelativeTicks(Canvas canvas, float x, float y) {
        float x1 = this.mPoints[0];
        float y1 = this.mPoints[1];
        float x2 = this.mPoints[this.mPoints.length - 2];
        float y2 = this.mPoints[this.mPoints.length - 1];
        float dist = (float)Math.hypot(x1 - x2, y1 - y2);
        float t = ((x - x1) * (x2 - x1) + (y - y1) * (y2 - y1)) / (dist * dist);
        float xp = x1 + t * (x2 - x1);
        float yp = y1 + t * (y2 - y1);
        Path path = new Path();
        path.moveTo(x, y);
        path.lineTo(xp, yp);
        float len = (float)Math.hypot(xp - x, yp - y);
        String text = "" + (float)((int)(100.0f * len / dist)) / 100.0f;
        this.getTextBounds(text, this.mTextPaint);
        float off = len / 2.0f - (float)(this.mBounds.width() / 2);
        canvas.drawTextOnPath(text, path, off, -20.0f, this.mTextPaint);
        canvas.drawLine(x, y, xp, yp, this.mPaintGraph);
    }

    void getTextBounds(String text, Paint paint) {
        paint.getTextBounds(text, 0, text.length(), this.mBounds);
    }

    private void drawPathCartesian(Canvas canvas) {
        float x1 = this.mPoints[0];
        float y1 = this.mPoints[1];
        float x2 = this.mPoints[this.mPoints.length - 2];
        float y2 = this.mPoints[this.mPoints.length - 1];
        canvas.drawLine(Math.min(x1, x2), Math.max(y1, y2), Math.max(x1, x2), Math.max(y1, y2), this.mPaintGraph);
        canvas.drawLine(Math.min(x1, x2), Math.min(y1, y2), Math.min(x1, x2), Math.max(y1, y2), this.mPaintGraph);
    }

    private void drawPathCartesianTicks(Canvas canvas, float x, float y) {
        float x1 = this.mPoints[0];
        float y1 = this.mPoints[1];
        float x2 = this.mPoints[this.mPoints.length - 2];
        float y2 = this.mPoints[this.mPoints.length - 1];
        float minx = Math.min(x1, x2);
        float maxy = Math.max(y1, y2);
        float xgap = x - Math.min(x1, x2);
        float ygap = Math.max(y1, y2) - y;
        String text = "" + (float)((int)(0.5 + (double)(100.0f * xgap / Math.abs(x2 - x1)))) / 100.0f;
        this.getTextBounds(text, this.mTextPaint);
        float off = xgap / 2.0f - (float)(this.mBounds.width() / 2);
        canvas.drawText(text, off + minx, y - 20.0f, this.mTextPaint);
        canvas.drawLine(x, y, Math.min(x1, x2), y, this.mPaintGraph);
        text = "" + (float)((int)(0.5 + (double)(100.0f * ygap / Math.abs(y2 - y1)))) / 100.0f;
        this.getTextBounds(text, this.mTextPaint);
        off = ygap / 2.0f - (float)(this.mBounds.height() / 2);
        canvas.drawText(text, x + 5.0f, maxy - off, this.mTextPaint);
        canvas.drawLine(x, y, x, Math.max(y1, y2), this.mPaintGraph);
    }

    private void drawPathScreenTicks(Canvas canvas, float x, float y, int viewWidth, int viewHeight, int layoutWidth, int layoutHeight) {
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 1.0f;
        float y2 = 1.0f;
        float minx = 0.0f;
        float maxy = 0.0f;
        float xgap = x;
        float ygap = y;
        String text = "" + (float)((int)(0.5 + (double)(100.0f * (xgap - (float)(viewWidth / 2)) / (float)(layoutWidth - viewWidth)))) / 100.0f;
        this.getTextBounds(text, this.mTextPaint);
        float off = xgap / 2.0f - (float)(this.mBounds.width() / 2);
        canvas.drawText(text, off + minx, y - 20.0f, this.mTextPaint);
        canvas.drawLine(x, y, Math.min(x1, x2), y, this.mPaintGraph);
        text = "" + (float)((int)(0.5 + (double)(100.0f * (ygap - (float)(viewHeight / 2)) / (float)(layoutHeight - viewHeight)))) / 100.0f;
        this.getTextBounds(text, this.mTextPaint);
        off = ygap / 2.0f - (float)(this.mBounds.height() / 2);
        canvas.drawText(text, x + 5.0f, maxy - off, this.mTextPaint);
        canvas.drawLine(x, y, x, Math.max(y1, y2), this.mPaintGraph);
    }

    private void drawRectangle(Canvas canvas, Motion motionController) {
        this.mPath.reset();
        int rectFrames = 50;
        for (int i = 0; i <= rectFrames; ++i) {
            float p = (float)i / (float)rectFrames;
            motionController.buildRect(p, this.mRectangle, 0);
            this.mPath.moveTo(this.mRectangle[0], this.mRectangle[1]);
            this.mPath.lineTo(this.mRectangle[2], this.mRectangle[3]);
            this.mPath.lineTo(this.mRectangle[4], this.mRectangle[5]);
            this.mPath.lineTo(this.mRectangle[6], this.mRectangle[7]);
            this.mPath.close();
        }
        this.mPaint.setColor(0x44000000);
        canvas.translate(2.0f, 2.0f);
        canvas.drawPath(this.mPath, this.mPaint);
        canvas.translate(-2.0f, -2.0f);
        this.mPaint.setColor(-65536);
        canvas.drawPath(this.mPath, this.mPaint);
    }
}

