/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.constraintlayout.core.ArrayRow;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.SolverVariable;
import androidx.constraintlayout.core.widgets.ChainHead;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import java.util.ArrayList;

class Chain {
    private static final boolean DEBUG = false;

    Chain() {
    }

    static void applyChainConstraints(ConstraintWidgetContainer constraintWidgetContainer, LinearSystem system, int orientation) {
        int offset = 0;
        int chainsSize = 0;
        ChainHead[] chainsArray = null;
        if (orientation == 0) {
            offset = 0;
            chainsSize = constraintWidgetContainer.mHorizontalChainsSize;
            chainsArray = constraintWidgetContainer.mHorizontalChainsArray;
        } else {
            offset = 2;
            chainsSize = constraintWidgetContainer.mVerticalChainsSize;
            chainsArray = constraintWidgetContainer.mVerticalChainsArray;
        }
        for (int i = 0; i < chainsSize; ++i) {
            ChainHead first = chainsArray[i];
            first.define();
            Chain.applyChainConstraints(constraintWidgetContainer, system, orientation, offset, first);
        }
    }

    static void applyChainConstraints(ConstraintWidgetContainer container, LinearSystem system, int orientation, int offset, ChainHead chainHead) {
        SolverVariable beginNextTarget;
        SolverVariable beginNext;
        SolverVariable beginTarget;
        int count;
        ArrayList<ConstraintWidget> listMatchConstraints;
        ConstraintWidget first = chainHead.mFirst;
        ConstraintWidget last = chainHead.mLast;
        ConstraintWidget firstVisibleWidget = chainHead.mFirstVisibleWidget;
        ConstraintWidget lastVisibleWidget = chainHead.mLastVisibleWidget;
        ConstraintWidget head = chainHead.mHead;
        ConstraintWidget widget = first;
        ConstraintWidget next = null;
        boolean done = false;
        float totalWeights = chainHead.mTotalWeight;
        ConstraintWidget firstMatchConstraintsWidget = chainHead.mFirstMatchConstraintWidget;
        ConstraintWidget previousMatchConstraintsWidget = chainHead.mLastMatchConstraintWidget;
        boolean isWrapContent = container.mListDimensionBehaviors[orientation] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        boolean isChainSpread = false;
        boolean isChainSpreadInside = false;
        boolean isChainPacked = false;
        if (orientation == 0) {
            isChainSpread = head.mHorizontalChainStyle == 0;
            isChainSpreadInside = head.mHorizontalChainStyle == 1;
            isChainPacked = head.mHorizontalChainStyle == 2;
        } else {
            isChainSpread = head.mVerticalChainStyle == 0;
            isChainSpreadInside = head.mVerticalChainStyle == 1;
            boolean bl = isChainPacked = head.mVerticalChainStyle == 2;
        }
        while (!done) {
            ConstraintAnchor nextAnchor;
            boolean isSpreadOnly;
            ConstraintAnchor begin = widget.mListAnchors[offset];
            int strength = 4;
            if (isWrapContent || isChainPacked) {
                strength = 1;
            }
            int margin = begin.getMargin();
            boolean bl = isSpreadOnly = widget.mListDimensionBehaviors[orientation] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mResolvedMatchConstraintDefault[orientation] == 0;
            if (begin.mTarget != null && widget != first) {
                margin += begin.mTarget.getMargin();
            }
            if (isChainPacked && widget != first && widget != firstVisibleWidget) {
                strength = 5;
            } else if (isChainSpread && isWrapContent) {
                strength = 4;
            }
            if (begin.mTarget != null) {
                if (widget == firstVisibleWidget) {
                    system.addGreaterThan(begin.mSolverVariable, begin.mTarget.mSolverVariable, margin, 5);
                } else {
                    system.addGreaterThan(begin.mSolverVariable, begin.mTarget.mSolverVariable, margin, 6);
                }
                if (isSpreadOnly && !isChainPacked && begin.mTarget.mOwner == container) {
                    strength = 5;
                }
                system.addEquality(begin.mSolverVariable, begin.mTarget.mSolverVariable, margin, strength);
            }
            if (isWrapContent) {
                if (widget.getVisibility() != 8 && widget.mListDimensionBehaviors[orientation] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    system.addGreaterThan(widget.mListAnchors[offset + 1].mSolverVariable, widget.mListAnchors[offset].mSolverVariable, 0, 5);
                }
                system.addGreaterThan(widget.mListAnchors[offset].mSolverVariable, container.mListAnchors[offset].mSolverVariable, 0, 6);
            }
            if ((nextAnchor = widget.mListAnchors[offset + 1].mTarget) != null) {
                next = nextAnchor.mOwner;
                if (next.mListAnchors[offset].mTarget == null || next.mListAnchors[offset].mTarget.mOwner != widget) {
                    next = null;
                }
            } else {
                next = null;
            }
            if (next != null) {
                widget = next;
                continue;
            }
            done = true;
        }
        if (lastVisibleWidget != null && last.mListAnchors[offset + 1].mTarget != null) {
            boolean isSpreadOnly;
            ConstraintAnchor end = lastVisibleWidget.mListAnchors[offset + 1];
            boolean bl = isSpreadOnly = lastVisibleWidget.mListDimensionBehaviors[orientation] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && lastVisibleWidget.mResolvedMatchConstraintDefault[orientation] == 0;
            if (isSpreadOnly && !isChainPacked && end.mTarget.mOwner == container) {
                system.addEquality(end.mSolverVariable, end.mTarget.mSolverVariable, -end.getMargin(), 5);
            } else if (isChainPacked && end.mTarget.mOwner == container) {
                system.addEquality(end.mSolverVariable, end.mTarget.mSolverVariable, -end.getMargin(), 4);
            }
            system.addLowerThan(end.mSolverVariable, last.mListAnchors[offset + 1].mTarget.mSolverVariable, -end.getMargin(), 5);
        }
        if (isWrapContent) {
            system.addGreaterThan(container.mListAnchors[offset + 1].mSolverVariable, last.mListAnchors[offset + 1].mSolverVariable, last.mListAnchors[offset + 1].getMargin(), 6);
        }
        if ((listMatchConstraints = chainHead.mWeightedMatchConstraintsWidgets) != null && (count = listMatchConstraints.size()) > 1) {
            ConstraintWidget lastMatch = null;
            float lastWeight = 0.0f;
            if (chainHead.mHasUndefinedWeights && !chainHead.mHasComplexMatchWeights) {
                totalWeights = chainHead.mWidgetsMatchCount;
            }
            for (int i = 0; i < count; ++i) {
                ConstraintWidget match = listMatchConstraints.get(i);
                float currentWeight = match.mWeight[orientation];
                if (currentWeight < 0.0f) {
                    if (chainHead.mHasComplexMatchWeights) {
                        system.addEquality(match.mListAnchors[offset + 1].mSolverVariable, match.mListAnchors[offset].mSolverVariable, 0, 4);
                        continue;
                    }
                    currentWeight = 1.0f;
                }
                if (currentWeight == 0.0f) {
                    system.addEquality(match.mListAnchors[offset + 1].mSolverVariable, match.mListAnchors[offset].mSolverVariable, 0, 6);
                    continue;
                }
                if (lastMatch != null) {
                    SolverVariable begin = lastMatch.mListAnchors[offset].mSolverVariable;
                    SolverVariable end = lastMatch.mListAnchors[offset + 1].mSolverVariable;
                    SolverVariable nextBegin = match.mListAnchors[offset].mSolverVariable;
                    SolverVariable nextEnd = match.mListAnchors[offset + 1].mSolverVariable;
                    ArrayRow row = system.createRow();
                    row.createRowEqualMatchDimensions(lastWeight, totalWeights, currentWeight, begin, end, nextBegin, nextEnd);
                    system.addConstraint(row);
                }
                lastMatch = match;
                lastWeight = currentWeight;
            }
        }
        if (firstVisibleWidget != null && (firstVisibleWidget == lastVisibleWidget || isChainPacked)) {
            ConstraintAnchor begin = first.mListAnchors[offset];
            ConstraintAnchor end = last.mListAnchors[offset + 1];
            SolverVariable beginTarget2 = begin.mTarget != null ? begin.mTarget.mSolverVariable : null;
            SolverVariable endTarget = end.mTarget != null ? end.mTarget.mSolverVariable : null;
            begin = firstVisibleWidget.mListAnchors[offset];
            end = lastVisibleWidget.mListAnchors[offset + 1];
            if (beginTarget2 != null && endTarget != null) {
                float bias = 0.5f;
                bias = orientation == 0 ? head.mHorizontalBiasPercent : head.mVerticalBiasPercent;
                int beginMargin = begin.getMargin();
                int endMargin = end.getMargin();
                system.addCentering(begin.mSolverVariable, beginTarget2, beginMargin, bias, endTarget, end.mSolverVariable, endMargin, 5);
            }
        } else if (isChainSpread && firstVisibleWidget != null) {
            boolean applyFixedEquality;
            widget = firstVisibleWidget;
            ConstraintWidget previousVisibleWidget = firstVisibleWidget;
            boolean bl = applyFixedEquality = chainHead.mWidgetsMatchCount > 0 && chainHead.mWidgetsCount == chainHead.mWidgetsMatchCount;
            while (widget != null) {
                next = widget.mNextChainWidget[orientation];
                while (next != null && next.getVisibility() == 8) {
                    next = next.mNextChainWidget[orientation];
                }
                if (next != null || widget == lastVisibleWidget) {
                    ConstraintAnchor beginAnchor = widget.mListAnchors[offset];
                    SolverVariable begin = beginAnchor.mSolverVariable;
                    SolverVariable solverVariable = beginTarget = beginAnchor.mTarget != null ? beginAnchor.mTarget.mSolverVariable : null;
                    if (previousVisibleWidget != widget) {
                        beginTarget = previousVisibleWidget.mListAnchors[offset + 1].mSolverVariable;
                    } else if (widget == firstVisibleWidget && previousVisibleWidget == widget) {
                        beginTarget = first.mListAnchors[offset].mTarget != null ? first.mListAnchors[offset].mTarget.mSolverVariable : null;
                    }
                    ConstraintAnchor beginNextAnchor = null;
                    beginNext = null;
                    beginNextTarget = null;
                    int beginMargin = beginAnchor.getMargin();
                    int nextMargin = widget.mListAnchors[offset + 1].getMargin();
                    if (next != null) {
                        beginNextAnchor = next.mListAnchors[offset];
                        beginNext = beginNextAnchor.mSolverVariable;
                        beginNextTarget = widget.mListAnchors[offset + 1].mSolverVariable;
                    } else {
                        beginNextAnchor = last.mListAnchors[offset + 1].mTarget;
                        if (beginNextAnchor != null) {
                            beginNext = beginNextAnchor.mSolverVariable;
                        }
                        beginNextTarget = widget.mListAnchors[offset + 1].mSolverVariable;
                    }
                    if (beginNextAnchor != null) {
                        nextMargin += beginNextAnchor.getMargin();
                    }
                    if (previousVisibleWidget != null) {
                        beginMargin += previousVisibleWidget.mListAnchors[offset + 1].getMargin();
                    }
                    if (begin != null && beginTarget != null && beginNext != null && beginNextTarget != null) {
                        int margin1 = beginMargin;
                        if (widget == firstVisibleWidget) {
                            margin1 = firstVisibleWidget.mListAnchors[offset].getMargin();
                        }
                        int margin2 = nextMargin;
                        if (widget == lastVisibleWidget) {
                            margin2 = lastVisibleWidget.mListAnchors[offset + 1].getMargin();
                        }
                        int strength = 4;
                        if (applyFixedEquality) {
                            strength = 6;
                        }
                        system.addCentering(begin, beginTarget, margin1, 0.5f, beginNext, beginNextTarget, margin2, strength);
                    }
                }
                if (widget.getVisibility() != 8) {
                    previousVisibleWidget = widget;
                }
                widget = next;
            }
        } else if (isChainSpreadInside && firstVisibleWidget != null) {
            boolean applyFixedEquality;
            widget = firstVisibleWidget;
            ConstraintWidget previousVisibleWidget = firstVisibleWidget;
            boolean bl = applyFixedEquality = chainHead.mWidgetsMatchCount > 0 && chainHead.mWidgetsCount == chainHead.mWidgetsMatchCount;
            while (widget != null) {
                next = widget.mNextChainWidget[orientation];
                while (next != null && next.getVisibility() == 8) {
                    next = next.mNextChainWidget[orientation];
                }
                if (widget != firstVisibleWidget && widget != lastVisibleWidget && next != null) {
                    if (next == lastVisibleWidget) {
                        next = null;
                    }
                    ConstraintAnchor beginAnchor = widget.mListAnchors[offset];
                    SolverVariable begin = beginAnchor.mSolverVariable;
                    beginTarget = beginAnchor.mTarget != null ? beginAnchor.mTarget.mSolverVariable : null;
                    beginTarget = previousVisibleWidget.mListAnchors[offset + 1].mSolverVariable;
                    ConstraintAnchor beginNextAnchor = null;
                    beginNext = null;
                    beginNextTarget = null;
                    int beginMargin = beginAnchor.getMargin();
                    int nextMargin = widget.mListAnchors[offset + 1].getMargin();
                    if (next != null) {
                        beginNextAnchor = next.mListAnchors[offset];
                        beginNext = beginNextAnchor.mSolverVariable;
                        beginNextTarget = beginNextAnchor.mTarget != null ? beginNextAnchor.mTarget.mSolverVariable : null;
                    } else {
                        beginNextAnchor = lastVisibleWidget.mListAnchors[offset];
                        if (beginNextAnchor != null) {
                            beginNext = beginNextAnchor.mSolverVariable;
                        }
                        beginNextTarget = widget.mListAnchors[offset + 1].mSolverVariable;
                    }
                    if (beginNextAnchor != null) {
                        nextMargin += beginNextAnchor.getMargin();
                    }
                    if (previousVisibleWidget != null) {
                        beginMargin += previousVisibleWidget.mListAnchors[offset + 1].getMargin();
                    }
                    int strength = 4;
                    if (applyFixedEquality) {
                        strength = 6;
                    }
                    if (begin != null && beginTarget != null && beginNext != null && beginNextTarget != null) {
                        system.addCentering(begin, beginTarget, beginMargin, 0.5f, beginNext, beginNextTarget, nextMargin, strength);
                    }
                }
                if (widget.getVisibility() != 8) {
                    previousVisibleWidget = widget;
                }
                widget = next;
            }
            ConstraintAnchor begin = firstVisibleWidget.mListAnchors[offset];
            ConstraintAnchor beginTarget3 = first.mListAnchors[offset].mTarget;
            ConstraintAnchor end = lastVisibleWidget.mListAnchors[offset + 1];
            ConstraintAnchor endTarget = last.mListAnchors[offset + 1].mTarget;
            if (beginTarget3 != null) {
                if (firstVisibleWidget != lastVisibleWidget) {
                    system.addEquality(begin.mSolverVariable, beginTarget3.mSolverVariable, begin.getMargin(), 4);
                } else if (endTarget != null) {
                    system.addCentering(begin.mSolverVariable, beginTarget3.mSolverVariable, begin.getMargin(), 0.5f, end.mSolverVariable, endTarget.mSolverVariable, end.getMargin(), 4);
                }
            }
            if (endTarget != null && firstVisibleWidget != lastVisibleWidget) {
                system.addEquality(end.mSolverVariable, endTarget.mSolverVariable, -end.getMargin(), 4);
            }
        }
        if ((isChainSpread || isChainSpreadInside) && firstVisibleWidget != null) {
            SolverVariable endTarget;
            ConstraintAnchor begin = firstVisibleWidget.mListAnchors[offset];
            ConstraintAnchor end = lastVisibleWidget.mListAnchors[offset + 1];
            SolverVariable beginTarget4 = begin.mTarget != null ? begin.mTarget.mSolverVariable : null;
            SolverVariable solverVariable = endTarget = end.mTarget != null ? end.mTarget.mSolverVariable : null;
            if (last != lastVisibleWidget) {
                ConstraintAnchor realEnd = last.mListAnchors[offset + 1];
                SolverVariable solverVariable2 = endTarget = realEnd.mTarget != null ? realEnd.mTarget.mSolverVariable : null;
            }
            if (firstVisibleWidget == lastVisibleWidget) {
                begin = firstVisibleWidget.mListAnchors[offset];
                end = firstVisibleWidget.mListAnchors[offset + 1];
            }
            if (beginTarget4 != null && endTarget != null) {
                float bias = 0.5f;
                int beginMargin = begin.getMargin();
                if (lastVisibleWidget == null) {
                    lastVisibleWidget = last;
                }
                int endMargin = lastVisibleWidget.mListAnchors[offset + 1].getMargin();
                system.addCentering(begin.mSolverVariable, beginTarget4, beginMargin, bias, endTarget, end.mSolverVariable, endMargin, 5);
            }
        }
    }
}

