/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state.helpers;

import androidx.constraintlayout.core.state.HelperReference;
import androidx.constraintlayout.core.state.State;
import java.util.HashMap;

public class ChainReference
extends HelperReference {
    protected float mBias = 0.5f;
    protected HashMap<String, Float> mMapWeights;
    protected HashMap<String, Float> mMapPreMargin;
    protected HashMap<String, Float> mMapPostMargin;
    protected State.Chain mStyle = State.Chain.SPREAD;

    public ChainReference(State state, State.Helper type) {
        super(state, type);
    }

    public State.Chain getStyle() {
        return State.Chain.SPREAD;
    }

    public ChainReference style(State.Chain style) {
        this.mStyle = style;
        return this;
    }

    public void addChainElement(String id, float weight, float preMargin, float postMargin) {
        super.add(id);
        if (!Float.isNaN(weight)) {
            if (this.mMapWeights == null) {
                this.mMapWeights = new HashMap();
            }
            this.mMapWeights.put(id, Float.valueOf(weight));
        }
        if (!Float.isNaN(preMargin)) {
            if (this.mMapPreMargin == null) {
                this.mMapPreMargin = new HashMap();
            }
            this.mMapPreMargin.put(id, Float.valueOf(preMargin));
        }
        if (!Float.isNaN(postMargin)) {
            if (this.mMapPostMargin == null) {
                this.mMapPostMargin = new HashMap();
            }
            this.mMapPostMargin.put(id, Float.valueOf(postMargin));
        }
    }

    protected float getWeight(String id) {
        if (this.mMapWeights == null) {
            return -1.0f;
        }
        if (this.mMapWeights.containsKey(id)) {
            return this.mMapWeights.get(id).floatValue();
        }
        return -1.0f;
    }

    protected float getPostMargin(String id) {
        if (this.mMapPostMargin != null && this.mMapPostMargin.containsKey(id)) {
            return this.mMapPostMargin.get(id).floatValue();
        }
        return 0.0f;
    }

    protected float getPreMargin(String id) {
        if (this.mMapPreMargin != null && this.mMapPreMargin.containsKey(id)) {
            return this.mMapPreMargin.get(id).floatValue();
        }
        return 0.0f;
    }

    public float getBias() {
        return this.mBias;
    }

    @Override
    public ChainReference bias(float bias) {
        this.mBias = bias;
        return this;
    }
}

