/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

import androidx.constraintlayout.core.ArrayRow;
import androidx.constraintlayout.core.Cache;
import androidx.constraintlayout.core.SolverVariable;
import java.util.Arrays;

public class SolverVariableValues
implements ArrayRow.ArrayRowVariables {
    private static final boolean DEBUG = false;
    private static final boolean HASH = true;
    private static float sEpsilon = 0.001f;
    private final int mNone = -1;
    private int mSize = 16;
    private int mHashSize = 16;
    int[] mKeys = new int[this.mSize];
    int[] mNextKeys = new int[this.mSize];
    int[] mVariables = new int[this.mSize];
    float[] mValues = new float[this.mSize];
    int[] mPrevious = new int[this.mSize];
    int[] mNext = new int[this.mSize];
    int mCount = 0;
    int mHead = -1;
    private final ArrayRow mRow;
    protected final Cache mCache;

    SolverVariableValues(ArrayRow row, Cache cache) {
        this.mRow = row;
        this.mCache = cache;
        this.clear();
    }

    @Override
    public int getCurrentSize() {
        return this.mCount;
    }

    @Override
    public SolverVariable getVariable(int index) {
        int count = this.mCount;
        if (count == 0) {
            return null;
        }
        int j = this.mHead;
        for (int i = 0; i < count; ++i) {
            if (i == index && j != -1) {
                return this.mCache.mIndexedVariables[this.mVariables[j]];
            }
            if ((j = this.mNext[j]) == -1) break;
        }
        return null;
    }

    @Override
    public float getVariableValue(int index) {
        int count = this.mCount;
        int j = this.mHead;
        for (int i = 0; i < count; ++i) {
            if (i == index) {
                return this.mValues[j];
            }
            if ((j = this.mNext[j]) == -1) break;
        }
        return 0.0f;
    }

    @Override
    public boolean contains(SolverVariable variable) {
        return this.indexOf(variable) != -1;
    }

    @Override
    public int indexOf(SolverVariable variable) {
        if (this.mCount == 0 || variable == null) {
            return -1;
        }
        int id = variable.id;
        int key = id % this.mHashSize;
        if ((key = this.mKeys[key]) == -1) {
            return -1;
        }
        if (this.mVariables[key] == id) {
            return key;
        }
        while (this.mNextKeys[key] != -1 && this.mVariables[this.mNextKeys[key]] != id) {
            key = this.mNextKeys[key];
        }
        if (this.mNextKeys[key] == -1) {
            return -1;
        }
        if (this.mVariables[this.mNextKeys[key]] == id) {
            return this.mNextKeys[key];
        }
        return -1;
    }

    @Override
    public float get(SolverVariable variable) {
        int index = this.indexOf(variable);
        if (index != -1) {
            return this.mValues[index];
        }
        return 0.0f;
    }

    @Override
    public void display() {
        int count = this.mCount;
        System.out.print("{ ");
        for (int i = 0; i < count; ++i) {
            SolverVariable v = this.getVariable(i);
            if (v == null) continue;
            System.out.print(v + " = " + this.getVariableValue(i) + " ");
        }
        System.out.println(" }");
    }

    public String toString() {
        String str = this.hashCode() + " { ";
        int count = this.mCount;
        for (int i = 0; i < count; ++i) {
            SolverVariable v = this.getVariable(i);
            if (v == null) continue;
            str = str + v + " = " + this.getVariableValue(i) + " ";
            int index = this.indexOf(v);
            str = str + "[p: ";
            str = this.mPrevious[index] != -1 ? str + this.mCache.mIndexedVariables[this.mVariables[this.mPrevious[index]]] : str + "none";
            str = str + ", n: ";
            str = this.mNext[index] != -1 ? str + this.mCache.mIndexedVariables[this.mVariables[this.mNext[index]]] : str + "none";
            str = str + "]";
        }
        str = str + " }";
        return str;
    }

    @Override
    public void clear() {
        int i;
        int count = this.mCount;
        for (i = 0; i < count; ++i) {
            SolverVariable v = this.getVariable(i);
            if (v == null) continue;
            v.removeFromRow(this.mRow);
        }
        for (i = 0; i < this.mSize; ++i) {
            this.mVariables[i] = -1;
            this.mNextKeys[i] = -1;
        }
        for (i = 0; i < this.mHashSize; ++i) {
            this.mKeys[i] = -1;
        }
        this.mCount = 0;
        this.mHead = -1;
    }

    private void increaseSize() {
        int size = this.mSize * 2;
        this.mVariables = Arrays.copyOf(this.mVariables, size);
        this.mValues = Arrays.copyOf(this.mValues, size);
        this.mPrevious = Arrays.copyOf(this.mPrevious, size);
        this.mNext = Arrays.copyOf(this.mNext, size);
        this.mNextKeys = Arrays.copyOf(this.mNextKeys, size);
        for (int i = this.mSize; i < size; ++i) {
            this.mVariables[i] = -1;
            this.mNextKeys[i] = -1;
        }
        this.mSize = size;
    }

    private void addToHashMap(SolverVariable variable, int index) {
        int hash = variable.id % this.mHashSize;
        int key = this.mKeys[hash];
        if (key == -1) {
            this.mKeys[hash] = index;
        } else {
            while (this.mNextKeys[key] != -1) {
                key = this.mNextKeys[key];
            }
            this.mNextKeys[key] = index;
        }
        this.mNextKeys[index] = -1;
    }

    private void displayHash() {
        for (int i = 0; i < this.mHashSize; ++i) {
            if (this.mKeys[i] == -1) continue;
            String str = this.hashCode() + " hash [" + i + "] => ";
            int key = this.mKeys[i];
            boolean done = false;
            while (!done) {
                str = str + " " + this.mVariables[key];
                if (this.mNextKeys[key] != -1) {
                    key = this.mNextKeys[key];
                    continue;
                }
                done = true;
            }
            System.out.println(str);
        }
    }

    private void removeFromHashMap(SolverVariable variable) {
        int hash = variable.id % this.mHashSize;
        int key = this.mKeys[hash];
        if (key == -1) {
            return;
        }
        int id = variable.id;
        if (this.mVariables[key] == id) {
            this.mKeys[hash] = this.mNextKeys[key];
            this.mNextKeys[key] = -1;
        } else {
            while (this.mNextKeys[key] != -1 && this.mVariables[this.mNextKeys[key]] != id) {
                key = this.mNextKeys[key];
            }
            int currentKey = this.mNextKeys[key];
            if (currentKey != -1 && this.mVariables[currentKey] == id) {
                this.mNextKeys[key] = this.mNextKeys[currentKey];
                this.mNextKeys[currentKey] = -1;
            }
        }
    }

    private void addVariable(int index, SolverVariable variable, float value) {
        this.mVariables[index] = variable.id;
        this.mValues[index] = value;
        this.mPrevious[index] = -1;
        this.mNext[index] = -1;
        variable.addToRow(this.mRow);
        ++variable.usageInRowCount;
        ++this.mCount;
    }

    private int findEmptySlot() {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mVariables[i] != -1) continue;
            return i;
        }
        return -1;
    }

    private void insertVariable(int index, SolverVariable variable, float value) {
        int availableSlot = this.findEmptySlot();
        this.addVariable(availableSlot, variable, value);
        if (index != -1) {
            this.mPrevious[availableSlot] = index;
            this.mNext[availableSlot] = this.mNext[index];
            this.mNext[index] = availableSlot;
        } else {
            this.mPrevious[availableSlot] = -1;
            if (this.mCount > 0) {
                this.mNext[availableSlot] = this.mHead;
                this.mHead = availableSlot;
            } else {
                this.mNext[availableSlot] = -1;
            }
        }
        if (this.mNext[availableSlot] != -1) {
            this.mPrevious[this.mNext[availableSlot]] = availableSlot;
        }
        this.addToHashMap(variable, availableSlot);
    }

    @Override
    public void put(SolverVariable variable, float value) {
        if (value > -sEpsilon && value < sEpsilon) {
            this.remove(variable, true);
            return;
        }
        if (this.mCount == 0) {
            this.addVariable(0, variable, value);
            this.addToHashMap(variable, 0);
            this.mHead = 0;
        } else {
            int index = this.indexOf(variable);
            if (index != -1) {
                this.mValues[index] = value;
            } else {
                if (this.mCount + 1 >= this.mSize) {
                    this.increaseSize();
                }
                int count = this.mCount;
                int previousItem = -1;
                int j = this.mHead;
                for (int i = 0; i < count; ++i) {
                    if (this.mVariables[j] == variable.id) {
                        this.mValues[j] = value;
                        return;
                    }
                    if (this.mVariables[j] < variable.id) {
                        previousItem = j;
                    }
                    if ((j = this.mNext[j]) == -1) break;
                }
                this.insertVariable(previousItem, variable, value);
            }
        }
    }

    @Override
    public int sizeInBytes() {
        return 0;
    }

    @Override
    public float remove(SolverVariable v, boolean removeFromDefinition) {
        int index = this.indexOf(v);
        if (index == -1) {
            return 0.0f;
        }
        this.removeFromHashMap(v);
        float value = this.mValues[index];
        if (this.mHead == index) {
            this.mHead = this.mNext[index];
        }
        this.mVariables[index] = -1;
        if (this.mPrevious[index] != -1) {
            this.mNext[this.mPrevious[index]] = this.mNext[index];
        }
        if (this.mNext[index] != -1) {
            this.mPrevious[this.mNext[index]] = this.mPrevious[index];
        }
        --this.mCount;
        --v.usageInRowCount;
        if (removeFromDefinition) {
            v.removeFromRow(this.mRow);
        }
        return value;
    }

    @Override
    public void add(SolverVariable v, float value, boolean removeFromDefinition) {
        if (value > -sEpsilon && value < sEpsilon) {
            return;
        }
        int index = this.indexOf(v);
        if (index == -1) {
            this.put(v, value);
        } else {
            int n = index;
            this.mValues[n] = this.mValues[n] + value;
            if (this.mValues[index] > -sEpsilon && this.mValues[index] < sEpsilon) {
                this.mValues[index] = 0.0f;
                this.remove(v, removeFromDefinition);
            }
        }
    }

    @Override
    public float use(ArrayRow definition, boolean removeFromDefinition) {
        float value = this.get(definition.mVariable);
        this.remove(definition.mVariable, removeFromDefinition);
        SolverVariableValues localDef = (SolverVariableValues)definition.variables;
        int definitionSize = localDef.getCurrentSize();
        int j = localDef.mHead;
        j = 0;
        int i = 0;
        while (j < definitionSize) {
            if (localDef.mVariables[i] != -1) {
                float definitionValue = localDef.mValues[i];
                SolverVariable definitionVariable = this.mCache.mIndexedVariables[localDef.mVariables[i]];
                this.add(definitionVariable, definitionValue * value, removeFromDefinition);
                ++j;
            }
            ++i;
        }
        return value;
    }

    @Override
    public void invert() {
        int count = this.mCount;
        int j = this.mHead;
        for (int i = 0; i < count; ++i) {
            int n = j;
            this.mValues[n] = this.mValues[n] * -1.0f;
            if ((j = this.mNext[j]) == -1) break;
        }
    }

    @Override
    public void divideByAmount(float amount) {
        int count = this.mCount;
        int j = this.mHead;
        for (int i = 0; i < count; ++i) {
            int n = j;
            this.mValues[n] = this.mValues[n] / amount;
            if ((j = this.mNext[j]) == -1) break;
        }
    }
}

