/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver;

import androidx.constraintlayout.solver.ArrayRow;
import androidx.constraintlayout.solver.Cache;
import androidx.constraintlayout.solver.SolverVariable;
import java.util.Arrays;

public class SolverVariableValues
implements ArrayRow.ArrayRowVariables {
    private static final boolean DEBUG = false;
    private static final boolean HASH = true;
    private static float epsilon = 0.001f;
    private final int NONE = -1;
    private int SIZE = 16;
    private int HASH_SIZE = 16;
    int[] keys = new int[this.SIZE];
    int[] nextKeys = new int[this.SIZE];
    int[] variables = new int[this.SIZE];
    float[] values = new float[this.SIZE];
    int[] previous = new int[this.SIZE];
    int[] next = new int[this.SIZE];
    int mCount = 0;
    int head = -1;
    private final ArrayRow mRow;
    protected final Cache mCache;

    SolverVariableValues(ArrayRow row, Cache cache) {
        this.mRow = row;
        this.mCache = cache;
        this.clear();
    }

    @Override
    public int getCurrentSize() {
        return this.mCount;
    }

    @Override
    public SolverVariable getVariable(int index) {
        int count = this.mCount;
        if (count == 0) {
            return null;
        }
        int j = this.head;
        for (int i = 0; i < count; ++i) {
            if (i == index && j != -1) {
                return this.mCache.mIndexedVariables[this.variables[j]];
            }
            if ((j = this.next[j]) == -1) break;
        }
        return null;
    }

    @Override
    public float getVariableValue(int index) {
        int count = this.mCount;
        int j = this.head;
        for (int i = 0; i < count; ++i) {
            if (i == index) {
                return this.values[j];
            }
            if ((j = this.next[j]) == -1) break;
        }
        return 0.0f;
    }

    @Override
    public boolean contains(SolverVariable variable) {
        return this.indexOf(variable) != -1;
    }

    @Override
    public int indexOf(SolverVariable variable) {
        if (this.mCount == 0 || variable == null) {
            return -1;
        }
        int id = variable.id;
        int key = id % this.HASH_SIZE;
        if ((key = this.keys[key]) == -1) {
            return -1;
        }
        if (this.variables[key] == id) {
            return key;
        }
        while (this.nextKeys[key] != -1 && this.variables[this.nextKeys[key]] != id) {
            key = this.nextKeys[key];
        }
        if (this.nextKeys[key] == -1) {
            return -1;
        }
        if (this.variables[this.nextKeys[key]] == id) {
            return this.nextKeys[key];
        }
        return -1;
    }

    @Override
    public float get(SolverVariable variable) {
        int index = this.indexOf(variable);
        if (index != -1) {
            return this.values[index];
        }
        return 0.0f;
    }

    @Override
    public void display() {
        int count = this.mCount;
        System.out.print("{ ");
        for (int i = 0; i < count; ++i) {
            SolverVariable v = this.getVariable(i);
            if (v == null) continue;
            System.out.print(v + " = " + this.getVariableValue(i) + " ");
        }
        System.out.println(" }");
    }

    public String toString() {
        String str = this.hashCode() + " { ";
        int count = this.mCount;
        for (int i = 0; i < count; ++i) {
            SolverVariable v = this.getVariable(i);
            if (v == null) continue;
            str = str + v + " = " + this.getVariableValue(i) + " ";
            int index = this.indexOf(v);
            str = str + "[p: ";
            str = this.previous[index] != -1 ? str + this.mCache.mIndexedVariables[this.variables[this.previous[index]]] : str + "none";
            str = str + ", n: ";
            str = this.next[index] != -1 ? str + this.mCache.mIndexedVariables[this.variables[this.next[index]]] : str + "none";
            str = str + "]";
        }
        str = str + " }";
        return str;
    }

    @Override
    public void clear() {
        int i;
        int count = this.mCount;
        for (i = 0; i < count; ++i) {
            SolverVariable v = this.getVariable(i);
            if (v == null) continue;
            v.removeFromRow(this.mRow);
        }
        for (i = 0; i < this.SIZE; ++i) {
            this.variables[i] = -1;
            this.nextKeys[i] = -1;
        }
        for (i = 0; i < this.HASH_SIZE; ++i) {
            this.keys[i] = -1;
        }
        this.mCount = 0;
        this.head = -1;
    }

    private void increaseSize() {
        int size = this.SIZE * 2;
        this.variables = Arrays.copyOf(this.variables, size);
        this.values = Arrays.copyOf(this.values, size);
        this.previous = Arrays.copyOf(this.previous, size);
        this.next = Arrays.copyOf(this.next, size);
        this.nextKeys = Arrays.copyOf(this.nextKeys, size);
        for (int i = this.SIZE; i < size; ++i) {
            this.variables[i] = -1;
            this.nextKeys[i] = -1;
        }
        this.SIZE = size;
    }

    private void addToHashMap(SolverVariable variable, int index) {
        int hash = variable.id % this.HASH_SIZE;
        int key = this.keys[hash];
        if (key == -1) {
            this.keys[hash] = index;
        } else {
            while (this.nextKeys[key] != -1) {
                key = this.nextKeys[key];
            }
            this.nextKeys[key] = index;
        }
        this.nextKeys[index] = -1;
    }

    private void displayHash() {
        for (int i = 0; i < this.HASH_SIZE; ++i) {
            if (this.keys[i] == -1) continue;
            String str = this.hashCode() + " hash [" + i + "] => ";
            int key = this.keys[i];
            boolean done = false;
            while (!done) {
                str = str + " " + this.variables[key];
                if (this.nextKeys[key] != -1) {
                    key = this.nextKeys[key];
                    continue;
                }
                done = true;
            }
            System.out.println(str);
        }
    }

    private void removeFromHashMap(SolverVariable variable) {
        int hash = variable.id % this.HASH_SIZE;
        int key = this.keys[hash];
        if (key == -1) {
            return;
        }
        int id = variable.id;
        if (this.variables[key] == id) {
            this.keys[hash] = this.nextKeys[key];
            this.nextKeys[key] = -1;
        } else {
            while (this.nextKeys[key] != -1 && this.variables[this.nextKeys[key]] != id) {
                key = this.nextKeys[key];
            }
            int currentKey = this.nextKeys[key];
            if (currentKey != -1 && this.variables[currentKey] == id) {
                this.nextKeys[key] = this.nextKeys[currentKey];
                this.nextKeys[currentKey] = -1;
            }
        }
    }

    private void addVariable(int index, SolverVariable variable, float value) {
        this.variables[index] = variable.id;
        this.values[index] = value;
        this.previous[index] = -1;
        this.next[index] = -1;
        variable.addToRow(this.mRow);
        ++variable.usageInRowCount;
        ++this.mCount;
    }

    private int findEmptySlot() {
        for (int i = 0; i < this.SIZE; ++i) {
            if (this.variables[i] != -1) continue;
            return i;
        }
        return -1;
    }

    private void insertVariable(int index, SolverVariable variable, float value) {
        int availableSlot = this.findEmptySlot();
        this.addVariable(availableSlot, variable, value);
        if (index != -1) {
            this.previous[availableSlot] = index;
            this.next[availableSlot] = this.next[index];
            this.next[index] = availableSlot;
        } else {
            this.previous[availableSlot] = -1;
            if (this.mCount > 0) {
                this.next[availableSlot] = this.head;
                this.head = availableSlot;
            } else {
                this.next[availableSlot] = -1;
            }
        }
        if (this.next[availableSlot] != -1) {
            this.previous[this.next[availableSlot]] = availableSlot;
        }
        this.addToHashMap(variable, availableSlot);
    }

    @Override
    public void put(SolverVariable variable, float value) {
        if (value > -epsilon && value < epsilon) {
            this.remove(variable, true);
            return;
        }
        if (this.mCount == 0) {
            this.addVariable(0, variable, value);
            this.addToHashMap(variable, 0);
            this.head = 0;
        } else {
            int index = this.indexOf(variable);
            if (index != -1) {
                this.values[index] = value;
            } else {
                if (this.mCount + 1 >= this.SIZE) {
                    this.increaseSize();
                }
                int count = this.mCount;
                int previousItem = -1;
                int j = this.head;
                for (int i = 0; i < count; ++i) {
                    if (this.variables[j] == variable.id) {
                        this.values[j] = value;
                        return;
                    }
                    if (this.variables[j] < variable.id) {
                        previousItem = j;
                    }
                    if ((j = this.next[j]) == -1) break;
                }
                this.insertVariable(previousItem, variable, value);
            }
        }
    }

    @Override
    public int sizeInBytes() {
        return 0;
    }

    @Override
    public float remove(SolverVariable v, boolean removeFromDefinition) {
        int index = this.indexOf(v);
        if (index == -1) {
            return 0.0f;
        }
        this.removeFromHashMap(v);
        float value = this.values[index];
        if (this.head == index) {
            this.head = this.next[index];
        }
        this.variables[index] = -1;
        if (this.previous[index] != -1) {
            this.next[this.previous[index]] = this.next[index];
        }
        if (this.next[index] != -1) {
            this.previous[this.next[index]] = this.previous[index];
        }
        --this.mCount;
        --v.usageInRowCount;
        if (removeFromDefinition) {
            v.removeFromRow(this.mRow);
        }
        return value;
    }

    @Override
    public void add(SolverVariable v, float value, boolean removeFromDefinition) {
        if (value > -epsilon && value < epsilon) {
            return;
        }
        int index = this.indexOf(v);
        if (index == -1) {
            this.put(v, value);
        } else {
            int n = index;
            this.values[n] = this.values[n] + value;
            if (this.values[index] > -epsilon && this.values[index] < epsilon) {
                this.values[index] = 0.0f;
                this.remove(v, removeFromDefinition);
            }
        }
    }

    @Override
    public float use(ArrayRow def, boolean removeFromDefinition) {
        float value = this.get(def.variable);
        this.remove(def.variable, removeFromDefinition);
        SolverVariableValues definition = (SolverVariableValues)def.variables;
        int definitionSize = definition.getCurrentSize();
        int j = definition.head;
        j = 0;
        int i = 0;
        while (j < definitionSize) {
            if (definition.variables[i] != -1) {
                float definitionValue = definition.values[i];
                SolverVariable definitionVariable = this.mCache.mIndexedVariables[definition.variables[i]];
                this.add(definitionVariable, definitionValue * value, removeFromDefinition);
                ++j;
            }
            ++i;
        }
        return value;
    }

    @Override
    public void invert() {
        int count = this.mCount;
        int j = this.head;
        for (int i = 0; i < count; ++i) {
            int n = j;
            this.values[n] = this.values[n] * -1.0f;
            if ((j = this.next[j]) == -1) break;
        }
    }

    @Override
    public void divideByAmount(float amount) {
        int count = this.mCount;
        int j = this.head;
        for (int i = 0; i < count; ++i) {
            int n = j;
            this.values[n] = this.values[n] / amount;
            if ((j = this.next[j]) == -1) break;
        }
    }
}

