/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection.annotation;

import android.databinding.tool.util.L;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public class AnnotationLogger
implements L.Client {
    private final ArrayList<Message> mMessages = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMessage(Diagnostic.Kind kind, String message, Element element) {
        ElementPath elementPath = null;
        if (element != null) {
            elementPath = ElementPath.toElementPath(element);
        }
        Message msg = new Message(kind, message, elementPath);
        ArrayList<Message> arrayList = this.mMessages;
        synchronized (arrayList) {
            this.mMessages.add(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushMessages(ProcessingEnvironment processingEnvironment) {
        Messager messager = processingEnvironment.getMessager();
        ArrayList<Message> arrayList = this.mMessages;
        synchronized (arrayList) {
            for (Message message : this.mMessages) {
                if (message.element != null) {
                    Element element = message.element.toElement(processingEnvironment);
                    messager.printMessage(message.kind, message.message, element);
                    continue;
                }
                messager.printMessage(message.kind, message.message);
            }
            this.mMessages.clear();
        }
    }

    private static abstract class ElementPath {
        private ElementPath() {
        }

        abstract Element toElement(ProcessingEnvironment var1);

        public static ElementPath toElementPath(Element element) {
            if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.ENUM) {
                return new TypeElementRoot((TypeElement)element);
            }
            if (element.getKind() == ElementKind.PACKAGE) {
                return new PackageElementRoot((PackageElement)element);
            }
            Element enclosing = element.getEnclosingElement();
            ElementPath parent = ElementPath.toElementPath(enclosing);
            List<? extends Element> enclosed = enclosing.getEnclosedElements();
            int index = enclosed.indexOf(element);
            if (index < 0) {
                throw new IllegalStateException("Can't find element in enclosing element");
            }
            return new ElementChild(parent, index);
        }
    }

    private static class Message {
        public final ElementPath element;
        public final String message;
        public final Diagnostic.Kind kind;

        private Message(Diagnostic.Kind kind, String message, ElementPath element) {
            this.element = element;
            this.message = message;
            this.kind = kind;
        }
    }

    private static class PackageElementRoot
    extends ElementPath {
        private final String mPackage;

        private PackageElementRoot(PackageElement element) {
            this.mPackage = element.getQualifiedName().toString();
        }

        @Override
        Element toElement(ProcessingEnvironment processingEnvironment) {
            Elements elements = processingEnvironment.getElementUtils();
            return elements.getPackageElement(this.mPackage);
        }
    }

    private static class TypeElementRoot
    extends ElementPath {
        private final String mElementType;

        private TypeElementRoot(TypeElement element) {
            this.mElementType = element.getQualifiedName().toString();
        }

        @Override
        Element toElement(ProcessingEnvironment processingEnvironment) {
            Elements elements = processingEnvironment.getElementUtils();
            return elements.getTypeElement(this.mElementType);
        }
    }

    private static class ElementChild
    extends ElementPath {
        private final ElementPath mEnclosing;
        private final int mEnclosingIndex;

        private ElementChild(ElementPath enclosing, int enclosingIndex) {
            this.mEnclosing = enclosing;
            this.mEnclosingIndex = enclosingIndex;
        }

        @Override
        Element toElement(ProcessingEnvironment processingEnvironment) {
            Element enclosing = this.mEnclosing.toElement(processingEnvironment);
            List<? extends Element> enclosed = enclosing.getEnclosedElements();
            return enclosed.get(this.mEnclosingIndex);
        }
    }
}

