/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.ComparisonExpr;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.solver.ExecutionPath;
import android.databinding.tool.writer.KCode;
import java.util.ArrayList;
import java.util.List;

public class FieldAssignmentExpr
extends Expr {
    final String mName;

    public FieldAssignmentExpr(Expr target, String name, Expr value) {
        super(target, value);
        this.mName = name;
    }

    @Override
    protected String computeUniqueKey() {
        return FieldAssignmentExpr.join(this.getTarget(), ".", this.mName, "=", this.getValueExpr());
    }

    public Expr getTarget() {
        return this.getChildren().get(0);
    }

    public Expr getValueExpr() {
        return this.getChildren().get(1);
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        this.getTarget().getResolvedType();
        return modelAnalyzer.findClass(Void.TYPE);
    }

    @Override
    public void injectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    @Override
    protected KCode generateCode() {
        return new KCode().app("", this.getTarget().toCode()).app("." + this.mName + " = ", this.getValueExpr().toCode());
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.assignment(this.getTarget().cloneToModel(model), this.mName, this.getValueExpr());
    }

    @Override
    protected String getInvertibleError() {
        return "Assignment expressions are inverses of field access expressions.";
    }

    @Override
    public List<ExecutionPath> toExecutionPath(List<ExecutionPath> paths) {
        Expr child = this.getTarget();
        List<ExecutionPath> targetPaths = child.toExecutionPath(paths);
        ArrayList<ExecutionPath> result = new ArrayList<ExecutionPath>();
        if (child instanceof StaticIdentifierExpr) {
            result.addAll(this.toExecutionPathInOrder(paths, child));
        } else {
            for (ExecutionPath path : targetPaths) {
                ComparisonExpr cmp = this.getModel().comparison("!=", child, this.getModel().symbol("null", Object.class));
                cmp.setUnwrapObservableFields(false);
                path.addPath(cmp);
                ExecutionPath subPath = path.addBranch(cmp, true);
                if (subPath == null) continue;
                subPath.addPath(this);
                result.add(subPath);
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getTarget().toString() + "." + this.mName + " = " + this.getValueExpr();
    }
}

