/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import android.databinding.tool.expr.ResourceExpr;
import android.databinding.tool.util.Resources;
import android.databinding.tool.util.SymbolTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\u001a*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001c\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012\u001a\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a*\u0010\u0014\u001a\u00020\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u000f\u001a \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c\u001a\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"EMPTY_RESOURCES", "Landroid/databinding/tool/util/Resources;", "getEMPTY_RESOURCES", "()Landroid/databinding/tool/util/Resources;", "STYLEABLE", "", "addResource", "", "type", "name", "resourcesBuilder", "Lcom/google/common/collect/ImmutableMultimap$Builder;", "parseLocalRTxt", "Landroid/databinding/tool/util/SymbolTable;", "file", "Ljava/io/File;", "parseMergedPackageAwareRTxt", "symbolTables", "Lcom/google/common/collect/ImmutableList$Builder;", "parsePackageAwareRTxt", "parseRTxtFiles", "localRFile", "dependenciesRFiles", "", "mergedDependenciesRFile", "readResources", "Lcom/google/common/collect/ImmutableMultimap;", "lines", "", "sanitizeName", "databinding-compiler"})
@JvmName(name="SymbolTableUtil")
@SourceDebugExtension(value={"SMAP\nSymbolTableUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolTableUtil.kt\nandroid/databinding/tool/util/SymbolTableUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n*L\n1#1,225:1\n1855#2,2:226\n1855#2,2:238\n1#3:228\n1#3:231\n1#3:234\n1#3:237\n230#4,2:229\n230#4,2:232\n230#4,2:235\n*S KotlinDebug\n*F\n+ 1 SymbolTableUtil.kt\nandroid/databinding/tool/util/SymbolTableUtil\n*L\n89#1:226,2\n215#1:238,2\n96#1:231\n123#1:234\n140#1:237\n96#1:229,2\n123#1:232,2\n140#1:235,2\n*E\n"})
public final class SymbolTableUtil {
    @NotNull
    private static final String STYLEABLE = "styleable";
    @NotNull
    private static final Resources EMPTY_RESOURCES = new Resources(null);

    @NotNull
    public static final Resources getEMPTY_RESOURCES() {
        return EMPTY_RESOURCES;
    }

    @NotNull
    public static final Resources parseRTxtFiles(@Nullable File localRFile, @Nullable List<? extends File> dependenciesRFiles, @Nullable File mergedDependenciesRFile) {
        ImmutableList.Builder symbolTables;
        block4: {
            if (localRFile == null) {
                return EMPTY_RESOURCES;
            }
            if (dependenciesRFiles != null && mergedDependenciesRFile != null) {
                throw new IllegalStateException("Unexpected error: Both listed and merged dependencies R files present.".toString());
            }
            symbolTables = ImmutableList.builder();
            symbolTables.add((Object)SymbolTableUtil.parseLocalRTxt(localRFile));
            List<? extends File> list = dependenciesRFiles;
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    symbolTables.add((Object)SymbolTableUtil.parsePackageAwareRTxt(it));
                }
            }
            File file = mergedDependenciesRFile;
            if (file == null) break block4;
            File it = file;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)symbolTables, (String)"symbolTables");
            SymbolTableUtil.parseMergedPackageAwareRTxt(it, (ImmutableList.Builder<SymbolTable>)symbolTables);
        }
        return new Resources((ImmutableList<SymbolTable>)symbolTables.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SymbolTable parseLocalRTxt(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File $this$useLines_u24default$iv = file;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$useLines = false;
        Object object = $this$useLines_u24default$iv;
        int n = 8192;
        Object object2 = object;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), charset$iv);
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        Throwable throwable = null;
        try {
            ImmutableMultimap<String, String> immutableMultimap;
            BufferedReader it$iv = (BufferedReader)object;
            boolean bl = false;
            Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            Iterator iterator = it.iterator();
            if (!iterator.hasNext()) {
                throw new IllegalStateException(("Incorrect package-aware R.txt format. Failed to parse file: " + file.getAbsolutePath()).toString());
            }
            iterator.next();
            if (!iterator.hasNext()) {
                throw new IllegalStateException(("Resource list needs to contain the local package. Failed to parse file: " + file.getAbsolutePath()).toString());
            }
            String localPackage = (String)iterator.next();
            if (!Intrinsics.areEqual((Object)localPackage, (Object)"local")) {
                throw new IllegalStateException(("Illegal local package '" + localPackage + "' in file " + file.getAbsolutePath()).toString());
            }
            try {
                immutableMultimap = SymbolTableUtil.readResources(iterator);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Failed to parse file: " + file.getAbsolutePath(), e);
            }
            ImmutableMultimap<String, String> resources = immutableMultimap;
            SymbolTable symbolTable = new SymbolTable("", resources);
            return symbolTable;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SymbolTable parsePackageAwareRTxt(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File $this$useLines_u24default$iv = file;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$useLines = false;
        Object object = $this$useLines_u24default$iv;
        int n = 8192;
        Object object2 = object;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), charset$iv);
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        Throwable throwable = null;
        try {
            ImmutableMultimap<String, String> immutableMultimap;
            BufferedReader it$iv = (BufferedReader)object;
            boolean bl = false;
            Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            Iterator iterator = it.iterator();
            if (!iterator.hasNext()) {
                throw new IllegalStateException(("Resource list needs to contain the local package. Failed to parse file: " + file.getAbsolutePath()).toString());
            }
            String pckg = (String)iterator.next();
            try {
                immutableMultimap = SymbolTableUtil.readResources(iterator);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Failed to parse file: " + file.getAbsolutePath(), e);
            }
            ImmutableMultimap<String, String> resources = immutableMultimap;
            SymbolTable symbolTable = new SymbolTable(pckg, resources);
            return symbolTable;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void parseMergedPackageAwareRTxt(@NotNull File file, @NotNull ImmutableList.Builder<SymbolTable> symbolTables) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(symbolTables, (String)"symbolTables");
        File $this$useLines_u24default$iv = file;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$useLines = false;
        Object object = $this$useLines_u24default$iv;
        int n = 8192;
        Object object2 = object;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), charset$iv);
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)object;
            boolean bl = false;
            Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            Iterator iterator = it.iterator();
            while (iterator.hasNext()) {
                ImmutableMultimap<String, String> immutableMultimap;
                if (!iterator.hasNext()) {
                    throw new IllegalStateException(("Resource list needs to contain the local package. Failed to parse file: " + file.getAbsolutePath()).toString());
                }
                String pckg = (String)iterator.next();
                try {
                    immutableMultimap = SymbolTableUtil.readResources(iterator);
                }
                catch (IllegalStateException e) {
                    throw new IllegalStateException("Failed to parse file: " + file.getAbsolutePath(), e);
                }
                ImmutableMultimap<String, String> resources = immutableMultimap;
                symbolTables.add((Object)new SymbolTable(pckg, resources));
            }
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @NotNull
    public static final ImmutableMultimap<String, String> readResources(@NotNull Iterator<String> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        ImmutableMultimap.Builder resources = ImmutableMultimap.builder();
        while (lines.hasNext()) {
            String line = lines.next();
            if (((CharSequence)line).length() == 0) {
                ImmutableMultimap immutableMultimap = resources.build();
                Intrinsics.checkNotNullExpressionValue((Object)immutableMultimap, (String)"resources.build()");
                return immutableMultimap;
            }
            String[] stringArray = new String[]{" "};
            List chunks = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (chunks.size() < 2 || !Intrinsics.areEqual(chunks.get(0), (Object)STYLEABLE) && chunks.size() != 2) {
                throw new IllegalStateException(("Illegal line in R.txt: '" + line + "'").toString());
            }
            String string = (String)chunks.get(0);
            String string2 = SymbolTableUtil.sanitizeName((String)chunks.get(1));
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
            SymbolTableUtil.addResource(string, string2, (ImmutableMultimap.Builder<String, String>)resources);
            if (!Intrinsics.areEqual(chunks.get(0), (Object)STYLEABLE)) continue;
            String parent = SymbolTableUtil.sanitizeName((String)chunks.get(1));
            int n = chunks.size();
            for (int i = 2; i < n; ++i) {
                resources.put((Object)STYLEABLE, (Object)(parent + "_" + SymbolTableUtil.sanitizeName((String)chunks.get(i))));
            }
        }
        ImmutableMultimap immutableMultimap = resources.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMultimap, (String)"resources.build()");
        return immutableMultimap;
    }

    public static final void addResource(@NotNull String type, @NotNull String name, @NotNull ImmutableMultimap.Builder<String, String> resourcesBuilder) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(resourcesBuilder, (String)"resourcesBuilder");
        List<String> list = ResourceExpr.R_OBJECT_TO_RESOURCE_TYPE.get(type);
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                resourcesBuilder.put((Object)it, (Object)name);
            }
        }
        resourcesBuilder.put((Object)type, (Object)name);
    }

    private static final String sanitizeName(String name) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)name, (char)'.', (char)'_', (boolean)false, (int)4, null), (char)':', (char)'_', (boolean)false, (int)4, null);
    }
}

