/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding;

import androidx.collection.ArrayMap;
import androidx.databinding.MapChangeRegistry;
import androidx.databinding.ObservableMap;
import java.util.Collection;

public class ObservableArrayMap<K, V>
extends ArrayMap<K, V>
implements ObservableMap<K, V> {
    private transient MapChangeRegistry mListeners;

    public void addOnMapChangedCallback(ObservableMap.OnMapChangedCallback<? extends ObservableMap<K, V>, K, V> listener) {
        if (this.mListeners == null) {
            this.mListeners = new MapChangeRegistry();
        }
        this.mListeners.add(listener);
    }

    public void removeOnMapChangedCallback(ObservableMap.OnMapChangedCallback<? extends ObservableMap<K, V>, K, V> listener) {
        if (this.mListeners != null) {
            this.mListeners.remove(listener);
        }
    }

    public void clear() {
        boolean wasEmpty = this.isEmpty();
        if (!wasEmpty) {
            super.clear();
            this.notifyChange(null);
        }
    }

    public V put(K k, V v) {
        Object val = super.put(k, v);
        this.notifyChange(k);
        return v;
    }

    public boolean removeAll(Collection<?> collection) {
        boolean removed = false;
        for (Object key : collection) {
            int index = this.indexOfKey(key);
            if (index < 0) continue;
            removed = true;
            this.removeAt(index);
        }
        return removed;
    }

    public boolean retainAll(Collection<?> collection) {
        boolean removed = false;
        for (int i = this.size() - 1; i >= 0; --i) {
            Object key = this.keyAt(i);
            if (collection.contains(key)) continue;
            this.removeAt(i);
            removed = true;
        }
        return removed;
    }

    public V removeAt(int index) {
        Object key = this.keyAt(index);
        Object value = super.removeAt(index);
        if (value != null) {
            this.notifyChange(key);
        }
        return (V)value;
    }

    public V setValueAt(int index, V value) {
        Object key = this.keyAt(index);
        Object oldValue = super.setValueAt(index, value);
        this.notifyChange(key);
        return (V)oldValue;
    }

    private void notifyChange(Object key) {
        if (this.mListeners != null) {
            this.mListeners.notifyCallbacks((Object)this, 0, key);
        }
    }
}

