/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore;

import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.datastore.DataStoreFile;
import androidx.datastore.core.DataMigration;
import androidx.datastore.core.DataStore;
import androidx.datastore.core.DataStoreFactory;
import androidx.datastore.core.Storage;
import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler;
import androidx.datastore.core.okio.OkioSerializer;
import androidx.datastore.core.okio.OkioStorage;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.CoroutineScope;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0002BU\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n\u0012\u001e\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\r0\f\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J#\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0016\u001a\u00020\u00032\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0096\u0002R\u001a\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/datastore/DataStoreSingletonDelegate;", "T", "Lkotlin/properties/ReadOnlyProperty;", "Landroid/content/Context;", "Landroidx/datastore/core/DataStore;", "fileName", "", "serializer", "Landroidx/datastore/core/okio/OkioSerializer;", "corruptionHandler", "Landroidx/datastore/core/handlers/ReplaceFileCorruptionHandler;", "produceMigrations", "Lkotlin/Function1;", "", "Landroidx/datastore/core/DataMigration;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Ljava/lang/String;Landroidx/datastore/core/okio/OkioSerializer;Landroidx/datastore/core/handlers/ReplaceFileCorruptionHandler;Lkotlin/jvm/functions/Function1;Lkotlinx/coroutines/CoroutineScope;)V", "INSTANCE", "lock", "", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "datastore_release"})
public final class DataStoreSingletonDelegate<T>
implements ReadOnlyProperty<Context, DataStore<T>> {
    @NotNull
    private final String fileName;
    @NotNull
    private final OkioSerializer<T> serializer;
    @Nullable
    private final ReplaceFileCorruptionHandler<T> corruptionHandler;
    @NotNull
    private final Function1<Context, List<DataMigration<T>>> produceMigrations;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Object lock;
    @GuardedBy(value="lock")
    @Nullable
    private volatile DataStore<T> INSTANCE;

    public DataStoreSingletonDelegate(@NotNull String fileName, @NotNull OkioSerializer<T> serializer, @Nullable ReplaceFileCorruptionHandler<T> corruptionHandler, @NotNull Function1<? super Context, ? extends List<? extends DataMigration<T>>> produceMigrations, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(produceMigrations, (String)"produceMigrations");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.fileName = fileName;
        this.serializer = serializer;
        this.corruptionHandler = corruptionHandler;
        this.produceMigrations = produceMigrations;
        this.scope = scope;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DataStore<T> getValue(@NotNull Context thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        DataStore<T> dataStore2 = this.INSTANCE;
        if (dataStore2 == null) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                if (this.INSTANCE == null) {
                    Context applicationContext = thisRef.getApplicationContext();
                    Storage storage = (Storage)new OkioStorage(FileSystem.SYSTEM, this.serializer, (Function0)new Function0<Path>(applicationContext, this){
                        final /* synthetic */ Context $applicationContext;
                        final /* synthetic */ DataStoreSingletonDelegate<T> this$0;
                        {
                            this.$applicationContext = $applicationContext;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final Path invoke() {
                            Context context = this.$applicationContext;
                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                            String string = DataStoreFile.dataStoreFile(context, DataStoreSingletonDelegate.access$getFileName$p(this.this$0)).getAbsolutePath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"applicationContext.dataS\u2026le(fileName).absolutePath");
                            return Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null);
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)applicationContext, (String)"applicationContext");
                    this.INSTANCE = DataStoreFactory.INSTANCE.create(storage, this.corruptionHandler, (List)this.produceMigrations.invoke((Object)applicationContext), this.scope);
                }
                DataStore<T> dataStore3 = this.INSTANCE;
                Intrinsics.checkNotNull(dataStore3);
                DataStore<T> dataStore4 = dataStore3;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                dataStore2 = dataStore4;
            }
        }
        return dataStore2;
    }

    public static final /* synthetic */ String access$getFileName$p(DataStoreSingletonDelegate $this) {
        return $this.fileName;
    }
}

