/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.migrations;

import android.content.SharedPreferences;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006H\u0086\u0002J\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\rJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0015J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0006J(\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u00062\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/datastore/migrations/SharedPreferencesView;", "", "prefs", "Landroid/content/SharedPreferences;", "keySet", "", "", "(Landroid/content/SharedPreferences;Ljava/util/Set;)V", "checkKey", "key", "contains", "", "getAll", "", "getBoolean", "defValue", "getFloat", "", "getInt", "", "getLong", "", "getString", "getStringSet", "defValues", "datastore_release"})
@SourceDebugExtension(value={"SMAP\nSharedPreferencesMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedPreferencesMigration.kt\nandroidx/datastore/migrations/SharedPreferencesView\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n515#2:321\n500#2,6:322\n442#2:328\n392#2:329\n1238#3,4:330\n1#4:334\n*S KotlinDebug\n*F\n+ 1 SharedPreferencesMigration.kt\nandroidx/datastore/migrations/SharedPreferencesView\n*L\n300#1:321\n300#1:322,6\n302#1:328\n302#1:329\n302#1:330,4\n*E\n"})
public final class SharedPreferencesView {
    @NotNull
    private final SharedPreferences prefs;
    @Nullable
    private final Set<String> keySet;

    public SharedPreferencesView(@NotNull SharedPreferences prefs, @Nullable Set<String> keySet) {
        Intrinsics.checkNotNullParameter((Object)prefs, (String)"prefs");
        this.prefs = prefs;
        this.keySet = keySet;
    }

    public final boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.prefs.contains(this.checkKey(key));
    }

    public final boolean getBoolean(@NotNull String key, boolean defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.prefs.getBoolean(this.checkKey(key), defValue);
    }

    public final float getFloat(@NotNull String key, float defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.prefs.getFloat(this.checkKey(key), defValue);
    }

    public final int getInt(@NotNull String key, int defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.prefs.getInt(this.checkKey(key), defValue);
    }

    public final long getLong(@NotNull String key, long defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.prefs.getLong(this.checkKey(key), defValue);
    }

    @Nullable
    public final String getString(@NotNull String key, @Nullable String defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.prefs.getString(this.checkKey(key), defValue);
    }

    public static /* synthetic */ String getString$default(SharedPreferencesView sharedPreferencesView, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return sharedPreferencesView.getString(string, string2);
    }

    @Nullable
    public final Set<String> getStringSet(@NotNull String key, @Nullable Set<String> defValues) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Set set = this.prefs.getStringSet(this.checkKey(key), defValues);
        return set != null ? CollectionsKt.toMutableSet((Iterable)set) : null;
    }

    public static /* synthetic */ Set getStringSet$default(SharedPreferencesView sharedPreferencesView, String string, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = null;
        }
        return sharedPreferencesView.getStringSet(string, set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> getAll() {
        void $this$mapValuesTo$iv$iv;
        Object key;
        Map $this$filterTo$iv$iv;
        Map map = this.prefs.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"prefs.all");
        Map $this$filter$iv = map;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            Map.Entry entry = element$iv$iv;
            boolean bl = false;
            key = (String)entry.getKey();
            Set<String> set = this.keySet;
            if (!(set != null ? set.contains(key) : true)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$filterTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            key = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Object value = entry.getValue();
            Object object = value instanceof Set ? CollectionsKt.toSet((Iterable)((Iterable)value)) : value;
            map4.put(k, object);
        }
        return destination$iv$iv;
    }

    private final String checkKey(String key) {
        Set<String> set = this.keySet;
        if (set != null) {
            Set<String> it = set;
            boolean bl = false;
            if (!it.contains(key)) {
                boolean bl2 = false;
                String string = "Can't access key outside migration: " + key;
                throw new IllegalStateException(string.toString());
            }
        }
        return key;
    }
}

