/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.viewsintegration;

import android.os.Build;
import android.text.TextWatcher;
import android.text.method.KeyListener;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.util.Preconditions;
import androidx.emoji2.viewsintegration.EmojiEditableFactory;
import androidx.emoji2.viewsintegration.EmojiInputConnection;
import androidx.emoji2.viewsintegration.EmojiKeyListener;
import androidx.emoji2.viewsintegration.EmojiTextWatcher;

public final class EmojiEditTextHelper {
    private final HelperInternal mHelper;
    private int mMaxEmojiCount = Integer.MAX_VALUE;
    private int mEmojiReplaceStrategy = 0;

    public EmojiEditTextHelper(@NonNull EditText editText) {
        this(editText, true);
    }

    public EmojiEditTextHelper(@NonNull EditText editText, boolean expectInitializedEmojiCompat) {
        Preconditions.checkNotNull((Object)editText, (Object)"editText cannot be null");
        this.mHelper = Build.VERSION.SDK_INT < 19 ? new HelperInternal() : new HelperInternal19(editText, expectInitializedEmojiCompat);
    }

    public void setMaxEmojiCount(@IntRange(from=0L) int maxEmojiCount) {
        Preconditions.checkArgumentNonnegative((int)maxEmojiCount, (String)"maxEmojiCount should be greater than 0");
        this.mMaxEmojiCount = maxEmojiCount;
        this.mHelper.setMaxEmojiCount(maxEmojiCount);
    }

    public int getMaxEmojiCount() {
        return this.mMaxEmojiCount;
    }

    @NonNull
    public KeyListener getKeyListener(@NonNull KeyListener keyListener) {
        Preconditions.checkNotNull((Object)keyListener, (Object)"keyListener cannot be null");
        return this.mHelper.getKeyListener(keyListener);
    }

    @Nullable
    public InputConnection onCreateInputConnection(@Nullable InputConnection inputConnection, @NonNull EditorInfo outAttrs) {
        if (inputConnection == null) {
            return null;
        }
        return this.mHelper.onCreateInputConnection(inputConnection, outAttrs);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setEmojiReplaceStrategy(int replaceStrategy) {
        this.mEmojiReplaceStrategy = replaceStrategy;
        this.mHelper.setEmojiReplaceStrategy(replaceStrategy);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getEmojiReplaceStrategy() {
        return this.mEmojiReplaceStrategy;
    }

    public boolean isEnabled() {
        return this.mHelper.isEnabled();
    }

    public void setEnabled(boolean isEnabled) {
        this.mHelper.setEnabled(isEnabled);
    }

    @RequiresApi(value=19)
    private static class HelperInternal19
    extends HelperInternal {
        private final EditText mEditText;
        private final EmojiTextWatcher mTextWatcher;

        HelperInternal19(@NonNull EditText editText, boolean expectInitializedEmojiCompat) {
            this.mEditText = editText;
            this.mTextWatcher = new EmojiTextWatcher(this.mEditText, expectInitializedEmojiCompat);
            this.mEditText.addTextChangedListener((TextWatcher)this.mTextWatcher);
            this.mEditText.setEditableFactory(EmojiEditableFactory.getInstance());
        }

        @Override
        void setMaxEmojiCount(int maxEmojiCount) {
            this.mTextWatcher.setMaxEmojiCount(maxEmojiCount);
        }

        @Override
        void setEmojiReplaceStrategy(int replaceStrategy) {
            this.mTextWatcher.setEmojiReplaceStrategy(replaceStrategy);
        }

        @Override
        KeyListener getKeyListener(@NonNull KeyListener keyListener) {
            if (keyListener instanceof EmojiKeyListener) {
                return keyListener;
            }
            return new EmojiKeyListener(keyListener);
        }

        @Override
        InputConnection onCreateInputConnection(@NonNull InputConnection inputConnection, @NonNull EditorInfo outAttrs) {
            if (inputConnection instanceof EmojiInputConnection) {
                return inputConnection;
            }
            return new EmojiInputConnection((TextView)this.mEditText, inputConnection, outAttrs);
        }

        @Override
        void setEnabled(boolean isEnabled) {
            this.mTextWatcher.setEnabled(isEnabled);
        }

        @Override
        boolean isEnabled() {
            return this.mTextWatcher.isEnabled();
        }
    }

    static class HelperInternal {
        HelperInternal() {
        }

        KeyListener getKeyListener(@NonNull KeyListener keyListener) {
            return keyListener;
        }

        InputConnection onCreateInputConnection(@NonNull InputConnection inputConnection, @NonNull EditorInfo outAttrs) {
            return inputConnection;
        }

        void setMaxEmojiCount(int maxEmojiCount) {
        }

        void setEmojiReplaceStrategy(int replaceStrategy) {
        }

        void setEnabled(boolean isEnabled) {
        }

        boolean isEnabled() {
            return false;
        }
    }
}

