/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app.testing;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.core.util.Preconditions;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentFactory;
import androidx.fragment.testing.R;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.test.core.app.ActivityScenario;
import androidx.test.core.app.ApplicationProvider;

public final class FragmentScenario<F extends Fragment> {
    private static final String FRAGMENT_TAG = "FragmentScenario_Fragment_Tag";
    final Class<F> mFragmentClass;
    private final ActivityScenario<EmptyFragmentActivity> mActivityScenario;
    @Nullable
    private final FragmentFactory mFragmentFactory;

    private FragmentScenario(@NonNull Class<F> fragmentClass, @Nullable FragmentFactory fragmentFactory, @NonNull ActivityScenario<EmptyFragmentActivity> activityScenario) {
        this.mFragmentClass = fragmentClass;
        this.mFragmentFactory = fragmentFactory;
        this.mActivityScenario = activityScenario;
    }

    @NonNull
    public static <F extends Fragment> FragmentScenario<F> launch(@NonNull Class<F> fragmentClass) {
        return FragmentScenario.launch(fragmentClass, null);
    }

    @NonNull
    public static <F extends Fragment> FragmentScenario<F> launch(@NonNull Class<F> fragmentClass, @Nullable Bundle fragmentArgs) {
        return FragmentScenario.launch(fragmentClass, fragmentArgs, null);
    }

    @NonNull
    public static <F extends Fragment> FragmentScenario<F> launch(@NonNull Class<F> fragmentClass, @Nullable Bundle fragmentArgs, @Nullable FragmentFactory factory) {
        return FragmentScenario.launch(fragmentClass, fragmentArgs, R.style.FragmentScenarioEmptyFragmentActivityTheme, factory);
    }

    @NonNull
    public static <F extends Fragment> FragmentScenario<F> launch(@NonNull Class<F> fragmentClass, @Nullable Bundle fragmentArgs, @StyleRes int themeResId, @Nullable FragmentFactory factory) {
        return FragmentScenario.internalLaunch(fragmentClass, fragmentArgs, themeResId, factory, 0);
    }

    @NonNull
    public static <F extends Fragment> FragmentScenario<F> launchInContainer(@NonNull Class<F> fragmentClass) {
        return FragmentScenario.launchInContainer(fragmentClass, null);
    }

    @NonNull
    public static <F extends Fragment> FragmentScenario<F> launchInContainer(@NonNull Class<F> fragmentClass, @Nullable Bundle fragmentArgs) {
        return FragmentScenario.launchInContainer(fragmentClass, fragmentArgs, null);
    }

    @NonNull
    public static <F extends Fragment> FragmentScenario<F> launchInContainer(@NonNull Class<F> fragmentClass, @Nullable Bundle fragmentArgs, @Nullable FragmentFactory factory) {
        return FragmentScenario.launchInContainer(fragmentClass, fragmentArgs, R.style.FragmentScenarioEmptyFragmentActivityTheme, factory);
    }

    @NonNull
    public static <F extends Fragment> FragmentScenario<F> launchInContainer(@NonNull Class<F> fragmentClass, @Nullable Bundle fragmentArgs, @StyleRes int themeResId, @Nullable FragmentFactory factory) {
        return FragmentScenario.internalLaunch(fragmentClass, fragmentArgs, themeResId, factory, 0x1020002);
    }

    @NonNull
    @SuppressLint(value={"RestrictedApi"})
    private static <F extends Fragment> FragmentScenario<F> internalLaunch(final @NonNull Class<F> fragmentClass, final @Nullable Bundle fragmentArgs, @StyleRes int themeResId, final @Nullable FragmentFactory factory, final @IdRes int containerViewId) {
        Intent startActivityIntent = Intent.makeMainActivity((ComponentName)new ComponentName(ApplicationProvider.getApplicationContext(), EmptyFragmentActivity.class)).putExtra("androidx.fragment.app.testing.FragmentScenario.EmptyFragmentActivity.THEME_EXTRAS_BUNDLE_KEY", themeResId);
        FragmentScenario<F> scenario = new FragmentScenario<F>(fragmentClass, factory, (ActivityScenario<EmptyFragmentActivity>)ActivityScenario.launch((Intent)startActivityIntent));
        scenario.mActivityScenario.onActivity((ActivityScenario.ActivityAction)new ActivityScenario.ActivityAction<EmptyFragmentActivity>(){

            public void perform(EmptyFragmentActivity activity) {
                if (factory != null) {
                    ViewModelProvider viewModelProvider = new ViewModelProvider((ViewModelStoreOwner)activity, (ViewModelProvider.Factory)ViewModelProvider.AndroidViewModelFactory.getInstance((Application)activity.getApplication()));
                    ((FragmentFactoryHolderViewModel)viewModelProvider.get(FragmentFactoryHolderViewModel.class)).setFragmentFactory(factory);
                    activity.getSupportFragmentManager().setFragmentFactory(factory);
                }
                Fragment fragment = activity.getSupportFragmentManager().getFragmentFactory().instantiate((ClassLoader)Preconditions.checkNotNull((Object)fragmentClass.getClassLoader()), fragmentClass.getName());
                fragment.setArguments(fragmentArgs);
                activity.getSupportFragmentManager().beginTransaction().add(containerViewId, fragment, FragmentScenario.FRAGMENT_TAG).commitNow();
            }
        });
        return scenario;
    }

    @NonNull
    public FragmentScenario<F> moveToState(@NonNull Lifecycle.State newState) {
        if (Build.VERSION.SDK_INT < 24 && newState == Lifecycle.State.STARTED) {
            throw new UnsupportedOperationException("Moving state to STARTED is not supported on Android API level 23 and lower. This restriction comes from the combination of the Android framework bug around the timing of onSaveInstanceState invocation and its workaround code in FragmentActivity. See http://issuetracker.google.com/65665621#comment3 for more information.");
        }
        if (newState == Lifecycle.State.DESTROYED) {
            this.mActivityScenario.onActivity((ActivityScenario.ActivityAction)new ActivityScenario.ActivityAction<EmptyFragmentActivity>(){

                public void perform(EmptyFragmentActivity activity) {
                    Fragment fragment = activity.getSupportFragmentManager().findFragmentByTag(FragmentScenario.FRAGMENT_TAG);
                    if (fragment != null) {
                        activity.getSupportFragmentManager().beginTransaction().remove(fragment).commitNowAllowingStateLoss();
                    }
                }
            });
        } else {
            this.mActivityScenario.onActivity((ActivityScenario.ActivityAction)new ActivityScenario.ActivityAction<EmptyFragmentActivity>(){

                public void perform(EmptyFragmentActivity activity) {
                    Fragment fragment = activity.getSupportFragmentManager().findFragmentByTag(FragmentScenario.FRAGMENT_TAG);
                    Preconditions.checkNotNull((Object)fragment, (Object)"The fragment has been removed from FragmentManager already.");
                }
            });
            this.mActivityScenario.moveToState(newState);
        }
        return this;
    }

    @NonNull
    public FragmentScenario<F> recreate() {
        this.mActivityScenario.recreate();
        return this;
    }

    @NonNull
    public FragmentScenario<F> onFragment(final @NonNull FragmentAction<F> action) {
        this.mActivityScenario.onActivity((ActivityScenario.ActivityAction)new ActivityScenario.ActivityAction<EmptyFragmentActivity>(){

            public void perform(EmptyFragmentActivity activity) {
                Fragment fragment = activity.getSupportFragmentManager().findFragmentByTag(FragmentScenario.FRAGMENT_TAG);
                Preconditions.checkNotNull((Object)fragment, (Object)"The fragment has been removed from FragmentManager already.");
                Preconditions.checkState((boolean)FragmentScenario.this.mFragmentClass.isInstance(fragment));
                action.perform((Fragment)Preconditions.checkNotNull(FragmentScenario.this.mFragmentClass.cast(fragment)));
            }
        });
        return this;
    }

    public static interface FragmentAction<F extends Fragment> {
        public void perform(@NonNull F var1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static class FragmentFactoryHolderViewModel
    extends ViewModel {
        @Nullable
        private FragmentFactory mFragmentFactory;

        void setFragmentFactory(@Nullable FragmentFactory factory) {
            this.mFragmentFactory = factory;
        }

        @Nullable
        FragmentFactory getFragmentFactory() {
            return this.mFragmentFactory;
        }

        protected void onCleared() {
            super.onCleared();
            this.mFragmentFactory = null;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static class EmptyFragmentActivity
    extends FragmentActivity {
        @NonNull
        public static final String THEME_EXTRAS_BUNDLE_KEY = "androidx.fragment.app.testing.FragmentScenario.EmptyFragmentActivity.THEME_EXTRAS_BUNDLE_KEY";

        @SuppressLint(value={"RestrictedApi"})
        protected void onCreate(@Nullable Bundle savedInstanceState) {
            this.setTheme(this.getIntent().getIntExtra(THEME_EXTRAS_BUNDLE_KEY, R.style.FragmentScenarioEmptyFragmentActivityTheme));
            ViewModelProvider viewModelProvider = new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)ViewModelProvider.AndroidViewModelFactory.getInstance((Application)this.getApplication()));
            FragmentFactory factory = ((FragmentFactoryHolderViewModel)viewModelProvider.get(FragmentFactoryHolderViewModel.class)).getFragmentFactory();
            if (factory != null) {
                this.getSupportFragmentManager().setFragmentFactory(factory);
            }
            super.onCreate(savedInstanceState);
        }
    }
}

