/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import androidx.arch.core.internal.FastSafeIterableMap;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry_androidKt;
import androidx.lifecycle.Lifecycling;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 :2\u00020\u0001:\u0002:;B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\"H\u0017J\u0010\u0010*\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u0010+\u001a\u00020\n2\u0006\u0010)\u001a\u00020\"H\u0002J\u0010\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u00100\u001a\u00020(2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020(2\u0006\u0010\r\u001a\u00020\nH\u0017J\u0010\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\nH\u0002J\b\u00106\u001a\u00020(H\u0002J\u0010\u00107\u001a\u00020(2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u00108\u001a\u00020(2\u0006\u0010)\u001a\u00020\"H\u0017J\b\u00109\u001a\u00020(H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\n0%j\b\u0012\u0004\u0012\u00020\n`&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Landroidx/lifecycle/LifecycleRegistry;", "Landroidx/lifecycle/Lifecycle;", "provider", "Landroidx/lifecycle/LifecycleOwner;", "(Landroidx/lifecycle/LifecycleOwner;)V", "enforceMainThread", "", "(Landroidx/lifecycle/LifecycleOwner;Z)V", "_currentStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Landroidx/lifecycle/Lifecycle$State;", "addingObserverCounter", "", "state", "currentState", "getCurrentState", "()Landroidx/lifecycle/Lifecycle$State;", "setCurrentState", "(Landroidx/lifecycle/Lifecycle$State;)V", "currentStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getCurrentStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "handlingEvent", "isSynced", "()Z", "lifecycleOwner", "Ljava/lang/ref/WeakReference;", "newEventOccurred", "observerCount", "getObserverCount", "()I", "observerMap", "Landroidx/arch/core/internal/FastSafeIterableMap;", "Landroidx/lifecycle/LifecycleObserver;", "Landroidx/lifecycle/LifecycleRegistry$ObserverWithState;", "parentStates", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "addObserver", "", "observer", "backwardPass", "calculateTargetState", "enforceMainThreadIfNeeded", "methodName", "", "forwardPass", "handleLifecycleEvent", "event", "Landroidx/lifecycle/Lifecycle$Event;", "markState", "moveToState", "next", "popParentState", "pushParentState", "removeObserver", "sync", "Companion", "ObserverWithState", "lifecycle-runtime_release"})
@SourceDebugExtension(value={"SMAP\nLifecycleRegistry.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LifecycleRegistry.jvm.kt\nandroidx/lifecycle/LifecycleRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n1#2:346\n*E\n"})
public class LifecycleRegistry
extends Lifecycle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean enforceMainThread;
    @NotNull
    private FastSafeIterableMap<LifecycleObserver, ObserverWithState> observerMap;
    @NotNull
    private Lifecycle.State state;
    @NotNull
    private final WeakReference<LifecycleOwner> lifecycleOwner;
    private int addingObserverCounter;
    private boolean handlingEvent;
    private boolean newEventOccurred;
    @NotNull
    private ArrayList<Lifecycle.State> parentStates;
    @NotNull
    private final MutableStateFlow<Lifecycle.State> _currentStateFlow;

    private LifecycleRegistry(LifecycleOwner provider, boolean enforceMainThread) {
        this.enforceMainThread = enforceMainThread;
        this.observerMap = new FastSafeIterableMap();
        this.state = Lifecycle.State.INITIALIZED;
        this.parentStates = new ArrayList();
        this.lifecycleOwner = new WeakReference<LifecycleOwner>(provider);
        this._currentStateFlow = StateFlowKt.MutableStateFlow((Object)Lifecycle.State.INITIALIZED);
    }

    public LifecycleRegistry(@NotNull LifecycleOwner provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this(provider, true);
    }

    @Deprecated(message="Override [currentState].")
    @MainThread
    public void markState(@NotNull Lifecycle.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.enforceMainThreadIfNeeded("markState");
        this.setCurrentState(state);
    }

    @NotNull
    public Lifecycle.State getCurrentState() {
        return this.state;
    }

    public void setCurrentState(@NotNull Lifecycle.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.enforceMainThreadIfNeeded("setCurrentState");
        this.moveToState(state);
    }

    @NotNull
    public StateFlow<Lifecycle.State> getCurrentStateFlow() {
        return FlowKt.asStateFlow(this._currentStateFlow);
    }

    public void handleLifecycleEvent(@NotNull Lifecycle.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.enforceMainThreadIfNeeded("handleLifecycleEvent");
        this.moveToState(event.getTargetState());
    }

    private final void moveToState(Lifecycle.State next) {
        if (this.state == next) {
            return;
        }
        if (!(this.state != Lifecycle.State.INITIALIZED || next != Lifecycle.State.DESTROYED)) {
            boolean bl = false;
            String string = "State must be at least CREATED to move to " + next + ", but was " + this.state + " in component " + this.lifecycleOwner.get();
            throw new IllegalStateException(string.toString());
        }
        this.state = next;
        if (this.handlingEvent || this.addingObserverCounter != 0) {
            this.newEventOccurred = true;
            return;
        }
        this.handlingEvent = true;
        this.sync();
        this.handlingEvent = false;
        if (this.state == Lifecycle.State.DESTROYED) {
            this.observerMap = new FastSafeIterableMap();
        }
    }

    private final boolean isSynced() {
        if (this.observerMap.size() == 0) {
            return true;
        }
        Map.Entry entry = this.observerMap.eldest();
        Intrinsics.checkNotNull((Object)entry);
        Lifecycle.State eldestObserverState = ((ObserverWithState)entry.getValue()).getState();
        Map.Entry entry2 = this.observerMap.newest();
        Intrinsics.checkNotNull((Object)entry2);
        Lifecycle.State newestObserverState = ((ObserverWithState)entry2.getValue()).getState();
        return eldestObserverState == newestObserverState && this.state == newestObserverState;
    }

    private final Lifecycle.State calculateTargetState(LifecycleObserver observer2) {
        Map.Entry map = this.observerMap.ceil((Object)observer2);
        Object object = map;
        Lifecycle.State siblingState = object != null && (object = (ObserverWithState)object.getValue()) != null ? ((ObserverWithState)object).getState() : null;
        Lifecycle.State parentState = !((Collection)this.parentStates).isEmpty() ? this.parentStates.get(this.parentStates.size() - 1) : null;
        return Companion.min$lifecycle_runtime_release(Companion.min$lifecycle_runtime_release(this.state, siblingState), parentState);
    }

    @MainThread
    public void addObserver(@NotNull LifecycleObserver observer2) {
        Intrinsics.checkNotNullParameter((Object)observer2, (String)"observer");
        this.enforceMainThreadIfNeeded("addObserver");
        Lifecycle.State initialState = this.state == Lifecycle.State.DESTROYED ? Lifecycle.State.DESTROYED : Lifecycle.State.INITIALIZED;
        ObserverWithState statefulObserver = new ObserverWithState(observer2, initialState);
        ObserverWithState previous = (ObserverWithState)this.observerMap.putIfAbsent((Object)observer2, (Object)statefulObserver);
        if (previous != null) {
            return;
        }
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this.lifecycleOwner.get();
        if (lifecycleOwner == null) {
            return;
        }
        LifecycleOwner lifecycleOwner2 = lifecycleOwner;
        boolean isReentrance = this.addingObserverCounter != 0 || this.handlingEvent;
        Lifecycle.State targetState = this.calculateTargetState(observer2);
        int n = this.addingObserverCounter;
        this.addingObserverCounter = n + 1;
        while (statefulObserver.getState().compareTo((Enum)targetState) < 0 && this.observerMap.contains((Object)observer2)) {
            Lifecycle.Event event;
            this.pushParentState(statefulObserver.getState());
            if (Lifecycle.Event.Companion.upFrom(statefulObserver.getState()) == null) {
                throw new IllegalStateException("no event up from " + statefulObserver.getState());
            }
            statefulObserver.dispatchEvent(lifecycleOwner2, event);
            this.popParentState();
            targetState = this.calculateTargetState(observer2);
        }
        if (!isReentrance) {
            this.sync();
        }
        n = this.addingObserverCounter;
        this.addingObserverCounter = n + -1;
    }

    private final void popParentState() {
        this.parentStates.remove(this.parentStates.size() - 1);
    }

    private final void pushParentState(Lifecycle.State state) {
        this.parentStates.add(state);
    }

    @MainThread
    public void removeObserver(@NotNull LifecycleObserver observer2) {
        Intrinsics.checkNotNullParameter((Object)observer2, (String)"observer");
        this.enforceMainThreadIfNeeded("removeObserver");
        this.observerMap.remove((Object)observer2);
    }

    public int getObserverCount() {
        this.enforceMainThreadIfNeeded("getObserverCount");
        return this.observerMap.size();
    }

    private final void forwardPass(LifecycleOwner lifecycleOwner) {
        SafeIterableMap.IteratorWithAdditions iteratorWithAdditions = this.observerMap.iteratorWithAdditions();
        Intrinsics.checkNotNullExpressionValue((Object)iteratorWithAdditions, (String)"observerMap.iteratorWithAdditions()");
        Iterator ascendingIterator = (Iterator)iteratorWithAdditions;
        while (ascendingIterator.hasNext() && !this.newEventOccurred) {
            Map.Entry entry = (Map.Entry)ascendingIterator.next();
            LifecycleObserver key = (LifecycleObserver)entry.getKey();
            ObserverWithState observer2 = (ObserverWithState)entry.getValue();
            while (observer2.getState().compareTo((Enum)this.state) < 0 && !this.newEventOccurred && this.observerMap.contains((Object)key)) {
                Lifecycle.Event event;
                this.pushParentState(observer2.getState());
                if (Lifecycle.Event.Companion.upFrom(observer2.getState()) == null) {
                    throw new IllegalStateException("no event up from " + observer2.getState());
                }
                observer2.dispatchEvent(lifecycleOwner, event);
                this.popParentState();
            }
        }
    }

    private final void backwardPass(LifecycleOwner lifecycleOwner) {
        Iterator iterator = this.observerMap.descendingIterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"observerMap.descendingIterator()");
        Iterator descendingIterator = iterator;
        while (descendingIterator.hasNext() && !this.newEventOccurred) {
            Map.Entry entry = (Map.Entry)descendingIterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"next()");
            LifecycleObserver key = (LifecycleObserver)entry.getKey();
            ObserverWithState observer2 = (ObserverWithState)entry.getValue();
            while (observer2.getState().compareTo((Enum)this.state) > 0 && !this.newEventOccurred && this.observerMap.contains((Object)key)) {
                Lifecycle.Event event;
                if (Lifecycle.Event.Companion.downFrom(observer2.getState()) == null) {
                    throw new IllegalStateException("no event down from " + observer2.getState());
                }
                this.pushParentState(event.getTargetState());
                observer2.dispatchEvent(lifecycleOwner, event);
                this.popParentState();
            }
        }
    }

    private final void sync() {
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this.lifecycleOwner.get();
        if (lifecycleOwner == null) {
            throw new IllegalStateException("LifecycleOwner of this LifecycleRegistry is already garbage collected. It is too late to change lifecycle state.");
        }
        LifecycleOwner lifecycleOwner2 = lifecycleOwner;
        while (!this.isSynced()) {
            this.newEventOccurred = false;
            Map.Entry entry = this.observerMap.eldest();
            Intrinsics.checkNotNull((Object)entry);
            if (this.state.compareTo((Enum)((ObserverWithState)entry.getValue()).getState()) < 0) {
                this.backwardPass(lifecycleOwner2);
            }
            Map.Entry newest = this.observerMap.newest();
            if (this.newEventOccurred || newest == null || this.state.compareTo((Enum)((ObserverWithState)newest.getValue()).getState()) <= 0) continue;
            this.forwardPass(lifecycleOwner2);
        }
        this.newEventOccurred = false;
        this._currentStateFlow.setValue((Object)this.getCurrentState());
    }

    private final void enforceMainThreadIfNeeded(String methodName) {
        if (this.enforceMainThread && !LifecycleRegistry_androidKt.isMainThread()) {
            boolean bl = false;
            String string = "Method " + methodName + " must be called on the main thread";
            throw new IllegalStateException(string.toString());
        }
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final LifecycleRegistry createUnsafe(@NotNull LifecycleOwner owner) {
        return Companion.createUnsafe(owner);
    }

    @JvmStatic
    @NotNull
    public static final Lifecycle.State min$lifecycle_runtime_release(@NotNull Lifecycle.State state1, @Nullable Lifecycle.State state2) {
        return Companion.min$lifecycle_runtime_release(state1, state2);
    }

    public /* synthetic */ LifecycleRegistry(LifecycleOwner provider, boolean enforceMainThread, DefaultConstructorMarker $constructor_marker) {
        this(provider, enforceMainThread);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001f\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0001\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Landroidx/lifecycle/LifecycleRegistry$Companion;", "", "()V", "createUnsafe", "Landroidx/lifecycle/LifecycleRegistry;", "owner", "Landroidx/lifecycle/LifecycleOwner;", "min", "Landroidx/lifecycle/Lifecycle$State;", "state1", "state2", "min$lifecycle_runtime_release", "lifecycle-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final LifecycleRegistry createUnsafe(@NotNull LifecycleOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return new LifecycleRegistry(owner, false, null);
        }

        @JvmStatic
        @NotNull
        public final Lifecycle.State min$lifecycle_runtime_release(@NotNull Lifecycle.State state1, @Nullable Lifecycle.State state2) {
            Intrinsics.checkNotNullParameter((Object)state1, (String)"state1");
            return state2 != null && state2.compareTo((Enum)state1) < 0 ? state2 : state1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Landroidx/lifecycle/LifecycleRegistry$ObserverWithState;", "", "observer", "Landroidx/lifecycle/LifecycleObserver;", "initialState", "Landroidx/lifecycle/Lifecycle$State;", "(Landroidx/lifecycle/LifecycleObserver;Landroidx/lifecycle/Lifecycle$State;)V", "lifecycleObserver", "Landroidx/lifecycle/LifecycleEventObserver;", "getLifecycleObserver", "()Landroidx/lifecycle/LifecycleEventObserver;", "setLifecycleObserver", "(Landroidx/lifecycle/LifecycleEventObserver;)V", "state", "getState", "()Landroidx/lifecycle/Lifecycle$State;", "setState", "(Landroidx/lifecycle/Lifecycle$State;)V", "dispatchEvent", "", "owner", "Landroidx/lifecycle/LifecycleOwner;", "event", "Landroidx/lifecycle/Lifecycle$Event;", "lifecycle-runtime_release"})
    public static final class ObserverWithState {
        @NotNull
        private Lifecycle.State state;
        @NotNull
        private LifecycleEventObserver lifecycleObserver;

        public ObserverWithState(@Nullable LifecycleObserver observer2, @NotNull Lifecycle.State initialState) {
            Intrinsics.checkNotNullParameter((Object)initialState, (String)"initialState");
            LifecycleObserver lifecycleObserver = observer2;
            Intrinsics.checkNotNull((Object)lifecycleObserver);
            this.lifecycleObserver = Lifecycling.lifecycleEventObserver((Object)lifecycleObserver);
            this.state = initialState;
        }

        @NotNull
        public final Lifecycle.State getState() {
            return this.state;
        }

        public final void setState(@NotNull Lifecycle.State state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"<set-?>");
            this.state = state;
        }

        @NotNull
        public final LifecycleEventObserver getLifecycleObserver() {
            return this.lifecycleObserver;
        }

        public final void setLifecycleObserver(@NotNull LifecycleEventObserver lifecycleEventObserver) {
            Intrinsics.checkNotNullParameter((Object)lifecycleEventObserver, (String)"<set-?>");
            this.lifecycleObserver = lifecycleEventObserver;
        }

        public final void dispatchEvent(@Nullable LifecycleOwner owner, @NotNull Lifecycle.Event event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Lifecycle.State newState = event.getTargetState();
            this.state = Companion.min$lifecycle_runtime_release(this.state, newState);
            LifecycleOwner lifecycleOwner = owner;
            Intrinsics.checkNotNull((Object)lifecycleOwner);
            this.lifecycleObserver.onStateChanged(lifecycleOwner, event);
            this.state = newState;
        }
    }
}

