/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.lint;

import androidx.lifecycle.lint.LifecycleWhenChecksKt;
import androidx.lifecycle.lint.RecursiveVisitHelper;
import com.android.tools.lint.detector.api.JavaContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.ArrayDeque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinUSwitchEntry;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002*+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\"H\u0016J\u001c\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&J\u001c\u0010#\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&J\u001c\u0010#\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u00142\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&J\n\u0010)\u001a\u00020\u0014*\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Landroidx/lifecycle/lint/LifecycleWhenVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "whenMethodName", "", "(Lcom/android/tools/lint/detector/api/JavaContext;Ljava/lang/String;)V", "currentState", "Landroidx/lifecycle/lint/LifecycleWhenVisitor$State;", "getCurrentState", "()Landroidx/lifecycle/lint/LifecycleWhenVisitor$State;", "recursiveHelper", "Landroidx/lifecycle/lint/RecursiveVisitHelper;", "states", "Ljava/util/ArrayDeque;", "updateSuspendCallSearch", "", "newState", "Landroidx/lifecycle/lint/LifecycleWhenVisitor$SearchState;", "visitCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitDeclaration", "Lorg/jetbrains/uast/UDeclaration;", "visitIfExpression", "Lorg/jetbrains/uast/UIfExpression;", "visitLambdaExpression", "Lorg/jetbrains/uast/ULambdaExpression;", "visitSwitchClauseExpression", "Lorg/jetbrains/uast/USwitchClauseExpression;", "visitTryExpression", "Lorg/jetbrains/uast/UTryExpression;", "withNewState", "suspendCallSearch", "block", "Lkotlin/Function0;", "state", "checkUIAccess", "foundSuspendCall", "SearchState", "State", "lifecycle-runtime-ktx-lint"})
public final class LifecycleWhenVisitor
extends AbstractUastVisitor {
    @NotNull
    private final JavaContext context;
    @NotNull
    private final String whenMethodName;
    @NotNull
    private final ArrayDeque<State> states;
    @NotNull
    private final RecursiveVisitHelper recursiveHelper;

    public LifecycleWhenVisitor(@NotNull JavaContext context, @NotNull String whenMethodName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)whenMethodName, (String)"whenMethodName");
        this.context = context;
        this.whenMethodName = whenMethodName;
        this.states = new ArrayDeque();
        this.states.push(new State(false, SearchState.DONT_SEARCH));
        this.recursiveHelper = new RecursiveVisitHelper();
    }

    public final boolean foundSuspendCall(@NotNull State $this$foundSuspendCall) {
        Intrinsics.checkNotNullParameter((Object)$this$foundSuspendCall, (String)"<this>");
        return $this$foundSuspendCall.getSuspendCallSearch() == SearchState.FOUND;
    }

    private final State getCurrentState() {
        State state = this.states.getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"states.first");
        return state;
    }

    @NotNull
    public final State withNewState(@NotNull State state, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.states.push(state);
        block.invoke();
        State lastState = this.states.pop();
        if (this.getCurrentState().getSuspendCallSearch() == SearchState.SEARCH) {
            Intrinsics.checkNotNullExpressionValue((Object)lastState, (String)"lastState");
            if (this.foundSuspendCall(lastState)) {
                this.updateSuspendCallSearch(SearchState.FOUND);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)lastState, (String)"lastState");
        return lastState;
    }

    @NotNull
    public final State withNewState(@NotNull SearchState suspendCallSearch, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)suspendCallSearch), (String)"suspendCallSearch");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return this.withNewState(new State(this.getCurrentState().getCheckUIAccess(), suspendCallSearch), block);
    }

    @NotNull
    public final State withNewState(boolean checkUIAccess, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return this.withNewState(new State(checkUIAccess, this.getCurrentState().getSuspendCallSearch()), block);
    }

    public boolean visitTryExpression(@NotNull UTryExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        State stateAfterTry2 = this.withNewState(SearchState.SEARCH, (Function0<Unit>)((Function0)new Function0<Unit>(node, this){
            final /* synthetic */ UTryExpression $node;
            final /* synthetic */ LifecycleWhenVisitor this$0;
            {
                this.$node = $node;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$node.getTryClause().accept((UastVisitor)this.this$0);
            }
        }));
        boolean checkView = this.getCurrentState().getCheckUIAccess() || this.foundSuspendCall(stateAfterTry2);
        this.withNewState(checkView, (Function0<Unit>)((Function0)new Function0<Unit>(node, this){
            final /* synthetic */ UTryExpression $node;
            final /* synthetic */ LifecycleWhenVisitor this$0;
            {
                this.$node = $node;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    UExpression uExpression = this.$node.getFinallyClause();
                    if (uExpression == null) break block0;
                    uExpression.accept((UastVisitor)this.this$0);
                }
            }
        }));
        return true;
    }

    public final void updateSuspendCallSearch(@NotNull SearchState newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        State previous = this.states.pop();
        this.states.push(new State(previous.getCheckUIAccess(), newState));
    }

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return super.visitCallExpression(node);
        }
        PsiMethod psiMethod2 = psiMethod;
        if (LifecycleWhenChecksKt.access$isSuspend(psiMethod2)) {
            this.updateSuspendCallSearch(SearchState.FOUND);
            this.recursiveHelper.visitIfNeeded(psiMethod2, (UastVisitor)this);
        }
        if (this.getCurrentState().getCheckUIAccess()) {
            LifecycleWhenChecksKt.checkUiAccess(this.context, node, this.whenMethodName);
        }
        return super.visitCallExpression(node);
    }

    public boolean visitLambdaExpression(@NotNull ULambdaExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return LifecycleWhenChecksKt.access$isSuspendLambda(node) || super.visitLambdaExpression(node);
    }

    public boolean visitClass(@NotNull UClass node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return true;
    }

    public boolean visitDeclaration(@NotNull UDeclaration node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return true;
    }

    public boolean visitIfExpression(@NotNull UIfExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!this.getCurrentState().getCheckUIAccess()) {
            return false;
        }
        PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)node.getCondition()));
        PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return false;
        }
        PsiMethod method = psiMethod;
        if (LifecycleWhenChecksKt.access$isLifecycleIsAtLeastMethod(method, this.context)) {
            this.withNewState(false, (Function0<Unit>)((Function0)new Function0<Unit>(node, this){
                final /* synthetic */ UIfExpression $node;
                final /* synthetic */ LifecycleWhenVisitor this$0;
                {
                    this.$node = $node;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    block0: {
                        UExpression uExpression = this.$node.getThenExpression();
                        if (uExpression == null) break block0;
                        uExpression.accept((UastVisitor)this.this$0);
                    }
                }
            }));
            UExpression uExpression = node.getElseExpression();
            if (uExpression != null) {
                uExpression.accept((UastVisitor)this);
            }
            return true;
        }
        return false;
    }

    public boolean visitSwitchClauseExpression(@NotNull USwitchClauseExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Iterable $this$forEach$iv = node.getCaseValues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UExpression expression = (UExpression)element$iv;
            boolean bl = false;
            PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)expression));
            PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
            if (psiMethod == null) {
                return false;
            }
            PsiMethod method = psiMethod;
            if (!LifecycleWhenChecksKt.access$isLifecycleIsAtLeastMethod(method, this.context)) continue;
            this.withNewState(false, (Function0<Unit>)((Function0)new Function0<Unit>(node, this){
                final /* synthetic */ USwitchClauseExpression $node;
                final /* synthetic */ LifecycleWhenVisitor this$0;
                {
                    this.$node = $node;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    block1: {
                        void $this$forEach$iv;
                        USwitchClauseExpression uSwitchClauseExpression = this.$node;
                        Object object = uSwitchClauseExpression instanceof KotlinUSwitchEntry ? (KotlinUSwitchEntry)uSwitchClauseExpression : null;
                        if (object == null || (object = object.getBody()) == null || (object = object.getExpressions()) == null) break block1;
                        Iterable iterable = (Iterable)object;
                        LifecycleWhenVisitor lifecycleWhenVisitor = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            UExpression it = (UExpression)element$iv;
                            boolean bl = false;
                            it.accept((UastVisitor)lifecycleWhenVisitor);
                        }
                    }
                }
            }));
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/lifecycle/lint/LifecycleWhenVisitor$SearchState;", "", "(Ljava/lang/String;I)V", "DONT_SEARCH", "SEARCH", "FOUND", "lifecycle-runtime-ktx-lint"})
    public static final class SearchState
    extends Enum<SearchState> {
        public static final /* enum */ SearchState DONT_SEARCH = new SearchState();
        public static final /* enum */ SearchState SEARCH = new SearchState();
        public static final /* enum */ SearchState FOUND = new SearchState();
        private static final /* synthetic */ SearchState[] $VALUES;

        public static SearchState[] values() {
            return (SearchState[])$VALUES.clone();
        }

        public static SearchState valueOf(String value) {
            return Enum.valueOf(SearchState.class, value);
        }

        static {
            $VALUES = searchStateArray = new SearchState[]{SearchState.DONT_SEARCH, SearchState.SEARCH, SearchState.FOUND};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Landroidx/lifecycle/lint/LifecycleWhenVisitor$State;", "", "checkUIAccess", "", "suspendCallSearch", "Landroidx/lifecycle/lint/LifecycleWhenVisitor$SearchState;", "(ZLandroidx/lifecycle/lint/LifecycleWhenVisitor$SearchState;)V", "getCheckUIAccess", "()Z", "getSuspendCallSearch", "()Landroidx/lifecycle/lint/LifecycleWhenVisitor$SearchState;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "lifecycle-runtime-ktx-lint"})
    public static final class State {
        private final boolean checkUIAccess;
        @NotNull
        private final SearchState suspendCallSearch;

        public State(boolean checkUIAccess, @NotNull SearchState suspendCallSearch) {
            Intrinsics.checkNotNullParameter((Object)((Object)suspendCallSearch), (String)"suspendCallSearch");
            this.checkUIAccess = checkUIAccess;
            this.suspendCallSearch = suspendCallSearch;
        }

        public final boolean getCheckUIAccess() {
            return this.checkUIAccess;
        }

        @NotNull
        public final SearchState getSuspendCallSearch() {
            return this.suspendCallSearch;
        }

        public final boolean component1() {
            return this.checkUIAccess;
        }

        @NotNull
        public final SearchState component2() {
            return this.suspendCallSearch;
        }

        @NotNull
        public final State copy(boolean checkUIAccess, @NotNull SearchState suspendCallSearch) {
            Intrinsics.checkNotNullParameter((Object)((Object)suspendCallSearch), (String)"suspendCallSearch");
            return new State(checkUIAccess, suspendCallSearch);
        }

        public static /* synthetic */ State copy$default(State state, boolean bl, SearchState searchState, int n, Object object) {
            if ((n & 1) != 0) {
                bl = state.checkUIAccess;
            }
            if ((n & 2) != 0) {
                searchState = state.suspendCallSearch;
            }
            return state.copy(bl, searchState);
        }

        @NotNull
        public String toString() {
            return "State(checkUIAccess=" + this.checkUIAccess + ", suspendCallSearch=" + (Object)((Object)this.suspendCallSearch) + ')';
        }

        public int hashCode() {
            int n = this.checkUIAccess ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result = n;
            result = result * 31 + this.suspendCallSearch.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.checkUIAccess != state.checkUIAccess) {
                return false;
            }
            return this.suspendCallSearch == state.suspendCallSearch;
        }
    }
}

