/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.lint;

import androidx.lifecycle.lint.Method;
import androidx.lifecycle.lint.RepeatOnLifecycleDetector;
import androidx.lifecycle.lint.RepeatOnLifecycleDetectorKt;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/lifecycle/lint/RecursiveMethodVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "originClassName", "", "lifecycleMethod", "Lcom/intellij/psi/PsiMethod;", "visitedMethods", "", "(Lcom/android/tools/lint/detector/api/JavaContext;Ljava/lang/String;Lcom/intellij/psi/PsiMethod;Ljava/util/Set;)V", "checkMethodCall", "", "psiMethod", "expression", "Lorg/jetbrains/uast/UCallExpression;", "visitCallExpression", "node", "lifecycle-runtime-ktx-lint"})
final class RecursiveMethodVisitor
extends AbstractUastVisitor {
    @NotNull
    private final JavaContext context;
    @Nullable
    private final String originClassName;
    @NotNull
    private final PsiMethod lifecycleMethod;
    @NotNull
    private final Set<PsiMethod> visitedMethods;

    public RecursiveMethodVisitor(@NotNull JavaContext context, @Nullable String originClassName, @NotNull PsiMethod lifecycleMethod, @NotNull Set<PsiMethod> visitedMethods) {
        this.context = context;
        this.originClassName = originClassName;
        this.lifecycleMethod = lifecycleMethod;
        this.visitedMethods = visitedMethods;
    }

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        block3: {
            UElement uElement;
            UMethod uastNode;
            UMethod uMethod;
            PsiMethod psiMethod = node.resolve();
            if (psiMethod == null) {
                return super.visitCallExpression(node);
            }
            PsiMethod psiMethod2 = psiMethod;
            if (this.visitedMethods.contains(psiMethod2)) {
                return super.visitCallExpression(node);
            }
            if (!Intrinsics.areEqual((Object)psiMethod2.getName(), (Object)RepeatOnLifecycleDetectorKt.access$getUNSAFE_METHOD$p().getName())) {
                this.visitedMethods.add(psiMethod2);
            }
            if (this.checkMethodCall(psiMethod2, node) || (uMethod = (uastNode = (uElement = UastFacade.INSTANCE.convertElementWithParent((PsiElement)psiMethod2, UMethod.class)) instanceof UMethod ? (UMethod)uElement : null)) == null || (uMethod = uMethod.getUastBody()) == null) break block3;
            uMethod.accept((UastVisitor)this);
        }
        return super.visitCallExpression(node);
    }

    private final boolean checkMethodCall(PsiMethod psiMethod, UCallExpression expression) {
        boolean bl;
        PsiClass psiClass = psiMethod.getContainingClass();
        Method method = new Method(psiClass != null ? psiClass.getQualifiedName() : null, psiMethod.getName());
        if (Intrinsics.areEqual((Object)method, (Object)RepeatOnLifecycleDetectorKt.access$getUNSAFE_METHOD$p())) {
            Context.report$default((Context)((Context)this.context), (Issue)RepeatOnLifecycleDetector.Companion.getISSUE(), (Location)this.context.getLocation((UElement)expression), (String)("Wrong usage of " + method.getName() + " from " + this.originClassName + "." + this.lifecycleMethod.getName() + "."), null, (int)8, null);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }
}

