/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle.lint;

import androidx.lifecycle.lint.RecursiveVisitHelper;
import com.android.tools.lint.detector.api.JavaContext;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Landroidx/lifecycle/lint/CheckAccessUiVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "recursiveHelper", "Landroidx/lifecycle/lint/RecursiveVisitHelper;", "uiAccessNode", "Lorg/jetbrains/uast/UCallExpression;", "getUiAccessNode", "()Lorg/jetbrains/uast/UCallExpression;", "setUiAccessNode", "(Lorg/jetbrains/uast/UCallExpression;)V", "visitCallExpression", "", "node", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitDeclaration", "Lorg/jetbrains/uast/UDeclaration;", "visitElement", "Lorg/jetbrains/uast/UElement;", "visitLambdaExpression", "Lorg/jetbrains/uast/ULambdaExpression;", "lifecycle-runtime-ktx-lint"})
public final class CheckAccessUiVisitor
extends AbstractUastVisitor {
    @NotNull
    private final JavaContext context;
    @Nullable
    private UCallExpression uiAccessNode;
    @NotNull
    private final RecursiveVisitHelper recursiveHelper;

    public CheckAccessUiVisitor(@NotNull JavaContext context) {
        this.context = context;
        this.recursiveHelper = new RecursiveVisitHelper();
    }

    @Nullable
    public final UCallExpression getUiAccessNode() {
        return this.uiAccessNode;
    }

    public final void setUiAccessNode(@Nullable UCallExpression uCallExpression) {
        this.uiAccessNode = uCallExpression;
    }

    public boolean visitElement(@NotNull UElement node) {
        return this.uiAccessNode != null;
    }

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        PsiClass receiverClass = PsiTypesUtil.getPsiClass((PsiType)node.getReceiverType());
        if (this.context.getEvaluator().extendsClass(receiverClass, "android.view.View", false)) {
            this.uiAccessNode = node;
            return true;
        }
        this.recursiveHelper.visitIfNeeded(node.resolve(), (UastVisitor)this);
        return super.visitCallExpression(node);
    }

    public boolean visitClass(@NotNull UClass node) {
        return true;
    }

    public boolean visitDeclaration(@NotNull UDeclaration node) {
        return true;
    }

    public boolean visitLambdaExpression(@NotNull ULambdaExpression node) {
        return true;
    }
}

