/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.annotation.SuppressLint;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.arch.core.internal.FastSafeIterableMap;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Lifecycling;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class LifecycleRegistry
extends Lifecycle {
    private FastSafeIterableMap<LifecycleObserver, ObserverWithState> mObserverMap = new FastSafeIterableMap();
    private Lifecycle.State mState;
    private final WeakReference<LifecycleOwner> mLifecycleOwner;
    private int mAddingObserverCounter = 0;
    private boolean mHandlingEvent = false;
    private boolean mNewEventOccurred = false;
    private ArrayList<Lifecycle.State> mParentStates = new ArrayList();
    private final boolean mEnforceMainThread;

    public LifecycleRegistry(@NonNull LifecycleOwner provider) {
        this(provider, true);
    }

    private LifecycleRegistry(@NonNull LifecycleOwner provider, boolean enforceMainThread) {
        this.mLifecycleOwner = new WeakReference<LifecycleOwner>(provider);
        this.mState = Lifecycle.State.INITIALIZED;
        this.mEnforceMainThread = enforceMainThread;
    }

    @Deprecated
    @MainThread
    public void markState(@NonNull Lifecycle.State state) {
        this.enforceMainThreadIfNeeded("markState");
        this.setCurrentState(state);
    }

    @MainThread
    public void setCurrentState(@NonNull Lifecycle.State state) {
        this.enforceMainThreadIfNeeded("setCurrentState");
        this.moveToState(state);
    }

    public void handleLifecycleEvent(@NonNull Lifecycle.Event event) {
        this.enforceMainThreadIfNeeded("handleLifecycleEvent");
        this.moveToState(event.getTargetState());
    }

    private void moveToState(Lifecycle.State next) {
        if (this.mState == next) {
            return;
        }
        if (this.mState == Lifecycle.State.INITIALIZED && next == Lifecycle.State.DESTROYED) {
            throw new IllegalStateException("no event down from " + this.mState + " in component " + this.mLifecycleOwner.get());
        }
        this.mState = next;
        if (this.mHandlingEvent || this.mAddingObserverCounter != 0) {
            this.mNewEventOccurred = true;
            return;
        }
        this.mHandlingEvent = true;
        this.sync();
        this.mHandlingEvent = false;
        if (this.mState == Lifecycle.State.DESTROYED) {
            this.mObserverMap = new FastSafeIterableMap();
        }
    }

    private boolean isSynced() {
        if (this.mObserverMap.size() == 0) {
            return true;
        }
        Lifecycle.State eldestObserverState = ((ObserverWithState)this.mObserverMap.eldest().getValue()).mState;
        Lifecycle.State newestObserverState = ((ObserverWithState)this.mObserverMap.newest().getValue()).mState;
        return eldestObserverState == newestObserverState && this.mState == newestObserverState;
    }

    private Lifecycle.State calculateTargetState(LifecycleObserver observer) {
        Map.Entry previous = this.mObserverMap.ceil((Object)observer);
        Lifecycle.State siblingState = previous != null ? ((ObserverWithState)previous.getValue()).mState : null;
        Lifecycle.State parentState = !this.mParentStates.isEmpty() ? this.mParentStates.get(this.mParentStates.size() - 1) : null;
        return LifecycleRegistry.min(LifecycleRegistry.min(this.mState, siblingState), parentState);
    }

    public void addObserver(@NonNull LifecycleObserver observer) {
        this.enforceMainThreadIfNeeded("addObserver");
        Lifecycle.State initialState = this.mState == Lifecycle.State.DESTROYED ? Lifecycle.State.DESTROYED : Lifecycle.State.INITIALIZED;
        ObserverWithState statefulObserver = new ObserverWithState(observer, initialState);
        ObserverWithState previous = (ObserverWithState)this.mObserverMap.putIfAbsent((Object)observer, (Object)statefulObserver);
        if (previous != null) {
            return;
        }
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this.mLifecycleOwner.get();
        if (lifecycleOwner == null) {
            return;
        }
        boolean isReentrance = this.mAddingObserverCounter != 0 || this.mHandlingEvent;
        Lifecycle.State targetState = this.calculateTargetState(observer);
        ++this.mAddingObserverCounter;
        while (statefulObserver.mState.compareTo((Enum)targetState) < 0 && this.mObserverMap.contains((Object)observer)) {
            this.pushParentState(statefulObserver.mState);
            Lifecycle.Event event = Lifecycle.Event.upFrom((Lifecycle.State)statefulObserver.mState);
            if (event == null) {
                throw new IllegalStateException("no event up from " + statefulObserver.mState);
            }
            statefulObserver.dispatchEvent(lifecycleOwner, event);
            this.popParentState();
            targetState = this.calculateTargetState(observer);
        }
        if (!isReentrance) {
            this.sync();
        }
        --this.mAddingObserverCounter;
    }

    private void popParentState() {
        this.mParentStates.remove(this.mParentStates.size() - 1);
    }

    private void pushParentState(Lifecycle.State state) {
        this.mParentStates.add(state);
    }

    public void removeObserver(@NonNull LifecycleObserver observer) {
        this.enforceMainThreadIfNeeded("removeObserver");
        this.mObserverMap.remove((Object)observer);
    }

    public int getObserverCount() {
        this.enforceMainThreadIfNeeded("getObserverCount");
        return this.mObserverMap.size();
    }

    @NonNull
    public Lifecycle.State getCurrentState() {
        return this.mState;
    }

    private void forwardPass(LifecycleOwner lifecycleOwner) {
        SafeIterableMap.IteratorWithAdditions ascendingIterator = this.mObserverMap.iteratorWithAdditions();
        while (ascendingIterator.hasNext() && !this.mNewEventOccurred) {
            Map.Entry entry = (Map.Entry)ascendingIterator.next();
            ObserverWithState observer = (ObserverWithState)entry.getValue();
            while (observer.mState.compareTo((Enum)this.mState) < 0 && !this.mNewEventOccurred && this.mObserverMap.contains((Object)((LifecycleObserver)entry.getKey()))) {
                this.pushParentState(observer.mState);
                Lifecycle.Event event = Lifecycle.Event.upFrom((Lifecycle.State)observer.mState);
                if (event == null) {
                    throw new IllegalStateException("no event up from " + observer.mState);
                }
                observer.dispatchEvent(lifecycleOwner, event);
                this.popParentState();
            }
        }
    }

    private void backwardPass(LifecycleOwner lifecycleOwner) {
        Iterator descendingIterator = this.mObserverMap.descendingIterator();
        while (descendingIterator.hasNext() && !this.mNewEventOccurred) {
            Map.Entry entry = (Map.Entry)descendingIterator.next();
            ObserverWithState observer = (ObserverWithState)entry.getValue();
            while (observer.mState.compareTo((Enum)this.mState) > 0 && !this.mNewEventOccurred && this.mObserverMap.contains((Object)((LifecycleObserver)entry.getKey()))) {
                Lifecycle.Event event = Lifecycle.Event.downFrom((Lifecycle.State)observer.mState);
                if (event == null) {
                    throw new IllegalStateException("no event down from " + observer.mState);
                }
                this.pushParentState(event.getTargetState());
                observer.dispatchEvent(lifecycleOwner, event);
                this.popParentState();
            }
        }
    }

    private void sync() {
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this.mLifecycleOwner.get();
        if (lifecycleOwner == null) {
            throw new IllegalStateException("LifecycleOwner of this LifecycleRegistry is alreadygarbage collected. It is too late to change lifecycle state.");
        }
        while (!this.isSynced()) {
            this.mNewEventOccurred = false;
            if (this.mState.compareTo((Enum)((ObserverWithState)this.mObserverMap.eldest().getValue()).mState) < 0) {
                this.backwardPass(lifecycleOwner);
            }
            Map.Entry newest = this.mObserverMap.newest();
            if (this.mNewEventOccurred || newest == null || this.mState.compareTo((Enum)((ObserverWithState)newest.getValue()).mState) <= 0) continue;
            this.forwardPass(lifecycleOwner);
        }
        this.mNewEventOccurred = false;
    }

    @SuppressLint(value={"RestrictedApi"})
    private void enforceMainThreadIfNeeded(String methodName) {
        if (this.mEnforceMainThread && !ArchTaskExecutor.getInstance().isMainThread()) {
            throw new IllegalStateException("Method " + methodName + " must be called on the main thread");
        }
    }

    @VisibleForTesting
    @NonNull
    public static LifecycleRegistry createUnsafe(@NonNull LifecycleOwner owner) {
        return new LifecycleRegistry(owner, false);
    }

    static Lifecycle.State min(@NonNull Lifecycle.State state1, @Nullable Lifecycle.State state2) {
        return state2 != null && state2.compareTo((Enum)state1) < 0 ? state2 : state1;
    }

    static class ObserverWithState {
        Lifecycle.State mState;
        LifecycleEventObserver mLifecycleObserver;

        ObserverWithState(LifecycleObserver observer, Lifecycle.State initialState) {
            this.mLifecycleObserver = Lifecycling.lifecycleEventObserver((Object)observer);
            this.mState = initialState;
        }

        void dispatchEvent(LifecycleOwner owner, Lifecycle.Event event) {
            Lifecycle.State newState = event.getTargetState();
            this.mState = LifecycleRegistry.min(this.mState, newState);
            this.mLifecycleObserver.onStateChanged(owner, event);
            this.mState = newState;
        }
    }
}

