/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.util.UnstableApi;
import java.util.Arrays;
import org.checkerframework.dataflow.qual.Pure;

@UnstableApi
public final class ColorInfo
implements Bundleable {
    public final int colorSpace;
    public final int colorRange;
    public final int colorTransfer;
    @Nullable
    public final byte[] hdrStaticInfo;
    private int hashCode;
    private static final int FIELD_COLOR_SPACE = 0;
    private static final int FIELD_COLOR_RANGE = 1;
    private static final int FIELD_COLOR_TRANSFER = 2;
    private static final int FIELD_HDR_STATIC_INFO = 3;
    public static final Bundleable.Creator<ColorInfo> CREATOR = bundle -> new ColorInfo(bundle.getInt(ColorInfo.keyForField(0), -1), bundle.getInt(ColorInfo.keyForField(1), -1), bundle.getInt(ColorInfo.keyForField(2), -1), bundle.getByteArray(ColorInfo.keyForField(3)));

    @Pure
    public static int isoColorPrimariesToColorSpace(int isoColorPrimaries) {
        switch (isoColorPrimaries) {
            case 1: {
                return 1;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 2;
            }
            case 9: {
                return 6;
            }
        }
        return -1;
    }

    @Pure
    public static int isoTransferCharacteristicsToColorTransfer(int isoTransferCharacteristics) {
        switch (isoTransferCharacteristics) {
            case 1: 
            case 6: 
            case 7: {
                return 3;
            }
            case 16: {
                return 6;
            }
            case 18: {
                return 7;
            }
        }
        return -1;
    }

    public ColorInfo(int colorSpace, int colorRange, int colorTransfer, @Nullable byte[] hdrStaticInfo) {
        this.colorSpace = colorSpace;
        this.colorRange = colorRange;
        this.colorTransfer = colorTransfer;
        this.hdrStaticInfo = hdrStaticInfo;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColorInfo other = (ColorInfo)obj;
        return this.colorSpace == other.colorSpace && this.colorRange == other.colorRange && this.colorTransfer == other.colorTransfer && Arrays.equals(this.hdrStaticInfo, other.hdrStaticInfo);
    }

    public String toString() {
        int n = this.colorSpace;
        int n2 = this.colorRange;
        int n3 = this.colorTransfer;
        boolean bl = this.hdrStaticInfo != null;
        return new StringBuilder(55).append("ColorInfo(").append(n).append(", ").append(n2).append(", ").append(n3).append(", ").append(bl).append(")").toString();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + this.colorSpace;
            result = 31 * result + this.colorRange;
            result = 31 * result + this.colorTransfer;
            this.hashCode = result = 31 * result + Arrays.hashCode(this.hdrStaticInfo);
        }
        return this.hashCode;
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(ColorInfo.keyForField(0), this.colorSpace);
        bundle.putInt(ColorInfo.keyForField(1), this.colorRange);
        bundle.putInt(ColorInfo.keyForField(2), this.colorTransfer);
        bundle.putByteArray(ColorInfo.keyForField(3), this.hdrStaticInfo);
        return bundle;
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }
}

