/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.util.UnstableApi;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public final class DeviceInfo
implements Bundleable {
    public static final int PLAYBACK_TYPE_LOCAL = 0;
    public static final int PLAYBACK_TYPE_REMOTE = 1;
    public static final DeviceInfo UNKNOWN = new DeviceInfo(0, 0, 0);
    public final int playbackType;
    public final int minVolume;
    public final int maxVolume;
    private static final int FIELD_PLAYBACK_TYPE = 0;
    private static final int FIELD_MIN_VOLUME = 1;
    private static final int FIELD_MAX_VOLUME = 2;
    @UnstableApi
    public static final Bundleable.Creator<DeviceInfo> CREATOR = bundle -> {
        int playbackType = bundle.getInt(DeviceInfo.keyForField(0), 0);
        int minVolume = bundle.getInt(DeviceInfo.keyForField(1), 0);
        int maxVolume = bundle.getInt(DeviceInfo.keyForField(2), 0);
        return new DeviceInfo(playbackType, minVolume, maxVolume);
    };

    @UnstableApi
    public DeviceInfo(int playbackType, int minVolume, int maxVolume) {
        this.playbackType = playbackType;
        this.minVolume = minVolume;
        this.maxVolume = maxVolume;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeviceInfo)) {
            return false;
        }
        DeviceInfo other = (DeviceInfo)obj;
        return this.playbackType == other.playbackType && this.minVolume == other.minVolume && this.maxVolume == other.maxVolume;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.playbackType;
        result = 31 * result + this.minVolume;
        result = 31 * result + this.maxVolume;
        return result;
    }

    @Override
    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(DeviceInfo.keyForField(0), this.playbackType);
        bundle.putInt(DeviceInfo.keyForField(1), this.minVolume);
        bundle.putInt(DeviceInfo.keyForField(2), this.maxVolume);
        return bundle;
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface PlaybackType {
    }
}

