/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.media3.common.C;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;

@UnstableApi
public final class DrmInitData
implements Comparator<SchemeData>,
Parcelable {
    private final SchemeData[] schemeDatas;
    private int hashCode;
    @Nullable
    public final String schemeType;
    public final int schemeDataCount;
    public static final Parcelable.Creator<DrmInitData> CREATOR = new Parcelable.Creator<DrmInitData>(){

        public DrmInitData createFromParcel(Parcel in) {
            return new DrmInitData(in);
        }

        public DrmInitData[] newArray(int size) {
            return new DrmInitData[size];
        }
    };

    @Nullable
    public static DrmInitData createSessionCreationData(@Nullable DrmInitData manifestData, @Nullable DrmInitData mediaData) {
        ArrayList<SchemeData> result = new ArrayList<SchemeData>();
        String schemeType = null;
        if (manifestData != null) {
            schemeType = manifestData.schemeType;
            for (SchemeData data : manifestData.schemeDatas) {
                if (!data.hasData()) continue;
                result.add(data);
            }
        }
        if (mediaData != null) {
            if (schemeType == null) {
                schemeType = mediaData.schemeType;
            }
            int manifestDatasCount = result.size();
            for (SchemeData data : mediaData.schemeDatas) {
                if (!data.hasData() || DrmInitData.containsSchemeDataWithUuid(result, manifestDatasCount, data.uuid)) continue;
                result.add(data);
            }
        }
        return result.isEmpty() ? null : new DrmInitData(schemeType, result);
    }

    public DrmInitData(List<SchemeData> schemeDatas) {
        this(null, false, schemeDatas.toArray(new SchemeData[0]));
    }

    public DrmInitData(@Nullable String schemeType, List<SchemeData> schemeDatas) {
        this(schemeType, false, schemeDatas.toArray(new SchemeData[0]));
    }

    public DrmInitData(SchemeData ... schemeDatas) {
        this((String)null, schemeDatas);
    }

    public DrmInitData(@Nullable String schemeType, SchemeData ... schemeDatas) {
        this(schemeType, true, schemeDatas);
    }

    private DrmInitData(@Nullable String schemeType, boolean cloneSchemeDatas, SchemeData ... schemeDatas) {
        this.schemeType = schemeType;
        if (cloneSchemeDatas) {
            schemeDatas = (SchemeData[])schemeDatas.clone();
        }
        this.schemeDatas = schemeDatas;
        this.schemeDataCount = schemeDatas.length;
        Arrays.sort(this.schemeDatas, this);
    }

    DrmInitData(Parcel in) {
        this.schemeType = in.readString();
        this.schemeDatas = Util.castNonNull((SchemeData[])in.createTypedArray(SchemeData.CREATOR));
        this.schemeDataCount = this.schemeDatas.length;
    }

    public SchemeData get(int index) {
        return this.schemeDatas[index];
    }

    public DrmInitData copyWithSchemeType(@Nullable String schemeType) {
        if (Util.areEqual(this.schemeType, schemeType)) {
            return this;
        }
        return new DrmInitData(schemeType, false, this.schemeDatas);
    }

    public DrmInitData merge(DrmInitData drmInitData) {
        Assertions.checkState(this.schemeType == null || drmInitData.schemeType == null || TextUtils.equals((CharSequence)this.schemeType, (CharSequence)drmInitData.schemeType));
        String mergedSchemeType = this.schemeType != null ? this.schemeType : drmInitData.schemeType;
        SchemeData[] mergedSchemeDatas = Util.nullSafeArrayConcatenation(this.schemeDatas, drmInitData.schemeDatas);
        return new DrmInitData(mergedSchemeType, mergedSchemeDatas);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.schemeType == null ? 0 : this.schemeType.hashCode();
            this.hashCode = result = 31 * result + Arrays.hashCode(this.schemeDatas);
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DrmInitData other = (DrmInitData)obj;
        return Util.areEqual(this.schemeType, other.schemeType) && Arrays.equals(this.schemeDatas, other.schemeDatas);
    }

    @Override
    public int compare(SchemeData first, SchemeData second) {
        return C.UUID_NIL.equals(first.uuid) ? (C.UUID_NIL.equals(second.uuid) ? 0 : 1) : first.uuid.compareTo(second.uuid);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.schemeType);
        dest.writeTypedArray((Parcelable[])this.schemeDatas, 0);
    }

    private static boolean containsSchemeDataWithUuid(ArrayList<SchemeData> datas, int limit, UUID uuid) {
        for (int i = 0; i < limit; ++i) {
            if (!datas.get((int)i).uuid.equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public static final class SchemeData
    implements Parcelable {
        private int hashCode;
        public final UUID uuid;
        @Nullable
        public final String licenseServerUrl;
        public final String mimeType;
        @Nullable
        public final byte[] data;
        public static final Parcelable.Creator<SchemeData> CREATOR = new Parcelable.Creator<SchemeData>(){

            public SchemeData createFromParcel(Parcel in) {
                return new SchemeData(in);
            }

            public SchemeData[] newArray(int size) {
                return new SchemeData[size];
            }
        };

        public SchemeData(UUID uuid, String mimeType, @Nullable byte[] data) {
            this(uuid, null, mimeType, data);
        }

        public SchemeData(UUID uuid, @Nullable String licenseServerUrl, String mimeType, @Nullable byte[] data) {
            this.uuid = Assertions.checkNotNull(uuid);
            this.licenseServerUrl = licenseServerUrl;
            this.mimeType = Assertions.checkNotNull(mimeType);
            this.data = data;
        }

        SchemeData(Parcel in) {
            this.uuid = new UUID(in.readLong(), in.readLong());
            this.licenseServerUrl = in.readString();
            this.mimeType = Util.castNonNull(in.readString());
            this.data = in.createByteArray();
        }

        public boolean matches(UUID schemeUuid) {
            return C.UUID_NIL.equals(this.uuid) || schemeUuid.equals(this.uuid);
        }

        public boolean canReplace(SchemeData other) {
            return this.hasData() && !other.hasData() && this.matches(other.uuid);
        }

        public boolean hasData() {
            return this.data != null;
        }

        public SchemeData copyWithData(@Nullable byte[] data) {
            return new SchemeData(this.uuid, this.licenseServerUrl, this.mimeType, data);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof SchemeData)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            SchemeData other = (SchemeData)obj;
            return Util.areEqual(this.licenseServerUrl, other.licenseServerUrl) && Util.areEqual(this.mimeType, other.mimeType) && Util.areEqual(this.uuid, other.uuid) && Arrays.equals(this.data, other.data);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = this.uuid.hashCode();
                result = 31 * result + (this.licenseServerUrl == null ? 0 : this.licenseServerUrl.hashCode());
                result = 31 * result + this.mimeType.hashCode();
                this.hashCode = result = 31 * result + Arrays.hashCode(this.data);
            }
            return this.hashCode;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.uuid.getMostSignificantBits());
            dest.writeLong(this.uuid.getLeastSignificantBits());
            dest.writeString(this.licenseServerUrl);
            dest.writeString(this.mimeType);
            dest.writeByteArray(this.data);
        }
    }
}

