/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.C;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.DrmInitData;
import androidx.media3.common.Metadata;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.BundleableUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;

public final class Format
implements Bundleable {
    public static final int NO_VALUE = -1;
    @UnstableApi
    public static final long OFFSET_SAMPLE_RELATIVE = Long.MAX_VALUE;
    private static final Format DEFAULT = new Builder().build();
    @Nullable
    public final String id;
    @Nullable
    public final String label;
    @Nullable
    public final String language;
    public final int selectionFlags;
    public final int roleFlags;
    @UnstableApi
    public final int averageBitrate;
    @UnstableApi
    public final int peakBitrate;
    @UnstableApi
    public final int bitrate;
    @Nullable
    public final String codecs;
    @UnstableApi
    @Nullable
    public final Metadata metadata;
    @Nullable
    public final String containerMimeType;
    @Nullable
    public final String sampleMimeType;
    @UnstableApi
    public final int maxInputSize;
    @UnstableApi
    public final List<byte[]> initializationData;
    @UnstableApi
    @Nullable
    public final DrmInitData drmInitData;
    @UnstableApi
    public final long subsampleOffsetUs;
    public final int width;
    public final int height;
    public final float frameRate;
    @UnstableApi
    public final int rotationDegrees;
    public final float pixelWidthHeightRatio;
    @UnstableApi
    @Nullable
    public final byte[] projectionData;
    @UnstableApi
    public final int stereoMode;
    @UnstableApi
    @Nullable
    public final ColorInfo colorInfo;
    public final int channelCount;
    public final int sampleRate;
    @UnstableApi
    public final int pcmEncoding;
    @UnstableApi
    public final int encoderDelay;
    @UnstableApi
    public final int encoderPadding;
    @UnstableApi
    public final int accessibilityChannel;
    @UnstableApi
    public final int cryptoType;
    private int hashCode;
    private static final int FIELD_ID = 0;
    private static final int FIELD_LABEL = 1;
    private static final int FIELD_LANGUAGE = 2;
    private static final int FIELD_SELECTION_FLAGS = 3;
    private static final int FIELD_ROLE_FLAGS = 4;
    private static final int FIELD_AVERAGE_BITRATE = 5;
    private static final int FIELD_PEAK_BITRATE = 6;
    private static final int FIELD_CODECS = 7;
    private static final int FIELD_METADATA = 8;
    private static final int FIELD_CONTAINER_MIME_TYPE = 9;
    private static final int FIELD_SAMPLE_MIME_TYPE = 10;
    private static final int FIELD_MAX_INPUT_SIZE = 11;
    private static final int FIELD_INITIALIZATION_DATA = 12;
    private static final int FIELD_DRM_INIT_DATA = 13;
    private static final int FIELD_SUBSAMPLE_OFFSET_US = 14;
    private static final int FIELD_WIDTH = 15;
    private static final int FIELD_HEIGHT = 16;
    private static final int FIELD_FRAME_RATE = 17;
    private static final int FIELD_ROTATION_DEGREES = 18;
    private static final int FIELD_PIXEL_WIDTH_HEIGHT_RATIO = 19;
    private static final int FIELD_PROJECTION_DATA = 20;
    private static final int FIELD_STEREO_MODE = 21;
    private static final int FIELD_COLOR_INFO = 22;
    private static final int FIELD_CHANNEL_COUNT = 23;
    private static final int FIELD_SAMPLE_RATE = 24;
    private static final int FIELD_PCM_ENCODING = 25;
    private static final int FIELD_ENCODER_DELAY = 26;
    private static final int FIELD_ENCODER_PADDING = 27;
    private static final int FIELD_ACCESSIBILITY_CHANNEL = 28;
    private static final int FIELD_CRYPTO_TYPE = 29;
    @UnstableApi
    public static final Bundleable.Creator<Format> CREATOR = Format::fromBundle;

    @Deprecated
    @UnstableApi
    public static Format createVideoSampleFormat(@Nullable String id, @Nullable String sampleMimeType, @Nullable String codecs, int bitrate, int maxInputSize, int width, int height, float frameRate, @Nullable List<byte[]> initializationData, @Nullable DrmInitData drmInitData) {
        return new Builder().setId(id).setAverageBitrate(bitrate).setPeakBitrate(bitrate).setCodecs(codecs).setSampleMimeType(sampleMimeType).setMaxInputSize(maxInputSize).setInitializationData(initializationData).setDrmInitData(drmInitData).setWidth(width).setHeight(height).setFrameRate(frameRate).build();
    }

    @Deprecated
    @UnstableApi
    public static Format createVideoSampleFormat(@Nullable String id, @Nullable String sampleMimeType, @Nullable String codecs, int bitrate, int maxInputSize, int width, int height, float frameRate, @Nullable List<byte[]> initializationData, int rotationDegrees, float pixelWidthHeightRatio, @Nullable DrmInitData drmInitData) {
        return new Builder().setId(id).setAverageBitrate(bitrate).setPeakBitrate(bitrate).setCodecs(codecs).setSampleMimeType(sampleMimeType).setMaxInputSize(maxInputSize).setInitializationData(initializationData).setDrmInitData(drmInitData).setWidth(width).setHeight(height).setFrameRate(frameRate).setRotationDegrees(rotationDegrees).setPixelWidthHeightRatio(pixelWidthHeightRatio).build();
    }

    @Deprecated
    @UnstableApi
    public static Format createAudioSampleFormat(@Nullable String id, @Nullable String sampleMimeType, @Nullable String codecs, int bitrate, int maxInputSize, int channelCount, int sampleRate, @Nullable List<byte[]> initializationData, @Nullable DrmInitData drmInitData, int selectionFlags, @Nullable String language) {
        return new Builder().setId(id).setLanguage(language).setSelectionFlags(selectionFlags).setAverageBitrate(bitrate).setPeakBitrate(bitrate).setCodecs(codecs).setSampleMimeType(sampleMimeType).setMaxInputSize(maxInputSize).setInitializationData(initializationData).setDrmInitData(drmInitData).setChannelCount(channelCount).setSampleRate(sampleRate).build();
    }

    @Deprecated
    @UnstableApi
    public static Format createAudioSampleFormat(@Nullable String id, @Nullable String sampleMimeType, @Nullable String codecs, int bitrate, int maxInputSize, int channelCount, int sampleRate, int pcmEncoding, @Nullable List<byte[]> initializationData, @Nullable DrmInitData drmInitData, int selectionFlags, @Nullable String language) {
        return new Builder().setId(id).setLanguage(language).setSelectionFlags(selectionFlags).setAverageBitrate(bitrate).setPeakBitrate(bitrate).setCodecs(codecs).setSampleMimeType(sampleMimeType).setMaxInputSize(maxInputSize).setInitializationData(initializationData).setDrmInitData(drmInitData).setChannelCount(channelCount).setSampleRate(sampleRate).setPcmEncoding(pcmEncoding).build();
    }

    @Deprecated
    @UnstableApi
    public static Format createContainerFormat(@Nullable String id, @Nullable String label, @Nullable String containerMimeType, @Nullable String sampleMimeType, @Nullable String codecs, int bitrate, int selectionFlags, int roleFlags, @Nullable String language) {
        return new Builder().setId(id).setLabel(label).setLanguage(language).setSelectionFlags(selectionFlags).setRoleFlags(roleFlags).setAverageBitrate(bitrate).setPeakBitrate(bitrate).setCodecs(codecs).setContainerMimeType(containerMimeType).setSampleMimeType(sampleMimeType).build();
    }

    @Deprecated
    @UnstableApi
    public static Format createSampleFormat(@Nullable String id, @Nullable String sampleMimeType) {
        return new Builder().setId(id).setSampleMimeType(sampleMimeType).build();
    }

    private Format(Builder builder) {
        this.id = builder.id;
        this.label = builder.label;
        this.language = Util.normalizeLanguageCode(builder.language);
        this.selectionFlags = builder.selectionFlags;
        this.roleFlags = builder.roleFlags;
        this.averageBitrate = builder.averageBitrate;
        this.peakBitrate = builder.peakBitrate;
        this.bitrate = this.peakBitrate != -1 ? this.peakBitrate : this.averageBitrate;
        this.codecs = builder.codecs;
        this.metadata = builder.metadata;
        this.containerMimeType = builder.containerMimeType;
        this.sampleMimeType = builder.sampleMimeType;
        this.maxInputSize = builder.maxInputSize;
        this.initializationData = builder.initializationData == null ? Collections.emptyList() : builder.initializationData;
        this.drmInitData = builder.drmInitData;
        this.subsampleOffsetUs = builder.subsampleOffsetUs;
        this.width = builder.width;
        this.height = builder.height;
        this.frameRate = builder.frameRate;
        this.rotationDegrees = builder.rotationDegrees == -1 ? 0 : builder.rotationDegrees;
        this.pixelWidthHeightRatio = builder.pixelWidthHeightRatio == -1.0f ? 1.0f : builder.pixelWidthHeightRatio;
        this.projectionData = builder.projectionData;
        this.stereoMode = builder.stereoMode;
        this.colorInfo = builder.colorInfo;
        this.channelCount = builder.channelCount;
        this.sampleRate = builder.sampleRate;
        this.pcmEncoding = builder.pcmEncoding;
        this.encoderDelay = builder.encoderDelay == -1 ? 0 : builder.encoderDelay;
        this.encoderPadding = builder.encoderPadding == -1 ? 0 : builder.encoderPadding;
        this.accessibilityChannel = builder.accessibilityChannel;
        this.cryptoType = builder.cryptoType == 0 && this.drmInitData != null ? 1 : builder.cryptoType;
    }

    @UnstableApi
    public Builder buildUpon() {
        return new Builder(this);
    }

    @Deprecated
    @UnstableApi
    public Format copyWithMaxInputSize(int maxInputSize) {
        return this.buildUpon().setMaxInputSize(maxInputSize).build();
    }

    @Deprecated
    @UnstableApi
    public Format copyWithSubsampleOffsetUs(long subsampleOffsetUs) {
        return this.buildUpon().setSubsampleOffsetUs(subsampleOffsetUs).build();
    }

    @Deprecated
    @UnstableApi
    public Format copyWithLabel(@Nullable String label) {
        return this.buildUpon().setLabel(label).build();
    }

    @Deprecated
    @UnstableApi
    public Format copyWithManifestFormatInfo(Format manifestFormat) {
        return this.withManifestFormatInfo(manifestFormat);
    }

    @UnstableApi
    public Format withManifestFormatInfo(Format manifestFormat) {
        String codecsOfType;
        if (this == manifestFormat) {
            return this;
        }
        int trackType = MimeTypes.getTrackType(this.sampleMimeType);
        String id = manifestFormat.id;
        String label = manifestFormat.label != null ? manifestFormat.label : this.label;
        String language = this.language;
        if ((trackType == 3 || trackType == 1) && manifestFormat.language != null) {
            language = manifestFormat.language;
        }
        int averageBitrate = this.averageBitrate == -1 ? manifestFormat.averageBitrate : this.averageBitrate;
        int peakBitrate = this.peakBitrate == -1 ? manifestFormat.peakBitrate : this.peakBitrate;
        String codecs = this.codecs;
        if (codecs == null && Util.splitCodecs(codecsOfType = Util.getCodecsOfType(manifestFormat.codecs, trackType)).length == 1) {
            codecs = codecsOfType;
        }
        Metadata metadata = this.metadata == null ? manifestFormat.metadata : this.metadata.copyWithAppendedEntriesFrom(manifestFormat.metadata);
        float frameRate = this.frameRate;
        if (frameRate == -1.0f && trackType == 2) {
            frameRate = manifestFormat.frameRate;
        }
        int selectionFlags = this.selectionFlags | manifestFormat.selectionFlags;
        int roleFlags = this.roleFlags | manifestFormat.roleFlags;
        DrmInitData drmInitData = DrmInitData.createSessionCreationData(manifestFormat.drmInitData, this.drmInitData);
        return this.buildUpon().setId(id).setLabel(label).setLanguage(language).setSelectionFlags(selectionFlags).setRoleFlags(roleFlags).setAverageBitrate(averageBitrate).setPeakBitrate(peakBitrate).setCodecs(codecs).setMetadata(metadata).setDrmInitData(drmInitData).setFrameRate(frameRate).build();
    }

    @Deprecated
    @UnstableApi
    public Format copyWithGaplessInfo(int encoderDelay, int encoderPadding) {
        return this.buildUpon().setEncoderDelay(encoderDelay).setEncoderPadding(encoderPadding).build();
    }

    @Deprecated
    @UnstableApi
    public Format copyWithFrameRate(float frameRate) {
        return this.buildUpon().setFrameRate(frameRate).build();
    }

    @Deprecated
    @UnstableApi
    public Format copyWithDrmInitData(@Nullable DrmInitData drmInitData) {
        return this.buildUpon().setDrmInitData(drmInitData).build();
    }

    @Deprecated
    @UnstableApi
    public Format copyWithMetadata(@Nullable Metadata metadata) {
        return this.buildUpon().setMetadata(metadata).build();
    }

    @Deprecated
    @UnstableApi
    public Format copyWithBitrate(int bitrate) {
        return this.buildUpon().setAverageBitrate(bitrate).setPeakBitrate(bitrate).build();
    }

    @Deprecated
    @UnstableApi
    public Format copyWithVideoSize(int width, int height) {
        return this.buildUpon().setWidth(width).setHeight(height).build();
    }

    @UnstableApi
    public Format copyWithCryptoType(int cryptoType) {
        return this.buildUpon().setCryptoType(cryptoType).build();
    }

    @UnstableApi
    public int getPixelCount() {
        return this.width == -1 || this.height == -1 ? -1 : this.width * this.height;
    }

    public String toString() {
        String string = this.id;
        String string2 = this.label;
        String string3 = this.containerMimeType;
        String string4 = this.sampleMimeType;
        String string5 = this.codecs;
        int n = this.bitrate;
        String string6 = this.language;
        int n2 = this.width;
        int n3 = this.height;
        float f = this.frameRate;
        int n4 = this.channelCount;
        int n5 = this.sampleRate;
        return new StringBuilder(104 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length()).append("Format(").append(string).append(", ").append(string2).append(", ").append(string3).append(", ").append(string4).append(", ").append(string5).append(", ").append(n).append(", ").append(string6).append(", [").append(n2).append(", ").append(n3).append(", ").append(f).append("], [").append(n4).append(", ").append(n5).append("])").toString();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + this.selectionFlags;
            result = 31 * result + this.roleFlags;
            result = 31 * result + this.averageBitrate;
            result = 31 * result + this.peakBitrate;
            result = 31 * result + (this.codecs == null ? 0 : this.codecs.hashCode());
            result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
            result = 31 * result + (this.containerMimeType == null ? 0 : this.containerMimeType.hashCode());
            result = 31 * result + (this.sampleMimeType == null ? 0 : this.sampleMimeType.hashCode());
            result = 31 * result + this.maxInputSize;
            result = 31 * result + (int)this.subsampleOffsetUs;
            result = 31 * result + this.width;
            result = 31 * result + this.height;
            result = 31 * result + Float.floatToIntBits(this.frameRate);
            result = 31 * result + this.rotationDegrees;
            result = 31 * result + Float.floatToIntBits(this.pixelWidthHeightRatio);
            result = 31 * result + this.stereoMode;
            result = 31 * result + this.channelCount;
            result = 31 * result + this.sampleRate;
            result = 31 * result + this.pcmEncoding;
            result = 31 * result + this.encoderDelay;
            result = 31 * result + this.encoderPadding;
            result = 31 * result + this.accessibilityChannel;
            this.hashCode = result = 31 * result + this.cryptoType;
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Format other = (Format)obj;
        if (this.hashCode != 0 && other.hashCode != 0 && this.hashCode != other.hashCode) {
            return false;
        }
        return this.selectionFlags == other.selectionFlags && this.roleFlags == other.roleFlags && this.averageBitrate == other.averageBitrate && this.peakBitrate == other.peakBitrate && this.maxInputSize == other.maxInputSize && this.subsampleOffsetUs == other.subsampleOffsetUs && this.width == other.width && this.height == other.height && this.rotationDegrees == other.rotationDegrees && this.stereoMode == other.stereoMode && this.channelCount == other.channelCount && this.sampleRate == other.sampleRate && this.pcmEncoding == other.pcmEncoding && this.encoderDelay == other.encoderDelay && this.encoderPadding == other.encoderPadding && this.accessibilityChannel == other.accessibilityChannel && this.cryptoType == other.cryptoType && Float.compare(this.frameRate, other.frameRate) == 0 && Float.compare(this.pixelWidthHeightRatio, other.pixelWidthHeightRatio) == 0 && Util.areEqual(this.id, other.id) && Util.areEqual(this.label, other.label) && Util.areEqual(this.codecs, other.codecs) && Util.areEqual(this.containerMimeType, other.containerMimeType) && Util.areEqual(this.sampleMimeType, other.sampleMimeType) && Util.areEqual(this.language, other.language) && Arrays.equals(this.projectionData, other.projectionData) && Util.areEqual(this.metadata, other.metadata) && Util.areEqual(this.colorInfo, other.colorInfo) && Util.areEqual(this.drmInitData, other.drmInitData) && this.initializationDataEquals(other);
    }

    @UnstableApi
    public boolean initializationDataEquals(Format other) {
        if (this.initializationData.size() != other.initializationData.size()) {
            return false;
        }
        for (int i = 0; i < this.initializationData.size(); ++i) {
            if (Arrays.equals(this.initializationData.get(i), other.initializationData.get(i))) continue;
            return false;
        }
        return true;
    }

    @UnstableApi
    public static String toLogString(@Nullable Format format) {
        if (format == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("id=").append(format.id).append(", mimeType=").append(format.sampleMimeType);
        if (format.bitrate != -1) {
            builder.append(", bitrate=").append(format.bitrate);
        }
        if (format.codecs != null) {
            builder.append(", codecs=").append(format.codecs);
        }
        if (format.drmInitData != null) {
            LinkedHashSet<String> schemes = new LinkedHashSet<String>();
            for (int i = 0; i < format.drmInitData.schemeDataCount; ++i) {
                UUID schemeUuid = format.drmInitData.get((int)i).uuid;
                if (schemeUuid.equals(C.COMMON_PSSH_UUID)) {
                    schemes.add("cenc");
                    continue;
                }
                if (schemeUuid.equals(C.CLEARKEY_UUID)) {
                    schemes.add("clearkey");
                    continue;
                }
                if (schemeUuid.equals(C.PLAYREADY_UUID)) {
                    schemes.add("playready");
                    continue;
                }
                if (schemeUuid.equals(C.WIDEVINE_UUID)) {
                    schemes.add("widevine");
                    continue;
                }
                if (schemeUuid.equals(C.UUID_NIL)) {
                    schemes.add("universal");
                    continue;
                }
                String string = String.valueOf(schemeUuid);
                schemes.add(new StringBuilder(10 + String.valueOf(string).length()).append("unknown (").append(string).append(")").toString());
            }
            builder.append(", drm=[");
            Joiner.on((char)',').appendTo(builder, schemes);
            builder.append(']');
        }
        if (format.width != -1 && format.height != -1) {
            builder.append(", res=").append(format.width).append("x").append(format.height);
        }
        if (format.frameRate != -1.0f) {
            builder.append(", fps=").append(format.frameRate);
        }
        if (format.channelCount != -1) {
            builder.append(", channels=").append(format.channelCount);
        }
        if (format.sampleRate != -1) {
            builder.append(", sample_rate=").append(format.sampleRate);
        }
        if (format.language != null) {
            builder.append(", language=").append(format.language);
        }
        if (format.label != null) {
            builder.append(", label=").append(format.label);
        }
        if (format.selectionFlags != 0) {
            ArrayList<String> selectionFlags = new ArrayList<String>();
            if ((format.selectionFlags & 4) != 0) {
                selectionFlags.add("auto");
            }
            if ((format.selectionFlags & 1) != 0) {
                selectionFlags.add("default");
            }
            if ((format.selectionFlags & 2) != 0) {
                selectionFlags.add("forced");
            }
            builder.append(", selectionFlags=[");
            Joiner.on((char)',').appendTo(builder, selectionFlags);
            builder.append("]");
        }
        if (format.roleFlags != 0) {
            ArrayList<String> roleFlags = new ArrayList<String>();
            if ((format.roleFlags & 1) != 0) {
                roleFlags.add("main");
            }
            if ((format.roleFlags & 2) != 0) {
                roleFlags.add("alt");
            }
            if ((format.roleFlags & 4) != 0) {
                roleFlags.add("supplementary");
            }
            if ((format.roleFlags & 8) != 0) {
                roleFlags.add("commentary");
            }
            if ((format.roleFlags & 0x10) != 0) {
                roleFlags.add("dub");
            }
            if ((format.roleFlags & 0x20) != 0) {
                roleFlags.add("emergency");
            }
            if ((format.roleFlags & 0x40) != 0) {
                roleFlags.add("caption");
            }
            if ((format.roleFlags & 0x80) != 0) {
                roleFlags.add("subtitle");
            }
            if ((format.roleFlags & 0x100) != 0) {
                roleFlags.add("sign");
            }
            if ((format.roleFlags & 0x200) != 0) {
                roleFlags.add("describes-video");
            }
            if ((format.roleFlags & 0x400) != 0) {
                roleFlags.add("describes-music");
            }
            if ((format.roleFlags & 0x800) != 0) {
                roleFlags.add("enhanced-intelligibility");
            }
            if ((format.roleFlags & 0x1000) != 0) {
                roleFlags.add("transcribes-dialog");
            }
            if ((format.roleFlags & 0x2000) != 0) {
                roleFlags.add("easy-read");
            }
            if ((format.roleFlags & 0x4000) != 0) {
                roleFlags.add("trick-play");
            }
            builder.append(", roleFlags=[");
            Joiner.on((char)',').appendTo(builder, roleFlags);
            builder.append("]");
        }
        return builder.toString();
    }

    @Override
    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(Format.keyForField(0), this.id);
        bundle.putString(Format.keyForField(1), this.label);
        bundle.putString(Format.keyForField(2), this.language);
        bundle.putInt(Format.keyForField(3), this.selectionFlags);
        bundle.putInt(Format.keyForField(4), this.roleFlags);
        bundle.putInt(Format.keyForField(5), this.averageBitrate);
        bundle.putInt(Format.keyForField(6), this.peakBitrate);
        bundle.putString(Format.keyForField(7), this.codecs);
        bundle.putParcelable(Format.keyForField(8), (Parcelable)this.metadata);
        bundle.putString(Format.keyForField(9), this.containerMimeType);
        bundle.putString(Format.keyForField(10), this.sampleMimeType);
        bundle.putInt(Format.keyForField(11), this.maxInputSize);
        for (int i = 0; i < this.initializationData.size(); ++i) {
            bundle.putByteArray(Format.keyForInitializationData(i), this.initializationData.get(i));
        }
        bundle.putParcelable(Format.keyForField(13), (Parcelable)this.drmInitData);
        bundle.putLong(Format.keyForField(14), this.subsampleOffsetUs);
        bundle.putInt(Format.keyForField(15), this.width);
        bundle.putInt(Format.keyForField(16), this.height);
        bundle.putFloat(Format.keyForField(17), this.frameRate);
        bundle.putInt(Format.keyForField(18), this.rotationDegrees);
        bundle.putFloat(Format.keyForField(19), this.pixelWidthHeightRatio);
        bundle.putByteArray(Format.keyForField(20), this.projectionData);
        bundle.putInt(Format.keyForField(21), this.stereoMode);
        bundle.putBundle(Format.keyForField(22), BundleableUtil.toNullableBundle(this.colorInfo));
        bundle.putInt(Format.keyForField(23), this.channelCount);
        bundle.putInt(Format.keyForField(24), this.sampleRate);
        bundle.putInt(Format.keyForField(25), this.pcmEncoding);
        bundle.putInt(Format.keyForField(26), this.encoderDelay);
        bundle.putInt(Format.keyForField(27), this.encoderPadding);
        bundle.putInt(Format.keyForField(28), this.accessibilityChannel);
        bundle.putInt(Format.keyForField(29), this.cryptoType);
        return bundle;
    }

    private static Format fromBundle(Bundle bundle) {
        byte[] data;
        Builder builder = new Builder();
        BundleableUtil.ensureClassLoader(bundle);
        builder.setId(Format.defaultIfNull(bundle.getString(Format.keyForField(0)), Format.DEFAULT.id)).setLabel(Format.defaultIfNull(bundle.getString(Format.keyForField(1)), Format.DEFAULT.label)).setLanguage(Format.defaultIfNull(bundle.getString(Format.keyForField(2)), Format.DEFAULT.language)).setSelectionFlags(bundle.getInt(Format.keyForField(3), Format.DEFAULT.selectionFlags)).setRoleFlags(bundle.getInt(Format.keyForField(4), Format.DEFAULT.roleFlags)).setAverageBitrate(bundle.getInt(Format.keyForField(5), Format.DEFAULT.averageBitrate)).setPeakBitrate(bundle.getInt(Format.keyForField(6), Format.DEFAULT.peakBitrate)).setCodecs(Format.defaultIfNull(bundle.getString(Format.keyForField(7)), Format.DEFAULT.codecs)).setMetadata(Format.defaultIfNull((Metadata)bundle.getParcelable(Format.keyForField(8)), Format.DEFAULT.metadata)).setContainerMimeType(Format.defaultIfNull(bundle.getString(Format.keyForField(9)), Format.DEFAULT.containerMimeType)).setSampleMimeType(Format.defaultIfNull(bundle.getString(Format.keyForField(10)), Format.DEFAULT.sampleMimeType)).setMaxInputSize(bundle.getInt(Format.keyForField(11), Format.DEFAULT.maxInputSize));
        ArrayList<byte[]> initializationData = new ArrayList<byte[]>();
        int i = 0;
        while ((data = bundle.getByteArray(Format.keyForInitializationData(i))) != null) {
            initializationData.add(data);
            ++i;
        }
        builder.setInitializationData(initializationData).setDrmInitData((DrmInitData)bundle.getParcelable(Format.keyForField(13))).setSubsampleOffsetUs(bundle.getLong(Format.keyForField(14), Format.DEFAULT.subsampleOffsetUs)).setWidth(bundle.getInt(Format.keyForField(15), Format.DEFAULT.width)).setHeight(bundle.getInt(Format.keyForField(16), Format.DEFAULT.height)).setFrameRate(bundle.getFloat(Format.keyForField(17), Format.DEFAULT.frameRate)).setRotationDegrees(bundle.getInt(Format.keyForField(18), Format.DEFAULT.rotationDegrees)).setPixelWidthHeightRatio(bundle.getFloat(Format.keyForField(19), Format.DEFAULT.pixelWidthHeightRatio)).setProjectionData(bundle.getByteArray(Format.keyForField(20))).setStereoMode(bundle.getInt(Format.keyForField(21), Format.DEFAULT.stereoMode)).setColorInfo(BundleableUtil.fromNullableBundle(ColorInfo.CREATOR, bundle.getBundle(Format.keyForField(22)))).setChannelCount(bundle.getInt(Format.keyForField(23), Format.DEFAULT.channelCount)).setSampleRate(bundle.getInt(Format.keyForField(24), Format.DEFAULT.sampleRate)).setPcmEncoding(bundle.getInt(Format.keyForField(25), Format.DEFAULT.pcmEncoding)).setEncoderDelay(bundle.getInt(Format.keyForField(26), Format.DEFAULT.encoderDelay)).setEncoderPadding(bundle.getInt(Format.keyForField(27), Format.DEFAULT.encoderPadding)).setAccessibilityChannel(bundle.getInt(Format.keyForField(28), Format.DEFAULT.accessibilityChannel)).setCryptoType(bundle.getInt(Format.keyForField(29), Format.DEFAULT.cryptoType));
        return builder.build();
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    private static String keyForInitializationData(int initialisationDataIndex) {
        String string = Format.keyForField(12);
        String string2 = Integer.toString(initialisationDataIndex, 36);
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("_").append(string2).toString();
    }

    @Nullable
    private static <T> T defaultIfNull(@Nullable T value, @Nullable T defaultValue) {
        return value != null ? value : defaultValue;
    }

    @UnstableApi
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String label;
        @Nullable
        private String language;
        private int selectionFlags;
        private int roleFlags;
        private int averageBitrate;
        private int peakBitrate;
        @Nullable
        private String codecs;
        @Nullable
        private Metadata metadata;
        @Nullable
        private String containerMimeType;
        @Nullable
        private String sampleMimeType;
        private int maxInputSize;
        @Nullable
        private List<byte[]> initializationData;
        @Nullable
        private DrmInitData drmInitData;
        private long subsampleOffsetUs;
        private int width;
        private int height;
        private float frameRate;
        private int rotationDegrees;
        private float pixelWidthHeightRatio;
        @Nullable
        private byte[] projectionData;
        private int stereoMode;
        @Nullable
        private ColorInfo colorInfo;
        private int channelCount;
        private int sampleRate;
        private int pcmEncoding;
        private int encoderDelay;
        private int encoderPadding;
        private int accessibilityChannel;
        private int cryptoType;

        public Builder() {
            this.averageBitrate = -1;
            this.peakBitrate = -1;
            this.maxInputSize = -1;
            this.subsampleOffsetUs = Long.MAX_VALUE;
            this.width = -1;
            this.height = -1;
            this.frameRate = -1.0f;
            this.pixelWidthHeightRatio = 1.0f;
            this.stereoMode = -1;
            this.channelCount = -1;
            this.sampleRate = -1;
            this.pcmEncoding = -1;
            this.accessibilityChannel = -1;
            this.cryptoType = 0;
        }

        private Builder(Format format) {
            this.id = format.id;
            this.label = format.label;
            this.language = format.language;
            this.selectionFlags = format.selectionFlags;
            this.roleFlags = format.roleFlags;
            this.averageBitrate = format.averageBitrate;
            this.peakBitrate = format.peakBitrate;
            this.codecs = format.codecs;
            this.metadata = format.metadata;
            this.containerMimeType = format.containerMimeType;
            this.sampleMimeType = format.sampleMimeType;
            this.maxInputSize = format.maxInputSize;
            this.initializationData = format.initializationData;
            this.drmInitData = format.drmInitData;
            this.subsampleOffsetUs = format.subsampleOffsetUs;
            this.width = format.width;
            this.height = format.height;
            this.frameRate = format.frameRate;
            this.rotationDegrees = format.rotationDegrees;
            this.pixelWidthHeightRatio = format.pixelWidthHeightRatio;
            this.projectionData = format.projectionData;
            this.stereoMode = format.stereoMode;
            this.colorInfo = format.colorInfo;
            this.channelCount = format.channelCount;
            this.sampleRate = format.sampleRate;
            this.pcmEncoding = format.pcmEncoding;
            this.encoderDelay = format.encoderDelay;
            this.encoderPadding = format.encoderPadding;
            this.accessibilityChannel = format.accessibilityChannel;
            this.cryptoType = format.cryptoType;
        }

        public Builder setId(@Nullable String id) {
            this.id = id;
            return this;
        }

        public Builder setId(int id) {
            this.id = Integer.toString(id);
            return this;
        }

        public Builder setLabel(@Nullable String label) {
            this.label = label;
            return this;
        }

        public Builder setLanguage(@Nullable String language) {
            this.language = language;
            return this;
        }

        public Builder setSelectionFlags(int selectionFlags) {
            this.selectionFlags = selectionFlags;
            return this;
        }

        public Builder setRoleFlags(int roleFlags) {
            this.roleFlags = roleFlags;
            return this;
        }

        public Builder setAverageBitrate(int averageBitrate) {
            this.averageBitrate = averageBitrate;
            return this;
        }

        public Builder setPeakBitrate(int peakBitrate) {
            this.peakBitrate = peakBitrate;
            return this;
        }

        public Builder setCodecs(@Nullable String codecs) {
            this.codecs = codecs;
            return this;
        }

        public Builder setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setContainerMimeType(@Nullable String containerMimeType) {
            this.containerMimeType = containerMimeType;
            return this;
        }

        public Builder setSampleMimeType(@Nullable String sampleMimeType) {
            this.sampleMimeType = sampleMimeType;
            return this;
        }

        public Builder setMaxInputSize(int maxInputSize) {
            this.maxInputSize = maxInputSize;
            return this;
        }

        public Builder setInitializationData(@Nullable List<byte[]> initializationData) {
            this.initializationData = initializationData;
            return this;
        }

        public Builder setDrmInitData(@Nullable DrmInitData drmInitData) {
            this.drmInitData = drmInitData;
            return this;
        }

        public Builder setSubsampleOffsetUs(long subsampleOffsetUs) {
            this.subsampleOffsetUs = subsampleOffsetUs;
            return this;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder setFrameRate(float frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public Builder setRotationDegrees(int rotationDegrees) {
            this.rotationDegrees = rotationDegrees;
            return this;
        }

        public Builder setPixelWidthHeightRatio(float pixelWidthHeightRatio) {
            this.pixelWidthHeightRatio = pixelWidthHeightRatio;
            return this;
        }

        public Builder setProjectionData(@Nullable byte[] projectionData) {
            this.projectionData = projectionData;
            return this;
        }

        public Builder setStereoMode(int stereoMode) {
            this.stereoMode = stereoMode;
            return this;
        }

        public Builder setColorInfo(@Nullable ColorInfo colorInfo) {
            this.colorInfo = colorInfo;
            return this;
        }

        public Builder setChannelCount(int channelCount) {
            this.channelCount = channelCount;
            return this;
        }

        public Builder setSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder setPcmEncoding(int pcmEncoding) {
            this.pcmEncoding = pcmEncoding;
            return this;
        }

        public Builder setEncoderDelay(int encoderDelay) {
            this.encoderDelay = encoderDelay;
            return this;
        }

        public Builder setEncoderPadding(int encoderPadding) {
            this.encoderPadding = encoderPadding;
            return this;
        }

        public Builder setAccessibilityChannel(int accessibilityChannel) {
            this.accessibilityChannel = accessibilityChannel;
            return this;
        }

        public Builder setCryptoType(int cryptoType) {
            this.cryptoType = cryptoType;
            return this;
        }

        public Format build() {
            return new Format(this);
        }
    }
}

