/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.Rating;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import com.google.common.base.Objects;

public final class HeartRating
extends Rating {
    private final boolean rated;
    private final boolean isHeart;
    private static final int TYPE = 0;
    private static final int FIELD_RATED = 1;
    private static final int FIELD_IS_HEART = 2;
    @UnstableApi
    public static final Bundleable.Creator<HeartRating> CREATOR = HeartRating::fromBundle;

    public HeartRating() {
        this.rated = false;
        this.isHeart = false;
    }

    public HeartRating(boolean isHeart) {
        this.rated = true;
        this.isHeart = isHeart;
    }

    @Override
    public boolean isRated() {
        return this.rated;
    }

    public boolean isHeart() {
        return this.isHeart;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rated, this.isHeart});
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof HeartRating)) {
            return false;
        }
        HeartRating other = (HeartRating)obj;
        return this.isHeart == other.isHeart && this.rated == other.rated;
    }

    @Override
    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(HeartRating.keyForField(0), 0);
        bundle.putBoolean(HeartRating.keyForField(1), this.rated);
        bundle.putBoolean(HeartRating.keyForField(2), this.isHeart);
        return bundle;
    }

    private static HeartRating fromBundle(Bundle bundle) {
        Assertions.checkArgument(bundle.getInt(HeartRating.keyForField(0), -1) == 0);
        boolean isRated = bundle.getBoolean(HeartRating.keyForField(1), false);
        return isRated ? new HeartRating(bundle.getBoolean(HeartRating.keyForField(2), false)) : new HeartRating();
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }
}

