/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.Metadata;
import androidx.media3.common.Rating;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.base.Objects;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;

public final class MediaMetadata
implements Bundleable {
    public static final int FOLDER_TYPE_NONE = -1;
    public static final int FOLDER_TYPE_MIXED = 0;
    public static final int FOLDER_TYPE_TITLES = 1;
    public static final int FOLDER_TYPE_ALBUMS = 2;
    public static final int FOLDER_TYPE_ARTISTS = 3;
    public static final int FOLDER_TYPE_GENRES = 4;
    public static final int FOLDER_TYPE_PLAYLISTS = 5;
    public static final int FOLDER_TYPE_YEARS = 6;
    public static final int PICTURE_TYPE_OTHER = 0;
    public static final int PICTURE_TYPE_FILE_ICON = 1;
    public static final int PICTURE_TYPE_FILE_ICON_OTHER = 2;
    public static final int PICTURE_TYPE_FRONT_COVER = 3;
    public static final int PICTURE_TYPE_BACK_COVER = 4;
    public static final int PICTURE_TYPE_LEAFLET_PAGE = 5;
    public static final int PICTURE_TYPE_MEDIA = 6;
    public static final int PICTURE_TYPE_LEAD_ARTIST_PERFORMER = 7;
    public static final int PICTURE_TYPE_ARTIST_PERFORMER = 8;
    public static final int PICTURE_TYPE_CONDUCTOR = 9;
    public static final int PICTURE_TYPE_BAND_ORCHESTRA = 10;
    public static final int PICTURE_TYPE_COMPOSER = 11;
    public static final int PICTURE_TYPE_LYRICIST = 12;
    public static final int PICTURE_TYPE_RECORDING_LOCATION = 13;
    public static final int PICTURE_TYPE_DURING_RECORDING = 14;
    public static final int PICTURE_TYPE_DURING_PERFORMANCE = 15;
    public static final int PICTURE_TYPE_MOVIE_VIDEO_SCREEN_CAPTURE = 16;
    public static final int PICTURE_TYPE_A_BRIGHT_COLORED_FISH = 17;
    public static final int PICTURE_TYPE_ILLUSTRATION = 18;
    public static final int PICTURE_TYPE_BAND_ARTIST_LOGO = 19;
    public static final int PICTURE_TYPE_PUBLISHER_STUDIO_LOGO = 20;
    public static final MediaMetadata EMPTY = new Builder().build();
    @Nullable
    public final CharSequence title;
    @Nullable
    public final CharSequence artist;
    @Nullable
    public final CharSequence albumTitle;
    @Nullable
    public final CharSequence albumArtist;
    @Nullable
    public final CharSequence displayTitle;
    @Nullable
    public final CharSequence subtitle;
    @Nullable
    public final CharSequence description;
    @Nullable
    public final Uri mediaUri;
    @Nullable
    public final Rating userRating;
    @Nullable
    public final Rating overallRating;
    @Nullable
    public final byte[] artworkData;
    @Nullable
    public final Integer artworkDataType;
    @Nullable
    public final Uri artworkUri;
    @Nullable
    public final Integer trackNumber;
    @Nullable
    public final Integer totalTrackCount;
    @Nullable
    public final Integer folderType;
    @Nullable
    public final Boolean isPlayable;
    @Deprecated
    @UnstableApi
    @Nullable
    public final Integer year;
    @Nullable
    public final Integer recordingYear;
    @Nullable
    public final Integer recordingMonth;
    @Nullable
    public final Integer recordingDay;
    @Nullable
    public final Integer releaseYear;
    @Nullable
    public final Integer releaseMonth;
    @Nullable
    public final Integer releaseDay;
    @Nullable
    public final CharSequence writer;
    @Nullable
    public final CharSequence composer;
    @Nullable
    public final CharSequence conductor;
    @Nullable
    public final Integer discNumber;
    @Nullable
    public final Integer totalDiscCount;
    @Nullable
    public final CharSequence genre;
    @Nullable
    public final CharSequence compilation;
    @Nullable
    public final CharSequence station;
    @Nullable
    public final Bundle extras;
    private static final int FIELD_TITLE = 0;
    private static final int FIELD_ARTIST = 1;
    private static final int FIELD_ALBUM_TITLE = 2;
    private static final int FIELD_ALBUM_ARTIST = 3;
    private static final int FIELD_DISPLAY_TITLE = 4;
    private static final int FIELD_SUBTITLE = 5;
    private static final int FIELD_DESCRIPTION = 6;
    private static final int FIELD_MEDIA_URI = 7;
    private static final int FIELD_USER_RATING = 8;
    private static final int FIELD_OVERALL_RATING = 9;
    private static final int FIELD_ARTWORK_DATA = 10;
    private static final int FIELD_ARTWORK_URI = 11;
    private static final int FIELD_TRACK_NUMBER = 12;
    private static final int FIELD_TOTAL_TRACK_COUNT = 13;
    private static final int FIELD_FOLDER_TYPE = 14;
    private static final int FIELD_IS_PLAYABLE = 15;
    private static final int FIELD_RECORDING_YEAR = 16;
    private static final int FIELD_RECORDING_MONTH = 17;
    private static final int FIELD_RECORDING_DAY = 18;
    private static final int FIELD_RELEASE_YEAR = 19;
    private static final int FIELD_RELEASE_MONTH = 20;
    private static final int FIELD_RELEASE_DAY = 21;
    private static final int FIELD_WRITER = 22;
    private static final int FIELD_COMPOSER = 23;
    private static final int FIELD_CONDUCTOR = 24;
    private static final int FIELD_DISC_NUMBER = 25;
    private static final int FIELD_TOTAL_DISC_COUNT = 26;
    private static final int FIELD_GENRE = 27;
    private static final int FIELD_COMPILATION = 28;
    private static final int FIELD_ARTWORK_DATA_TYPE = 29;
    private static final int FIELD_STATION = 30;
    private static final int FIELD_EXTRAS = 1000;
    @UnstableApi
    public static final Bundleable.Creator<MediaMetadata> CREATOR = MediaMetadata::fromBundle;

    private MediaMetadata(Builder builder) {
        this.title = builder.title;
        this.artist = builder.artist;
        this.albumTitle = builder.albumTitle;
        this.albumArtist = builder.albumArtist;
        this.displayTitle = builder.displayTitle;
        this.subtitle = builder.subtitle;
        this.description = builder.description;
        this.mediaUri = builder.mediaUri;
        this.userRating = builder.userRating;
        this.overallRating = builder.overallRating;
        this.artworkData = builder.artworkData;
        this.artworkDataType = builder.artworkDataType;
        this.artworkUri = builder.artworkUri;
        this.trackNumber = builder.trackNumber;
        this.totalTrackCount = builder.totalTrackCount;
        this.folderType = builder.folderType;
        this.isPlayable = builder.isPlayable;
        this.year = builder.recordingYear;
        this.recordingYear = builder.recordingYear;
        this.recordingMonth = builder.recordingMonth;
        this.recordingDay = builder.recordingDay;
        this.releaseYear = builder.releaseYear;
        this.releaseMonth = builder.releaseMonth;
        this.releaseDay = builder.releaseDay;
        this.writer = builder.writer;
        this.composer = builder.composer;
        this.conductor = builder.conductor;
        this.discNumber = builder.discNumber;
        this.totalDiscCount = builder.totalDiscCount;
        this.genre = builder.genre;
        this.compilation = builder.compilation;
        this.station = builder.station;
        this.extras = builder.extras;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MediaMetadata that = (MediaMetadata)obj;
        return Util.areEqual(this.title, that.title) && Util.areEqual(this.artist, that.artist) && Util.areEqual(this.albumTitle, that.albumTitle) && Util.areEqual(this.albumArtist, that.albumArtist) && Util.areEqual(this.displayTitle, that.displayTitle) && Util.areEqual(this.subtitle, that.subtitle) && Util.areEqual(this.description, that.description) && Util.areEqual(this.mediaUri, that.mediaUri) && Util.areEqual(this.userRating, that.userRating) && Util.areEqual(this.overallRating, that.overallRating) && Arrays.equals(this.artworkData, that.artworkData) && Util.areEqual(this.artworkDataType, that.artworkDataType) && Util.areEqual(this.artworkUri, that.artworkUri) && Util.areEqual(this.trackNumber, that.trackNumber) && Util.areEqual(this.totalTrackCount, that.totalTrackCount) && Util.areEqual(this.folderType, that.folderType) && Util.areEqual(this.isPlayable, that.isPlayable) && Util.areEqual(this.recordingYear, that.recordingYear) && Util.areEqual(this.recordingMonth, that.recordingMonth) && Util.areEqual(this.recordingDay, that.recordingDay) && Util.areEqual(this.releaseYear, that.releaseYear) && Util.areEqual(this.releaseMonth, that.releaseMonth) && Util.areEqual(this.releaseDay, that.releaseDay) && Util.areEqual(this.writer, that.writer) && Util.areEqual(this.composer, that.composer) && Util.areEqual(this.conductor, that.conductor) && Util.areEqual(this.discNumber, that.discNumber) && Util.areEqual(this.totalDiscCount, that.totalDiscCount) && Util.areEqual(this.genre, that.genre) && Util.areEqual(this.compilation, that.compilation) && Util.areEqual(this.station, that.station);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.title, this.artist, this.albumTitle, this.albumArtist, this.displayTitle, this.subtitle, this.description, this.mediaUri, this.userRating, this.overallRating, Arrays.hashCode(this.artworkData), this.artworkDataType, this.artworkUri, this.trackNumber, this.totalTrackCount, this.folderType, this.isPlayable, this.recordingYear, this.recordingMonth, this.recordingDay, this.releaseYear, this.releaseMonth, this.releaseDay, this.writer, this.composer, this.conductor, this.discNumber, this.totalDiscCount, this.genre, this.compilation, this.station});
    }

    @Override
    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putCharSequence(MediaMetadata.keyForField(0), this.title);
        bundle.putCharSequence(MediaMetadata.keyForField(1), this.artist);
        bundle.putCharSequence(MediaMetadata.keyForField(2), this.albumTitle);
        bundle.putCharSequence(MediaMetadata.keyForField(3), this.albumArtist);
        bundle.putCharSequence(MediaMetadata.keyForField(4), this.displayTitle);
        bundle.putCharSequence(MediaMetadata.keyForField(5), this.subtitle);
        bundle.putCharSequence(MediaMetadata.keyForField(6), this.description);
        bundle.putParcelable(MediaMetadata.keyForField(7), (Parcelable)this.mediaUri);
        bundle.putByteArray(MediaMetadata.keyForField(10), this.artworkData);
        bundle.putParcelable(MediaMetadata.keyForField(11), (Parcelable)this.artworkUri);
        bundle.putCharSequence(MediaMetadata.keyForField(22), this.writer);
        bundle.putCharSequence(MediaMetadata.keyForField(23), this.composer);
        bundle.putCharSequence(MediaMetadata.keyForField(24), this.conductor);
        bundle.putCharSequence(MediaMetadata.keyForField(27), this.genre);
        bundle.putCharSequence(MediaMetadata.keyForField(28), this.compilation);
        bundle.putCharSequence(MediaMetadata.keyForField(30), this.station);
        if (this.userRating != null) {
            bundle.putBundle(MediaMetadata.keyForField(8), this.userRating.toBundle());
        }
        if (this.overallRating != null) {
            bundle.putBundle(MediaMetadata.keyForField(9), this.overallRating.toBundle());
        }
        if (this.trackNumber != null) {
            bundle.putInt(MediaMetadata.keyForField(12), this.trackNumber.intValue());
        }
        if (this.totalTrackCount != null) {
            bundle.putInt(MediaMetadata.keyForField(13), this.totalTrackCount.intValue());
        }
        if (this.folderType != null) {
            bundle.putInt(MediaMetadata.keyForField(14), this.folderType.intValue());
        }
        if (this.isPlayable != null) {
            bundle.putBoolean(MediaMetadata.keyForField(15), this.isPlayable.booleanValue());
        }
        if (this.recordingYear != null) {
            bundle.putInt(MediaMetadata.keyForField(16), this.recordingYear.intValue());
        }
        if (this.recordingMonth != null) {
            bundle.putInt(MediaMetadata.keyForField(17), this.recordingMonth.intValue());
        }
        if (this.recordingDay != null) {
            bundle.putInt(MediaMetadata.keyForField(18), this.recordingDay.intValue());
        }
        if (this.releaseYear != null) {
            bundle.putInt(MediaMetadata.keyForField(19), this.releaseYear.intValue());
        }
        if (this.releaseMonth != null) {
            bundle.putInt(MediaMetadata.keyForField(20), this.releaseMonth.intValue());
        }
        if (this.releaseDay != null) {
            bundle.putInt(MediaMetadata.keyForField(21), this.releaseDay.intValue());
        }
        if (this.discNumber != null) {
            bundle.putInt(MediaMetadata.keyForField(25), this.discNumber.intValue());
        }
        if (this.totalDiscCount != null) {
            bundle.putInt(MediaMetadata.keyForField(26), this.totalDiscCount.intValue());
        }
        if (this.artworkDataType != null) {
            bundle.putInt(MediaMetadata.keyForField(29), this.artworkDataType.intValue());
        }
        if (this.extras != null) {
            bundle.putBundle(MediaMetadata.keyForField(1000), this.extras);
        }
        return bundle;
    }

    private static MediaMetadata fromBundle(Bundle bundle) {
        Bundle fieldBundle;
        Builder builder = new Builder();
        builder.setTitle(bundle.getCharSequence(MediaMetadata.keyForField(0))).setArtist(bundle.getCharSequence(MediaMetadata.keyForField(1))).setAlbumTitle(bundle.getCharSequence(MediaMetadata.keyForField(2))).setAlbumArtist(bundle.getCharSequence(MediaMetadata.keyForField(3))).setDisplayTitle(bundle.getCharSequence(MediaMetadata.keyForField(4))).setSubtitle(bundle.getCharSequence(MediaMetadata.keyForField(5))).setDescription(bundle.getCharSequence(MediaMetadata.keyForField(6))).setMediaUri((Uri)bundle.getParcelable(MediaMetadata.keyForField(7))).setArtworkData(bundle.getByteArray(MediaMetadata.keyForField(10)), bundle.containsKey(MediaMetadata.keyForField(29)) ? Integer.valueOf(bundle.getInt(MediaMetadata.keyForField(29))) : null).setArtworkUri((Uri)bundle.getParcelable(MediaMetadata.keyForField(11))).setWriter(bundle.getCharSequence(MediaMetadata.keyForField(22))).setComposer(bundle.getCharSequence(MediaMetadata.keyForField(23))).setConductor(bundle.getCharSequence(MediaMetadata.keyForField(24))).setGenre(bundle.getCharSequence(MediaMetadata.keyForField(27))).setCompilation(bundle.getCharSequence(MediaMetadata.keyForField(28))).setStation(bundle.getCharSequence(MediaMetadata.keyForField(30))).setExtras(bundle.getBundle(MediaMetadata.keyForField(1000)));
        if (bundle.containsKey(MediaMetadata.keyForField(8)) && (fieldBundle = bundle.getBundle(MediaMetadata.keyForField(8))) != null) {
            builder.setUserRating(Rating.CREATOR.fromBundle(fieldBundle));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(9)) && (fieldBundle = bundle.getBundle(MediaMetadata.keyForField(9))) != null) {
            builder.setOverallRating(Rating.CREATOR.fromBundle(fieldBundle));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(12))) {
            builder.setTrackNumber(bundle.getInt(MediaMetadata.keyForField(12)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(13))) {
            builder.setTotalTrackCount(bundle.getInt(MediaMetadata.keyForField(13)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(14))) {
            builder.setFolderType(bundle.getInt(MediaMetadata.keyForField(14)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(15))) {
            builder.setIsPlayable(bundle.getBoolean(MediaMetadata.keyForField(15)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(16))) {
            builder.setRecordingYear(bundle.getInt(MediaMetadata.keyForField(16)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(17))) {
            builder.setRecordingMonth(bundle.getInt(MediaMetadata.keyForField(17)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(18))) {
            builder.setRecordingDay(bundle.getInt(MediaMetadata.keyForField(18)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(19))) {
            builder.setReleaseYear(bundle.getInt(MediaMetadata.keyForField(19)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(20))) {
            builder.setReleaseMonth(bundle.getInt(MediaMetadata.keyForField(20)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(21))) {
            builder.setReleaseDay(bundle.getInt(MediaMetadata.keyForField(21)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(25))) {
            builder.setDiscNumber(bundle.getInt(MediaMetadata.keyForField(25)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(26))) {
            builder.setTotalDiscCount(bundle.getInt(MediaMetadata.keyForField(26)));
        }
        return builder.build();
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface PictureType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface FolderType {
    }

    public static final class Builder {
        @Nullable
        private CharSequence title;
        @Nullable
        private CharSequence artist;
        @Nullable
        private CharSequence albumTitle;
        @Nullable
        private CharSequence albumArtist;
        @Nullable
        private CharSequence displayTitle;
        @Nullable
        private CharSequence subtitle;
        @Nullable
        private CharSequence description;
        @Nullable
        private Uri mediaUri;
        @Nullable
        private Rating userRating;
        @Nullable
        private Rating overallRating;
        @Nullable
        private byte[] artworkData;
        @Nullable
        private Integer artworkDataType;
        @Nullable
        private Uri artworkUri;
        @Nullable
        private Integer trackNumber;
        @Nullable
        private Integer totalTrackCount;
        @Nullable
        private Integer folderType;
        @Nullable
        private Boolean isPlayable;
        @Nullable
        private Integer recordingYear;
        @Nullable
        private Integer recordingMonth;
        @Nullable
        private Integer recordingDay;
        @Nullable
        private Integer releaseYear;
        @Nullable
        private Integer releaseMonth;
        @Nullable
        private Integer releaseDay;
        @Nullable
        private CharSequence writer;
        @Nullable
        private CharSequence composer;
        @Nullable
        private CharSequence conductor;
        @Nullable
        private Integer discNumber;
        @Nullable
        private Integer totalDiscCount;
        @Nullable
        private CharSequence genre;
        @Nullable
        private CharSequence compilation;
        @Nullable
        private CharSequence station;
        @Nullable
        private Bundle extras;

        public Builder() {
        }

        private Builder(MediaMetadata mediaMetadata) {
            this.title = mediaMetadata.title;
            this.artist = mediaMetadata.artist;
            this.albumTitle = mediaMetadata.albumTitle;
            this.albumArtist = mediaMetadata.albumArtist;
            this.displayTitle = mediaMetadata.displayTitle;
            this.subtitle = mediaMetadata.subtitle;
            this.description = mediaMetadata.description;
            this.mediaUri = mediaMetadata.mediaUri;
            this.userRating = mediaMetadata.userRating;
            this.overallRating = mediaMetadata.overallRating;
            this.artworkData = mediaMetadata.artworkData;
            this.artworkDataType = mediaMetadata.artworkDataType;
            this.artworkUri = mediaMetadata.artworkUri;
            this.trackNumber = mediaMetadata.trackNumber;
            this.totalTrackCount = mediaMetadata.totalTrackCount;
            this.folderType = mediaMetadata.folderType;
            this.isPlayable = mediaMetadata.isPlayable;
            this.recordingYear = mediaMetadata.recordingYear;
            this.recordingMonth = mediaMetadata.recordingMonth;
            this.recordingDay = mediaMetadata.recordingDay;
            this.releaseYear = mediaMetadata.releaseYear;
            this.releaseMonth = mediaMetadata.releaseMonth;
            this.releaseDay = mediaMetadata.releaseDay;
            this.writer = mediaMetadata.writer;
            this.composer = mediaMetadata.composer;
            this.conductor = mediaMetadata.conductor;
            this.discNumber = mediaMetadata.discNumber;
            this.totalDiscCount = mediaMetadata.totalDiscCount;
            this.genre = mediaMetadata.genre;
            this.compilation = mediaMetadata.compilation;
            this.station = mediaMetadata.station;
            this.extras = mediaMetadata.extras;
        }

        public Builder setTitle(@Nullable CharSequence title) {
            this.title = title;
            return this;
        }

        public Builder setArtist(@Nullable CharSequence artist) {
            this.artist = artist;
            return this;
        }

        public Builder setAlbumTitle(@Nullable CharSequence albumTitle) {
            this.albumTitle = albumTitle;
            return this;
        }

        public Builder setAlbumArtist(@Nullable CharSequence albumArtist) {
            this.albumArtist = albumArtist;
            return this;
        }

        public Builder setDisplayTitle(@Nullable CharSequence displayTitle) {
            this.displayTitle = displayTitle;
            return this;
        }

        public Builder setSubtitle(@Nullable CharSequence subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder setDescription(@Nullable CharSequence description) {
            this.description = description;
            return this;
        }

        public Builder setMediaUri(@Nullable Uri mediaUri) {
            this.mediaUri = mediaUri;
            return this;
        }

        public Builder setUserRating(@Nullable Rating userRating) {
            this.userRating = userRating;
            return this;
        }

        public Builder setOverallRating(@Nullable Rating overallRating) {
            this.overallRating = overallRating;
            return this;
        }

        @Deprecated
        @UnstableApi
        public Builder setArtworkData(@Nullable byte[] artworkData) {
            return this.setArtworkData(artworkData, null);
        }

        public Builder setArtworkData(@Nullable byte[] artworkData, @Nullable Integer artworkDataType) {
            this.artworkData = artworkData == null ? null : (byte[])artworkData.clone();
            this.artworkDataType = artworkDataType;
            return this;
        }

        public Builder maybeSetArtworkData(byte[] artworkData, int artworkDataType) {
            if (this.artworkData == null || Util.areEqual(artworkDataType, 3) || !Util.areEqual(this.artworkDataType, 3)) {
                this.artworkData = (byte[])artworkData.clone();
                this.artworkDataType = artworkDataType;
            }
            return this;
        }

        public Builder setArtworkUri(@Nullable Uri artworkUri) {
            this.artworkUri = artworkUri;
            return this;
        }

        public Builder setTrackNumber(@Nullable Integer trackNumber) {
            this.trackNumber = trackNumber;
            return this;
        }

        public Builder setTotalTrackCount(@Nullable Integer totalTrackCount) {
            this.totalTrackCount = totalTrackCount;
            return this;
        }

        public Builder setFolderType(@Nullable Integer folderType) {
            this.folderType = folderType;
            return this;
        }

        public Builder setIsPlayable(@Nullable Boolean isPlayable) {
            this.isPlayable = isPlayable;
            return this;
        }

        @Deprecated
        @UnstableApi
        public Builder setYear(@Nullable Integer year) {
            return this.setRecordingYear(year);
        }

        public Builder setRecordingYear(@Nullable Integer recordingYear) {
            this.recordingYear = recordingYear;
            return this;
        }

        public Builder setRecordingMonth(@Nullable @IntRange(from=1L, to=12L) Integer recordingMonth) {
            this.recordingMonth = recordingMonth;
            return this;
        }

        public Builder setRecordingDay(@Nullable @IntRange(from=1L, to=31L) Integer recordingDay) {
            this.recordingDay = recordingDay;
            return this;
        }

        public Builder setReleaseYear(@Nullable Integer releaseYear) {
            this.releaseYear = releaseYear;
            return this;
        }

        public Builder setReleaseMonth(@Nullable @IntRange(from=1L, to=12L) Integer releaseMonth) {
            this.releaseMonth = releaseMonth;
            return this;
        }

        public Builder setReleaseDay(@Nullable @IntRange(from=1L, to=31L) Integer releaseDay) {
            this.releaseDay = releaseDay;
            return this;
        }

        public Builder setWriter(@Nullable CharSequence writer) {
            this.writer = writer;
            return this;
        }

        public Builder setComposer(@Nullable CharSequence composer) {
            this.composer = composer;
            return this;
        }

        public Builder setConductor(@Nullable CharSequence conductor) {
            this.conductor = conductor;
            return this;
        }

        public Builder setDiscNumber(@Nullable Integer discNumber) {
            this.discNumber = discNumber;
            return this;
        }

        public Builder setTotalDiscCount(@Nullable Integer totalDiscCount) {
            this.totalDiscCount = totalDiscCount;
            return this;
        }

        public Builder setGenre(@Nullable CharSequence genre) {
            this.genre = genre;
            return this;
        }

        public Builder setCompilation(@Nullable CharSequence compilation) {
            this.compilation = compilation;
            return this;
        }

        public Builder setStation(@Nullable CharSequence station) {
            this.station = station;
            return this;
        }

        public Builder setExtras(@Nullable Bundle extras) {
            this.extras = extras;
            return this;
        }

        @UnstableApi
        public Builder populateFromMetadata(Metadata metadata) {
            for (int i = 0; i < metadata.length(); ++i) {
                Metadata.Entry entry = metadata.get(i);
                entry.populateMediaMetadata(this);
            }
            return this;
        }

        @UnstableApi
        public Builder populateFromMetadata(List<Metadata> metadataList) {
            for (int i = 0; i < metadataList.size(); ++i) {
                Metadata metadata = metadataList.get(i);
                for (int j = 0; j < metadata.length(); ++j) {
                    Metadata.Entry entry = metadata.get(j);
                    entry.populateMediaMetadata(this);
                }
            }
            return this;
        }

        @UnstableApi
        public Builder populate(@Nullable MediaMetadata mediaMetadata) {
            if (mediaMetadata == null) {
                return this;
            }
            if (mediaMetadata.title != null) {
                this.setTitle(mediaMetadata.title);
            }
            if (mediaMetadata.artist != null) {
                this.setArtist(mediaMetadata.artist);
            }
            if (mediaMetadata.albumTitle != null) {
                this.setAlbumTitle(mediaMetadata.albumTitle);
            }
            if (mediaMetadata.albumArtist != null) {
                this.setAlbumArtist(mediaMetadata.albumArtist);
            }
            if (mediaMetadata.displayTitle != null) {
                this.setDisplayTitle(mediaMetadata.displayTitle);
            }
            if (mediaMetadata.subtitle != null) {
                this.setSubtitle(mediaMetadata.subtitle);
            }
            if (mediaMetadata.description != null) {
                this.setDescription(mediaMetadata.description);
            }
            if (mediaMetadata.mediaUri != null) {
                this.setMediaUri(mediaMetadata.mediaUri);
            }
            if (mediaMetadata.userRating != null) {
                this.setUserRating(mediaMetadata.userRating);
            }
            if (mediaMetadata.overallRating != null) {
                this.setOverallRating(mediaMetadata.overallRating);
            }
            if (mediaMetadata.artworkData != null) {
                this.setArtworkData(mediaMetadata.artworkData, mediaMetadata.artworkDataType);
            }
            if (mediaMetadata.artworkUri != null) {
                this.setArtworkUri(mediaMetadata.artworkUri);
            }
            if (mediaMetadata.trackNumber != null) {
                this.setTrackNumber(mediaMetadata.trackNumber);
            }
            if (mediaMetadata.totalTrackCount != null) {
                this.setTotalTrackCount(mediaMetadata.totalTrackCount);
            }
            if (mediaMetadata.folderType != null) {
                this.setFolderType(mediaMetadata.folderType);
            }
            if (mediaMetadata.isPlayable != null) {
                this.setIsPlayable(mediaMetadata.isPlayable);
            }
            if (mediaMetadata.year != null) {
                this.setRecordingYear(mediaMetadata.year);
            }
            if (mediaMetadata.recordingYear != null) {
                this.setRecordingYear(mediaMetadata.recordingYear);
            }
            if (mediaMetadata.recordingMonth != null) {
                this.setRecordingMonth(mediaMetadata.recordingMonth);
            }
            if (mediaMetadata.recordingDay != null) {
                this.setRecordingDay(mediaMetadata.recordingDay);
            }
            if (mediaMetadata.releaseYear != null) {
                this.setReleaseYear(mediaMetadata.releaseYear);
            }
            if (mediaMetadata.releaseMonth != null) {
                this.setReleaseMonth(mediaMetadata.releaseMonth);
            }
            if (mediaMetadata.releaseDay != null) {
                this.setReleaseDay(mediaMetadata.releaseDay);
            }
            if (mediaMetadata.writer != null) {
                this.setWriter(mediaMetadata.writer);
            }
            if (mediaMetadata.composer != null) {
                this.setComposer(mediaMetadata.composer);
            }
            if (mediaMetadata.conductor != null) {
                this.setConductor(mediaMetadata.conductor);
            }
            if (mediaMetadata.discNumber != null) {
                this.setDiscNumber(mediaMetadata.discNumber);
            }
            if (mediaMetadata.totalDiscCount != null) {
                this.setTotalDiscCount(mediaMetadata.totalDiscCount);
            }
            if (mediaMetadata.genre != null) {
                this.setGenre(mediaMetadata.genre);
            }
            if (mediaMetadata.compilation != null) {
                this.setCompilation(mediaMetadata.compilation);
            }
            if (mediaMetadata.station != null) {
                this.setStation(mediaMetadata.station);
            }
            if (mediaMetadata.extras != null) {
                this.setExtras(mediaMetadata.extras);
            }
            return this;
        }

        public MediaMetadata build() {
            return new MediaMetadata(this);
        }
    }
}

