/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.MediaMetadata;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.util.Arrays;
import java.util.List;

@UnstableApi
public final class Metadata
implements Parcelable {
    private final Entry[] entries;
    public static final Parcelable.Creator<Metadata> CREATOR = new Parcelable.Creator<Metadata>(){

        public Metadata createFromParcel(Parcel in) {
            return new Metadata(in);
        }

        public Metadata[] newArray(int size) {
            return new Metadata[size];
        }
    };

    public Metadata(Entry ... entries) {
        this.entries = entries;
    }

    public Metadata(List<? extends Entry> entries) {
        this.entries = entries.toArray(new Entry[0]);
    }

    Metadata(Parcel in) {
        this.entries = new Entry[in.readInt()];
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = (Entry)in.readParcelable(Entry.class.getClassLoader());
        }
    }

    public int length() {
        return this.entries.length;
    }

    public Entry get(int index) {
        return this.entries[index];
    }

    public Metadata copyWithAppendedEntriesFrom(@Nullable Metadata other) {
        if (other == null) {
            return this;
        }
        return this.copyWithAppendedEntries(other.entries);
    }

    public Metadata copyWithAppendedEntries(Entry ... entriesToAppend) {
        if (entriesToAppend.length == 0) {
            return this;
        }
        return new Metadata(Util.nullSafeArrayConcatenation(this.entries, entriesToAppend));
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Metadata other = (Metadata)obj;
        return Arrays.equals(this.entries, other.entries);
    }

    public int hashCode() {
        return Arrays.hashCode(this.entries);
    }

    public String toString() {
        String string = String.valueOf(Arrays.toString(this.entries));
        return string.length() != 0 ? "entries=".concat(string) : new String("entries=");
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.entries.length);
        for (Entry entry : this.entries) {
            dest.writeParcelable((Parcelable)entry, 0);
        }
    }

    public static interface Entry
    extends Parcelable {
        @Nullable
        default public Format getWrappedMetadataFormat() {
            return null;
        }

        @Nullable
        default public byte[] getWrappedMetadataBytes() {
            return null;
        }

        default public void populateMediaMetadata(MediaMetadata.Builder builder) {
        }
    }
}

