/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import androidx.annotation.FloatRange;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.Rating;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import com.google.common.base.Objects;

public final class PercentageRating
extends Rating {
    private final float percent;
    private static final int TYPE = 1;
    private static final int FIELD_PERCENT = 1;
    @UnstableApi
    public static final Bundleable.Creator<PercentageRating> CREATOR = PercentageRating::fromBundle;

    public PercentageRating() {
        this.percent = -1.0f;
    }

    public PercentageRating(@FloatRange(from=0.0, to=100.0) float percent) {
        Assertions.checkArgument(percent >= 0.0f && percent <= 100.0f, "percent must be in the range of [0, 100]");
        this.percent = percent;
    }

    @Override
    public boolean isRated() {
        return this.percent != -1.0f;
    }

    public float getPercent() {
        return this.percent;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.percent)});
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof PercentageRating)) {
            return false;
        }
        return this.percent == ((PercentageRating)obj).percent;
    }

    @Override
    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(PercentageRating.keyForField(0), 1);
        bundle.putFloat(PercentageRating.keyForField(1), this.percent);
        return bundle;
    }

    private static PercentageRating fromBundle(Bundle bundle) {
        Assertions.checkArgument(bundle.getInt(PercentageRating.keyForField(0), -1) == 1);
        float percent = bundle.getFloat(PercentageRating.keyForField(1), -1.0f);
        return percent == -1.0f ? new PercentageRating() : new PercentageRating(percent);
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }
}

