/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.util.BundleableUtil;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import com.google.common.collect.ImmutableList;
import java.util.List;

@UnstableApi
public final class TrackGroupArray
implements Bundleable {
    private static final String TAG = "TrackGroupArray";
    public static final TrackGroupArray EMPTY = new TrackGroupArray(new TrackGroup[0]);
    public final int length;
    private final ImmutableList<TrackGroup> trackGroups;
    private int hashCode;
    private static final int FIELD_TRACK_GROUPS = 0;
    public static final Bundleable.Creator<TrackGroupArray> CREATOR = bundle -> {
        List<TrackGroup> trackGroups = BundleableUtil.fromBundleNullableList(TrackGroup.CREATOR, bundle.getParcelableArrayList(TrackGroupArray.keyForField(0)), ImmutableList.of());
        return new TrackGroupArray(trackGroups.toArray(new TrackGroup[0]));
    };

    public TrackGroupArray(TrackGroup ... trackGroups) {
        this.trackGroups = ImmutableList.copyOf((Object[])trackGroups);
        this.length = trackGroups.length;
        this.verifyCorrectness();
    }

    public TrackGroup get(int index) {
        return (TrackGroup)this.trackGroups.get(index);
    }

    public int indexOf(TrackGroup group) {
        int index = this.trackGroups.indexOf((Object)group);
        return index >= 0 ? index : -1;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.trackGroups.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackGroupArray other = (TrackGroupArray)obj;
        return this.length == other.length && this.trackGroups.equals(other.trackGroups);
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(TrackGroupArray.keyForField(0), BundleableUtil.toBundleArrayList(this.trackGroups));
        return bundle;
    }

    private void verifyCorrectness() {
        for (int i = 0; i < this.trackGroups.size(); ++i) {
            for (int j = i + 1; j < this.trackGroups.size(); ++j) {
                if (!((TrackGroup)this.trackGroups.get(i)).equals(this.trackGroups.get(j))) continue;
                Log.e(TAG, "", new IllegalArgumentException("Multiple identical TrackGroups added to one TrackGroupArray."));
            }
        }
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }
}

