/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.media3.common.util.UnstableApi;

@UnstableApi
public final class StreamKey
implements Comparable<StreamKey>,
Parcelable {
    public final int periodIndex;
    public final int groupIndex;
    public final int streamIndex;
    @Deprecated
    public final int trackIndex;
    public static final Parcelable.Creator<StreamKey> CREATOR = new Parcelable.Creator<StreamKey>(){

        public StreamKey createFromParcel(Parcel in) {
            return new StreamKey(in);
        }

        public StreamKey[] newArray(int size) {
            return new StreamKey[size];
        }
    };

    public StreamKey(int groupIndex, int streamIndex) {
        this(0, groupIndex, streamIndex);
    }

    public StreamKey(int periodIndex, int groupIndex, int streamIndex) {
        this.periodIndex = periodIndex;
        this.groupIndex = groupIndex;
        this.streamIndex = streamIndex;
        this.trackIndex = streamIndex;
    }

    StreamKey(Parcel in) {
        this.periodIndex = in.readInt();
        this.groupIndex = in.readInt();
        this.trackIndex = this.streamIndex = in.readInt();
    }

    public String toString() {
        return this.periodIndex + "." + this.groupIndex + "." + this.streamIndex;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamKey that = (StreamKey)o;
        return this.periodIndex == that.periodIndex && this.groupIndex == that.groupIndex && this.streamIndex == that.streamIndex;
    }

    public int hashCode() {
        int result = this.periodIndex;
        result = 31 * result + this.groupIndex;
        result = 31 * result + this.streamIndex;
        return result;
    }

    @Override
    public int compareTo(StreamKey o) {
        int result = this.periodIndex - o.periodIndex;
        if (result == 0 && (result = this.groupIndex - o.groupIndex) == 0) {
            result = this.streamIndex - o.streamIndex;
        }
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.periodIndex);
        dest.writeInt(this.groupIndex);
        dest.writeInt(this.streamIndex);
    }
}

