/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Player;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.List;

@UnstableApi
public abstract class BasePlayer
implements Player {
    protected final Timeline.Window window = new Timeline.Window();

    protected BasePlayer() {
    }

    @Override
    public final void setMediaItem(MediaItem mediaItem) {
        this.setMediaItems((List<MediaItem>)ImmutableList.of((Object)mediaItem));
    }

    @Override
    public final void setMediaItem(MediaItem mediaItem, long startPositionMs) {
        this.setMediaItems((List<MediaItem>)ImmutableList.of((Object)mediaItem), 0, startPositionMs);
    }

    @Override
    public final void setMediaItem(MediaItem mediaItem, boolean resetPosition) {
        this.setMediaItems((List<MediaItem>)ImmutableList.of((Object)mediaItem), resetPosition);
    }

    @Override
    public final void setMediaItems(List<MediaItem> mediaItems) {
        this.setMediaItems(mediaItems, true);
    }

    @Override
    public final void addMediaItem(int index, MediaItem mediaItem) {
        this.addMediaItems(index, (List<MediaItem>)ImmutableList.of((Object)mediaItem));
    }

    @Override
    public final void addMediaItem(MediaItem mediaItem) {
        this.addMediaItems((List<MediaItem>)ImmutableList.of((Object)mediaItem));
    }

    @Override
    public final void addMediaItems(List<MediaItem> mediaItems) {
        this.addMediaItems(Integer.MAX_VALUE, mediaItems);
    }

    @Override
    public final void moveMediaItem(int currentIndex, int newIndex) {
        if (currentIndex != newIndex) {
            this.moveMediaItems(currentIndex, currentIndex + 1, newIndex);
        }
    }

    @Override
    public final void removeMediaItem(int index) {
        this.removeMediaItems(index, index + 1);
    }

    @Override
    public final void clearMediaItems() {
        this.removeMediaItems(0, Integer.MAX_VALUE);
    }

    @Override
    public final boolean isCommandAvailable(int command) {
        return this.getAvailableCommands().contains(command);
    }

    @Override
    public final boolean canAdvertiseSession() {
        return true;
    }

    @Override
    public final void play() {
        this.setPlayWhenReady(true);
    }

    @Override
    public final void pause() {
        this.setPlayWhenReady(false);
    }

    @Override
    public final boolean isPlaying() {
        return this.getPlaybackState() == 3 && this.getPlayWhenReady() && this.getPlaybackSuppressionReason() == 0;
    }

    @Override
    public final void seekToDefaultPosition() {
        this.seekToDefaultPositionInternal(this.getCurrentMediaItemIndex(), 4);
    }

    @Override
    public final void seekToDefaultPosition(int mediaItemIndex) {
        this.seekToDefaultPositionInternal(mediaItemIndex, 10);
    }

    @Override
    public final void seekBack() {
        this.seekToOffset(-this.getSeekBackIncrement(), 11);
    }

    @Override
    public final void seekForward() {
        this.seekToOffset(this.getSeekForwardIncrement(), 12);
    }

    @Override
    @Deprecated
    public final boolean hasPrevious() {
        return this.hasPreviousMediaItem();
    }

    @Override
    @Deprecated
    public final boolean hasPreviousWindow() {
        return this.hasPreviousMediaItem();
    }

    @Override
    public final boolean hasPreviousMediaItem() {
        return this.getPreviousMediaItemIndex() != -1;
    }

    @Override
    @Deprecated
    public final void previous() {
        this.seekToPreviousMediaItem();
    }

    @Override
    @Deprecated
    public final void seekToPreviousWindow() {
        this.seekToPreviousMediaItem();
    }

    @Override
    public final void seekToPreviousMediaItem() {
        this.seekToPreviousMediaItemInternal(6);
    }

    @Override
    public final void seekToPrevious() {
        Timeline timeline = this.getCurrentTimeline();
        if (timeline.isEmpty() || this.isPlayingAd()) {
            return;
        }
        boolean hasPreviousMediaItem = this.hasPreviousMediaItem();
        if (this.isCurrentMediaItemLive() && !this.isCurrentMediaItemSeekable()) {
            if (hasPreviousMediaItem) {
                this.seekToPreviousMediaItemInternal(7);
            }
        } else if (hasPreviousMediaItem && this.getCurrentPosition() <= this.getMaxSeekToPreviousPosition()) {
            this.seekToPreviousMediaItemInternal(7);
        } else {
            this.seekToCurrentItem(0L, 7);
        }
    }

    @Override
    @Deprecated
    public final boolean hasNext() {
        return this.hasNextMediaItem();
    }

    @Override
    @Deprecated
    public final boolean hasNextWindow() {
        return this.hasNextMediaItem();
    }

    @Override
    public final boolean hasNextMediaItem() {
        return this.getNextMediaItemIndex() != -1;
    }

    @Override
    @Deprecated
    public final void next() {
        this.seekToNextMediaItem();
    }

    @Override
    @Deprecated
    public final void seekToNextWindow() {
        this.seekToNextMediaItem();
    }

    @Override
    public final void seekToNextMediaItem() {
        this.seekToNextMediaItemInternal(8);
    }

    @Override
    public final void seekToNext() {
        Timeline timeline = this.getCurrentTimeline();
        if (timeline.isEmpty() || this.isPlayingAd()) {
            return;
        }
        if (this.hasNextMediaItem()) {
            this.seekToNextMediaItemInternal(9);
        } else if (this.isCurrentMediaItemLive() && this.isCurrentMediaItemDynamic()) {
            this.seekToDefaultPositionInternal(this.getCurrentMediaItemIndex(), 9);
        }
    }

    @Override
    public final void seekTo(long positionMs) {
        this.seekToCurrentItem(positionMs, 5);
    }

    @Override
    public final void seekTo(int mediaItemIndex, long positionMs) {
        this.seekTo(mediaItemIndex, positionMs, 10, false);
    }

    @VisibleForTesting(otherwise=4)
    public abstract void seekTo(int var1, long var2, int var4, boolean var5);

    @Override
    public final void setPlaybackSpeed(float speed) {
        this.setPlaybackParameters(this.getPlaybackParameters().withSpeed(speed));
    }

    @Override
    @Deprecated
    public final int getCurrentWindowIndex() {
        return this.getCurrentMediaItemIndex();
    }

    @Override
    @Deprecated
    public final int getNextWindowIndex() {
        return this.getNextMediaItemIndex();
    }

    @Override
    public final int getNextMediaItemIndex() {
        Timeline timeline = this.getCurrentTimeline();
        return timeline.isEmpty() ? -1 : timeline.getNextWindowIndex(this.getCurrentMediaItemIndex(), this.getRepeatModeForNavigation(), this.getShuffleModeEnabled());
    }

    @Override
    @Deprecated
    public final int getPreviousWindowIndex() {
        return this.getPreviousMediaItemIndex();
    }

    @Override
    public final int getPreviousMediaItemIndex() {
        Timeline timeline = this.getCurrentTimeline();
        return timeline.isEmpty() ? -1 : timeline.getPreviousWindowIndex(this.getCurrentMediaItemIndex(), this.getRepeatModeForNavigation(), this.getShuffleModeEnabled());
    }

    @Override
    @Nullable
    public final MediaItem getCurrentMediaItem() {
        Timeline timeline = this.getCurrentTimeline();
        return timeline.isEmpty() ? null : timeline.getWindow((int)this.getCurrentMediaItemIndex(), (Timeline.Window)this.window).mediaItem;
    }

    @Override
    public final int getMediaItemCount() {
        return this.getCurrentTimeline().getWindowCount();
    }

    @Override
    public final MediaItem getMediaItemAt(int index) {
        return this.getCurrentTimeline().getWindow((int)index, (Timeline.Window)this.window).mediaItem;
    }

    @Override
    @Nullable
    public final Object getCurrentManifest() {
        Timeline timeline = this.getCurrentTimeline();
        return timeline.isEmpty() ? null : timeline.getWindow((int)this.getCurrentMediaItemIndex(), (Timeline.Window)this.window).manifest;
    }

    @Override
    public final int getBufferedPercentage() {
        long position = this.getBufferedPosition();
        long duration = this.getDuration();
        return position == -9223372036854775807L || duration == -9223372036854775807L ? 0 : (duration == 0L ? 100 : Util.constrainValue((int)(position * 100L / duration), 0, 100));
    }

    @Override
    @Deprecated
    public final boolean isCurrentWindowDynamic() {
        return this.isCurrentMediaItemDynamic();
    }

    @Override
    public final boolean isCurrentMediaItemDynamic() {
        Timeline timeline = this.getCurrentTimeline();
        return !timeline.isEmpty() && timeline.getWindow((int)this.getCurrentMediaItemIndex(), (Timeline.Window)this.window).isDynamic;
    }

    @Override
    @Deprecated
    public final boolean isCurrentWindowLive() {
        return this.isCurrentMediaItemLive();
    }

    @Override
    public final boolean isCurrentMediaItemLive() {
        Timeline timeline = this.getCurrentTimeline();
        return !timeline.isEmpty() && timeline.getWindow(this.getCurrentMediaItemIndex(), this.window).isLive();
    }

    @Override
    public final long getCurrentLiveOffset() {
        Timeline timeline = this.getCurrentTimeline();
        if (timeline.isEmpty()) {
            return -9223372036854775807L;
        }
        long windowStartTimeMs = timeline.getWindow((int)this.getCurrentMediaItemIndex(), (Timeline.Window)this.window).windowStartTimeMs;
        if (windowStartTimeMs == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        return this.window.getCurrentUnixTimeMs() - this.window.windowStartTimeMs - this.getContentPosition();
    }

    @Override
    @Deprecated
    public final boolean isCurrentWindowSeekable() {
        return this.isCurrentMediaItemSeekable();
    }

    @Override
    public final boolean isCurrentMediaItemSeekable() {
        Timeline timeline = this.getCurrentTimeline();
        return !timeline.isEmpty() && timeline.getWindow((int)this.getCurrentMediaItemIndex(), (Timeline.Window)this.window).isSeekable;
    }

    @Override
    public final long getContentDuration() {
        Timeline timeline = this.getCurrentTimeline();
        return timeline.isEmpty() ? -9223372036854775807L : timeline.getWindow(this.getCurrentMediaItemIndex(), this.window).getDurationMs();
    }

    private int getRepeatModeForNavigation() {
        int repeatMode = this.getRepeatMode();
        return repeatMode == 1 ? 0 : repeatMode;
    }

    private void seekToCurrentItem(long positionMs, int seekCommand) {
        this.seekTo(this.getCurrentMediaItemIndex(), positionMs, seekCommand, false);
    }

    private void seekToOffset(long offsetMs, int seekCommand) {
        long positionMs = this.getCurrentPosition() + offsetMs;
        long durationMs = this.getDuration();
        if (durationMs != -9223372036854775807L) {
            positionMs = Math.min(positionMs, durationMs);
        }
        positionMs = Math.max(positionMs, 0L);
        this.seekToCurrentItem(positionMs, seekCommand);
    }

    private void seekToDefaultPositionInternal(int mediaItemIndex, int seekCommand) {
        this.seekTo(mediaItemIndex, -9223372036854775807L, seekCommand, false);
    }

    private void seekToNextMediaItemInternal(int seekCommand) {
        int nextMediaItemIndex = this.getNextMediaItemIndex();
        if (nextMediaItemIndex == -1) {
            return;
        }
        if (nextMediaItemIndex == this.getCurrentMediaItemIndex()) {
            this.repeatCurrentMediaItem(seekCommand);
        } else {
            this.seekToDefaultPositionInternal(nextMediaItemIndex, seekCommand);
        }
    }

    private void seekToPreviousMediaItemInternal(int seekCommand) {
        int previousMediaItemIndex = this.getPreviousMediaItemIndex();
        if (previousMediaItemIndex == -1) {
            return;
        }
        if (previousMediaItemIndex == this.getCurrentMediaItemIndex()) {
            this.repeatCurrentMediaItem(seekCommand);
        } else {
            this.seekToDefaultPositionInternal(previousMediaItemIndex, seekCommand);
        }
    }

    private void repeatCurrentMediaItem(int seekCommand) {
        this.seekTo(this.getCurrentMediaItemIndex(), -9223372036854775807L, seekCommand, true);
    }
}

