/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.text;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.Layout;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextUtils;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.base.Objects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.checkerframework.dataflow.qual.Pure;

public final class Cue
implements Bundleable {
    public static final Cue EMPTY = new Builder().setText("").build();
    public static final float DIMEN_UNSET = -3.4028235E38f;
    public static final int TYPE_UNSET = Integer.MIN_VALUE;
    public static final int ANCHOR_TYPE_START = 0;
    public static final int ANCHOR_TYPE_MIDDLE = 1;
    public static final int ANCHOR_TYPE_END = 2;
    public static final int LINE_TYPE_FRACTION = 0;
    public static final int LINE_TYPE_NUMBER = 1;
    public static final int TEXT_SIZE_TYPE_FRACTIONAL = 0;
    public static final int TEXT_SIZE_TYPE_FRACTIONAL_IGNORE_PADDING = 1;
    public static final int TEXT_SIZE_TYPE_ABSOLUTE = 2;
    public static final int VERTICAL_TYPE_RL = 1;
    public static final int VERTICAL_TYPE_LR = 2;
    @Nullable
    public final CharSequence text;
    @Nullable
    public final Layout.Alignment textAlignment;
    @Nullable
    public final Layout.Alignment multiRowAlignment;
    @Nullable
    public final Bitmap bitmap;
    public final float line;
    public final int lineType;
    public final int lineAnchor;
    public final float position;
    public final int positionAnchor;
    public final float size;
    public final float bitmapHeight;
    public final boolean windowColorSet;
    public final int windowColor;
    public final int textSizeType;
    public final float textSize;
    public final int verticalType;
    public final float shearDegrees;
    private static final String FIELD_TEXT = Util.intToStringMaxRadix(0);
    private static final String FIELD_TEXT_ALIGNMENT = Util.intToStringMaxRadix(1);
    private static final String FIELD_MULTI_ROW_ALIGNMENT = Util.intToStringMaxRadix(2);
    private static final String FIELD_BITMAP = Util.intToStringMaxRadix(3);
    private static final String FIELD_LINE = Util.intToStringMaxRadix(4);
    private static final String FIELD_LINE_TYPE = Util.intToStringMaxRadix(5);
    private static final String FIELD_LINE_ANCHOR = Util.intToStringMaxRadix(6);
    private static final String FIELD_POSITION = Util.intToStringMaxRadix(7);
    private static final String FIELD_POSITION_ANCHOR = Util.intToStringMaxRadix(8);
    private static final String FIELD_TEXT_SIZE_TYPE = Util.intToStringMaxRadix(9);
    private static final String FIELD_TEXT_SIZE = Util.intToStringMaxRadix(10);
    private static final String FIELD_SIZE = Util.intToStringMaxRadix(11);
    private static final String FIELD_BITMAP_HEIGHT = Util.intToStringMaxRadix(12);
    private static final String FIELD_WINDOW_COLOR = Util.intToStringMaxRadix(13);
    private static final String FIELD_WINDOW_COLOR_SET = Util.intToStringMaxRadix(14);
    private static final String FIELD_VERTICAL_TYPE = Util.intToStringMaxRadix(15);
    private static final String FIELD_SHEAR_DEGREES = Util.intToStringMaxRadix(16);
    @UnstableApi
    public static final Bundleable.Creator<Cue> CREATOR = Cue::fromBundle;

    @Deprecated
    @UnstableApi
    public Cue(CharSequence text) {
        this(text, null, -3.4028235E38f, Integer.MIN_VALUE, Integer.MIN_VALUE, -3.4028235E38f, Integer.MIN_VALUE, -3.4028235E38f);
    }

    @Deprecated
    @UnstableApi
    public Cue(CharSequence text, @Nullable Layout.Alignment textAlignment, float line, int lineType, int lineAnchor, float position, int positionAnchor, float size) {
        this(text, textAlignment, line, lineType, lineAnchor, position, positionAnchor, size, false, -16777216);
    }

    @Deprecated
    @UnstableApi
    public Cue(CharSequence text, @Nullable Layout.Alignment textAlignment, float line, int lineType, int lineAnchor, float position, int positionAnchor, float size, int textSizeType, float textSize) {
        this(text, textAlignment, null, null, line, lineType, lineAnchor, position, positionAnchor, textSizeType, textSize, size, -3.4028235E38f, false, -16777216, Integer.MIN_VALUE, 0.0f);
    }

    @Deprecated
    @UnstableApi
    public Cue(CharSequence text, @Nullable Layout.Alignment textAlignment, float line, int lineType, int lineAnchor, float position, int positionAnchor, float size, boolean windowColorSet, int windowColor) {
        this(text, textAlignment, null, null, line, lineType, lineAnchor, position, positionAnchor, Integer.MIN_VALUE, -3.4028235E38f, size, -3.4028235E38f, windowColorSet, windowColor, Integer.MIN_VALUE, 0.0f);
    }

    private Cue(@Nullable CharSequence text, @Nullable Layout.Alignment textAlignment, @Nullable Layout.Alignment multiRowAlignment, @Nullable Bitmap bitmap, float line, int lineType, int lineAnchor, float position, int positionAnchor, int textSizeType, float textSize, float size, float bitmapHeight, boolean windowColorSet, int windowColor, int verticalType, float shearDegrees) {
        if (text == null) {
            Assertions.checkNotNull(bitmap);
        } else {
            Assertions.checkArgument(bitmap == null);
        }
        this.text = text instanceof Spanned ? SpannedString.valueOf((CharSequence)text) : (text != null ? text.toString() : null);
        this.textAlignment = textAlignment;
        this.multiRowAlignment = multiRowAlignment;
        this.bitmap = bitmap;
        this.line = line;
        this.lineType = lineType;
        this.lineAnchor = lineAnchor;
        this.position = position;
        this.positionAnchor = positionAnchor;
        this.size = size;
        this.bitmapHeight = bitmapHeight;
        this.windowColorSet = windowColorSet;
        this.windowColor = windowColor;
        this.textSizeType = textSizeType;
        this.textSize = textSize;
        this.verticalType = verticalType;
        this.shearDegrees = shearDegrees;
    }

    @UnstableApi
    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cue that = (Cue)obj;
        return TextUtils.equals((CharSequence)this.text, (CharSequence)that.text) && this.textAlignment == that.textAlignment && this.multiRowAlignment == that.multiRowAlignment && (this.bitmap == null ? that.bitmap == null : that.bitmap != null && this.bitmap.sameAs(that.bitmap)) && this.line == that.line && this.lineType == that.lineType && this.lineAnchor == that.lineAnchor && this.position == that.position && this.positionAnchor == that.positionAnchor && this.size == that.size && this.bitmapHeight == that.bitmapHeight && this.windowColorSet == that.windowColorSet && this.windowColor == that.windowColor && this.textSizeType == that.textSizeType && this.textSize == that.textSize && this.verticalType == that.verticalType && this.shearDegrees == that.shearDegrees;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.text, this.textAlignment, this.multiRowAlignment, this.bitmap, Float.valueOf(this.line), this.lineType, this.lineAnchor, Float.valueOf(this.position), this.positionAnchor, Float.valueOf(this.size), Float.valueOf(this.bitmapHeight), this.windowColorSet, this.windowColor, this.textSizeType, Float.valueOf(this.textSize), this.verticalType, Float.valueOf(this.shearDegrees)});
    }

    @Override
    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putCharSequence(FIELD_TEXT, this.text);
        bundle.putSerializable(FIELD_TEXT_ALIGNMENT, (Serializable)this.textAlignment);
        bundle.putSerializable(FIELD_MULTI_ROW_ALIGNMENT, (Serializable)this.multiRowAlignment);
        bundle.putParcelable(FIELD_BITMAP, (Parcelable)this.bitmap);
        bundle.putFloat(FIELD_LINE, this.line);
        bundle.putInt(FIELD_LINE_TYPE, this.lineType);
        bundle.putInt(FIELD_LINE_ANCHOR, this.lineAnchor);
        bundle.putFloat(FIELD_POSITION, this.position);
        bundle.putInt(FIELD_POSITION_ANCHOR, this.positionAnchor);
        bundle.putInt(FIELD_TEXT_SIZE_TYPE, this.textSizeType);
        bundle.putFloat(FIELD_TEXT_SIZE, this.textSize);
        bundle.putFloat(FIELD_SIZE, this.size);
        bundle.putFloat(FIELD_BITMAP_HEIGHT, this.bitmapHeight);
        bundle.putBoolean(FIELD_WINDOW_COLOR_SET, this.windowColorSet);
        bundle.putInt(FIELD_WINDOW_COLOR, this.windowColor);
        bundle.putInt(FIELD_VERTICAL_TYPE, this.verticalType);
        bundle.putFloat(FIELD_SHEAR_DEGREES, this.shearDegrees);
        return bundle;
    }

    private static final Cue fromBundle(Bundle bundle) {
        Bitmap bitmap;
        Layout.Alignment multiRowAlignment;
        Layout.Alignment textAlignment;
        Builder builder = new Builder();
        CharSequence text = bundle.getCharSequence(FIELD_TEXT);
        if (text != null) {
            builder.setText(text);
        }
        if ((textAlignment = (Layout.Alignment)bundle.getSerializable(FIELD_TEXT_ALIGNMENT)) != null) {
            builder.setTextAlignment(textAlignment);
        }
        if ((multiRowAlignment = (Layout.Alignment)bundle.getSerializable(FIELD_MULTI_ROW_ALIGNMENT)) != null) {
            builder.setMultiRowAlignment(multiRowAlignment);
        }
        if ((bitmap = (Bitmap)bundle.getParcelable(FIELD_BITMAP)) != null) {
            builder.setBitmap(bitmap);
        }
        if (bundle.containsKey(FIELD_LINE) && bundle.containsKey(FIELD_LINE_TYPE)) {
            builder.setLine(bundle.getFloat(FIELD_LINE), bundle.getInt(FIELD_LINE_TYPE));
        }
        if (bundle.containsKey(FIELD_LINE_ANCHOR)) {
            builder.setLineAnchor(bundle.getInt(FIELD_LINE_ANCHOR));
        }
        if (bundle.containsKey(FIELD_POSITION)) {
            builder.setPosition(bundle.getFloat(FIELD_POSITION));
        }
        if (bundle.containsKey(FIELD_POSITION_ANCHOR)) {
            builder.setPositionAnchor(bundle.getInt(FIELD_POSITION_ANCHOR));
        }
        if (bundle.containsKey(FIELD_TEXT_SIZE) && bundle.containsKey(FIELD_TEXT_SIZE_TYPE)) {
            builder.setTextSize(bundle.getFloat(FIELD_TEXT_SIZE), bundle.getInt(FIELD_TEXT_SIZE_TYPE));
        }
        if (bundle.containsKey(FIELD_SIZE)) {
            builder.setSize(bundle.getFloat(FIELD_SIZE));
        }
        if (bundle.containsKey(FIELD_BITMAP_HEIGHT)) {
            builder.setBitmapHeight(bundle.getFloat(FIELD_BITMAP_HEIGHT));
        }
        if (bundle.containsKey(FIELD_WINDOW_COLOR)) {
            builder.setWindowColor(bundle.getInt(FIELD_WINDOW_COLOR));
        }
        if (!bundle.getBoolean(FIELD_WINDOW_COLOR_SET, false)) {
            builder.clearWindowColor();
        }
        if (bundle.containsKey(FIELD_VERTICAL_TYPE)) {
            builder.setVerticalType(bundle.getInt(FIELD_VERTICAL_TYPE));
        }
        if (bundle.containsKey(FIELD_SHEAR_DEGREES)) {
            builder.setShearDegrees(bundle.getFloat(FIELD_SHEAR_DEGREES));
        }
        return builder.build();
    }

    @UnstableApi
    public static final class Builder {
        @Nullable
        private CharSequence text;
        @Nullable
        private Bitmap bitmap;
        @Nullable
        private Layout.Alignment textAlignment;
        @Nullable
        private Layout.Alignment multiRowAlignment;
        private float line;
        private int lineType;
        private int lineAnchor;
        private float position;
        private int positionAnchor;
        private int textSizeType;
        private float textSize;
        private float size;
        private float bitmapHeight;
        private boolean windowColorSet;
        @ColorInt
        private int windowColor;
        private int verticalType;
        private float shearDegrees;

        public Builder() {
            this.text = null;
            this.bitmap = null;
            this.textAlignment = null;
            this.multiRowAlignment = null;
            this.line = -3.4028235E38f;
            this.lineType = Integer.MIN_VALUE;
            this.lineAnchor = Integer.MIN_VALUE;
            this.position = -3.4028235E38f;
            this.positionAnchor = Integer.MIN_VALUE;
            this.textSizeType = Integer.MIN_VALUE;
            this.textSize = -3.4028235E38f;
            this.size = -3.4028235E38f;
            this.bitmapHeight = -3.4028235E38f;
            this.windowColorSet = false;
            this.windowColor = -16777216;
            this.verticalType = Integer.MIN_VALUE;
        }

        private Builder(Cue cue) {
            this.text = cue.text;
            this.bitmap = cue.bitmap;
            this.textAlignment = cue.textAlignment;
            this.multiRowAlignment = cue.multiRowAlignment;
            this.line = cue.line;
            this.lineType = cue.lineType;
            this.lineAnchor = cue.lineAnchor;
            this.position = cue.position;
            this.positionAnchor = cue.positionAnchor;
            this.textSizeType = cue.textSizeType;
            this.textSize = cue.textSize;
            this.size = cue.size;
            this.bitmapHeight = cue.bitmapHeight;
            this.windowColorSet = cue.windowColorSet;
            this.windowColor = cue.windowColor;
            this.verticalType = cue.verticalType;
            this.shearDegrees = cue.shearDegrees;
        }

        @CanIgnoreReturnValue
        public Builder setText(CharSequence text) {
            this.text = text;
            return this;
        }

        @Pure
        @Nullable
        public CharSequence getText() {
            return this.text;
        }

        @CanIgnoreReturnValue
        public Builder setBitmap(Bitmap bitmap) {
            this.bitmap = bitmap;
            return this;
        }

        @Pure
        @Nullable
        public Bitmap getBitmap() {
            return this.bitmap;
        }

        @CanIgnoreReturnValue
        public Builder setTextAlignment(@Nullable Layout.Alignment textAlignment) {
            this.textAlignment = textAlignment;
            return this;
        }

        @Pure
        @Nullable
        public Layout.Alignment getTextAlignment() {
            return this.textAlignment;
        }

        @CanIgnoreReturnValue
        public Builder setMultiRowAlignment(@Nullable Layout.Alignment multiRowAlignment) {
            this.multiRowAlignment = multiRowAlignment;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLine(float line, int lineType) {
            this.line = line;
            this.lineType = lineType;
            return this;
        }

        @Pure
        public float getLine() {
            return this.line;
        }

        @Pure
        public int getLineType() {
            return this.lineType;
        }

        @CanIgnoreReturnValue
        public Builder setLineAnchor(int lineAnchor) {
            this.lineAnchor = lineAnchor;
            return this;
        }

        @Pure
        public int getLineAnchor() {
            return this.lineAnchor;
        }

        @CanIgnoreReturnValue
        public Builder setPosition(float position) {
            this.position = position;
            return this;
        }

        @Pure
        public float getPosition() {
            return this.position;
        }

        @CanIgnoreReturnValue
        public Builder setPositionAnchor(int positionAnchor) {
            this.positionAnchor = positionAnchor;
            return this;
        }

        @Pure
        public int getPositionAnchor() {
            return this.positionAnchor;
        }

        @CanIgnoreReturnValue
        public Builder setTextSize(float textSize, int textSizeType) {
            this.textSize = textSize;
            this.textSizeType = textSizeType;
            return this;
        }

        @Pure
        public int getTextSizeType() {
            return this.textSizeType;
        }

        @Pure
        public float getTextSize() {
            return this.textSize;
        }

        @CanIgnoreReturnValue
        public Builder setSize(float size) {
            this.size = size;
            return this;
        }

        @Pure
        public float getSize() {
            return this.size;
        }

        @CanIgnoreReturnValue
        public Builder setBitmapHeight(float bitmapHeight) {
            this.bitmapHeight = bitmapHeight;
            return this;
        }

        @Pure
        public float getBitmapHeight() {
            return this.bitmapHeight;
        }

        @CanIgnoreReturnValue
        public Builder setWindowColor(@ColorInt int windowColor) {
            this.windowColor = windowColor;
            this.windowColorSet = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clearWindowColor() {
            this.windowColorSet = false;
            return this;
        }

        public boolean isWindowColorSet() {
            return this.windowColorSet;
        }

        @Pure
        @ColorInt
        public int getWindowColor() {
            return this.windowColor;
        }

        @CanIgnoreReturnValue
        public Builder setVerticalType(int verticalType) {
            this.verticalType = verticalType;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setShearDegrees(float shearDegrees) {
            this.shearDegrees = shearDegrees;
            return this;
        }

        @Pure
        public int getVerticalType() {
            return this.verticalType;
        }

        public Cue build() {
            return new Cue(this.text, this.textAlignment, this.multiRowAlignment, this.bitmap, this.line, this.lineType, this.lineAnchor, this.position, this.positionAnchor, this.textSizeType, this.textSize, this.size, this.bitmapHeight, this.windowColorSet, this.windowColor, this.verticalType, this.shearDegrees);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface VerticalType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface TextSizeType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface LineType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface AnchorType {
    }
}

