/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.media.AudioAttributes;
import android.os.Bundle;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.Bundleable;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

public final class AudioAttributes
implements Bundleable {
    public static final AudioAttributes DEFAULT = new Builder().build();
    public final int contentType;
    public final int flags;
    public final int usage;
    public final int allowedCapturePolicy;
    public final int spatializationBehavior;
    @Nullable
    private AudioAttributesV21 audioAttributesV21;
    private static final String FIELD_CONTENT_TYPE = Util.intToStringMaxRadix(0);
    private static final String FIELD_FLAGS = Util.intToStringMaxRadix(1);
    private static final String FIELD_USAGE = Util.intToStringMaxRadix(2);
    private static final String FIELD_ALLOWED_CAPTURE_POLICY = Util.intToStringMaxRadix(3);
    private static final String FIELD_SPATIALIZATION_BEHAVIOR = Util.intToStringMaxRadix(4);
    @UnstableApi
    public static final Bundleable.Creator<AudioAttributes> CREATOR = bundle -> {
        Builder builder = new Builder();
        if (bundle.containsKey(FIELD_CONTENT_TYPE)) {
            builder.setContentType(bundle.getInt(FIELD_CONTENT_TYPE));
        }
        if (bundle.containsKey(FIELD_FLAGS)) {
            builder.setFlags(bundle.getInt(FIELD_FLAGS));
        }
        if (bundle.containsKey(FIELD_USAGE)) {
            builder.setUsage(bundle.getInt(FIELD_USAGE));
        }
        if (bundle.containsKey(FIELD_ALLOWED_CAPTURE_POLICY)) {
            builder.setAllowedCapturePolicy(bundle.getInt(FIELD_ALLOWED_CAPTURE_POLICY));
        }
        if (bundle.containsKey(FIELD_SPATIALIZATION_BEHAVIOR)) {
            builder.setSpatializationBehavior(bundle.getInt(FIELD_SPATIALIZATION_BEHAVIOR));
        }
        return builder.build();
    };

    private AudioAttributes(int contentType, int flags, int usage, int allowedCapturePolicy, int spatializationBehavior) {
        this.contentType = contentType;
        this.flags = flags;
        this.usage = usage;
        this.allowedCapturePolicy = allowedCapturePolicy;
        this.spatializationBehavior = spatializationBehavior;
    }

    @RequiresApi(value=21)
    public AudioAttributesV21 getAudioAttributesV21() {
        if (this.audioAttributesV21 == null) {
            this.audioAttributesV21 = new AudioAttributesV21(this);
        }
        return this.audioAttributesV21;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AudioAttributes other = (AudioAttributes)obj;
        return this.contentType == other.contentType && this.flags == other.flags && this.usage == other.usage && this.allowedCapturePolicy == other.allowedCapturePolicy && this.spatializationBehavior == other.spatializationBehavior;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.contentType;
        result = 31 * result + this.flags;
        result = 31 * result + this.usage;
        result = 31 * result + this.allowedCapturePolicy;
        result = 31 * result + this.spatializationBehavior;
        return result;
    }

    @Override
    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(FIELD_CONTENT_TYPE, this.contentType);
        bundle.putInt(FIELD_FLAGS, this.flags);
        bundle.putInt(FIELD_USAGE, this.usage);
        bundle.putInt(FIELD_ALLOWED_CAPTURE_POLICY, this.allowedCapturePolicy);
        bundle.putInt(FIELD_SPATIALIZATION_BEHAVIOR, this.spatializationBehavior);
        return bundle;
    }

    @RequiresApi(value=21)
    public static final class AudioAttributesV21 {
        public final android.media.AudioAttributes audioAttributes;

        private AudioAttributesV21(AudioAttributes audioAttributes) {
            AudioAttributes.Builder builder = new AudioAttributes.Builder().setContentType(audioAttributes.contentType).setFlags(audioAttributes.flags).setUsage(audioAttributes.usage);
            if (Util.SDK_INT >= 29) {
                Api29.setAllowedCapturePolicy(builder, audioAttributes.allowedCapturePolicy);
            }
            if (Util.SDK_INT >= 32) {
                Api32.setSpatializationBehavior(builder, audioAttributes.spatializationBehavior);
            }
            this.audioAttributes = builder.build();
        }
    }

    public static final class Builder {
        private int contentType = 0;
        private int flags = 0;
        private int usage = 1;
        private int allowedCapturePolicy = 1;
        private int spatializationBehavior = 0;

        @CanIgnoreReturnValue
        public Builder setContentType(int contentType) {
            this.contentType = contentType;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFlags(int flags) {
            this.flags = flags;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUsage(int usage) {
            this.usage = usage;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAllowedCapturePolicy(int allowedCapturePolicy) {
            this.allowedCapturePolicy = allowedCapturePolicy;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSpatializationBehavior(int spatializationBehavior) {
            this.spatializationBehavior = spatializationBehavior;
            return this;
        }

        public AudioAttributes build() {
            return new AudioAttributes(this.contentType, this.flags, this.usage, this.allowedCapturePolicy, this.spatializationBehavior);
        }
    }

    @RequiresApi(value=32)
    private static final class Api32 {
        private Api32() {
        }

        @DoNotInline
        public static void setSpatializationBehavior(AudioAttributes.Builder builder, int spatializationBehavior) {
            builder.setSpatializationBehavior(spatializationBehavior);
        }
    }

    @RequiresApi(value=29)
    private static final class Api29 {
        private Api29() {
        }

        @DoNotInline
        public static void setAllowedCapturePolicy(AudioAttributes.Builder builder, int allowedCapturePolicy) {
            builder.setAllowedCapturePolicy(allowedCapturePolicy);
        }
    }
}

