/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public final class DeviceInfo
implements Bundleable {
    public static final int PLAYBACK_TYPE_LOCAL = 0;
    public static final int PLAYBACK_TYPE_REMOTE = 1;
    public static final DeviceInfo UNKNOWN = new Builder(0).build();
    public final int playbackType;
    @IntRange(from=0L)
    public final int minVolume;
    @IntRange(from=0L)
    public final int maxVolume;
    @Nullable
    public final String routingControllerId;
    private static final String FIELD_PLAYBACK_TYPE = Util.intToStringMaxRadix(0);
    private static final String FIELD_MIN_VOLUME = Util.intToStringMaxRadix(1);
    private static final String FIELD_MAX_VOLUME = Util.intToStringMaxRadix(2);
    private static final String FIELD_ROUTING_CONTROLLER_ID = Util.intToStringMaxRadix(3);
    @UnstableApi
    public static final Bundleable.Creator<DeviceInfo> CREATOR = bundle -> {
        int playbackType = bundle.getInt(FIELD_PLAYBACK_TYPE, 0);
        int minVolume = bundle.getInt(FIELD_MIN_VOLUME, 0);
        int maxVolume = bundle.getInt(FIELD_MAX_VOLUME, 0);
        String routingControllerId = bundle.getString(FIELD_ROUTING_CONTROLLER_ID);
        return new Builder(playbackType).setMinVolume(minVolume).setMaxVolume(maxVolume).setRoutingControllerId(routingControllerId).build();
    };

    @Deprecated
    @UnstableApi
    public DeviceInfo(int playbackType, @IntRange(from=0L) int minVolume, @IntRange(from=0L) int maxVolume) {
        this(new Builder(playbackType).setMinVolume(minVolume).setMaxVolume(maxVolume));
    }

    private DeviceInfo(Builder builder) {
        this.playbackType = builder.playbackType;
        this.minVolume = builder.minVolume;
        this.maxVolume = builder.maxVolume;
        this.routingControllerId = builder.routingControllerId;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeviceInfo)) {
            return false;
        }
        DeviceInfo other = (DeviceInfo)obj;
        return this.playbackType == other.playbackType && this.minVolume == other.minVolume && this.maxVolume == other.maxVolume && Util.areEqual(this.routingControllerId, other.routingControllerId);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.playbackType;
        result = 31 * result + this.minVolume;
        result = 31 * result + this.maxVolume;
        result = 31 * result + (this.routingControllerId == null ? 0 : this.routingControllerId.hashCode());
        return result;
    }

    @Override
    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        if (this.playbackType != 0) {
            bundle.putInt(FIELD_PLAYBACK_TYPE, this.playbackType);
        }
        if (this.minVolume != 0) {
            bundle.putInt(FIELD_MIN_VOLUME, this.minVolume);
        }
        if (this.maxVolume != 0) {
            bundle.putInt(FIELD_MAX_VOLUME, this.maxVolume);
        }
        if (this.routingControllerId != null) {
            bundle.putString(FIELD_ROUTING_CONTROLLER_ID, this.routingControllerId);
        }
        return bundle;
    }

    public static final class Builder {
        private final int playbackType;
        private int minVolume;
        private int maxVolume;
        @Nullable
        private String routingControllerId;

        public Builder(int playbackType) {
            this.playbackType = playbackType;
        }

        @CanIgnoreReturnValue
        public Builder setMinVolume(@IntRange(from=0L) int minVolume) {
            this.minVolume = minVolume;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxVolume(@IntRange(from=0L) int maxVolume) {
            this.maxVolume = maxVolume;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRoutingControllerId(@Nullable String routingControllerId) {
            Assertions.checkArgument(this.playbackType != 0 || routingControllerId == null);
            this.routingControllerId = routingControllerId;
            return this;
        }

        public DeviceInfo build() {
            Assertions.checkArgument(this.minVolume <= this.maxVolume);
            return new DeviceInfo(this);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface PlaybackType {
    }
}

