/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.PriorityQueue;

@UnstableApi
public final class PriorityTaskManager {
    private final Object lock = new Object();
    private final PriorityQueue<Integer> queue = new PriorityQueue(10, Collections.reverseOrder());
    private int highestPriority = Integer.MIN_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int priority) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add(priority);
            this.highestPriority = Math.max(this.highestPriority, priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proceed(int priority) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.highestPriority != priority) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean proceedNonBlocking(int priority) {
        Object object = this.lock;
        synchronized (object) {
            return this.highestPriority == priority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proceedOrThrow(int priority) throws PriorityTooLowException {
        Object object = this.lock;
        synchronized (object) {
            if (this.highestPriority != priority) {
                throw new PriorityTooLowException(priority, this.highestPriority);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int priority) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.remove(priority);
            this.highestPriority = this.queue.isEmpty() ? Integer.MIN_VALUE : Util.castNonNull(this.queue.peek());
            this.lock.notifyAll();
        }
    }

    public static class PriorityTooLowException
    extends IOException {
        public PriorityTooLowException(int priority, int highestPriority) {
            super("Priority too low [priority=" + priority + ", highest=" + highestPriority + "]");
        }
    }
}

