/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;

@UnstableApi
public class Label {
    @Nullable
    public final String language;
    public final String value;
    private static final String FIELD_LANGUAGE_INDEX = Util.intToStringMaxRadix(0);
    private static final String FIELD_VALUE_INDEX = Util.intToStringMaxRadix(1);

    public Label(@Nullable String language, String value) {
        this.language = Util.normalizeLanguageCode(language);
        this.value = value;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Label label = (Label)o;
        return Util.areEqual(this.language, label.language) && Util.areEqual(this.value, label.value);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        return result;
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        if (this.language != null) {
            bundle.putString(FIELD_LANGUAGE_INDEX, this.language);
        }
        bundle.putString(FIELD_VALUE_INDEX, this.value);
        return bundle;
    }

    public static Label fromBundle(Bundle bundle) {
        return new Label(bundle.getString(FIELD_LANGUAGE_INDEX), Assertions.checkNotNull(bundle.getString(FIELD_VALUE_INDEX)));
    }
}

