/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.TimestampIterator;
import androidx.media3.common.util.UnstableApi;

@UnstableApi
public final class ConstantRateTimestampIterator
implements TimestampIterator {
    private final float frameRate;
    private final double framesDurationUs;
    private final int totalNumberOfFramesToAdd;
    private final long startPositionUs;
    private final long endPositionUs;
    private int framesAdded;

    public ConstantRateTimestampIterator(@IntRange(from=1L) long durationUs, @FloatRange(from=0.0, fromInclusive=false) float frameRate) {
        this(0L, durationUs, frameRate);
    }

    public ConstantRateTimestampIterator(@IntRange(from=0L) long startPositionUs, @IntRange(from=1L) long endPositionUs, @FloatRange(from=0.0, fromInclusive=false) float frameRate) {
        Assertions.checkArgument(endPositionUs > 0L);
        Assertions.checkArgument(frameRate > 0.0f);
        Assertions.checkArgument(0L <= startPositionUs && startPositionUs < endPositionUs);
        this.startPositionUs = startPositionUs;
        this.endPositionUs = endPositionUs;
        this.frameRate = frameRate;
        float durationSecs = (float)(endPositionUs - startPositionUs) / 1000000.0f;
        this.totalNumberOfFramesToAdd = Math.round(frameRate * durationSecs);
        this.framesDurationUs = 1000000.0f / frameRate;
    }

    @Override
    public boolean hasNext() {
        return this.framesAdded < this.totalNumberOfFramesToAdd;
    }

    @Override
    public long next() {
        Assertions.checkState(this.hasNext());
        return this.getTimestampUsAfter(this.framesAdded++);
    }

    @Override
    public ConstantRateTimestampIterator copyOf() {
        return new ConstantRateTimestampIterator(this.startPositionUs, this.endPositionUs, this.frameRate);
    }

    @Override
    public long getLastTimestampUs() {
        if (this.totalNumberOfFramesToAdd == 0) {
            return -9223372036854775807L;
        }
        return this.getTimestampUsAfter(this.totalNumberOfFramesToAdd - 1);
    }

    private long getTimestampUsAfter(int numberOfFrames) {
        long timestampUs = this.startPositionUs + Math.round(this.framesDurationUs * (double)numberOfFrames);
        Assertions.checkState(timestampUs >= 0L);
        return timestampUs;
    }
}

