/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import android.os.SystemClock;
import androidx.annotation.GuardedBy;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import java.util.concurrent.TimeoutException;

@UnstableApi
public final class TimestampAdjuster {
    public static final long MODE_NO_OFFSET = Long.MAX_VALUE;
    public static final long MODE_SHARED = 0x7FFFFFFFFFFFFFFEL;
    private static final long MAX_PTS_PLUS_ONE = 0x200000000L;
    @GuardedBy(value="this")
    private long firstSampleTimestampUs;
    @GuardedBy(value="this")
    private long timestampOffsetUs;
    @GuardedBy(value="this")
    private long lastUnadjustedTimestampUs;
    private final ThreadLocal<Long> nextSampleTimestampUs = new ThreadLocal();

    public TimestampAdjuster(long firstSampleTimestampUs) {
        this.reset(firstSampleTimestampUs);
    }

    public synchronized void sharedInitializeOrWait(boolean canInitialize, long nextSampleTimestampUs, long timeoutMs) throws InterruptedException, TimeoutException {
        Assertions.checkState(this.firstSampleTimestampUs == 0x7FFFFFFFFFFFFFFEL);
        if (this.isInitialized()) {
            return;
        }
        if (canInitialize) {
            this.nextSampleTimestampUs.set(nextSampleTimestampUs);
        } else {
            long totalWaitDurationMs = 0L;
            long remainingTimeoutMs = timeoutMs;
            while (!this.isInitialized()) {
                if (timeoutMs == 0L) {
                    this.wait();
                    continue;
                }
                Assertions.checkState(remainingTimeoutMs > 0L);
                long waitStartingTimeMs = SystemClock.elapsedRealtime();
                this.wait(remainingTimeoutMs);
                if ((totalWaitDurationMs += SystemClock.elapsedRealtime() - waitStartingTimeMs) >= timeoutMs && !this.isInitialized()) {
                    String message = "TimestampAdjuster failed to initialize in " + timeoutMs + " milliseconds";
                    throw new TimeoutException(message);
                }
                remainingTimeoutMs = timeoutMs - totalWaitDurationMs;
            }
        }
    }

    public synchronized long getFirstSampleTimestampUs() {
        return this.firstSampleTimestampUs == Long.MAX_VALUE || this.firstSampleTimestampUs == 0x7FFFFFFFFFFFFFFEL ? -9223372036854775807L : this.firstSampleTimestampUs;
    }

    public synchronized long getLastAdjustedTimestampUs() {
        return this.lastUnadjustedTimestampUs != -9223372036854775807L ? this.lastUnadjustedTimestampUs + this.timestampOffsetUs : this.getFirstSampleTimestampUs();
    }

    public synchronized long getTimestampOffsetUs() {
        return this.timestampOffsetUs;
    }

    public synchronized void reset(long firstSampleTimestampUs) {
        this.firstSampleTimestampUs = firstSampleTimestampUs;
        this.timestampOffsetUs = firstSampleTimestampUs == Long.MAX_VALUE ? 0L : -9223372036854775807L;
        this.lastUnadjustedTimestampUs = -9223372036854775807L;
    }

    public synchronized long adjustTsTimestamp(long pts90Khz) {
        if (pts90Khz == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        if (this.lastUnadjustedTimestampUs != -9223372036854775807L) {
            long lastPts = TimestampAdjuster.usToNonWrappedPts(this.lastUnadjustedTimestampUs);
            long closestWrapCount = (lastPts + 0x100000000L) / 0x200000000L;
            long ptsWrapBelow = pts90Khz + 0x200000000L * (closestWrapCount - 1L);
            long ptsWrapAbove = pts90Khz + 0x200000000L * closestWrapCount;
            pts90Khz = Math.abs(ptsWrapBelow - lastPts) < Math.abs(ptsWrapAbove - lastPts) ? ptsWrapBelow : ptsWrapAbove;
        }
        return this.adjustSampleTimestamp(TimestampAdjuster.ptsToUs(pts90Khz));
    }

    public synchronized long adjustTsTimestampGreaterThanPreviousTimestamp(long pts90Khz) {
        if (pts90Khz == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        if (this.lastUnadjustedTimestampUs != -9223372036854775807L) {
            long lastPts = TimestampAdjuster.usToNonWrappedPts(this.lastUnadjustedTimestampUs);
            long wrapCount = lastPts / 0x200000000L;
            long ptsSameWrap = pts90Khz + 0x200000000L * wrapCount;
            long ptsNextWrap = pts90Khz + 0x200000000L * (wrapCount + 1L);
            pts90Khz = ptsSameWrap >= lastPts ? ptsSameWrap : ptsNextWrap;
        }
        return this.adjustSampleTimestamp(TimestampAdjuster.ptsToUs(pts90Khz));
    }

    public synchronized long adjustSampleTimestamp(long timeUs) {
        if (timeUs == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        if (!this.isInitialized()) {
            long desiredSampleTimestampUs = this.firstSampleTimestampUs == 0x7FFFFFFFFFFFFFFEL ? Assertions.checkNotNull(this.nextSampleTimestampUs.get()) : this.firstSampleTimestampUs;
            this.timestampOffsetUs = desiredSampleTimestampUs - timeUs;
            this.notifyAll();
        }
        this.lastUnadjustedTimestampUs = timeUs;
        return timeUs + this.timestampOffsetUs;
    }

    public synchronized boolean isInitialized() {
        return this.timestampOffsetUs != -9223372036854775807L;
    }

    public static long ptsToUs(long pts) {
        return pts * 1000000L / 90000L;
    }

    public static long usToWrappedPts(long us) {
        return TimestampAdjuster.usToNonWrappedPts(us) % 0x200000000L;
    }

    public static long usToNonWrappedPts(long us) {
        return us * 90000L / 1000000L;
    }
}

