/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.container;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.media3.common.Metadata;
import androidx.media3.common.util.UnstableApi;
import com.google.common.primitives.Longs;

@UnstableApi
public final class Mp4TimestampData
implements Metadata.Entry {
    public static final int TIMESCALE_UNSET = -1;
    private static final int UNIX_EPOCH_TO_MP4_TIME_DELTA_SECONDS = 2082844800;
    public final long creationTimestampSeconds;
    public final long modificationTimestampSeconds;
    public final long timescale;
    public static final Parcelable.Creator<Mp4TimestampData> CREATOR = new Parcelable.Creator<Mp4TimestampData>(){

        public Mp4TimestampData createFromParcel(Parcel in) {
            return new Mp4TimestampData(in);
        }

        public Mp4TimestampData[] newArray(int size) {
            return new Mp4TimestampData[size];
        }
    };

    public Mp4TimestampData(long creationTimestampSeconds, long modificationTimestampSeconds) {
        this.creationTimestampSeconds = creationTimestampSeconds;
        this.modificationTimestampSeconds = modificationTimestampSeconds;
        this.timescale = -1L;
    }

    public Mp4TimestampData(long creationTimestampSeconds, long modificationTimestampSeconds, long timescale) {
        this.creationTimestampSeconds = creationTimestampSeconds;
        this.modificationTimestampSeconds = modificationTimestampSeconds;
        this.timescale = timescale;
    }

    private Mp4TimestampData(Parcel in) {
        this.creationTimestampSeconds = in.readLong();
        this.modificationTimestampSeconds = in.readLong();
        this.timescale = in.readLong();
    }

    public static long unixTimeToMp4TimeSeconds(long unixTimestampMs) {
        return unixTimestampMs / 1000L + 2082844800L;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Mp4TimestampData)) {
            return false;
        }
        Mp4TimestampData other = (Mp4TimestampData)obj;
        return this.creationTimestampSeconds == other.creationTimestampSeconds && this.modificationTimestampSeconds == other.modificationTimestampSeconds && this.timescale == other.timescale;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Longs.hashCode((long)this.creationTimestampSeconds);
        result = 31 * result + Longs.hashCode((long)this.modificationTimestampSeconds);
        result = 31 * result + Longs.hashCode((long)this.timescale);
        return result;
    }

    public String toString() {
        return "Mp4Timestamp: creation time=" + this.creationTimestampSeconds + ", modification time=" + this.modificationTimestampSeconds + ", timescale=" + this.timescale;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.creationTimestampSeconds);
        dest.writeLong(this.modificationTimestampSeconds);
        dest.writeLong(this.timescale);
    }
}

