/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource.cache;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.PriorityTaskManager;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSink;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSourceException;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.FileDataSource;
import androidx.media3.datasource.PlaceholderDataSource;
import androidx.media3.datasource.PriorityDataSource;
import androidx.media3.datasource.TeeDataSource;
import androidx.media3.datasource.TransferListener;
import androidx.media3.datasource.cache.Cache;
import androidx.media3.datasource.cache.CacheDataSink;
import androidx.media3.datasource.cache.CacheKeyFactory;
import androidx.media3.datasource.cache.CacheSpan;
import androidx.media3.datasource.cache.ContentMetadata;
import androidx.media3.datasource.cache.ContentMetadataMutations;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class CacheDataSource
implements DataSource {
    public static final int FLAG_BLOCK_ON_CACHE = 1;
    public static final int FLAG_IGNORE_CACHE_ON_ERROR = 2;
    public static final int FLAG_IGNORE_CACHE_FOR_UNSET_LENGTH_REQUESTS = 4;
    private static final int CACHE_NOT_IGNORED = -1;
    public static final int CACHE_IGNORED_REASON_ERROR = 0;
    public static final int CACHE_IGNORED_REASON_UNSET_LENGTH = 1;
    private static final long MIN_READ_BEFORE_CHECKING_CACHE = 102400L;
    private final Cache cache;
    private final DataSource cacheReadDataSource;
    @Nullable
    private final DataSource cacheWriteDataSource;
    private final DataSource upstreamDataSource;
    private final CacheKeyFactory cacheKeyFactory;
    @Nullable
    private final EventListener eventListener;
    private final boolean blockOnCache;
    private final boolean ignoreCacheOnError;
    private final boolean ignoreCacheForUnsetLengthRequests;
    @Nullable
    private Uri actualUri;
    @Nullable
    private DataSpec requestDataSpec;
    @Nullable
    private DataSpec currentDataSpec;
    @Nullable
    private DataSource currentDataSource;
    private long currentDataSourceBytesRead;
    private long readPosition;
    private long bytesRemaining;
    @Nullable
    private CacheSpan currentHoleSpan;
    private boolean seenCacheError;
    private boolean currentRequestIgnoresCache;
    private long totalCachedBytesRead;
    private long checkCachePosition;

    public CacheDataSource(Cache cache, @Nullable DataSource upstreamDataSource) {
        this(cache, upstreamDataSource, 0);
    }

    public CacheDataSource(Cache cache, @Nullable DataSource upstreamDataSource, int flags) {
        this(cache, upstreamDataSource, new FileDataSource(), new CacheDataSink(cache, 0x500000L), flags, null);
    }

    public CacheDataSource(Cache cache, @Nullable DataSource upstreamDataSource, DataSource cacheReadDataSource, @Nullable DataSink cacheWriteDataSink, int flags, @Nullable EventListener eventListener) {
        this(cache, upstreamDataSource, cacheReadDataSource, cacheWriteDataSink, flags, eventListener, null);
    }

    public CacheDataSource(Cache cache, @Nullable DataSource upstreamDataSource, DataSource cacheReadDataSource, @Nullable DataSink cacheWriteDataSink, int flags, @Nullable EventListener eventListener, @Nullable CacheKeyFactory cacheKeyFactory) {
        this(cache, upstreamDataSource, cacheReadDataSource, cacheWriteDataSink, cacheKeyFactory, flags, null, 0, eventListener);
    }

    private CacheDataSource(Cache cache, @Nullable DataSource upstreamDataSource, DataSource cacheReadDataSource, @Nullable DataSink cacheWriteDataSink, @Nullable CacheKeyFactory cacheKeyFactory, int flags, @Nullable PriorityTaskManager upstreamPriorityTaskManager, int upstreamPriority, @Nullable EventListener eventListener) {
        this.cache = cache;
        this.cacheReadDataSource = cacheReadDataSource;
        this.cacheKeyFactory = cacheKeyFactory != null ? cacheKeyFactory : CacheKeyFactory.DEFAULT;
        this.blockOnCache = (flags & 1) != 0;
        this.ignoreCacheOnError = (flags & 2) != 0;
        boolean bl = this.ignoreCacheForUnsetLengthRequests = (flags & 4) != 0;
        if (upstreamDataSource != null) {
            if (upstreamPriorityTaskManager != null) {
                upstreamDataSource = new PriorityDataSource(upstreamDataSource, upstreamPriorityTaskManager, upstreamPriority);
            }
            this.upstreamDataSource = upstreamDataSource;
            this.cacheWriteDataSource = cacheWriteDataSink != null ? new TeeDataSource(upstreamDataSource, cacheWriteDataSink) : null;
        } else {
            this.upstreamDataSource = PlaceholderDataSource.INSTANCE;
            this.cacheWriteDataSource = null;
        }
        this.eventListener = eventListener;
    }

    public Cache getCache() {
        return this.cache;
    }

    public CacheKeyFactory getCacheKeyFactory() {
        return this.cacheKeyFactory;
    }

    @Override
    public void addTransferListener(TransferListener transferListener) {
        Assertions.checkNotNull((Object)transferListener);
        this.cacheReadDataSource.addTransferListener(transferListener);
        this.upstreamDataSource.addTransferListener(transferListener);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        try {
            DataSpec requestDataSpec;
            String key = this.cacheKeyFactory.buildCacheKey(dataSpec);
            this.requestDataSpec = requestDataSpec = dataSpec.buildUpon().setKey(key).build();
            this.actualUri = CacheDataSource.getRedirectedUriOrDefault(this.cache, key, requestDataSpec.uri);
            this.readPosition = dataSpec.position;
            int reason = this.shouldIgnoreCacheForRequest(dataSpec);
            boolean bl = this.currentRequestIgnoresCache = reason != -1;
            if (this.currentRequestIgnoresCache) {
                this.notifyCacheIgnored(reason);
            }
            if (this.currentRequestIgnoresCache) {
                this.bytesRemaining = -1L;
            } else {
                this.bytesRemaining = ContentMetadata.getContentLength(this.cache.getContentMetadata(key));
                if (this.bytesRemaining != -1L) {
                    this.bytesRemaining -= dataSpec.position;
                    if (this.bytesRemaining < 0L) {
                        throw new DataSourceException(2008);
                    }
                }
            }
            if (dataSpec.length != -1L) {
                long l = this.bytesRemaining = this.bytesRemaining == -1L ? dataSpec.length : Math.min(this.bytesRemaining, dataSpec.length);
            }
            if (this.bytesRemaining > 0L || this.bytesRemaining == -1L) {
                this.openNextSource(requestDataSpec, false);
            }
            return dataSpec.length != -1L ? dataSpec.length : this.bytesRemaining;
        }
        catch (Throwable e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        DataSpec requestDataSpec = (DataSpec)Assertions.checkNotNull((Object)this.requestDataSpec);
        DataSpec currentDataSpec = (DataSpec)Assertions.checkNotNull((Object)this.currentDataSpec);
        try {
            int bytesRead;
            if (this.readPosition >= this.checkCachePosition) {
                this.openNextSource(requestDataSpec, true);
            }
            if ((bytesRead = ((DataSource)Assertions.checkNotNull((Object)this.currentDataSource)).read(buffer, offset, length)) != -1) {
                if (this.isReadingFromCache()) {
                    this.totalCachedBytesRead += (long)bytesRead;
                }
                this.readPosition += (long)bytesRead;
                this.currentDataSourceBytesRead += (long)bytesRead;
                if (this.bytesRemaining != -1L) {
                    this.bytesRemaining -= (long)bytesRead;
                }
            } else if (this.isReadingFromUpstream() && (currentDataSpec.length == -1L || this.currentDataSourceBytesRead < currentDataSpec.length)) {
                this.setNoBytesRemainingAndMaybeStoreLength((String)Util.castNonNull((Object)requestDataSpec.key));
            } else if (this.bytesRemaining > 0L || this.bytesRemaining == -1L) {
                this.closeCurrentSource();
                this.openNextSource(requestDataSpec, false);
                return this.read(buffer, offset, length);
            }
            return bytesRead;
        }
        catch (Throwable e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.actualUri;
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        return this.isReadingFromUpstream() ? this.upstreamDataSource.getResponseHeaders() : Collections.emptyMap();
    }

    @Override
    public void close() throws IOException {
        this.requestDataSpec = null;
        this.actualUri = null;
        this.readPosition = 0L;
        this.notifyBytesRead();
        try {
            this.closeCurrentSource();
        }
        catch (Throwable e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    private void openNextSource(DataSpec requestDataSpec, boolean checkCache) throws IOException {
        DataSpec nextDataSpec;
        DataSource nextDataSource;
        CacheSpan nextSpan;
        String key = (String)Util.castNonNull((Object)requestDataSpec.key);
        if (this.currentRequestIgnoresCache) {
            nextSpan = null;
        } else if (this.blockOnCache) {
            try {
                nextSpan = this.cache.startReadWrite(key, this.readPosition, this.bytesRemaining);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        } else {
            nextSpan = this.cache.startReadWriteNonBlocking(key, this.readPosition, this.bytesRemaining);
        }
        if (nextSpan == null) {
            nextDataSource = this.upstreamDataSource;
            nextDataSpec = requestDataSpec.buildUpon().setPosition(this.readPosition).setLength(this.bytesRemaining).build();
        } else if (nextSpan.isCached) {
            Uri fileUri = Uri.fromFile((File)((File)Util.castNonNull((Object)nextSpan.file)));
            long filePositionOffset = nextSpan.position;
            long positionInFile = this.readPosition - filePositionOffset;
            long length = nextSpan.length - positionInFile;
            if (this.bytesRemaining != -1L) {
                length = Math.min(length, this.bytesRemaining);
            }
            nextDataSpec = requestDataSpec.buildUpon().setUri(fileUri).setUriPositionOffset(filePositionOffset).setPosition(positionInFile).setLength(length).build();
            nextDataSource = this.cacheReadDataSource;
        } else {
            long length;
            if (nextSpan.isOpenEnded()) {
                length = this.bytesRemaining;
            } else {
                length = nextSpan.length;
                if (this.bytesRemaining != -1L) {
                    length = Math.min(length, this.bytesRemaining);
                }
            }
            nextDataSpec = requestDataSpec.buildUpon().setPosition(this.readPosition).setLength(length).build();
            if (this.cacheWriteDataSource != null) {
                nextDataSource = this.cacheWriteDataSource;
            } else {
                nextDataSource = this.upstreamDataSource;
                this.cache.releaseHoleSpan(nextSpan);
                nextSpan = null;
            }
        }
        long l = this.checkCachePosition = !this.currentRequestIgnoresCache && nextDataSource == this.upstreamDataSource ? this.readPosition + 102400L : Long.MAX_VALUE;
        if (checkCache) {
            Assertions.checkState((boolean)this.isBypassingCache());
            if (nextDataSource == this.upstreamDataSource) {
                return;
            }
            try {
                this.closeCurrentSource();
            }
            catch (Throwable e) {
                if (((CacheSpan)Util.castNonNull((Object)nextSpan)).isHoleSpan()) {
                    this.cache.releaseHoleSpan(nextSpan);
                }
                throw e;
            }
        }
        if (nextSpan != null && nextSpan.isHoleSpan()) {
            this.currentHoleSpan = nextSpan;
        }
        this.currentDataSource = nextDataSource;
        this.currentDataSpec = nextDataSpec;
        this.currentDataSourceBytesRead = 0L;
        long resolvedLength = nextDataSource.open(nextDataSpec);
        ContentMetadataMutations mutations = new ContentMetadataMutations();
        if (nextDataSpec.length == -1L && resolvedLength != -1L) {
            this.bytesRemaining = resolvedLength;
            ContentMetadataMutations.setContentLength(mutations, this.readPosition + this.bytesRemaining);
        }
        if (this.isReadingFromUpstream()) {
            this.actualUri = nextDataSource.getUri();
            boolean isRedirected = !requestDataSpec.uri.equals((Object)this.actualUri);
            ContentMetadataMutations.setRedirectedUri(mutations, isRedirected ? this.actualUri : null);
        }
        if (this.isWritingToCache()) {
            this.cache.applyContentMetadataMutations(key, mutations);
        }
    }

    private void setNoBytesRemainingAndMaybeStoreLength(String key) throws IOException {
        this.bytesRemaining = 0L;
        if (this.isWritingToCache()) {
            ContentMetadataMutations mutations = new ContentMetadataMutations();
            ContentMetadataMutations.setContentLength(mutations, this.readPosition);
            this.cache.applyContentMetadataMutations(key, mutations);
        }
    }

    private static Uri getRedirectedUriOrDefault(Cache cache, String key, Uri defaultUri) {
        Uri redirectedUri = ContentMetadata.getRedirectedUri(cache.getContentMetadata(key));
        return redirectedUri != null ? redirectedUri : defaultUri;
    }

    private boolean isReadingFromUpstream() {
        return !this.isReadingFromCache();
    }

    private boolean isBypassingCache() {
        return this.currentDataSource == this.upstreamDataSource;
    }

    private boolean isReadingFromCache() {
        return this.currentDataSource == this.cacheReadDataSource;
    }

    private boolean isWritingToCache() {
        return this.currentDataSource == this.cacheWriteDataSource;
    }

    private void closeCurrentSource() throws IOException {
        if (this.currentDataSource == null) {
            return;
        }
        try {
            this.currentDataSource.close();
        }
        finally {
            this.currentDataSpec = null;
            this.currentDataSource = null;
            if (this.currentHoleSpan != null) {
                this.cache.releaseHoleSpan(this.currentHoleSpan);
                this.currentHoleSpan = null;
            }
        }
    }

    private void handleBeforeThrow(Throwable exception) {
        if (this.isReadingFromCache() || exception instanceof Cache.CacheException) {
            this.seenCacheError = true;
        }
    }

    private int shouldIgnoreCacheForRequest(DataSpec dataSpec) {
        if (this.ignoreCacheOnError && this.seenCacheError) {
            return 0;
        }
        if (this.ignoreCacheForUnsetLengthRequests && dataSpec.length == -1L) {
            return 1;
        }
        return -1;
    }

    private void notifyCacheIgnored(int reason) {
        if (this.eventListener != null) {
            this.eventListener.onCacheIgnored(reason);
        }
    }

    private void notifyBytesRead() {
        if (this.eventListener != null && this.totalCachedBytesRead > 0L) {
            this.eventListener.onCachedBytesRead(this.cache.getCacheSpace(), this.totalCachedBytesRead);
            this.totalCachedBytesRead = 0L;
        }
    }

    public static interface EventListener {
        public void onCachedBytesRead(long var1, long var3);

        public void onCacheIgnored(int var1);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface CacheIgnoredReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Flags {
    }

    public static final class Factory
    implements DataSource.Factory {
        private @MonotonicNonNull Cache cache;
        private DataSource.Factory cacheReadDataSourceFactory = new FileDataSource.Factory();
        @Nullable
        private DataSink.Factory cacheWriteDataSinkFactory;
        private CacheKeyFactory cacheKeyFactory = CacheKeyFactory.DEFAULT;
        private boolean cacheIsReadOnly;
        @Nullable
        private DataSource.Factory upstreamDataSourceFactory;
        @Nullable
        private PriorityTaskManager upstreamPriorityTaskManager;
        private int upstreamPriority;
        private int flags;
        @Nullable
        private EventListener eventListener;

        @CanIgnoreReturnValue
        public Factory setCache(Cache cache) {
            this.cache = cache;
            return this;
        }

        @Nullable
        public Cache getCache() {
            return this.cache;
        }

        @CanIgnoreReturnValue
        public Factory setCacheReadDataSourceFactory(DataSource.Factory cacheReadDataSourceFactory) {
            this.cacheReadDataSourceFactory = cacheReadDataSourceFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setCacheWriteDataSinkFactory(@Nullable DataSink.Factory cacheWriteDataSinkFactory) {
            this.cacheWriteDataSinkFactory = cacheWriteDataSinkFactory;
            this.cacheIsReadOnly = cacheWriteDataSinkFactory == null;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setCacheKeyFactory(CacheKeyFactory cacheKeyFactory) {
            this.cacheKeyFactory = cacheKeyFactory;
            return this;
        }

        public CacheKeyFactory getCacheKeyFactory() {
            return this.cacheKeyFactory;
        }

        @CanIgnoreReturnValue
        public Factory setUpstreamDataSourceFactory(@Nullable DataSource.Factory upstreamDataSourceFactory) {
            this.upstreamDataSourceFactory = upstreamDataSourceFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setUpstreamPriorityTaskManager(@Nullable PriorityTaskManager upstreamPriorityTaskManager) {
            this.upstreamPriorityTaskManager = upstreamPriorityTaskManager;
            return this;
        }

        @Nullable
        public PriorityTaskManager getUpstreamPriorityTaskManager() {
            return this.upstreamPriorityTaskManager;
        }

        @CanIgnoreReturnValue
        public Factory setUpstreamPriority(int upstreamPriority) {
            this.upstreamPriority = upstreamPriority;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setFlags(int flags) {
            this.flags = flags;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setEventListener(@Nullable EventListener eventListener) {
            this.eventListener = eventListener;
            return this;
        }

        @Override
        public CacheDataSource createDataSource() {
            return this.createDataSourceInternal(this.upstreamDataSourceFactory != null ? this.upstreamDataSourceFactory.createDataSource() : null, this.flags, this.upstreamPriority);
        }

        public CacheDataSource createDataSourceForDownloading() {
            return this.createDataSourceInternal(this.upstreamDataSourceFactory != null ? this.upstreamDataSourceFactory.createDataSource() : null, this.flags | 1, -1000);
        }

        public CacheDataSource createDataSourceForRemovingDownload() {
            return this.createDataSourceInternal(null, this.flags | 1, -1000);
        }

        private CacheDataSource createDataSourceInternal(@Nullable DataSource upstreamDataSource, int flags, int upstreamPriority) {
            Cache cache = (Cache)Assertions.checkNotNull((Object)this.cache);
            DataSink cacheWriteDataSink = this.cacheIsReadOnly || upstreamDataSource == null ? null : (this.cacheWriteDataSinkFactory != null ? this.cacheWriteDataSinkFactory.createDataSink() : new CacheDataSink.Factory().setCache(cache).createDataSink());
            return new CacheDataSource(cache, upstreamDataSource, this.cacheReadDataSourceFactory.createDataSource(), cacheWriteDataSink, this.cacheKeyFactory, flags, this.upstreamPriorityTaskManager, upstreamPriority, this.eventListener);
        }
    }
}

