/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.dash.offline;

import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.RunnableFutureTask;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.cache.CacheDataSource;
import androidx.media3.exoplayer.dash.BaseUrlExclusionList;
import androidx.media3.exoplayer.dash.DashSegmentIndex;
import androidx.media3.exoplayer.dash.DashUtil;
import androidx.media3.exoplayer.dash.DashWrappingSegmentIndex;
import androidx.media3.exoplayer.dash.manifest.AdaptationSet;
import androidx.media3.exoplayer.dash.manifest.BaseUrl;
import androidx.media3.exoplayer.dash.manifest.DashManifest;
import androidx.media3.exoplayer.dash.manifest.DashManifestParser;
import androidx.media3.exoplayer.dash.manifest.Period;
import androidx.media3.exoplayer.dash.manifest.RangedUri;
import androidx.media3.exoplayer.dash.manifest.Representation;
import androidx.media3.exoplayer.offline.DownloadException;
import androidx.media3.exoplayer.offline.SegmentDownloader;
import androidx.media3.exoplayer.upstream.ParsingLoadable;
import androidx.media3.extractor.ChunkIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NullableType;

@UnstableApi
public final class DashDownloader
extends SegmentDownloader<DashManifest> {
    private final BaseUrlExclusionList baseUrlExclusionList = new BaseUrlExclusionList();

    public DashDownloader(MediaItem mediaItem, CacheDataSource.Factory cacheDataSourceFactory) {
        this(mediaItem, cacheDataSourceFactory, Runnable::run);
    }

    public DashDownloader(MediaItem mediaItem, CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this(mediaItem, new DashManifestParser(), cacheDataSourceFactory, executor, 20000L);
    }

    @Deprecated
    public DashDownloader(MediaItem mediaItem, ParsingLoadable.Parser<DashManifest> manifestParser, CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this(mediaItem, manifestParser, cacheDataSourceFactory, executor, 20000L);
    }

    public DashDownloader(MediaItem mediaItem, ParsingLoadable.Parser<DashManifest> manifestParser, CacheDataSource.Factory cacheDataSourceFactory, Executor executor, long maxMergedSegmentStartTimeDiffMs) {
        super(mediaItem, manifestParser, cacheDataSourceFactory, executor, maxMergedSegmentStartTimeDiffMs);
    }

    protected List<SegmentDownloader.Segment> getSegments(DataSource dataSource, DashManifest manifest, boolean removing) throws IOException, InterruptedException {
        ArrayList<SegmentDownloader.Segment> segments = new ArrayList<SegmentDownloader.Segment>();
        for (int i = 0; i < manifest.getPeriodCount(); ++i) {
            Period period = manifest.getPeriod(i);
            long periodStartUs = Util.msToUs((long)period.startMs);
            long periodDurationUs = manifest.getPeriodDurationUs(i);
            List<AdaptationSet> adaptationSets = period.adaptationSets;
            for (int j = 0; j < adaptationSets.size(); ++j) {
                this.addSegmentsForAdaptationSet(dataSource, adaptationSets.get(j), periodStartUs, periodDurationUs, removing, segments);
            }
        }
        return segments;
    }

    private void addSegmentsForAdaptationSet(DataSource dataSource, AdaptationSet adaptationSet, long periodStartUs, long periodDurationUs, boolean removing, ArrayList<SegmentDownloader.Segment> out) throws IOException, InterruptedException {
        for (int i = 0; i < adaptationSet.representations.size(); ++i) {
            RangedUri indexUri;
            DashSegmentIndex index;
            Representation representation = adaptationSet.representations.get(i);
            try {
                index = this.getSegmentIndex(dataSource, adaptationSet.type, representation, removing);
                if (index == null) {
                    throw new DownloadException("Missing segment index");
                }
            }
            catch (IOException e) {
                if (removing) continue;
                throw e;
            }
            long segmentCount = index.getSegmentCount(periodDurationUs);
            if (segmentCount == -1L) {
                throw new DownloadException("Unbounded segment index");
            }
            String baseUrl = ((BaseUrl)Util.castNonNull((Object)this.baseUrlExclusionList.selectBaseUrl(representation.baseUrls))).url;
            RangedUri initializationUri = representation.getInitializationUri();
            if (initializationUri != null) {
                out.add(this.createSegment(representation, baseUrl, periodStartUs, initializationUri));
            }
            if ((indexUri = representation.getIndexUri()) != null) {
                out.add(this.createSegment(representation, baseUrl, periodStartUs, indexUri));
            }
            long firstSegmentNum = index.getFirstSegmentNum();
            long lastSegmentNum = firstSegmentNum + segmentCount - 1L;
            for (long j = firstSegmentNum; j <= lastSegmentNum; ++j) {
                out.add(this.createSegment(representation, baseUrl, periodStartUs + index.getTimeUs(j), index.getSegmentUrl(j)));
            }
        }
    }

    private SegmentDownloader.Segment createSegment(Representation representation, String baseUrl, long startTimeUs, RangedUri rangedUri) {
        DataSpec dataSpec = DashUtil.buildDataSpec(representation, baseUrl, rangedUri, 0);
        return new SegmentDownloader.Segment(startTimeUs, dataSpec);
    }

    @Nullable
    private DashSegmentIndex getSegmentIndex(final DataSource dataSource, final int trackType, final Representation representation, boolean removing) throws IOException, InterruptedException {
        DashSegmentIndex index = representation.getIndex();
        if (index != null) {
            return index;
        }
        RunnableFutureTask<@NullableType ChunkIndex, IOException> runnable = new RunnableFutureTask<ChunkIndex, IOException>(this){

            protected @NullableType ChunkIndex doWork() throws IOException {
                return DashUtil.loadChunkIndex(dataSource, trackType, representation);
            }
        };
        ChunkIndex seekMap = (ChunkIndex)this.execute((RunnableFutureTask)runnable, removing);
        return seekMap == null ? null : new DashWrappingSegmentIndex(seekMap, representation.presentationTimeOffsetUs);
    }
}

