/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.dash;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.MediaLibraryInfo;
import androidx.media3.common.ParserException;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.dash.BaseUrlExclusionList;
import androidx.media3.exoplayer.dash.DashChunkSource;
import androidx.media3.exoplayer.dash.DashManifestStaleException;
import androidx.media3.exoplayer.dash.DashMediaPeriod;
import androidx.media3.exoplayer.dash.DashSegmentIndex;
import androidx.media3.exoplayer.dash.DefaultDashChunkSource;
import androidx.media3.exoplayer.dash.PlayerEmsgHandler;
import androidx.media3.exoplayer.dash.manifest.AdaptationSet;
import androidx.media3.exoplayer.dash.manifest.DashManifest;
import androidx.media3.exoplayer.dash.manifest.DashManifestParser;
import androidx.media3.exoplayer.dash.manifest.Period;
import androidx.media3.exoplayer.dash.manifest.Representation;
import androidx.media3.exoplayer.dash.manifest.UtcTimingElement;
import androidx.media3.exoplayer.drm.DefaultDrmSessionManagerProvider;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import androidx.media3.exoplayer.drm.DrmSessionManager;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.offline.FilteringManifestParser;
import androidx.media3.exoplayer.source.BaseMediaSource;
import androidx.media3.exoplayer.source.CompositeSequenceableLoaderFactory;
import androidx.media3.exoplayer.source.DefaultCompositeSequenceableLoaderFactory;
import androidx.media3.exoplayer.source.LoadEventInfo;
import androidx.media3.exoplayer.source.MediaLoadData;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.MediaSourceEventListener;
import androidx.media3.exoplayer.source.MediaSourceFactory;
import androidx.media3.exoplayer.upstream.Allocator;
import androidx.media3.exoplayer.upstream.CmcdConfiguration;
import androidx.media3.exoplayer.upstream.DefaultLoadErrorHandlingPolicy;
import androidx.media3.exoplayer.upstream.LoadErrorHandlingPolicy;
import androidx.media3.exoplayer.upstream.Loader;
import androidx.media3.exoplayer.upstream.LoaderErrorThrower;
import androidx.media3.exoplayer.upstream.ParsingLoadable;
import androidx.media3.exoplayer.util.SntpClient;
import androidx.media3.extractor.text.SubtitleParser;
import com.google.common.base.Charsets;
import com.google.common.math.LongMath;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UnstableApi
public final class DashMediaSource
extends BaseMediaSource {
    public static final long DEFAULT_FALLBACK_TARGET_LIVE_OFFSET_MS = 30000L;
    public static final String DEFAULT_MEDIA_ID = "DashMediaSource";
    public static final long MIN_LIVE_DEFAULT_START_POSITION_US = 5000000L;
    private static final long DEFAULT_NOTIFY_MANIFEST_INTERVAL_MS = 5000L;
    private static final String TAG = "DashMediaSource";
    private final boolean sideloadedManifest;
    private final DataSource.Factory manifestDataSourceFactory;
    private final DashChunkSource.Factory chunkSourceFactory;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    @Nullable
    private final CmcdConfiguration cmcdConfiguration;
    private final DrmSessionManager drmSessionManager;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final BaseUrlExclusionList baseUrlExclusionList;
    private final long fallbackTargetLiveOffsetMs;
    private final long minLiveStartPositionUs;
    private final MediaSourceEventListener.EventDispatcher manifestEventDispatcher;
    private final ParsingLoadable.Parser<? extends DashManifest> manifestParser;
    private final ManifestCallback manifestCallback;
    private final Object manifestUriLock;
    private final SparseArray<DashMediaPeriod> periodsById;
    private final Runnable refreshManifestRunnable;
    private final Runnable simulateManifestRefreshRunnable;
    private final PlayerEmsgHandler.PlayerEmsgCallback playerEmsgCallback;
    private final LoaderErrorThrower manifestLoadErrorThrower;
    private DataSource dataSource;
    private Loader loader;
    @Nullable
    private TransferListener mediaTransferListener;
    private IOException manifestFatalError;
    private Handler handler;
    private MediaItem.LiveConfiguration liveConfiguration;
    private Uri manifestUri;
    private Uri initialManifestUri;
    private DashManifest manifest;
    private boolean manifestLoadPending;
    private long manifestLoadStartTimestampMs;
    private long manifestLoadEndTimestampMs;
    private long elapsedRealtimeOffsetMs;
    private int staleManifestReloadAttempt;
    private long expiredManifestPublishTimeUs;
    private int firstPeriodId;
    @GuardedBy(value="this")
    private MediaItem mediaItem;

    private DashMediaSource(MediaItem mediaItem, @Nullable DashManifest manifest, @Nullable DataSource.Factory manifestDataSourceFactory, @Nullable ParsingLoadable.Parser<? extends DashManifest> manifestParser, DashChunkSource.Factory chunkSourceFactory, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, @Nullable CmcdConfiguration cmcdConfiguration, DrmSessionManager drmSessionManager, LoadErrorHandlingPolicy loadErrorHandlingPolicy, long fallbackTargetLiveOffsetMs, long minLiveStartPositionUs) {
        this.mediaItem = mediaItem;
        this.liveConfiguration = mediaItem.liveConfiguration;
        this.manifestUri = ((MediaItem.LocalConfiguration)Assertions.checkNotNull((Object)mediaItem.localConfiguration)).uri;
        this.initialManifestUri = mediaItem.localConfiguration.uri;
        this.manifest = manifest;
        this.manifestDataSourceFactory = manifestDataSourceFactory;
        this.manifestParser = manifestParser;
        this.chunkSourceFactory = chunkSourceFactory;
        this.cmcdConfiguration = cmcdConfiguration;
        this.drmSessionManager = drmSessionManager;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.fallbackTargetLiveOffsetMs = fallbackTargetLiveOffsetMs;
        this.minLiveStartPositionUs = minLiveStartPositionUs;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.baseUrlExclusionList = new BaseUrlExclusionList();
        this.sideloadedManifest = manifest != null;
        this.manifestEventDispatcher = this.createEventDispatcher(null);
        this.manifestUriLock = new Object();
        this.periodsById = new SparseArray();
        this.playerEmsgCallback = new DefaultPlayerEmsgCallback();
        this.expiredManifestPublishTimeUs = -9223372036854775807L;
        this.elapsedRealtimeOffsetMs = -9223372036854775807L;
        if (this.sideloadedManifest) {
            Assertions.checkState((!manifest.dynamic ? 1 : 0) != 0);
            this.manifestCallback = null;
            this.refreshManifestRunnable = null;
            this.simulateManifestRefreshRunnable = null;
            this.manifestLoadErrorThrower = new LoaderErrorThrower.Placeholder();
        } else {
            this.manifestCallback = new ManifestCallback();
            this.manifestLoadErrorThrower = new ManifestLoadErrorThrower();
            this.refreshManifestRunnable = this::startLoadingManifest;
            this.simulateManifestRefreshRunnable = () -> this.processManifest(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceManifestUri(Uri manifestUri) {
        Object object = this.manifestUriLock;
        synchronized (object) {
            this.manifestUri = manifestUri;
            this.initialManifestUri = manifestUri;
        }
    }

    public synchronized MediaItem getMediaItem() {
        return this.mediaItem;
    }

    public boolean canUpdateMediaItem(MediaItem mediaItem) {
        MediaItem existingMediaItem = this.getMediaItem();
        MediaItem.LocalConfiguration existingConfiguration = (MediaItem.LocalConfiguration)Assertions.checkNotNull((Object)existingMediaItem.localConfiguration);
        MediaItem.LocalConfiguration newConfiguration = mediaItem.localConfiguration;
        return newConfiguration != null && newConfiguration.uri.equals((Object)existingConfiguration.uri) && newConfiguration.streamKeys.equals(existingConfiguration.streamKeys) && Util.areEqual((Object)newConfiguration.drmConfiguration, (Object)existingConfiguration.drmConfiguration) && existingMediaItem.liveConfiguration.equals((Object)mediaItem.liveConfiguration);
    }

    public synchronized void updateMediaItem(MediaItem mediaItem) {
        this.mediaItem = mediaItem;
    }

    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.mediaTransferListener = mediaTransferListener;
        this.drmSessionManager.setPlayer(Looper.myLooper(), this.getPlayerId());
        this.drmSessionManager.prepare();
        if (this.sideloadedManifest) {
            this.processManifest(false);
        } else {
            this.dataSource = this.manifestDataSourceFactory.createDataSource();
            this.loader = new Loader("DashMediaSource");
            this.handler = Util.createHandlerForCurrentLooper();
            this.startLoadingManifest();
        }
    }

    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.manifestLoadErrorThrower.maybeThrowError();
    }

    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        int periodIndex = (Integer)id.periodUid - this.firstPeriodId;
        MediaSourceEventListener.EventDispatcher periodEventDispatcher = this.createEventDispatcher(id);
        DrmSessionEventListener.EventDispatcher drmEventDispatcher = this.createDrmEventDispatcher(id);
        DashMediaPeriod mediaPeriod = new DashMediaPeriod(this.firstPeriodId + periodIndex, this.manifest, this.baseUrlExclusionList, periodIndex, this.chunkSourceFactory, this.mediaTransferListener, this.cmcdConfiguration, this.drmSessionManager, drmEventDispatcher, this.loadErrorHandlingPolicy, periodEventDispatcher, this.elapsedRealtimeOffsetMs, this.manifestLoadErrorThrower, allocator, this.compositeSequenceableLoaderFactory, this.playerEmsgCallback, this.getPlayerId());
        this.periodsById.put(mediaPeriod.id, (Object)mediaPeriod);
        return mediaPeriod;
    }

    public void releasePeriod(MediaPeriod mediaPeriod) {
        DashMediaPeriod dashMediaPeriod = (DashMediaPeriod)mediaPeriod;
        dashMediaPeriod.release();
        this.periodsById.remove(dashMediaPeriod.id);
    }

    protected void releaseSourceInternal() {
        this.manifestLoadPending = false;
        this.dataSource = null;
        if (this.loader != null) {
            this.loader.release();
            this.loader = null;
        }
        this.manifestLoadStartTimestampMs = 0L;
        this.manifestLoadEndTimestampMs = 0L;
        this.manifestUri = this.initialManifestUri;
        this.manifestFatalError = null;
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler = null;
        }
        this.elapsedRealtimeOffsetMs = -9223372036854775807L;
        this.staleManifestReloadAttempt = 0;
        this.expiredManifestPublishTimeUs = -9223372036854775807L;
        this.periodsById.clear();
        this.baseUrlExclusionList.reset();
        this.drmSessionManager.release();
    }

    void onDashManifestRefreshRequested() {
        this.handler.removeCallbacks(this.simulateManifestRefreshRunnable);
        this.startLoadingManifest();
    }

    void onDashManifestPublishTimeExpired(long expiredManifestPublishTimeUs) {
        if (this.expiredManifestPublishTimeUs == -9223372036854775807L || this.expiredManifestPublishTimeUs < expiredManifestPublishTimeUs) {
            this.expiredManifestPublishTimeUs = expiredManifestPublishTimeUs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onManifestLoadCompleted(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        int removedPeriodCount;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.manifestEventDispatcher.loadCompleted(loadEventInfo, loadable.type);
        DashManifest newManifest = (DashManifest)loadable.getResult();
        int oldPeriodCount = this.manifest == null ? 0 : this.manifest.getPeriodCount();
        long newFirstPeriodStartTimeMs = newManifest.getPeriod((int)0).startMs;
        for (removedPeriodCount = 0; removedPeriodCount < oldPeriodCount && this.manifest.getPeriod((int)removedPeriodCount).startMs < newFirstPeriodStartTimeMs; ++removedPeriodCount) {
        }
        if (newManifest.dynamic) {
            boolean isManifestStale = false;
            if (oldPeriodCount - removedPeriodCount > newManifest.getPeriodCount()) {
                Log.w((String)"DashMediaSource", (String)"Loaded out of sync manifest");
                isManifestStale = true;
            } else if (this.expiredManifestPublishTimeUs != -9223372036854775807L && newManifest.publishTimeMs * 1000L <= this.expiredManifestPublishTimeUs) {
                Log.w((String)"DashMediaSource", (String)("Loaded stale dynamic manifest: " + newManifest.publishTimeMs + ", " + this.expiredManifestPublishTimeUs));
                isManifestStale = true;
            }
            if (isManifestStale) {
                if (this.staleManifestReloadAttempt++ < this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(loadable.type)) {
                    this.scheduleManifestRefresh(this.getManifestLoadRetryDelayMillis());
                } else {
                    this.manifestFatalError = new DashManifestStaleException();
                }
                return;
            }
            this.staleManifestReloadAttempt = 0;
        }
        this.manifest = newManifest;
        this.manifestLoadPending &= this.manifest.dynamic;
        this.manifestLoadStartTimestampMs = elapsedRealtimeMs - loadDurationMs;
        this.manifestLoadEndTimestampMs = elapsedRealtimeMs;
        this.firstPeriodId += removedPeriodCount;
        Object object = this.manifestUriLock;
        synchronized (object) {
            boolean isSameUriInstance;
            boolean bl = isSameUriInstance = loadable.dataSpec.uri == this.manifestUri;
            if (isSameUriInstance) {
                this.manifestUri = this.manifest.location != null ? this.manifest.location : loadable.getUri();
            }
        }
        if (this.manifest.dynamic && this.elapsedRealtimeOffsetMs == -9223372036854775807L) {
            if (this.manifest.utcTiming != null) {
                this.resolveUtcTimingElement(this.manifest.utcTiming);
            } else {
                this.loadNtpTimeOffset();
            }
        } else {
            this.processManifest(true);
        }
    }

    Loader.LoadErrorAction onManifestLoadError(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
        MediaLoadData mediaLoadData;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo = new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData = new MediaLoadData(loadable.type), error, errorCount);
        long retryDelayMs = this.loadErrorHandlingPolicy.getRetryDelayMsFor(loadErrorInfo);
        Loader.LoadErrorAction loadErrorAction = retryDelayMs == -9223372036854775807L ? Loader.DONT_RETRY_FATAL : Loader.createRetryAction((boolean)false, (long)retryDelayMs);
        boolean wasCanceled = !loadErrorAction.isRetry();
        this.manifestEventDispatcher.loadError(loadEventInfo, loadable.type, error, wasCanceled);
        if (wasCanceled) {
            this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        }
        return loadErrorAction;
    }

    void onUtcTimestampLoadCompleted(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.manifestEventDispatcher.loadCompleted(loadEventInfo, loadable.type);
        this.onUtcTimestampResolved((Long)loadable.getResult() - elapsedRealtimeMs);
    }

    Loader.LoadErrorAction onUtcTimestampLoadError(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        this.manifestEventDispatcher.loadError(new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded()), loadable.type, error, true);
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.onUtcTimestampResolutionError(error);
        return Loader.DONT_RETRY;
    }

    void onLoadCanceled(ParsingLoadable<?> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.manifestEventDispatcher.loadCanceled(loadEventInfo, loadable.type);
    }

    private void resolveUtcTimingElement(UtcTimingElement timingElement) {
        String scheme = timingElement.schemeIdUri;
        if (Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:direct:2014") || Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:direct:2012")) {
            this.resolveUtcTimingElementDirect(timingElement);
        } else if (Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:http-iso:2014") || Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:http-iso:2012")) {
            this.resolveUtcTimingElementHttp(timingElement, new Iso8601Parser());
        } else if (Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:http-xsdate:2014") || Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:http-xsdate:2012")) {
            this.resolveUtcTimingElementHttp(timingElement, new XsDateTimeParser());
        } else if (Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:ntp:2014") || Util.areEqual((Object)scheme, (Object)"urn:mpeg:dash:utc:ntp:2012")) {
            this.loadNtpTimeOffset();
        } else {
            this.onUtcTimestampResolutionError(new IOException("Unsupported UTC timing scheme"));
        }
    }

    private void resolveUtcTimingElementDirect(UtcTimingElement timingElement) {
        try {
            long utcTimestampMs = Util.parseXsDateTime((String)timingElement.value);
            this.onUtcTimestampResolved(utcTimestampMs - this.manifestLoadEndTimestampMs);
        }
        catch (ParserException e) {
            this.onUtcTimestampResolutionError((IOException)((Object)e));
        }
    }

    private void resolveUtcTimingElementHttp(UtcTimingElement timingElement, ParsingLoadable.Parser<Long> parser) {
        this.startLoading(new ParsingLoadable(this.dataSource, Uri.parse((String)timingElement.value), 5, parser), new UtcTimestampCallback(), 1);
    }

    private void loadNtpTimeOffset() {
        SntpClient.initialize((Loader)this.loader, (SntpClient.InitializationCallback)new SntpClient.InitializationCallback(){

            public void onInitialized() {
                DashMediaSource.this.onUtcTimestampResolved(SntpClient.getElapsedRealtimeOffsetMs());
            }

            public void onInitializationFailed(IOException error) {
                DashMediaSource.this.onUtcTimestampResolutionError(error);
            }
        });
    }

    private void onUtcTimestampResolved(long elapsedRealtimeOffsetMs) {
        this.elapsedRealtimeOffsetMs = elapsedRealtimeOffsetMs;
        this.processManifest(true);
    }

    private void onUtcTimestampResolutionError(IOException error) {
        Log.e((String)"DashMediaSource", (String)"Failed to resolve time offset.", (Throwable)error);
        this.elapsedRealtimeOffsetMs = System.currentTimeMillis() - SystemClock.elapsedRealtime();
        this.processManifest(true);
    }

    private void processManifest(boolean scheduleRefresh) {
        boolean windowChangingImplicitly;
        for (int i = 0; i < this.periodsById.size(); ++i) {
            int id = this.periodsById.keyAt(i);
            if (id < this.firstPeriodId) continue;
            ((DashMediaPeriod)this.periodsById.valueAt(i)).updateManifest(this.manifest, id - this.firstPeriodId);
        }
        Period firstPeriod = this.manifest.getPeriod(0);
        int lastPeriodIndex = this.manifest.getPeriodCount() - 1;
        Period lastPeriod = this.manifest.getPeriod(lastPeriodIndex);
        long lastPeriodDurationUs = this.manifest.getPeriodDurationUs(lastPeriodIndex);
        long nowUnixTimeUs = Util.msToUs((long)Util.getNowUnixTimeMs((long)this.elapsedRealtimeOffsetMs));
        long windowStartTimeInManifestUs = DashMediaSource.getAvailableStartTimeInManifestUs(firstPeriod, this.manifest.getPeriodDurationUs(0), nowUnixTimeUs);
        long windowEndTimeInManifestUs = DashMediaSource.getAvailableEndTimeInManifestUs(lastPeriod, lastPeriodDurationUs, nowUnixTimeUs);
        boolean bl = windowChangingImplicitly = this.manifest.dynamic && !DashMediaSource.isIndexExplicit(lastPeriod);
        if (windowChangingImplicitly && this.manifest.timeShiftBufferDepthMs != -9223372036854775807L) {
            long timeShiftBufferStartTimeInManifestUs = windowEndTimeInManifestUs - Util.msToUs((long)this.manifest.timeShiftBufferDepthMs);
            windowStartTimeInManifestUs = Math.max(windowStartTimeInManifestUs, timeShiftBufferStartTimeInManifestUs);
        }
        long windowDurationUs = windowEndTimeInManifestUs - windowStartTimeInManifestUs;
        long windowStartUnixTimeMs = -9223372036854775807L;
        long windowDefaultPositionUs = 0L;
        if (this.manifest.dynamic) {
            Assertions.checkState((this.manifest.availabilityStartTimeMs != -9223372036854775807L ? 1 : 0) != 0);
            long nowInWindowUs = nowUnixTimeUs - Util.msToUs((long)this.manifest.availabilityStartTimeMs) - windowStartTimeInManifestUs;
            this.updateLiveConfiguration(nowInWindowUs, windowDurationUs);
            windowStartUnixTimeMs = this.manifest.availabilityStartTimeMs + Util.usToMs((long)windowStartTimeInManifestUs);
            windowDefaultPositionUs = nowInWindowUs - Util.msToUs((long)this.liveConfiguration.targetOffsetMs);
            long minimumWindowDefaultPositionUs = Math.min(this.minLiveStartPositionUs, windowDurationUs / 2L);
            if (windowDefaultPositionUs < minimumWindowDefaultPositionUs) {
                windowDefaultPositionUs = minimumWindowDefaultPositionUs;
            }
        }
        long offsetInFirstPeriodUs = windowStartTimeInManifestUs - Util.msToUs((long)firstPeriod.startMs);
        DashTimeline timeline = new DashTimeline(this.manifest.availabilityStartTimeMs, windowStartUnixTimeMs, this.elapsedRealtimeOffsetMs, this.firstPeriodId, offsetInFirstPeriodUs, windowDurationUs, windowDefaultPositionUs, this.manifest, this.getMediaItem(), this.manifest.dynamic ? this.liveConfiguration : null);
        this.refreshSourceInfo(timeline);
        if (!this.sideloadedManifest) {
            this.handler.removeCallbacks(this.simulateManifestRefreshRunnable);
            if (windowChangingImplicitly) {
                this.handler.postDelayed(this.simulateManifestRefreshRunnable, DashMediaSource.getIntervalUntilNextManifestRefreshMs(this.manifest, Util.getNowUnixTimeMs((long)this.elapsedRealtimeOffsetMs)));
            }
            if (this.manifestLoadPending) {
                this.startLoadingManifest();
            } else if (scheduleRefresh && this.manifest.dynamic && this.manifest.minUpdatePeriodMs != -9223372036854775807L) {
                long minUpdatePeriodMs = this.manifest.minUpdatePeriodMs;
                if (minUpdatePeriodMs == 0L) {
                    minUpdatePeriodMs = 5000L;
                }
                long nextLoadTimestampMs = this.manifestLoadStartTimestampMs + minUpdatePeriodMs;
                long delayUntilNextLoadMs = Math.max(0L, nextLoadTimestampMs - SystemClock.elapsedRealtime());
                this.scheduleManifestRefresh(delayUntilNextLoadMs);
            }
        }
    }

    private void updateLiveConfiguration(long nowInWindowUs, long windowDurationUs) {
        long targetOffsetMs;
        long maxPossibleLiveOffsetMs;
        MediaItem.LiveConfiguration mediaItemLiveConfiguration = this.getMediaItem().liveConfiguration;
        long maxLiveOffsetMs = maxPossibleLiveOffsetMs = Util.usToMs((long)nowInWindowUs);
        if (mediaItemLiveConfiguration.maxOffsetMs != -9223372036854775807L) {
            maxLiveOffsetMs = Math.min(maxLiveOffsetMs, mediaItemLiveConfiguration.maxOffsetMs);
        } else if (this.manifest.serviceDescription != null && this.manifest.serviceDescription.maxOffsetMs != -9223372036854775807L) {
            maxLiveOffsetMs = Math.min(maxLiveOffsetMs, this.manifest.serviceDescription.maxOffsetMs);
        }
        long minLiveOffsetMs = Util.usToMs((long)(nowInWindowUs - windowDurationUs));
        if (minLiveOffsetMs < 0L && maxLiveOffsetMs > 0L) {
            minLiveOffsetMs = 0L;
        }
        if (this.manifest.minBufferTimeMs != -9223372036854775807L) {
            minLiveOffsetMs = Math.min(minLiveOffsetMs + this.manifest.minBufferTimeMs, maxPossibleLiveOffsetMs);
        }
        if (mediaItemLiveConfiguration.minOffsetMs != -9223372036854775807L) {
            minLiveOffsetMs = Util.constrainValue((long)mediaItemLiveConfiguration.minOffsetMs, (long)minLiveOffsetMs, (long)maxPossibleLiveOffsetMs);
        } else if (this.manifest.serviceDescription != null && this.manifest.serviceDescription.minOffsetMs != -9223372036854775807L) {
            minLiveOffsetMs = Util.constrainValue((long)this.manifest.serviceDescription.minOffsetMs, (long)minLiveOffsetMs, (long)maxPossibleLiveOffsetMs);
        }
        if (minLiveOffsetMs > maxLiveOffsetMs) {
            maxLiveOffsetMs = minLiveOffsetMs;
        }
        if ((targetOffsetMs = this.liveConfiguration.targetOffsetMs != -9223372036854775807L ? this.liveConfiguration.targetOffsetMs : (this.manifest.serviceDescription != null && this.manifest.serviceDescription.targetOffsetMs != -9223372036854775807L ? this.manifest.serviceDescription.targetOffsetMs : (this.manifest.suggestedPresentationDelayMs != -9223372036854775807L ? this.manifest.suggestedPresentationDelayMs : this.fallbackTargetLiveOffsetMs))) < minLiveOffsetMs) {
            targetOffsetMs = minLiveOffsetMs;
        }
        if (targetOffsetMs > maxLiveOffsetMs) {
            long safeDistanceFromWindowStartUs = Math.min(this.minLiveStartPositionUs, windowDurationUs / 2L);
            long maxTargetOffsetForSafeDistanceToWindowStartMs = Util.usToMs((long)(nowInWindowUs - safeDistanceFromWindowStartUs));
            targetOffsetMs = Util.constrainValue((long)maxTargetOffsetForSafeDistanceToWindowStartMs, (long)minLiveOffsetMs, (long)maxLiveOffsetMs);
        }
        float minPlaybackSpeed = -3.4028235E38f;
        if (mediaItemLiveConfiguration.minPlaybackSpeed != -3.4028235E38f) {
            minPlaybackSpeed = mediaItemLiveConfiguration.minPlaybackSpeed;
        } else if (this.manifest.serviceDescription != null) {
            minPlaybackSpeed = this.manifest.serviceDescription.minPlaybackSpeed;
        }
        float maxPlaybackSpeed = -3.4028235E38f;
        if (mediaItemLiveConfiguration.maxPlaybackSpeed != -3.4028235E38f) {
            maxPlaybackSpeed = mediaItemLiveConfiguration.maxPlaybackSpeed;
        } else if (this.manifest.serviceDescription != null) {
            maxPlaybackSpeed = this.manifest.serviceDescription.maxPlaybackSpeed;
        }
        if (minPlaybackSpeed == -3.4028235E38f && maxPlaybackSpeed == -3.4028235E38f && (this.manifest.serviceDescription == null || this.manifest.serviceDescription.targetOffsetMs == -9223372036854775807L)) {
            minPlaybackSpeed = 1.0f;
            maxPlaybackSpeed = 1.0f;
        }
        this.liveConfiguration = new MediaItem.LiveConfiguration.Builder().setTargetOffsetMs(targetOffsetMs).setMinOffsetMs(minLiveOffsetMs).setMaxOffsetMs(maxLiveOffsetMs).setMinPlaybackSpeed(minPlaybackSpeed).setMaxPlaybackSpeed(maxPlaybackSpeed).build();
    }

    private void scheduleManifestRefresh(long delayUntilNextLoadMs) {
        this.handler.postDelayed(this.refreshManifestRunnable, delayUntilNextLoadMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadingManifest() {
        Uri manifestUri;
        this.handler.removeCallbacks(this.refreshManifestRunnable);
        if (this.loader.hasFatalError()) {
            return;
        }
        if (this.loader.isLoading()) {
            this.manifestLoadPending = true;
            return;
        }
        Object object = this.manifestUriLock;
        synchronized (object) {
            manifestUri = this.manifestUri;
        }
        this.manifestLoadPending = false;
        this.startLoading(new ParsingLoadable(this.dataSource, manifestUri, 4, this.manifestParser), this.manifestCallback, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(4));
    }

    private long getManifestLoadRetryDelayMillis() {
        return Math.min((this.staleManifestReloadAttempt - 1) * 1000, 5000);
    }

    private <T> void startLoading(ParsingLoadable<T> loadable, Loader.Callback<ParsingLoadable<T>> callback, int minRetryCount) {
        long elapsedRealtimeMs = this.loader.startLoading(loadable, callback, minRetryCount);
        this.manifestEventDispatcher.loadStarted(new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, elapsedRealtimeMs), loadable.type);
    }

    private static long getIntervalUntilNextManifestRefreshMs(DashManifest manifest, long nowUnixTimeMs) {
        int periodIndex = manifest.getPeriodCount() - 1;
        Period period = manifest.getPeriod(periodIndex);
        long periodStartUs = Util.msToUs((long)period.startMs);
        long periodDurationUs = manifest.getPeriodDurationUs(periodIndex);
        long nowUnixTimeUs = Util.msToUs((long)nowUnixTimeMs);
        long availabilityStartTimeUs = Util.msToUs((long)manifest.availabilityStartTimeMs);
        long intervalUs = Util.msToUs((long)5000L);
        for (int i = 0; i < period.adaptationSets.size(); ++i) {
            long nextSegmentShiftUnixTimeUs;
            long requiredIntervalUs;
            DashSegmentIndex index;
            List<Representation> representations = period.adaptationSets.get((int)i).representations;
            if (representations.isEmpty() || (index = representations.get(0).getIndex()) == null || (requiredIntervalUs = (nextSegmentShiftUnixTimeUs = availabilityStartTimeUs + periodStartUs + index.getNextSegmentAvailableTimeUs(periodDurationUs, nowUnixTimeUs)) - nowUnixTimeUs) >= intervalUs - 100000L && (requiredIntervalUs <= intervalUs || requiredIntervalUs >= intervalUs + 100000L)) continue;
            intervalUs = requiredIntervalUs;
        }
        return LongMath.divide((long)intervalUs, (long)1000L, (RoundingMode)RoundingMode.CEILING);
    }

    private static long getAvailableStartTimeInManifestUs(Period period, long periodDurationUs, long nowUnixTimeUs) {
        long periodStartTimeInManifestUs;
        long availableStartTimeInManifestUs = periodStartTimeInManifestUs = Util.msToUs((long)period.startMs);
        boolean haveAudioVideoAdaptationSets = DashMediaSource.hasVideoOrAudioAdaptationSets(period);
        for (int i = 0; i < period.adaptationSets.size(); ++i) {
            boolean adaptationSetIsNotAudioVideo;
            AdaptationSet adaptationSet = period.adaptationSets.get(i);
            List<Representation> representations = adaptationSet.representations;
            boolean bl = adaptationSetIsNotAudioVideo = adaptationSet.type != 1 && adaptationSet.type != 2;
            if (haveAudioVideoAdaptationSets && adaptationSetIsNotAudioVideo || representations.isEmpty()) continue;
            DashSegmentIndex index = representations.get(0).getIndex();
            if (index == null) {
                return periodStartTimeInManifestUs;
            }
            long availableSegmentCount = index.getAvailableSegmentCount(periodDurationUs, nowUnixTimeUs);
            if (availableSegmentCount == 0L) {
                return periodStartTimeInManifestUs;
            }
            long firstAvailableSegmentNum = index.getFirstAvailableSegmentNum(periodDurationUs, nowUnixTimeUs);
            long adaptationSetAvailableStartTimeInManifestUs = periodStartTimeInManifestUs + index.getTimeUs(firstAvailableSegmentNum);
            availableStartTimeInManifestUs = Math.max(availableStartTimeInManifestUs, adaptationSetAvailableStartTimeInManifestUs);
        }
        return availableStartTimeInManifestUs;
    }

    private static long getAvailableEndTimeInManifestUs(Period period, long periodDurationUs, long nowUnixTimeUs) {
        long periodStartTimeInManifestUs = Util.msToUs((long)period.startMs);
        long availableEndTimeInManifestUs = Long.MAX_VALUE;
        boolean haveAudioVideoAdaptationSets = DashMediaSource.hasVideoOrAudioAdaptationSets(period);
        for (int i = 0; i < period.adaptationSets.size(); ++i) {
            boolean adaptationSetIsNotAudioVideo;
            AdaptationSet adaptationSet = period.adaptationSets.get(i);
            List<Representation> representations = adaptationSet.representations;
            boolean bl = adaptationSetIsNotAudioVideo = adaptationSet.type != 1 && adaptationSet.type != 2;
            if (haveAudioVideoAdaptationSets && adaptationSetIsNotAudioVideo || representations.isEmpty()) continue;
            DashSegmentIndex index = representations.get(0).getIndex();
            if (index == null) {
                return periodStartTimeInManifestUs + periodDurationUs;
            }
            long availableSegmentCount = index.getAvailableSegmentCount(periodDurationUs, nowUnixTimeUs);
            if (availableSegmentCount == 0L) {
                return periodStartTimeInManifestUs;
            }
            long firstAvailableSegmentNum = index.getFirstAvailableSegmentNum(periodDurationUs, nowUnixTimeUs);
            long lastAvailableSegmentNum = firstAvailableSegmentNum + availableSegmentCount - 1L;
            long adaptationSetAvailableEndTimeInManifestUs = periodStartTimeInManifestUs + index.getTimeUs(lastAvailableSegmentNum) + index.getDurationUs(lastAvailableSegmentNum, periodDurationUs);
            availableEndTimeInManifestUs = Math.min(availableEndTimeInManifestUs, adaptationSetAvailableEndTimeInManifestUs);
        }
        return availableEndTimeInManifestUs;
    }

    private static boolean isIndexExplicit(Period period) {
        for (int i = 0; i < period.adaptationSets.size(); ++i) {
            DashSegmentIndex index = period.adaptationSets.get((int)i).representations.get(0).getIndex();
            if (index != null && !index.isExplicit()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasVideoOrAudioAdaptationSets(Period period) {
        for (int i = 0; i < period.adaptationSets.size(); ++i) {
            int type = period.adaptationSets.get((int)i).type;
            if (type != 1 && type != 2) continue;
            return true;
        }
        return false;
    }

    static {
        MediaLibraryInfo.registerModule((String)"media3.exoplayer.dash");
    }

    private final class DefaultPlayerEmsgCallback
    implements PlayerEmsgHandler.PlayerEmsgCallback {
        private DefaultPlayerEmsgCallback() {
        }

        @Override
        public void onDashManifestRefreshRequested() {
            DashMediaSource.this.onDashManifestRefreshRequested();
        }

        @Override
        public void onDashManifestPublishTimeExpired(long expiredManifestPublishTimeUs) {
            DashMediaSource.this.onDashManifestPublishTimeExpired(expiredManifestPublishTimeUs);
        }
    }

    private final class ManifestCallback
    implements Loader.Callback<ParsingLoadable<DashManifest>> {
        private ManifestCallback() {
        }

        public void onLoadCompleted(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs) {
            DashMediaSource.this.onManifestLoadCompleted(loadable, elapsedRealtimeMs, loadDurationMs);
        }

        public void onLoadCanceled(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
            DashMediaSource.this.onLoadCanceled(loadable, elapsedRealtimeMs, loadDurationMs);
        }

        public Loader.LoadErrorAction onLoadError(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
            return DashMediaSource.this.onManifestLoadError(loadable, elapsedRealtimeMs, loadDurationMs, error, errorCount);
        }
    }

    final class ManifestLoadErrorThrower
    implements LoaderErrorThrower {
        ManifestLoadErrorThrower() {
        }

        public void maybeThrowError() throws IOException {
            DashMediaSource.this.loader.maybeThrowError();
            this.maybeThrowManifestError();
        }

        public void maybeThrowError(int minRetryCount) throws IOException {
            DashMediaSource.this.loader.maybeThrowError(minRetryCount);
            this.maybeThrowManifestError();
        }

        private void maybeThrowManifestError() throws IOException {
            if (DashMediaSource.this.manifestFatalError != null) {
                throw DashMediaSource.this.manifestFatalError;
            }
        }
    }

    static final class Iso8601Parser
    implements ParsingLoadable.Parser<Long> {
        private static final Pattern TIMESTAMP_WITH_TIMEZONE_PATTERN = Pattern.compile("(.+?)(Z|((\\+|-|\u2212)(\\d\\d)(:?(\\d\\d))?))");

        Iso8601Parser() {
        }

        public Long parse(Uri uri, InputStream inputStream) throws IOException {
            String firstLine = new BufferedReader(new InputStreamReader(inputStream, Charsets.UTF_8)).readLine();
            try {
                Matcher matcher = TIMESTAMP_WITH_TIMEZONE_PATTERN.matcher(firstLine);
                if (!matcher.matches()) {
                    throw ParserException.createForMalformedManifest((String)("Couldn't parse timestamp: " + firstLine), null);
                }
                String timestampWithoutTimezone = matcher.group(1);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                long timestampMs = format.parse(timestampWithoutTimezone).getTime();
                String timezone = matcher.group(2);
                if (!"Z".equals(timezone)) {
                    long sign = "+".equals(matcher.group(4)) ? 1L : -1L;
                    long hours = Long.parseLong(matcher.group(5));
                    String minutesString = matcher.group(7);
                    long minutes = TextUtils.isEmpty((CharSequence)minutesString) ? 0L : Long.parseLong(minutesString);
                    long timestampOffsetMs = sign * ((hours * 60L + minutes) * 60L * 1000L);
                    timestampMs -= timestampOffsetMs;
                }
                return timestampMs;
            }
            catch (ParseException e) {
                throw ParserException.createForMalformedManifest(null, (Throwable)e);
            }
        }
    }

    private static final class XsDateTimeParser
    implements ParsingLoadable.Parser<Long> {
        private XsDateTimeParser() {
        }

        public Long parse(Uri uri, InputStream inputStream) throws IOException {
            String firstLine = new BufferedReader(new InputStreamReader(inputStream)).readLine();
            return Util.parseXsDateTime((String)firstLine);
        }
    }

    private final class UtcTimestampCallback
    implements Loader.Callback<ParsingLoadable<Long>> {
        private UtcTimestampCallback() {
        }

        public void onLoadCompleted(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs) {
            DashMediaSource.this.onUtcTimestampLoadCompleted(loadable, elapsedRealtimeMs, loadDurationMs);
        }

        public void onLoadCanceled(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
            DashMediaSource.this.onLoadCanceled(loadable, elapsedRealtimeMs, loadDurationMs);
        }

        public Loader.LoadErrorAction onLoadError(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
            return DashMediaSource.this.onUtcTimestampLoadError(loadable, elapsedRealtimeMs, loadDurationMs, error);
        }
    }

    private static final class DashTimeline
    extends Timeline {
        private final long presentationStartTimeMs;
        private final long windowStartTimeMs;
        private final long elapsedRealtimeEpochOffsetMs;
        private final int firstPeriodId;
        private final long offsetInFirstPeriodUs;
        private final long windowDurationUs;
        private final long windowDefaultStartPositionUs;
        private final DashManifest manifest;
        private final MediaItem mediaItem;
        @Nullable
        private final MediaItem.LiveConfiguration liveConfiguration;

        public DashTimeline(long presentationStartTimeMs, long windowStartTimeMs, long elapsedRealtimeEpochOffsetMs, int firstPeriodId, long offsetInFirstPeriodUs, long windowDurationUs, long windowDefaultStartPositionUs, DashManifest manifest, MediaItem mediaItem, @Nullable MediaItem.LiveConfiguration liveConfiguration) {
            Assertions.checkState((manifest.dynamic == (liveConfiguration != null) ? 1 : 0) != 0);
            this.presentationStartTimeMs = presentationStartTimeMs;
            this.windowStartTimeMs = windowStartTimeMs;
            this.elapsedRealtimeEpochOffsetMs = elapsedRealtimeEpochOffsetMs;
            this.firstPeriodId = firstPeriodId;
            this.offsetInFirstPeriodUs = offsetInFirstPeriodUs;
            this.windowDurationUs = windowDurationUs;
            this.windowDefaultStartPositionUs = windowDefaultStartPositionUs;
            this.manifest = manifest;
            this.mediaItem = mediaItem;
            this.liveConfiguration = liveConfiguration;
        }

        public int getPeriodCount() {
            return this.manifest.getPeriodCount();
        }

        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
            Assertions.checkIndex((int)periodIndex, (int)0, (int)this.getPeriodCount());
            String id = setIds ? this.manifest.getPeriod((int)periodIndex).id : null;
            Integer uid = setIds ? Integer.valueOf(this.firstPeriodId + periodIndex) : null;
            return period.set((Object)id, (Object)uid, 0, this.manifest.getPeriodDurationUs(periodIndex), Util.msToUs((long)(this.manifest.getPeriod((int)periodIndex).startMs - this.manifest.getPeriod((int)0).startMs)) - this.offsetInFirstPeriodUs);
        }

        public int getWindowCount() {
            return 1;
        }

        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
            Assertions.checkIndex((int)windowIndex, (int)0, (int)1);
            long windowDefaultStartPositionUs = this.getAdjustedWindowDefaultStartPositionUs(defaultPositionProjectionUs);
            return window.set(Timeline.Window.SINGLE_WINDOW_UID, this.mediaItem, (Object)this.manifest, this.presentationStartTimeMs, this.windowStartTimeMs, this.elapsedRealtimeEpochOffsetMs, true, DashTimeline.isMovingLiveWindow(this.manifest), this.liveConfiguration, windowDefaultStartPositionUs, this.windowDurationUs, 0, this.getPeriodCount() - 1, this.offsetInFirstPeriodUs);
        }

        public int getIndexOfPeriod(Object uid) {
            if (!(uid instanceof Integer)) {
                return -1;
            }
            int periodId = (Integer)uid;
            int periodIndex = periodId - this.firstPeriodId;
            return periodIndex < 0 || periodIndex >= this.getPeriodCount() ? -1 : periodIndex;
        }

        private long getAdjustedWindowDefaultStartPositionUs(long defaultPositionProjectionUs) {
            long defaultStartPositionInPeriodUs;
            long windowDefaultStartPositionUs = this.windowDefaultStartPositionUs;
            if (!DashTimeline.isMovingLiveWindow(this.manifest)) {
                return windowDefaultStartPositionUs;
            }
            if (defaultPositionProjectionUs > 0L && (windowDefaultStartPositionUs += defaultPositionProjectionUs) > this.windowDurationUs) {
                return -9223372036854775807L;
            }
            int periodIndex = 0;
            long periodDurationUs = this.manifest.getPeriodDurationUs(periodIndex);
            for (defaultStartPositionInPeriodUs = this.offsetInFirstPeriodUs + windowDefaultStartPositionUs; periodIndex < this.manifest.getPeriodCount() - 1 && defaultStartPositionInPeriodUs >= periodDurationUs; defaultStartPositionInPeriodUs -= periodDurationUs) {
                periodDurationUs = this.manifest.getPeriodDurationUs(++periodIndex);
            }
            Period period = this.manifest.getPeriod(periodIndex);
            int videoAdaptationSetIndex = period.getAdaptationSetIndex(2);
            if (videoAdaptationSetIndex == -1) {
                return windowDefaultStartPositionUs;
            }
            DashSegmentIndex snapIndex = period.adaptationSets.get((int)videoAdaptationSetIndex).representations.get(0).getIndex();
            if (snapIndex == null || snapIndex.getSegmentCount(periodDurationUs) == 0L) {
                return windowDefaultStartPositionUs;
            }
            long segmentNum = snapIndex.getSegmentNum(defaultStartPositionInPeriodUs, periodDurationUs);
            return windowDefaultStartPositionUs + snapIndex.getTimeUs(segmentNum) - defaultStartPositionInPeriodUs;
        }

        public Object getUidOfPeriod(int periodIndex) {
            Assertions.checkIndex((int)periodIndex, (int)0, (int)this.getPeriodCount());
            return this.firstPeriodId + periodIndex;
        }

        private static boolean isMovingLiveWindow(DashManifest manifest) {
            return manifest.dynamic && manifest.minUpdatePeriodMs != -9223372036854775807L && manifest.durationMs == -9223372036854775807L;
        }
    }

    public static final class Factory
    implements MediaSourceFactory {
        private final DashChunkSource.Factory chunkSourceFactory;
        @Nullable
        private final DataSource.Factory manifestDataSourceFactory;
        private CmcdConfiguration.Factory cmcdConfigurationFactory;
        private DrmSessionManagerProvider drmSessionManagerProvider;
        private CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
        private long fallbackTargetLiveOffsetMs;
        private long minLiveStartPositionUs;
        @Nullable
        private ParsingLoadable.Parser<? extends DashManifest> manifestParser;

        public Factory(DataSource.Factory dataSourceFactory) {
            this(new DefaultDashChunkSource.Factory(dataSourceFactory), dataSourceFactory);
        }

        public Factory(DashChunkSource.Factory chunkSourceFactory, @Nullable DataSource.Factory manifestDataSourceFactory) {
            this.chunkSourceFactory = (DashChunkSource.Factory)Assertions.checkNotNull((Object)chunkSourceFactory);
            this.manifestDataSourceFactory = manifestDataSourceFactory;
            this.drmSessionManagerProvider = new DefaultDrmSessionManagerProvider();
            this.loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy();
            this.fallbackTargetLiveOffsetMs = 30000L;
            this.minLiveStartPositionUs = 5000000L;
            this.compositeSequenceableLoaderFactory = new DefaultCompositeSequenceableLoaderFactory();
            this.experimentalParseSubtitlesDuringExtraction(true);
        }

        @CanIgnoreReturnValue
        public Factory setCmcdConfigurationFactory(CmcdConfiguration.Factory cmcdConfigurationFactory) {
            this.cmcdConfigurationFactory = (CmcdConfiguration.Factory)Assertions.checkNotNull((Object)cmcdConfigurationFactory);
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setDrmSessionManagerProvider(DrmSessionManagerProvider drmSessionManagerProvider) {
            this.drmSessionManagerProvider = (DrmSessionManagerProvider)Assertions.checkNotNull((Object)drmSessionManagerProvider, (Object)"MediaSource.Factory#setDrmSessionManagerProvider no longer handles null by instantiating a new DefaultDrmSessionManagerProvider. Explicitly construct and pass an instance in order to retain the old behavior.");
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setLoadErrorHandlingPolicy(LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.loadErrorHandlingPolicy = (LoadErrorHandlingPolicy)Assertions.checkNotNull((Object)loadErrorHandlingPolicy, (Object)"MediaSource.Factory#setLoadErrorHandlingPolicy no longer handles null by instantiating a new DefaultLoadErrorHandlingPolicy. Explicitly construct and pass an instance in order to retain the old behavior.");
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setSubtitleParserFactory(SubtitleParser.Factory subtitleParserFactory) {
            this.chunkSourceFactory.setSubtitleParserFactory((SubtitleParser.Factory)Assertions.checkNotNull((Object)subtitleParserFactory));
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Factory experimentalParseSubtitlesDuringExtraction(boolean parseSubtitlesDuringExtraction) {
            this.chunkSourceFactory.experimentalParseSubtitlesDuringExtraction(parseSubtitlesDuringExtraction);
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setFallbackTargetLiveOffsetMs(long fallbackTargetLiveOffsetMs) {
            this.fallbackTargetLiveOffsetMs = fallbackTargetLiveOffsetMs;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setMinLiveStartPositionUs(long minLiveStartPositionUs) {
            this.minLiveStartPositionUs = minLiveStartPositionUs;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setManifestParser(@Nullable ParsingLoadable.Parser<? extends DashManifest> manifestParser) {
            this.manifestParser = manifestParser;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setCompositeSequenceableLoaderFactory(CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory) {
            this.compositeSequenceableLoaderFactory = (CompositeSequenceableLoaderFactory)Assertions.checkNotNull((Object)compositeSequenceableLoaderFactory, (Object)"DashMediaSource.Factory#setCompositeSequenceableLoaderFactory no longer handles null by instantiating a new DefaultCompositeSequenceableLoaderFactory. Explicitly construct and pass an instance in order to retain the old behavior.");
            return this;
        }

        public DashMediaSource createMediaSource(DashManifest manifest) {
            return this.createMediaSource(manifest, new MediaItem.Builder().setUri(Uri.EMPTY).setMediaId("DashMediaSource").setMimeType("application/dash+xml").build());
        }

        public DashMediaSource createMediaSource(DashManifest manifest, MediaItem mediaItem) {
            Assertions.checkArgument((!manifest.dynamic ? 1 : 0) != 0);
            MediaItem.Builder mediaItemBuilder = mediaItem.buildUpon().setMimeType("application/dash+xml");
            if (mediaItem.localConfiguration == null) {
                mediaItemBuilder.setUri(Uri.EMPTY);
            }
            mediaItem = mediaItemBuilder.build();
            CmcdConfiguration cmcdConfiguration = this.cmcdConfigurationFactory == null ? null : this.cmcdConfigurationFactory.createCmcdConfiguration(mediaItem);
            return new DashMediaSource(mediaItem, manifest, null, null, this.chunkSourceFactory, this.compositeSequenceableLoaderFactory, cmcdConfiguration, this.drmSessionManagerProvider.get(mediaItem), this.loadErrorHandlingPolicy, this.fallbackTargetLiveOffsetMs, this.minLiveStartPositionUs);
        }

        public DashMediaSource createMediaSource(MediaItem mediaItem) {
            List streamKeys;
            Assertions.checkNotNull((Object)mediaItem.localConfiguration);
            DashManifestParser manifestParser = this.manifestParser;
            if (manifestParser == null) {
                manifestParser = new DashManifestParser();
            }
            if (!(streamKeys = mediaItem.localConfiguration.streamKeys).isEmpty()) {
                manifestParser = new FilteringManifestParser((ParsingLoadable.Parser)manifestParser, streamKeys);
            }
            CmcdConfiguration cmcdConfiguration = this.cmcdConfigurationFactory == null ? null : this.cmcdConfigurationFactory.createCmcdConfiguration(mediaItem);
            return new DashMediaSource(mediaItem, null, this.manifestDataSourceFactory, manifestParser, this.chunkSourceFactory, this.compositeSequenceableLoaderFactory, cmcdConfiguration, this.drmSessionManagerProvider.get(mediaItem), this.loadErrorHandlingPolicy, this.fallbackTargetLiveOffsetMs, this.minLiveStartPositionUs);
        }

        public int[] getSupportedTypes() {
            return new int[]{0};
        }
    }
}

