/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.dash;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSpec;
import androidx.media3.exoplayer.dash.manifest.BaseUrl;
import androidx.media3.exoplayer.dash.manifest.DashManifest;
import androidx.media3.exoplayer.dash.manifest.DashManifestParser;
import androidx.media3.exoplayer.dash.manifest.Period;
import androidx.media3.exoplayer.dash.manifest.RangedUri;
import androidx.media3.exoplayer.dash.manifest.Representation;
import androidx.media3.exoplayer.source.chunk.BundledChunkExtractor;
import androidx.media3.exoplayer.source.chunk.ChunkExtractor;
import androidx.media3.exoplayer.source.chunk.InitializationChunk;
import androidx.media3.exoplayer.upstream.ParsingLoadable;
import androidx.media3.extractor.ChunkIndex;
import androidx.media3.extractor.Extractor;
import androidx.media3.extractor.mkv.MatroskaExtractor;
import androidx.media3.extractor.mp4.FragmentedMp4Extractor;
import androidx.media3.extractor.text.SubtitleParser;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@UnstableApi
public final class DashUtil {
    public static DataSpec buildDataSpec(Representation representation, String baseUrl, RangedUri requestUri, int flags, Map<String, String> httpRequestHeaders) {
        return new DataSpec.Builder().setUri(requestUri.resolveUri(baseUrl)).setPosition(requestUri.start).setLength(requestUri.length).setKey(DashUtil.resolveCacheKey(representation, requestUri)).setFlags(flags).setHttpRequestHeaders(httpRequestHeaders).build();
    }

    @Deprecated
    public static DataSpec buildDataSpec(Representation representation, String baseUrl, RangedUri requestUri, int flags) {
        return DashUtil.buildDataSpec(representation, baseUrl, requestUri, flags, (Map<String, String>)ImmutableMap.of());
    }

    @Deprecated
    public static DataSpec buildDataSpec(Representation representation, RangedUri requestUri, int flags) {
        return DashUtil.buildDataSpec(representation, ((BaseUrl)representation.baseUrls.get((int)0)).url, requestUri, flags, (Map<String, String>)ImmutableMap.of());
    }

    public static DashManifest loadManifest(DataSource dataSource, Uri uri) throws IOException {
        return (DashManifest)ParsingLoadable.load((DataSource)dataSource, (ParsingLoadable.Parser)new DashManifestParser(), (Uri)uri, (int)4);
    }

    @Nullable
    public static Format loadFormatWithDrmInitData(DataSource dataSource, Period period) throws IOException {
        int primaryTrackType = 2;
        Representation representation = DashUtil.getFirstRepresentation(period, primaryTrackType);
        if (representation == null && (representation = DashUtil.getFirstRepresentation(period, primaryTrackType = 1)) == null) {
            return null;
        }
        Format manifestFormat = representation.format;
        Format sampleFormat = DashUtil.loadSampleFormat(dataSource, primaryTrackType, representation);
        return sampleFormat == null ? manifestFormat : sampleFormat.withManifestFormatInfo(manifestFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Format loadSampleFormat(DataSource dataSource, int trackType, Representation representation, int baseUrlIndex) throws IOException {
        if (representation.getInitializationUri() == null) {
            return null;
        }
        ChunkExtractor chunkExtractor = DashUtil.newChunkExtractor(trackType, representation.format);
        try {
            DashUtil.loadInitializationData(chunkExtractor, dataSource, representation, baseUrlIndex, false);
        }
        finally {
            chunkExtractor.release();
        }
        return ((Format[])Assertions.checkStateNotNull((Object)chunkExtractor.getSampleFormats()))[0];
    }

    @Nullable
    public static Format loadSampleFormat(DataSource dataSource, int trackType, Representation representation) throws IOException {
        return DashUtil.loadSampleFormat(dataSource, trackType, representation, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ChunkIndex loadChunkIndex(DataSource dataSource, int trackType, Representation representation, int baseUrlIndex) throws IOException {
        if (representation.getInitializationUri() == null) {
            return null;
        }
        ChunkExtractor chunkExtractor = DashUtil.newChunkExtractor(trackType, representation.format);
        try {
            DashUtil.loadInitializationData(chunkExtractor, dataSource, representation, baseUrlIndex, true);
        }
        finally {
            chunkExtractor.release();
        }
        return chunkExtractor.getChunkIndex();
    }

    @Nullable
    public static ChunkIndex loadChunkIndex(DataSource dataSource, int trackType, Representation representation) throws IOException {
        return DashUtil.loadChunkIndex(dataSource, trackType, representation, 0);
    }

    private static void loadInitializationData(ChunkExtractor chunkExtractor, DataSource dataSource, Representation representation, int baseUrlIndex, boolean loadIndex) throws IOException {
        RangedUri requestUri;
        RangedUri initializationUri = (RangedUri)Assertions.checkNotNull((Object)representation.getInitializationUri());
        if (loadIndex) {
            RangedUri indexUri = representation.getIndexUri();
            if (indexUri == null) {
                return;
            }
            requestUri = initializationUri.attemptMerge(indexUri, ((BaseUrl)representation.baseUrls.get((int)baseUrlIndex)).url);
            if (requestUri == null) {
                DashUtil.loadInitializationData(dataSource, representation, baseUrlIndex, chunkExtractor, initializationUri);
                requestUri = indexUri;
            }
        } else {
            requestUri = initializationUri;
        }
        DashUtil.loadInitializationData(dataSource, representation, baseUrlIndex, chunkExtractor, requestUri);
    }

    public static void loadInitializationData(ChunkExtractor chunkExtractor, DataSource dataSource, Representation representation, boolean loadIndex) throws IOException {
        DashUtil.loadInitializationData(chunkExtractor, dataSource, representation, 0, loadIndex);
    }

    private static void loadInitializationData(DataSource dataSource, Representation representation, int baseUrlIndex, ChunkExtractor chunkExtractor, RangedUri requestUri) throws IOException {
        DataSpec dataSpec = DashUtil.buildDataSpec(representation, ((BaseUrl)representation.baseUrls.get((int)baseUrlIndex)).url, requestUri, 0, (Map<String, String>)ImmutableMap.of());
        InitializationChunk initializationChunk = new InitializationChunk(dataSource, dataSpec, representation.format, 0, null, chunkExtractor);
        initializationChunk.load();
    }

    public static String resolveCacheKey(Representation representation, RangedUri rangedUri) {
        String cacheKey = representation.getCacheKey();
        return cacheKey != null ? cacheKey : rangedUri.resolveUri(((BaseUrl)representation.baseUrls.get((int)0)).url).toString();
    }

    private static ChunkExtractor newChunkExtractor(int trackType, Format format) {
        String mimeType = format.containerMimeType;
        boolean isWebm = mimeType != null && (mimeType.startsWith("video/webm") || mimeType.startsWith("audio/webm"));
        MatroskaExtractor extractor = isWebm ? new MatroskaExtractor(SubtitleParser.Factory.UNSUPPORTED, 2) : new FragmentedMp4Extractor(SubtitleParser.Factory.UNSUPPORTED, 32);
        return new BundledChunkExtractor((Extractor)extractor, trackType, format);
    }

    @Nullable
    private static Representation getFirstRepresentation(Period period, int type) {
        int index = period.getAdaptationSetIndex(type);
        if (index == -1) {
            return null;
        }
        List<Representation> representations = period.adaptationSets.get((int)index).representations;
        return representations.isEmpty() ? null : representations.get(0);
    }

    private DashUtil() {
    }
}

