/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.smoothstreaming;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.MediaLibraryInfo;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.drm.DefaultDrmSessionManagerProvider;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import androidx.media3.exoplayer.drm.DrmSessionManager;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.offline.FilteringManifestParser;
import androidx.media3.exoplayer.smoothstreaming.DefaultSsChunkSource;
import androidx.media3.exoplayer.smoothstreaming.SsChunkSource;
import androidx.media3.exoplayer.smoothstreaming.SsMediaPeriod;
import androidx.media3.exoplayer.smoothstreaming.manifest.SsManifest;
import androidx.media3.exoplayer.smoothstreaming.manifest.SsManifestParser;
import androidx.media3.exoplayer.source.BaseMediaSource;
import androidx.media3.exoplayer.source.CompositeSequenceableLoaderFactory;
import androidx.media3.exoplayer.source.DefaultCompositeSequenceableLoaderFactory;
import androidx.media3.exoplayer.source.LoadEventInfo;
import androidx.media3.exoplayer.source.MediaLoadData;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.MediaSourceEventListener;
import androidx.media3.exoplayer.source.MediaSourceFactory;
import androidx.media3.exoplayer.source.SinglePeriodTimeline;
import androidx.media3.exoplayer.upstream.Allocator;
import androidx.media3.exoplayer.upstream.CmcdConfiguration;
import androidx.media3.exoplayer.upstream.DefaultLoadErrorHandlingPolicy;
import androidx.media3.exoplayer.upstream.LoadErrorHandlingPolicy;
import androidx.media3.exoplayer.upstream.Loader;
import androidx.media3.exoplayer.upstream.LoaderErrorThrower;
import androidx.media3.exoplayer.upstream.ParsingLoadable;
import androidx.media3.extractor.text.SubtitleParser;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@UnstableApi
public final class SsMediaSource
extends BaseMediaSource
implements Loader.Callback<ParsingLoadable<SsManifest>> {
    public static final long DEFAULT_LIVE_PRESENTATION_DELAY_MS = 30000L;
    private static final int MINIMUM_MANIFEST_REFRESH_PERIOD_MS = 5000;
    private static final long MIN_LIVE_DEFAULT_START_POSITION_US = 5000000L;
    private final boolean sideloadedManifest;
    private final Uri manifestUri;
    private final DataSource.Factory manifestDataSourceFactory;
    private final SsChunkSource.Factory chunkSourceFactory;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    @Nullable
    private final CmcdConfiguration cmcdConfiguration;
    private final DrmSessionManager drmSessionManager;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final long livePresentationDelayMs;
    private final MediaSourceEventListener.EventDispatcher manifestEventDispatcher;
    private final ParsingLoadable.Parser<? extends SsManifest> manifestParser;
    private final ArrayList<SsMediaPeriod> mediaPeriods;
    private DataSource manifestDataSource;
    private Loader manifestLoader;
    private LoaderErrorThrower manifestLoaderErrorThrower;
    @Nullable
    private TransferListener mediaTransferListener;
    private long manifestLoadStartTimestamp;
    private SsManifest manifest;
    private Handler manifestRefreshHandler;
    @GuardedBy(value="this")
    private MediaItem mediaItem;

    private SsMediaSource(MediaItem mediaItem, @Nullable SsManifest manifest, @Nullable DataSource.Factory manifestDataSourceFactory, @Nullable ParsingLoadable.Parser<? extends SsManifest> manifestParser, SsChunkSource.Factory chunkSourceFactory, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, @Nullable CmcdConfiguration cmcdConfiguration, DrmSessionManager drmSessionManager, LoadErrorHandlingPolicy loadErrorHandlingPolicy, long livePresentationDelayMs) {
        Assertions.checkState((manifest == null || !manifest.isLive ? 1 : 0) != 0);
        this.mediaItem = mediaItem;
        MediaItem.LocalConfiguration localConfiguration = (MediaItem.LocalConfiguration)Assertions.checkNotNull((Object)mediaItem.localConfiguration);
        this.manifest = manifest;
        this.manifestUri = localConfiguration.uri.equals((Object)Uri.EMPTY) ? null : Util.fixSmoothStreamingIsmManifestUri((Uri)localConfiguration.uri);
        this.manifestDataSourceFactory = manifestDataSourceFactory;
        this.manifestParser = manifestParser;
        this.chunkSourceFactory = chunkSourceFactory;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.cmcdConfiguration = cmcdConfiguration;
        this.drmSessionManager = drmSessionManager;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.livePresentationDelayMs = livePresentationDelayMs;
        this.manifestEventDispatcher = this.createEventDispatcher(null);
        this.sideloadedManifest = manifest != null;
        this.mediaPeriods = new ArrayList();
    }

    public synchronized MediaItem getMediaItem() {
        return this.mediaItem;
    }

    public boolean canUpdateMediaItem(MediaItem mediaItem) {
        MediaItem.LocalConfiguration existingConfiguration = (MediaItem.LocalConfiguration)Assertions.checkNotNull((Object)this.getMediaItem().localConfiguration);
        MediaItem.LocalConfiguration newConfiguration = mediaItem.localConfiguration;
        return newConfiguration != null && newConfiguration.uri.equals((Object)existingConfiguration.uri) && newConfiguration.streamKeys.equals(existingConfiguration.streamKeys) && Util.areEqual((Object)newConfiguration.drmConfiguration, (Object)existingConfiguration.drmConfiguration);
    }

    public synchronized void updateMediaItem(MediaItem mediaItem) {
        this.mediaItem = mediaItem;
    }

    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.mediaTransferListener = mediaTransferListener;
        this.drmSessionManager.setPlayer(Looper.myLooper(), this.getPlayerId());
        this.drmSessionManager.prepare();
        if (this.sideloadedManifest) {
            this.manifestLoaderErrorThrower = new LoaderErrorThrower.Placeholder();
            this.processManifest();
        } else {
            this.manifestDataSource = this.manifestDataSourceFactory.createDataSource();
            this.manifestLoader = new Loader("SsMediaSource");
            this.manifestLoaderErrorThrower = this.manifestLoader;
            this.manifestRefreshHandler = Util.createHandlerForCurrentLooper();
            this.startLoadingManifest();
        }
    }

    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher = this.createEventDispatcher(id);
        DrmSessionEventListener.EventDispatcher drmEventDispatcher = this.createDrmEventDispatcher(id);
        SsMediaPeriod period = new SsMediaPeriod(this.manifest, this.chunkSourceFactory, this.mediaTransferListener, this.compositeSequenceableLoaderFactory, this.cmcdConfiguration, this.drmSessionManager, drmEventDispatcher, this.loadErrorHandlingPolicy, mediaSourceEventDispatcher, this.manifestLoaderErrorThrower, allocator);
        this.mediaPeriods.add(period);
        return period;
    }

    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((SsMediaPeriod)mediaPeriod).release();
        this.mediaPeriods.remove(mediaPeriod);
    }

    protected void releaseSourceInternal() {
        this.manifest = this.sideloadedManifest ? this.manifest : null;
        this.manifestDataSource = null;
        this.manifestLoadStartTimestamp = 0L;
        if (this.manifestLoader != null) {
            this.manifestLoader.release();
            this.manifestLoader = null;
        }
        if (this.manifestRefreshHandler != null) {
            this.manifestRefreshHandler.removeCallbacksAndMessages(null);
            this.manifestRefreshHandler = null;
        }
        this.drmSessionManager.release();
    }

    public void onLoadCompleted(ParsingLoadable<SsManifest> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.manifestEventDispatcher.loadCompleted(loadEventInfo, loadable.type);
        this.manifest = (SsManifest)loadable.getResult();
        this.manifestLoadStartTimestamp = elapsedRealtimeMs - loadDurationMs;
        this.processManifest();
        this.scheduleManifestRefresh();
    }

    public void onLoadCanceled(ParsingLoadable<SsManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.manifestEventDispatcher.loadCanceled(loadEventInfo, loadable.type);
    }

    public Loader.LoadErrorAction onLoadError(ParsingLoadable<SsManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
        MediaLoadData mediaLoadData;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        long retryDelayMs = this.loadErrorHandlingPolicy.getRetryDelayMsFor(new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData = new MediaLoadData(loadable.type), error, errorCount));
        Loader.LoadErrorAction loadErrorAction = retryDelayMs == -9223372036854775807L ? Loader.DONT_RETRY_FATAL : Loader.createRetryAction((boolean)false, (long)retryDelayMs);
        boolean wasCanceled = !loadErrorAction.isRetry();
        this.manifestEventDispatcher.loadError(loadEventInfo, loadable.type, error, wasCanceled);
        if (wasCanceled) {
            this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        }
        return loadErrorAction;
    }

    private void processManifest() {
        SinglePeriodTimeline timeline;
        for (int i = 0; i < this.mediaPeriods.size(); ++i) {
            this.mediaPeriods.get(i).updateManifest(this.manifest);
        }
        long startTimeUs = Long.MAX_VALUE;
        long endTimeUs = Long.MIN_VALUE;
        for (SsManifest.StreamElement element : this.manifest.streamElements) {
            if (element.chunkCount <= 0) continue;
            startTimeUs = Math.min(startTimeUs, element.getStartTimeUs(0));
            endTimeUs = Math.max(endTimeUs, element.getStartTimeUs(element.chunkCount - 1) + element.getChunkDurationUs(element.chunkCount - 1));
        }
        if (startTimeUs == Long.MAX_VALUE) {
            long periodDurationUs = this.manifest.isLive ? -9223372036854775807L : 0L;
            timeline = new SinglePeriodTimeline(periodDurationUs, 0L, 0L, 0L, true, this.manifest.isLive, this.manifest.isLive, (Object)this.manifest, this.getMediaItem());
        } else if (this.manifest.isLive) {
            long durationUs;
            long defaultStartPositionUs;
            if (this.manifest.dvrWindowLengthUs != -9223372036854775807L && this.manifest.dvrWindowLengthUs > 0L) {
                startTimeUs = Math.max(startTimeUs, endTimeUs - this.manifest.dvrWindowLengthUs);
            }
            if ((defaultStartPositionUs = (durationUs = endTimeUs - startTimeUs) - Util.msToUs((long)this.livePresentationDelayMs)) < 5000000L) {
                defaultStartPositionUs = Math.min(5000000L, durationUs / 2L);
            }
            timeline = new SinglePeriodTimeline(-9223372036854775807L, durationUs, startTimeUs, defaultStartPositionUs, true, true, true, (Object)this.manifest, this.getMediaItem());
        } else {
            long durationUs = this.manifest.durationUs != -9223372036854775807L ? this.manifest.durationUs : endTimeUs - startTimeUs;
            timeline = new SinglePeriodTimeline(startTimeUs + durationUs, durationUs, startTimeUs, 0L, true, false, false, (Object)this.manifest, this.getMediaItem());
        }
        this.refreshSourceInfo((Timeline)timeline);
    }

    private void scheduleManifestRefresh() {
        if (!this.manifest.isLive) {
            return;
        }
        long nextLoadTimestamp = this.manifestLoadStartTimestamp + 5000L;
        long delayUntilNextLoad = Math.max(0L, nextLoadTimestamp - SystemClock.elapsedRealtime());
        this.manifestRefreshHandler.postDelayed(this::startLoadingManifest, delayUntilNextLoad);
    }

    private void startLoadingManifest() {
        if (this.manifestLoader.hasFatalError()) {
            return;
        }
        ParsingLoadable loadable = new ParsingLoadable(this.manifestDataSource, this.manifestUri, 4, this.manifestParser);
        long elapsedRealtimeMs = this.manifestLoader.startLoading((Loader.Loadable)loadable, (Loader.Callback)this, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(loadable.type));
        this.manifestEventDispatcher.loadStarted(new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, elapsedRealtimeMs), loadable.type);
    }

    static {
        MediaLibraryInfo.registerModule((String)"media3.exoplayer.smoothstreaming");
    }

    public static final class Factory
    implements MediaSourceFactory {
        private final SsChunkSource.Factory chunkSourceFactory;
        @Nullable
        private final DataSource.Factory manifestDataSourceFactory;
        private CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
        @Nullable
        private CmcdConfiguration.Factory cmcdConfigurationFactory;
        private DrmSessionManagerProvider drmSessionManagerProvider;
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
        private long livePresentationDelayMs;
        @Nullable
        private ParsingLoadable.Parser<? extends SsManifest> manifestParser;

        public Factory(DataSource.Factory dataSourceFactory) {
            this(new DefaultSsChunkSource.Factory(dataSourceFactory), dataSourceFactory);
        }

        public Factory(SsChunkSource.Factory chunkSourceFactory, @Nullable DataSource.Factory manifestDataSourceFactory) {
            this.chunkSourceFactory = (SsChunkSource.Factory)Assertions.checkNotNull((Object)chunkSourceFactory);
            this.manifestDataSourceFactory = manifestDataSourceFactory;
            this.drmSessionManagerProvider = new DefaultDrmSessionManagerProvider();
            this.loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy();
            this.livePresentationDelayMs = 30000L;
            this.compositeSequenceableLoaderFactory = new DefaultCompositeSequenceableLoaderFactory();
            this.experimentalParseSubtitlesDuringExtraction(true);
        }

        @CanIgnoreReturnValue
        public Factory setLoadErrorHandlingPolicy(LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.loadErrorHandlingPolicy = (LoadErrorHandlingPolicy)Assertions.checkNotNull((Object)loadErrorHandlingPolicy, (Object)"MediaSource.Factory#setLoadErrorHandlingPolicy no longer handles null by instantiating a new DefaultLoadErrorHandlingPolicy. Explicitly construct and pass an instance in order to retain the old behavior.");
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setSubtitleParserFactory(SubtitleParser.Factory subtitleParserFactory) {
            this.chunkSourceFactory.setSubtitleParserFactory((SubtitleParser.Factory)Assertions.checkNotNull((Object)subtitleParserFactory));
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Factory experimentalParseSubtitlesDuringExtraction(boolean parseSubtitlesDuringExtraction) {
            this.chunkSourceFactory.experimentalParseSubtitlesDuringExtraction(parseSubtitlesDuringExtraction);
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setLivePresentationDelayMs(long livePresentationDelayMs) {
            this.livePresentationDelayMs = livePresentationDelayMs;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setManifestParser(@Nullable ParsingLoadable.Parser<? extends SsManifest> manifestParser) {
            this.manifestParser = manifestParser;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setCompositeSequenceableLoaderFactory(CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory) {
            this.compositeSequenceableLoaderFactory = (CompositeSequenceableLoaderFactory)Assertions.checkNotNull((Object)compositeSequenceableLoaderFactory, (Object)"SsMediaSource.Factory#setCompositeSequenceableLoaderFactory no longer handles null by instantiating a new DefaultCompositeSequenceableLoaderFactory. Explicitly construct and pass an instance in order to retain the old behavior.");
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setCmcdConfigurationFactory(CmcdConfiguration.Factory cmcdConfigurationFactory) {
            this.cmcdConfigurationFactory = (CmcdConfiguration.Factory)Assertions.checkNotNull((Object)cmcdConfigurationFactory);
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setDrmSessionManagerProvider(DrmSessionManagerProvider drmSessionManagerProvider) {
            this.drmSessionManagerProvider = (DrmSessionManagerProvider)Assertions.checkNotNull((Object)drmSessionManagerProvider, (Object)"MediaSource.Factory#setDrmSessionManagerProvider no longer handles null by instantiating a new DefaultDrmSessionManagerProvider. Explicitly construct and pass an instance in order to retain the old behavior.");
            return this;
        }

        public SsMediaSource createMediaSource(SsManifest manifest) {
            return this.createMediaSource(manifest, MediaItem.fromUri((Uri)Uri.EMPTY));
        }

        public SsMediaSource createMediaSource(SsManifest manifest, MediaItem mediaItem) {
            ImmutableList streamKeys;
            Assertions.checkArgument((!((SsManifest)manifest).isLive ? 1 : 0) != 0);
            Object object = streamKeys = mediaItem.localConfiguration != null ? mediaItem.localConfiguration.streamKeys : ImmutableList.of();
            if (!streamKeys.isEmpty()) {
                manifest = ((SsManifest)manifest).copy((List)streamKeys);
            }
            boolean hasUri = mediaItem.localConfiguration != null;
            mediaItem = mediaItem.buildUpon().setMimeType("application/vnd.ms-sstr+xml").setUri(hasUri ? mediaItem.localConfiguration.uri : Uri.EMPTY).build();
            CmcdConfiguration cmcdConfiguration = this.cmcdConfigurationFactory == null ? null : this.cmcdConfigurationFactory.createCmcdConfiguration(mediaItem);
            return new SsMediaSource(mediaItem, (SsManifest)manifest, null, null, this.chunkSourceFactory, this.compositeSequenceableLoaderFactory, cmcdConfiguration, this.drmSessionManagerProvider.get(mediaItem), this.loadErrorHandlingPolicy, this.livePresentationDelayMs);
        }

        public SsMediaSource createMediaSource(MediaItem mediaItem) {
            List streamKeys;
            Assertions.checkNotNull((Object)mediaItem.localConfiguration);
            SsManifestParser manifestParser = this.manifestParser;
            if (manifestParser == null) {
                manifestParser = new SsManifestParser();
            }
            if (!(streamKeys = mediaItem.localConfiguration.streamKeys).isEmpty()) {
                manifestParser = new FilteringManifestParser((ParsingLoadable.Parser)manifestParser, streamKeys);
            }
            CmcdConfiguration cmcdConfiguration = this.cmcdConfigurationFactory == null ? null : this.cmcdConfigurationFactory.createCmcdConfiguration(mediaItem);
            return new SsMediaSource(mediaItem, null, this.manifestDataSourceFactory, manifestParser, this.chunkSourceFactory, this.compositeSequenceableLoaderFactory, cmcdConfiguration, this.drmSessionManagerProvider.get(mediaItem), this.loadErrorHandlingPolicy, this.livePresentationDelayMs);
        }

        public int[] getSupportedTypes() {
            return new int[]{1};
        }
    }
}

