/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import androidx.media3.common.Timeline;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.AbstractConcatenatedTimeline;
import androidx.media3.exoplayer.MediaSourceInfoHolder;
import androidx.media3.exoplayer.source.ShuffleOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

final class PlaylistTimeline
extends AbstractConcatenatedTimeline {
    private final int windowCount;
    private final int periodCount;
    private final int[] firstPeriodInChildIndices;
    private final int[] firstWindowInChildIndices;
    private final Timeline[] timelines;
    private final Object[] uids;
    private final HashMap<Object, Integer> childIndexByUid;

    public PlaylistTimeline(Collection<? extends MediaSourceInfoHolder> mediaSourceInfoHolders, ShuffleOrder shuffleOrder) {
        super(false, shuffleOrder);
        int childCount = mediaSourceInfoHolders.size();
        this.firstPeriodInChildIndices = new int[childCount];
        this.firstWindowInChildIndices = new int[childCount];
        this.timelines = new Timeline[childCount];
        this.uids = new Object[childCount];
        this.childIndexByUid = new HashMap();
        int index = 0;
        int windowCount = 0;
        int periodCount = 0;
        for (MediaSourceInfoHolder mediaSourceInfoHolder : mediaSourceInfoHolders) {
            this.timelines[index] = mediaSourceInfoHolder.getTimeline();
            this.firstWindowInChildIndices[index] = windowCount;
            this.firstPeriodInChildIndices[index] = periodCount;
            windowCount += this.timelines[index].getWindowCount();
            periodCount += this.timelines[index].getPeriodCount();
            this.uids[index] = mediaSourceInfoHolder.getUid();
            this.childIndexByUid.put(this.uids[index], index++);
        }
        this.windowCount = windowCount;
        this.periodCount = periodCount;
    }

    List<Timeline> getChildTimelines() {
        return Arrays.asList(this.timelines);
    }

    @Override
    protected int getChildIndexByPeriodIndex(int periodIndex) {
        return Util.binarySearchFloor((int[])this.firstPeriodInChildIndices, (int)(periodIndex + 1), (boolean)false, (boolean)false);
    }

    @Override
    protected int getChildIndexByWindowIndex(int windowIndex) {
        return Util.binarySearchFloor((int[])this.firstWindowInChildIndices, (int)(windowIndex + 1), (boolean)false, (boolean)false);
    }

    @Override
    protected int getChildIndexByChildUid(Object childUid) {
        Integer index = this.childIndexByUid.get(childUid);
        return index == null ? -1 : index;
    }

    @Override
    protected Timeline getTimelineByChildIndex(int childIndex) {
        return this.timelines[childIndex];
    }

    @Override
    protected int getFirstPeriodIndexByChildIndex(int childIndex) {
        return this.firstPeriodInChildIndices[childIndex];
    }

    @Override
    protected int getFirstWindowIndexByChildIndex(int childIndex) {
        return this.firstWindowInChildIndices[childIndex];
    }

    @Override
    protected Object getChildUidByChildIndex(int childIndex) {
        return this.uids[childIndex];
    }

    public int getWindowCount() {
        return this.windowCount;
    }

    public int getPeriodCount() {
        return this.periodCount;
    }
}

