/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.analytics;

import android.os.Looper;
import android.util.SparseArray;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.DeviceInfo;
import androidx.media3.common.Format;
import androidx.media3.common.MediaItem;
import androidx.media3.common.MediaMetadata;
import androidx.media3.common.Metadata;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Player;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.Tracks;
import androidx.media3.common.VideoSize;
import androidx.media3.common.text.Cue;
import androidx.media3.common.text.CueGroup;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.HandlerWrapper;
import androidx.media3.common.util.ListenerSet;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.DecoderCounters;
import androidx.media3.exoplayer.DecoderReuseEvaluation;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.analytics.AnalyticsCollector;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import androidx.media3.exoplayer.source.LoadEventInfo;
import androidx.media3.exoplayer.source.MediaLoadData;
import androidx.media3.exoplayer.source.MediaSource;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public class DefaultAnalyticsCollector
implements AnalyticsCollector {
    private final Clock clock;
    private final Timeline.Period period;
    private final Timeline.Window window;
    private final MediaPeriodQueueTracker mediaPeriodQueueTracker;
    private final SparseArray<AnalyticsListener.EventTime> eventTimes;
    private ListenerSet<AnalyticsListener> listeners;
    private @MonotonicNonNull Player player;
    private @MonotonicNonNull HandlerWrapper handler;
    private boolean isSeeking;

    public DefaultAnalyticsCollector(Clock clock) {
        this.clock = (Clock)Assertions.checkNotNull((Object)clock);
        this.listeners = new ListenerSet(Util.getCurrentOrMainLooper(), clock, (listener, flags) -> {});
        this.period = new Timeline.Period();
        this.window = new Timeline.Window();
        this.mediaPeriodQueueTracker = new MediaPeriodQueueTracker(this.period);
        this.eventTimes = new SparseArray();
    }

    @Deprecated
    public void setThrowsWhenUsingWrongThread(boolean throwsWhenUsingWrongThread) {
        this.listeners.setThrowsWhenUsingWrongThread(throwsWhenUsingWrongThread);
    }

    @Override
    @CallSuper
    public void addListener(AnalyticsListener listener) {
        Assertions.checkNotNull((Object)listener);
        this.listeners.add((Object)listener);
    }

    @Override
    @CallSuper
    public void removeListener(AnalyticsListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    @CallSuper
    public void setPlayer(Player player, Looper looper) {
        Assertions.checkState((this.player == null || this.mediaPeriodQueueTracker.mediaPeriodQueue.isEmpty() ? 1 : 0) != 0);
        this.player = (Player)Assertions.checkNotNull((Object)player);
        this.handler = this.clock.createHandler(looper, null);
        this.listeners = this.listeners.copy(looper, (listener, flags) -> listener.onEvents(player, new AnalyticsListener.Events(flags, this.eventTimes)));
    }

    @Override
    @CallSuper
    public void release() {
        ((HandlerWrapper)Assertions.checkStateNotNull((Object)this.handler)).post(this::releaseInternal);
    }

    @Override
    public final void updateMediaPeriodQueueInfo(List<MediaSource.MediaPeriodId> queue, @Nullable MediaSource.MediaPeriodId readingPeriod) {
        this.mediaPeriodQueueTracker.onQueueUpdated(queue, readingPeriod, (Player)Assertions.checkNotNull((Object)this.player));
    }

    @Override
    public final void notifySeekStarted() {
        if (!this.isSeeking) {
            AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
            this.isSeeking = true;
            this.sendEvent(eventTime, -1, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onSeekStarted(eventTime)));
        }
    }

    @Override
    public final void onAudioEnabled(DecoderCounters counters) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1007, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> {
            listener.onAudioEnabled(eventTime, counters);
            listener.onDecoderEnabled(eventTime, 1, counters);
        }));
    }

    @Override
    public final void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1008, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> {
            listener.onAudioDecoderInitialized(eventTime, decoderName, initializationDurationMs);
            listener.onAudioDecoderInitialized(eventTime, decoderName, initializedTimestampMs, initializationDurationMs);
            listener.onDecoderInitialized(eventTime, 1, decoderName, initializationDurationMs);
        }));
    }

    @Override
    public final void onAudioInputFormatChanged(Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1009, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> {
            listener.onAudioInputFormatChanged(eventTime, format);
            listener.onAudioInputFormatChanged(eventTime, format, decoderReuseEvaluation);
            listener.onDecoderInputFormatChanged(eventTime, 1, format);
        }));
    }

    @Override
    public final void onAudioPositionAdvancing(long playoutStartSystemTimeMs) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1010, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onAudioPositionAdvancing(eventTime, playoutStartSystemTimeMs)));
    }

    @Override
    public final void onAudioUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1011, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onAudioUnderrun(eventTime, bufferSize, bufferSizeMs, elapsedSinceLastFeedMs)));
    }

    @Override
    public final void onAudioDecoderReleased(String decoderName) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1012, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onAudioDecoderReleased(eventTime, decoderName)));
    }

    @Override
    public final void onAudioDisabled(DecoderCounters counters) {
        AnalyticsListener.EventTime eventTime = this.generatePlayingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1013, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> {
            listener.onAudioDisabled(eventTime, counters);
            listener.onDecoderDisabled(eventTime, 1, counters);
        }));
    }

    @Override
    public final void onAudioSinkError(Exception audioSinkError) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1014, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onAudioSinkError(eventTime, audioSinkError)));
    }

    @Override
    public final void onAudioCodecError(Exception audioCodecError) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1029, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onAudioCodecError(eventTime, audioCodecError)));
    }

    public final void onVolumeChanged(float volume) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 22, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onVolumeChanged(eventTime, volume)));
    }

    @Override
    public final void onVideoEnabled(DecoderCounters counters) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1015, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> {
            listener.onVideoEnabled(eventTime, counters);
            listener.onDecoderEnabled(eventTime, 2, counters);
        }));
    }

    @Override
    public final void onVideoDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1016, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> {
            listener.onVideoDecoderInitialized(eventTime, decoderName, initializationDurationMs);
            listener.onVideoDecoderInitialized(eventTime, decoderName, initializedTimestampMs, initializationDurationMs);
            listener.onDecoderInitialized(eventTime, 2, decoderName, initializationDurationMs);
        }));
    }

    @Override
    public final void onVideoInputFormatChanged(Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1017, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> {
            listener.onVideoInputFormatChanged(eventTime, format);
            listener.onVideoInputFormatChanged(eventTime, format, decoderReuseEvaluation);
            listener.onDecoderInputFormatChanged(eventTime, 2, format);
        }));
    }

    @Override
    public final void onDroppedFrames(int count, long elapsedMs) {
        AnalyticsListener.EventTime eventTime = this.generatePlayingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1018, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onDroppedVideoFrames(eventTime, count, elapsedMs)));
    }

    @Override
    public final void onVideoDecoderReleased(String decoderName) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1019, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onVideoDecoderReleased(eventTime, decoderName)));
    }

    @Override
    public final void onVideoDisabled(DecoderCounters counters) {
        AnalyticsListener.EventTime eventTime = this.generatePlayingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1020, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> {
            listener.onVideoDisabled(eventTime, counters);
            listener.onDecoderDisabled(eventTime, 2, counters);
        }));
    }

    @Override
    public final void onRenderedFirstFrame(Object output, long renderTimeMs) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 26, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onRenderedFirstFrame(eventTime, output, renderTimeMs)));
    }

    @Override
    public final void onVideoFrameProcessingOffset(long totalProcessingOffsetUs, int frameCount) {
        AnalyticsListener.EventTime eventTime = this.generatePlayingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1021, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onVideoFrameProcessingOffset(eventTime, totalProcessingOffsetUs, frameCount)));
    }

    @Override
    public final void onVideoCodecError(Exception videoCodecError) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1030, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onVideoCodecError(eventTime, videoCodecError)));
    }

    public final void onSurfaceSizeChanged(int width, int height) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 24, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onSurfaceSizeChanged(eventTime, width, height)));
    }

    @Override
    public final void onLoadStarted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        this.sendEvent(eventTime, 1000, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onLoadStarted(eventTime, loadEventInfo, mediaLoadData)));
    }

    @Override
    public final void onLoadCompleted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        this.sendEvent(eventTime, 1001, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onLoadCompleted(eventTime, loadEventInfo, mediaLoadData)));
    }

    @Override
    public final void onLoadCanceled(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        this.sendEvent(eventTime, 1002, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onLoadCanceled(eventTime, loadEventInfo, mediaLoadData)));
    }

    @Override
    public final void onLoadError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        this.sendEvent(eventTime, 1003, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onLoadError(eventTime, loadEventInfo, mediaLoadData, error, wasCanceled)));
    }

    @Override
    public final void onUpstreamDiscarded(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        this.sendEvent(eventTime, 1005, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onUpstreamDiscarded(eventTime, mediaLoadData)));
    }

    @Override
    public final void onDownstreamFormatChanged(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        this.sendEvent(eventTime, 1004, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onDownstreamFormatChanged(eventTime, mediaLoadData)));
    }

    public final void onTimelineChanged(Timeline timeline, int reason) {
        this.mediaPeriodQueueTracker.onTimelineChanged((Player)Assertions.checkNotNull((Object)this.player));
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 0, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onTimelineChanged(eventTime, reason)));
    }

    public final void onMediaItemTransition(@Nullable MediaItem mediaItem, int reason) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 1, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onMediaItemTransition(eventTime, mediaItem, reason)));
    }

    public void onTracksChanged(Tracks tracks) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 2, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onTracksChanged(eventTime, tracks)));
    }

    public void onLoadingChanged(boolean isLoading) {
    }

    public final void onIsLoadingChanged(boolean isLoading) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 3, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> {
            listener.onLoadingChanged(eventTime, isLoading);
            listener.onIsLoadingChanged(eventTime, isLoading);
        }));
    }

    public void onAvailableCommandsChanged(Player.Commands availableCommands) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 13, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onAvailableCommandsChanged(eventTime, availableCommands)));
    }

    public final void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, -1, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onPlayerStateChanged(eventTime, playWhenReady, playbackState)));
    }

    public final void onPlaybackStateChanged(int playbackState) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 4, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onPlaybackStateChanged(eventTime, playbackState)));
    }

    public final void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 5, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onPlayWhenReadyChanged(eventTime, playWhenReady, reason)));
    }

    public final void onPlaybackSuppressionReasonChanged(int playbackSuppressionReason) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 6, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onPlaybackSuppressionReasonChanged(eventTime, playbackSuppressionReason)));
    }

    public void onIsPlayingChanged(boolean isPlaying) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 7, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onIsPlayingChanged(eventTime, isPlaying)));
    }

    public final void onRepeatModeChanged(int repeatMode) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 8, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onRepeatModeChanged(eventTime, repeatMode)));
    }

    public final void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 9, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onShuffleModeChanged(eventTime, shuffleModeEnabled)));
    }

    public final void onPlayerError(PlaybackException error) {
        AnalyticsListener.EventTime eventTime = this.getEventTimeForErrorEvent(error);
        this.sendEvent(eventTime, 10, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onPlayerError(eventTime, error)));
    }

    public void onPlayerErrorChanged(@Nullable PlaybackException error) {
        AnalyticsListener.EventTime eventTime = this.getEventTimeForErrorEvent(error);
        this.sendEvent(eventTime, 10, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onPlayerErrorChanged(eventTime, error)));
    }

    public void onPositionDiscontinuity(int reason) {
    }

    public final void onPositionDiscontinuity(Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
        if (reason == 1) {
            this.isSeeking = false;
        }
        this.mediaPeriodQueueTracker.onPositionDiscontinuity((Player)Assertions.checkNotNull((Object)this.player));
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 11, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> {
            listener.onPositionDiscontinuity(eventTime, reason);
            listener.onPositionDiscontinuity(eventTime, oldPosition, newPosition, reason);
        }));
    }

    public final void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 12, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onPlaybackParametersChanged(eventTime, playbackParameters)));
    }

    public void onSeekBackIncrementChanged(long seekBackIncrementMs) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 16, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onSeekBackIncrementChanged(eventTime, seekBackIncrementMs)));
    }

    public void onSeekForwardIncrementChanged(long seekForwardIncrementMs) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 17, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onSeekForwardIncrementChanged(eventTime, seekForwardIncrementMs)));
    }

    public void onMaxSeekToPreviousPositionChanged(long maxSeekToPreviousPositionMs) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 18, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onMaxSeekToPreviousPositionChanged(eventTime, maxSeekToPreviousPositionMs)));
    }

    public void onMediaMetadataChanged(MediaMetadata mediaMetadata) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 14, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onMediaMetadataChanged(eventTime, mediaMetadata)));
    }

    public void onPlaylistMetadataChanged(MediaMetadata playlistMetadata) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 15, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onPlaylistMetadataChanged(eventTime, playlistMetadata)));
    }

    public final void onMetadata(Metadata metadata) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 28, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onMetadata(eventTime, metadata)));
    }

    public void onCues(List<Cue> cues) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 27, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onCues(eventTime, cues)));
    }

    public void onCues(CueGroup cueGroup) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 27, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onCues(eventTime, cueGroup)));
    }

    public final void onSeekProcessed() {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, -1, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onSeekProcessed(eventTime)));
    }

    public final void onSkipSilenceEnabledChanged(boolean skipSilenceEnabled) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 23, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onSkipSilenceEnabledChanged(eventTime, skipSilenceEnabled)));
    }

    public final void onAudioSessionIdChanged(int audioSessionId) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 21, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onAudioSessionIdChanged(eventTime, audioSessionId)));
    }

    public final void onAudioAttributesChanged(AudioAttributes audioAttributes) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 20, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onAudioAttributesChanged(eventTime, audioAttributes)));
    }

    public final void onVideoSizeChanged(VideoSize videoSize) {
        AnalyticsListener.EventTime eventTime = this.generateReadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 25, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> {
            listener.onVideoSizeChanged(eventTime, videoSize);
            listener.onVideoSizeChanged(eventTime, videoSize.width, videoSize.height, videoSize.unappliedRotationDegrees, videoSize.pixelWidthHeightRatio);
        }));
    }

    public void onTrackSelectionParametersChanged(TrackSelectionParameters parameters) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 19, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onTrackSelectionParametersChanged(eventTime, parameters)));
    }

    public void onDeviceInfoChanged(DeviceInfo deviceInfo) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 29, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onDeviceInfoChanged(eventTime, deviceInfo)));
    }

    public void onDeviceVolumeChanged(int volume, boolean muted) {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 30, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onDeviceVolumeChanged(eventTime, volume, muted)));
    }

    public void onRenderedFirstFrame() {
    }

    public void onEvents(Player player, Player.Events events) {
    }

    @Override
    public final void onBandwidthSample(int elapsedMs, long bytesTransferred, long bitrateEstimate) {
        AnalyticsListener.EventTime eventTime = this.generateLoadingMediaPeriodEventTime();
        this.sendEvent(eventTime, 1006, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onBandwidthEstimate(eventTime, elapsedMs, bytesTransferred, bitrateEstimate)));
    }

    @Override
    public final void onDrmSessionAcquired(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, int state) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        this.sendEvent(eventTime, 1022, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> {
            listener.onDrmSessionAcquired(eventTime);
            listener.onDrmSessionAcquired(eventTime, state);
        }));
    }

    @Override
    public final void onDrmKeysLoaded(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        this.sendEvent(eventTime, 1023, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onDrmKeysLoaded(eventTime)));
    }

    @Override
    public final void onDrmSessionManagerError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, Exception error) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        this.sendEvent(eventTime, 1024, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onDrmSessionManagerError(eventTime, error)));
    }

    @Override
    public final void onDrmKeysRestored(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        this.sendEvent(eventTime, 1025, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onDrmKeysRestored(eventTime)));
    }

    @Override
    public final void onDrmKeysRemoved(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        this.sendEvent(eventTime, 1026, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onDrmKeysRemoved(eventTime)));
    }

    @Override
    public final void onDrmSessionReleased(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        AnalyticsListener.EventTime eventTime = this.generateMediaPeriodEventTime(windowIndex, mediaPeriodId);
        this.sendEvent(eventTime, 1027, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onDrmSessionReleased(eventTime)));
    }

    protected final void sendEvent(AnalyticsListener.EventTime eventTime, int eventFlag, ListenerSet.Event<AnalyticsListener> eventInvocation) {
        this.eventTimes.put(eventFlag, (Object)eventTime);
        this.listeners.sendEvent(eventFlag, eventInvocation);
    }

    protected final AnalyticsListener.EventTime generateCurrentPlayerMediaPeriodEventTime() {
        return this.generateEventTime(this.mediaPeriodQueueTracker.getCurrentPlayerMediaPeriod());
    }

    @RequiresNonNull(value={"player"})
    protected final AnalyticsListener.EventTime generateEventTime(Timeline timeline, int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        long eventPositionMs;
        boolean isInCurrentWindow;
        if (timeline.isEmpty()) {
            mediaPeriodId = null;
        }
        long realtimeMs = this.clock.elapsedRealtime();
        boolean bl = isInCurrentWindow = timeline.equals((Object)this.player.getCurrentTimeline()) && windowIndex == this.player.getCurrentMediaItemIndex();
        if (mediaPeriodId != null && mediaPeriodId.isAd()) {
            boolean isCurrentAd = isInCurrentWindow && this.player.getCurrentAdGroupIndex() == mediaPeriodId.adGroupIndex && this.player.getCurrentAdIndexInAdGroup() == mediaPeriodId.adIndexInAdGroup;
            eventPositionMs = isCurrentAd ? this.player.getCurrentPosition() : 0L;
        } else {
            eventPositionMs = isInCurrentWindow ? this.player.getContentPosition() : (timeline.isEmpty() ? 0L : timeline.getWindow(windowIndex, this.window).getDefaultPositionMs());
        }
        MediaSource.MediaPeriodId currentMediaPeriodId = this.mediaPeriodQueueTracker.getCurrentPlayerMediaPeriod();
        return new AnalyticsListener.EventTime(realtimeMs, timeline, windowIndex, mediaPeriodId, eventPositionMs, this.player.getCurrentTimeline(), this.player.getCurrentMediaItemIndex(), currentMediaPeriodId, this.player.getCurrentPosition(), this.player.getTotalBufferedDuration());
    }

    private void releaseInternal() {
        AnalyticsListener.EventTime eventTime = this.generateCurrentPlayerMediaPeriodEventTime();
        this.sendEvent(eventTime, 1028, (ListenerSet.Event<AnalyticsListener>)((ListenerSet.Event)listener -> listener.onPlayerReleased(eventTime)));
        this.listeners.release();
    }

    private AnalyticsListener.EventTime generateEventTime(@Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        Timeline knownTimeline;
        Assertions.checkNotNull((Object)this.player);
        Timeline timeline = knownTimeline = mediaPeriodId == null ? null : this.mediaPeriodQueueTracker.getMediaPeriodIdTimeline(mediaPeriodId);
        if (mediaPeriodId == null || knownTimeline == null) {
            Timeline timeline2;
            int windowIndex = this.player.getCurrentMediaItemIndex();
            boolean windowIsInTimeline = windowIndex < (timeline2 = this.player.getCurrentTimeline()).getWindowCount();
            return this.generateEventTime(windowIsInTimeline ? timeline2 : Timeline.EMPTY, windowIndex, null);
        }
        int windowIndex = knownTimeline.getPeriodByUid((Object)mediaPeriodId.periodUid, (Timeline.Period)this.period).windowIndex;
        return this.generateEventTime(knownTimeline, windowIndex, mediaPeriodId);
    }

    private AnalyticsListener.EventTime generatePlayingMediaPeriodEventTime() {
        return this.generateEventTime(this.mediaPeriodQueueTracker.getPlayingMediaPeriod());
    }

    private AnalyticsListener.EventTime generateReadingMediaPeriodEventTime() {
        return this.generateEventTime(this.mediaPeriodQueueTracker.getReadingMediaPeriod());
    }

    private AnalyticsListener.EventTime generateLoadingMediaPeriodEventTime() {
        return this.generateEventTime(this.mediaPeriodQueueTracker.getLoadingMediaPeriod());
    }

    private AnalyticsListener.EventTime generateMediaPeriodEventTime(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        Assertions.checkNotNull((Object)this.player);
        if (mediaPeriodId != null) {
            boolean isInKnownTimeline = this.mediaPeriodQueueTracker.getMediaPeriodIdTimeline(mediaPeriodId) != null;
            return isInKnownTimeline ? this.generateEventTime(mediaPeriodId) : this.generateEventTime(Timeline.EMPTY, windowIndex, mediaPeriodId);
        }
        Timeline timeline = this.player.getCurrentTimeline();
        boolean windowIsInTimeline = windowIndex < timeline.getWindowCount();
        return this.generateEventTime(windowIsInTimeline ? timeline : Timeline.EMPTY, windowIndex, null);
    }

    private AnalyticsListener.EventTime getEventTimeForErrorEvent(@Nullable PlaybackException error) {
        if (error instanceof ExoPlaybackException) {
            ExoPlaybackException exoError = (ExoPlaybackException)error;
            if (exoError.mediaPeriodId != null) {
                return this.generateEventTime(new MediaSource.MediaPeriodId(exoError.mediaPeriodId));
            }
        }
        return this.generateCurrentPlayerMediaPeriodEventTime();
    }

    private static final class MediaPeriodQueueTracker {
        private final Timeline.Period period;
        private ImmutableList<MediaSource.MediaPeriodId> mediaPeriodQueue;
        private ImmutableMap<MediaSource.MediaPeriodId, Timeline> mediaPeriodTimelines;
        @Nullable
        private MediaSource.MediaPeriodId currentPlayerMediaPeriod;
        private  @MonotonicNonNull MediaSource.MediaPeriodId playingMediaPeriod;
        private  @MonotonicNonNull MediaSource.MediaPeriodId readingMediaPeriod;

        public MediaPeriodQueueTracker(Timeline.Period period) {
            this.period = period;
            this.mediaPeriodQueue = ImmutableList.of();
            this.mediaPeriodTimelines = ImmutableMap.of();
        }

        @Nullable
        public MediaSource.MediaPeriodId getCurrentPlayerMediaPeriod() {
            return this.currentPlayerMediaPeriod;
        }

        @Nullable
        public MediaSource.MediaPeriodId getPlayingMediaPeriod() {
            return this.playingMediaPeriod;
        }

        @Nullable
        public MediaSource.MediaPeriodId getReadingMediaPeriod() {
            return this.readingMediaPeriod;
        }

        @Nullable
        public MediaSource.MediaPeriodId getLoadingMediaPeriod() {
            return this.mediaPeriodQueue.isEmpty() ? null : (MediaSource.MediaPeriodId)((Object)Iterables.getLast(this.mediaPeriodQueue));
        }

        @Nullable
        public Timeline getMediaPeriodIdTimeline(MediaSource.MediaPeriodId mediaPeriodId) {
            return (Timeline)this.mediaPeriodTimelines.get((Object)mediaPeriodId);
        }

        public void onPositionDiscontinuity(Player player) {
            this.currentPlayerMediaPeriod = MediaPeriodQueueTracker.findCurrentPlayerMediaPeriodInQueue(player, this.mediaPeriodQueue, this.playingMediaPeriod, this.period);
        }

        public void onTimelineChanged(Player player) {
            this.currentPlayerMediaPeriod = MediaPeriodQueueTracker.findCurrentPlayerMediaPeriodInQueue(player, this.mediaPeriodQueue, this.playingMediaPeriod, this.period);
            this.updateMediaPeriodTimelines(player.getCurrentTimeline());
        }

        public void onQueueUpdated(List<MediaSource.MediaPeriodId> queue, @Nullable MediaSource.MediaPeriodId readingPeriod, Player player) {
            this.mediaPeriodQueue = ImmutableList.copyOf(queue);
            if (!queue.isEmpty()) {
                this.playingMediaPeriod = queue.get(0);
                this.readingMediaPeriod = (MediaSource.MediaPeriodId)((Object)Assertions.checkNotNull((Object)((Object)readingPeriod)));
            }
            if (this.currentPlayerMediaPeriod == null) {
                this.currentPlayerMediaPeriod = MediaPeriodQueueTracker.findCurrentPlayerMediaPeriodInQueue(player, this.mediaPeriodQueue, this.playingMediaPeriod, this.period);
            }
            this.updateMediaPeriodTimelines(player.getCurrentTimeline());
        }

        private void updateMediaPeriodTimelines(Timeline preferredTimeline) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (this.mediaPeriodQueue.isEmpty()) {
                this.addTimelineForMediaPeriodId((ImmutableMap.Builder<MediaSource.MediaPeriodId, Timeline>)builder, this.playingMediaPeriod, preferredTimeline);
                if (!Objects.equal((Object)((Object)this.readingMediaPeriod), (Object)((Object)this.playingMediaPeriod))) {
                    this.addTimelineForMediaPeriodId((ImmutableMap.Builder<MediaSource.MediaPeriodId, Timeline>)builder, this.readingMediaPeriod, preferredTimeline);
                }
                if (!Objects.equal((Object)((Object)this.currentPlayerMediaPeriod), (Object)((Object)this.playingMediaPeriod)) && !Objects.equal((Object)((Object)this.currentPlayerMediaPeriod), (Object)((Object)this.readingMediaPeriod))) {
                    this.addTimelineForMediaPeriodId((ImmutableMap.Builder<MediaSource.MediaPeriodId, Timeline>)builder, this.currentPlayerMediaPeriod, preferredTimeline);
                }
            } else {
                for (int i = 0; i < this.mediaPeriodQueue.size(); ++i) {
                    this.addTimelineForMediaPeriodId((ImmutableMap.Builder<MediaSource.MediaPeriodId, Timeline>)builder, (MediaSource.MediaPeriodId)((Object)this.mediaPeriodQueue.get(i)), preferredTimeline);
                }
                if (!this.mediaPeriodQueue.contains((Object)this.currentPlayerMediaPeriod)) {
                    this.addTimelineForMediaPeriodId((ImmutableMap.Builder<MediaSource.MediaPeriodId, Timeline>)builder, this.currentPlayerMediaPeriod, preferredTimeline);
                }
            }
            this.mediaPeriodTimelines = builder.buildOrThrow();
        }

        private void addTimelineForMediaPeriodId(ImmutableMap.Builder<MediaSource.MediaPeriodId, Timeline> mediaPeriodTimelinesBuilder, @Nullable MediaSource.MediaPeriodId mediaPeriodId, Timeline preferredTimeline) {
            if (mediaPeriodId == null) {
                return;
            }
            if (preferredTimeline.getIndexOfPeriod(mediaPeriodId.periodUid) != -1) {
                mediaPeriodTimelinesBuilder.put((Object)mediaPeriodId, (Object)preferredTimeline);
            } else {
                Timeline existingTimeline = (Timeline)this.mediaPeriodTimelines.get((Object)mediaPeriodId);
                if (existingTimeline != null) {
                    mediaPeriodTimelinesBuilder.put((Object)mediaPeriodId, (Object)existingTimeline);
                }
            }
        }

        @Nullable
        private static MediaSource.MediaPeriodId findCurrentPlayerMediaPeriodInQueue(Player player, ImmutableList<MediaSource.MediaPeriodId> mediaPeriodQueue, @Nullable MediaSource.MediaPeriodId playingMediaPeriod, Timeline.Period period) {
            Timeline playerTimeline = player.getCurrentTimeline();
            int playerPeriodIndex = player.getCurrentPeriodIndex();
            Object playerPeriodUid = playerTimeline.isEmpty() ? null : playerTimeline.getUidOfPeriod(playerPeriodIndex);
            int playerNextAdGroupIndex = player.isPlayingAd() || playerTimeline.isEmpty() ? -1 : playerTimeline.getPeriod(playerPeriodIndex, period).getAdGroupIndexAfterPositionUs(Util.msToUs((long)player.getCurrentPosition()) - period.getPositionInWindowUs());
            for (int i = 0; i < mediaPeriodQueue.size(); ++i) {
                MediaSource.MediaPeriodId mediaPeriodId = (MediaSource.MediaPeriodId)((Object)mediaPeriodQueue.get(i));
                if (!MediaPeriodQueueTracker.isMatchingMediaPeriod(mediaPeriodId, playerPeriodUid, player.isPlayingAd(), player.getCurrentAdGroupIndex(), player.getCurrentAdIndexInAdGroup(), playerNextAdGroupIndex)) continue;
                return mediaPeriodId;
            }
            if (mediaPeriodQueue.isEmpty() && playingMediaPeriod != null && MediaPeriodQueueTracker.isMatchingMediaPeriod(playingMediaPeriod, playerPeriodUid, player.isPlayingAd(), player.getCurrentAdGroupIndex(), player.getCurrentAdIndexInAdGroup(), playerNextAdGroupIndex)) {
                return playingMediaPeriod;
            }
            return null;
        }

        private static boolean isMatchingMediaPeriod(MediaSource.MediaPeriodId mediaPeriodId, @Nullable Object playerPeriodUid, boolean isPlayingAd, int playerAdGroupIndex, int playerAdIndexInAdGroup, int playerNextAdGroupIndex) {
            if (!mediaPeriodId.periodUid.equals(playerPeriodUid)) {
                return false;
            }
            return isPlayingAd && mediaPeriodId.adGroupIndex == playerAdGroupIndex && mediaPeriodId.adIndexInAdGroup == playerAdIndexInAdGroup || !isPlayingAd && mediaPeriodId.adGroupIndex == -1 && mediaPeriodId.nextAdGroupIndex == playerNextAdGroupIndex;
        }
    }
}

